package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Request for populating or extending a context menu with actions</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html">QWebEngineContextMenuRequest</a></code></p>
 */
public final class QWebEngineContextMenuRequest extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineContextMenuRequest.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#EditFlag-enum">QWebEngineContextMenuRequest::EditFlag</a></code></p>
     * 
     * @see EditFlags
     */
    public enum EditFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#EditFlag-enum">QWebEngineContextMenuRequest::<wbr/>CanUndo</a></code></p>
         */
        CanUndo(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#EditFlag-enum">QWebEngineContextMenuRequest::<wbr/>CanRedo</a></code></p>
         */
        CanRedo(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#EditFlag-enum">QWebEngineContextMenuRequest::<wbr/>CanCut</a></code></p>
         */
        CanCut(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#EditFlag-enum">QWebEngineContextMenuRequest::<wbr/>CanCopy</a></code></p>
         */
        CanCopy(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#EditFlag-enum">QWebEngineContextMenuRequest::<wbr/>CanPaste</a></code></p>
         */
        CanPaste(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#EditFlag-enum">QWebEngineContextMenuRequest::<wbr/>CanDelete</a></code></p>
         */
        CanDelete(32),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#EditFlag-enum">QWebEngineContextMenuRequest::<wbr/>CanSelectAll</a></code></p>
         */
        CanSelectAll(64),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#EditFlag-enum">QWebEngineContextMenuRequest::<wbr/>CanTranslate</a></code></p>
         */
        CanTranslate(128),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#EditFlag-enum">QWebEngineContextMenuRequest::<wbr/>CanEditRichly</a></code></p>
         */
        CanEditRichly(256);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private EditFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull EditFlags asFlags() {
            return new EditFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull EditFlags combined(@NonNull EditFlag e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull EditFlags cleared(@NonNull EditFlag e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link EditFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull EditFlags flags(@Nullable EditFlag @NonNull... values) {
            return new EditFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull EditFlag resolve(int value) {
            switch (value) {
            case 1: return CanUndo;
            case 2: return CanRedo;
            case 4: return CanCut;
            case 8: return CanCopy;
            case 16: return CanPaste;
            case 32: return CanDelete;
            case 64: return CanSelectAll;
            case 128: return CanTranslate;
            case 256: return CanEditRichly;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link EditFlag}
     */
    public static final class EditFlags extends QFlags<EditFlag> implements Comparable<EditFlags> {
        private static final long serialVersionUID = 0x6471c7474d16e451L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new EditFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public EditFlags(@Nullable EditFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new EditFlags with given <code>value</code>.
         * @param value
         */
        public EditFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new EditFlags
         */
        @Override
        public final @NonNull EditFlags combined(@StrictNonNull EditFlag e){
            return new EditFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull EditFlags setFlag(@Nullable EditFlag e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull EditFlags setFlag(@Nullable EditFlag e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this EditFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull EditFlag @NonNull[] flags(){
            return super.flags(EditFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull EditFlags clone(){
            return new EditFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull EditFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaFlag-enum">QWebEngineContextMenuRequest::MediaFlag</a></code></p>
     * 
     * @see MediaFlags
     */
    public enum MediaFlag implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaFlag-enum">QWebEngineContextMenuRequest::<wbr/>MediaInError</a></code></p>
         */
        MediaInError(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaFlag-enum">QWebEngineContextMenuRequest::<wbr/>MediaPaused</a></code></p>
         */
        MediaPaused(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaFlag-enum">QWebEngineContextMenuRequest::<wbr/>MediaMuted</a></code></p>
         */
        MediaMuted(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaFlag-enum">QWebEngineContextMenuRequest::<wbr/>MediaLoop</a></code></p>
         */
        MediaLoop(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaFlag-enum">QWebEngineContextMenuRequest::<wbr/>MediaCanSave</a></code></p>
         */
        MediaCanSave(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaFlag-enum">QWebEngineContextMenuRequest::<wbr/>MediaHasAudio</a></code></p>
         */
        MediaHasAudio(32),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaFlag-enum">QWebEngineContextMenuRequest::<wbr/>MediaCanToggleControls</a></code></p>
         */
        MediaCanToggleControls(64),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaFlag-enum">QWebEngineContextMenuRequest::<wbr/>MediaControls</a></code></p>
         */
        MediaControls(128),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaFlag-enum">QWebEngineContextMenuRequest::<wbr/>MediaCanPrint</a></code></p>
         */
        MediaCanPrint(256),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaFlag-enum">QWebEngineContextMenuRequest::<wbr/>MediaCanRotate</a></code></p>
         */
        MediaCanRotate(512);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private MediaFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull MediaFlags asFlags() {
            return new MediaFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull MediaFlags combined(@NonNull MediaFlag e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull MediaFlags cleared(@NonNull MediaFlag e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link MediaFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull MediaFlags flags(@Nullable MediaFlag @NonNull... values) {
            return new MediaFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull MediaFlag resolve(int value) {
            switch (value) {
            case 1: return MediaInError;
            case 2: return MediaPaused;
            case 4: return MediaMuted;
            case 8: return MediaLoop;
            case 16: return MediaCanSave;
            case 32: return MediaHasAudio;
            case 64: return MediaCanToggleControls;
            case 128: return MediaControls;
            case 256: return MediaCanPrint;
            case 512: return MediaCanRotate;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link MediaFlag}
     */
    public static final class MediaFlags extends QFlags<MediaFlag> implements Comparable<MediaFlags> {
        private static final long serialVersionUID = 0xa5bae86f204e2f26L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new MediaFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public MediaFlags(@Nullable MediaFlag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new MediaFlags with given <code>value</code>.
         * @param value
         */
        public MediaFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new MediaFlags
         */
        @Override
        public final @NonNull MediaFlags combined(@StrictNonNull MediaFlag e){
            return new MediaFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull MediaFlags setFlag(@Nullable MediaFlag e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull MediaFlags setFlag(@Nullable MediaFlag e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this MediaFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull MediaFlag @NonNull[] flags(){
            return super.flags(MediaFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull MediaFlags clone(){
            return new MediaFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull MediaFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaType-enum">QWebEngineContextMenuRequest::MediaType</a></code></p>
     */
    public enum MediaType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaType-enum">QWebEngineContextMenuRequest::<wbr/>MediaTypeNone</a></code></p>
         */
        MediaTypeNone(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaType-enum">QWebEngineContextMenuRequest::<wbr/>MediaTypeImage</a></code></p>
         */
        MediaTypeImage(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaType-enum">QWebEngineContextMenuRequest::<wbr/>MediaTypeVideo</a></code></p>
         */
        MediaTypeVideo(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaType-enum">QWebEngineContextMenuRequest::<wbr/>MediaTypeAudio</a></code></p>
         */
        MediaTypeAudio(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaType-enum">QWebEngineContextMenuRequest::<wbr/>MediaTypeCanvas</a></code></p>
         */
        MediaTypeCanvas(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaType-enum">QWebEngineContextMenuRequest::<wbr/>MediaTypeFile</a></code></p>
         */
        MediaTypeFile(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaType-enum">QWebEngineContextMenuRequest::<wbr/>MediaTypePlugin</a></code></p>
         */
        MediaTypePlugin(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private MediaType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull MediaType resolve(int value) {
            switch (value) {
            case 0: return MediaTypeNone;
            case 1: return MediaTypeImage;
            case 2: return MediaTypeVideo;
            case 3: return MediaTypeAudio;
            case 4: return MediaTypeCanvas;
            case 5: return MediaTypeFile;
            case 6: return MediaTypePlugin;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#editFlags">QWebEngineContextMenuRequest::<wbr/>editFlags()const</a></code></p>
     */
    @QtPropertyReader(name="editFlags")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineContextMenuRequest.@NonNull EditFlags editFlags(){
        return new io.qt.webengine.core.QWebEngineContextMenuRequest.EditFlags(editFlags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int editFlags_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#accepted-prop">QWebEngineContextMenuRequest::<wbr/>isAccepted()const</a></code></p>
     */
    @QtPropertyReader(name="accepted")
    @QtUninvokable
    public final boolean isAccepted(){
        return isAccepted_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAccepted_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#isContentEditable">QWebEngineContextMenuRequest::<wbr/>isContentEditable()const</a></code></p>
     */
    @QtPropertyReader(name="isContentEditable")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean isContentEditable(){
        return isContentEditable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isContentEditable_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#linkText">QWebEngineContextMenuRequest::<wbr/>linkText()const</a></code></p>
     */
    @QtPropertyReader(name="linkText")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String linkText(){
        return linkText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String linkText_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#linkUrl">QWebEngineContextMenuRequest::<wbr/>linkUrl()const</a></code></p>
     */
    @QtPropertyReader(name="linkUrl")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl linkUrl(){
        return linkUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl linkUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#mediaFlags">QWebEngineContextMenuRequest::<wbr/>mediaFlags()const</a></code></p>
     */
    @QtPropertyReader(name="mediaFlags")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineContextMenuRequest.@NonNull MediaFlags mediaFlags(){
        return new io.qt.webengine.core.QWebEngineContextMenuRequest.MediaFlags(mediaFlags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int mediaFlags_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#mediaType">QWebEngineContextMenuRequest::<wbr/>mediaType()const</a></code></p>
     */
    @QtPropertyReader(name="mediaType")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineContextMenuRequest.@NonNull MediaType mediaType(){
        return io.qt.webengine.core.QWebEngineContextMenuRequest.MediaType.resolve(mediaType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int mediaType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#mediaUrl">QWebEngineContextMenuRequest::<wbr/>mediaUrl()const</a></code></p>
     */
    @QtPropertyReader(name="mediaUrl")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl mediaUrl(){
        return mediaUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl mediaUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#misspelledWord">QWebEngineContextMenuRequest::<wbr/>misspelledWord()const</a></code></p>
     */
    @QtPropertyReader(name="misspelledWord")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String misspelledWord(){
        return misspelledWord_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String misspelledWord_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#position">QWebEngineContextMenuRequest::<wbr/>position()const</a></code></p>
     */
    @QtPropertyReader(name="position")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPoint position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#selectedText">QWebEngineContextMenuRequest::<wbr/>selectedText()const</a></code></p>
     */
    @QtPropertyReader(name="selectedText")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String selectedText(){
        return selectedText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String selectedText_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#accepted-prop">QWebEngineContextMenuRequest::<wbr/>setAccepted(bool)</a></code></p>
     */
    @QtPropertyWriter(name="accepted")
    @QtUninvokable
    public final void setAccepted(boolean accepted){
        setAccepted_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), accepted);
    }
    
    @QtUninvokable
    private native void setAccepted_native_bool(long __this__nativeId, boolean accepted);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#spellCheckerSuggestions">QWebEngineContextMenuRequest::<wbr/>spellCheckerSuggestions()const</a></code></p>
     */
    @QtPropertyReader(name="spellCheckerSuggestions")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList spellCheckerSuggestions(){
        return spellCheckerSuggestions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList spellCheckerSuggestions_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWebEngineContextMenuRequest(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #editFlags()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineContextMenuRequest.@NonNull EditFlags getEditFlags() {
        return editFlags();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isAccepted()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAccepted() {
        return isAccepted();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #linkText()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getLinkText() {
        return linkText();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #linkUrl()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getLinkUrl() {
        return linkUrl();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #mediaFlags()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineContextMenuRequest.@NonNull MediaFlags getMediaFlags() {
        return mediaFlags();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #mediaType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineContextMenuRequest.@NonNull MediaType getMediaType() {
        return mediaType();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #mediaUrl()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getMediaUrl() {
        return mediaUrl();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #misspelledWord()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getMisspelledWord() {
        return misspelledWord();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #position()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint getPosition() {
        return position();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #selectedText()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getSelectedText() {
        return selectedText();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #spellCheckerSuggestions()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getSpellCheckerSuggestions() {
        return spellCheckerSuggestions();
    }
}
