package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Java wrapper for Qt header file QtWebEngineCore</p>
 */
public final class QtWebEngineCore
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QtWebEngineCore() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QtWebEngineCore."); }
    
    /**
     * <p>Java wrapper for Qt enum QtWebEngineCore::ReferrerPolicy</p>
     */
    @QtRejectedEntries({"Last"})
    public enum ReferrerPolicy implements QtEnumerator {
        /**
         * <p>Representing QtWebEngineCore::ReferrerPolicy::Always</p>
         */
        Always(0),
        /**
         * <p>Representing QtWebEngineCore::ReferrerPolicy::Default</p>
         */
        Default(1),
        /**
         * <p>Representing QtWebEngineCore::ReferrerPolicy::NoReferrerWhenDowngrade</p>
         */
        NoReferrerWhenDowngrade(2),
        /**
         * <p>Representing QtWebEngineCore::ReferrerPolicy::Never</p>
         */
        Never(3),
        /**
         * <p>Representing QtWebEngineCore::ReferrerPolicy::Origin</p>
         */
        Origin(4),
        /**
         * <p>Representing QtWebEngineCore::ReferrerPolicy::OriginWhenCrossOrigin</p>
         */
        OriginWhenCrossOrigin(5),
        /**
         * <p>Representing QtWebEngineCore::ReferrerPolicy::NoReferrerWhenDowngradeOriginWhenCrossOrigin</p>
         */
        NoReferrerWhenDowngradeOriginWhenCrossOrigin(6),
        /**
         * <p>Representing QtWebEngineCore::ReferrerPolicy::SameOrigin</p>
         */
        SameOrigin(7),
        /**
         * <p>Representing QtWebEngineCore::ReferrerPolicy::StrictOrigin</p>
         */
        StrictOrigin(8),
        /**
         * <p>Representing QtWebEngineCore::ReferrerPolicy::Last</p>
         */
        Last(8);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ReferrerPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ReferrerPolicy resolve(int value) {
            switch (value) {
            case 0: return Always;
            case 1: return Default;
            case 2: return NoReferrerWhenDowngrade;
            case 3: return Never;
            case 4: return Origin;
            case 5: return OriginWhenCrossOrigin;
            case 6: return NoReferrerWhenDowngradeOriginWhenCrossOrigin;
            case 7: return SameOrigin;
            case 8: return StrictOrigin;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qtwebenginecoreglobal-h.html#qWebEngineChromiumSecurityPatchVersion">qWebEngineChromiumSecurityPatchVersion()</a></p>
     */
    public native static java.lang.@Nullable String qWebEngineChromiumSecurityPatchVersion();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qtwebenginecoreglobal-h.html#qWebEngineChromiumVersion">qWebEngineChromiumVersion()</a></p>
     */
    public native static java.lang.@Nullable String qWebEngineChromiumVersion();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qtwebenginecoreglobal-h.html#qWebEngineVersion">qWebEngineVersion()</a></p>
     */
    public native static java.lang.@Nullable String qWebEngineVersion();
    
}
