package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Configures a custom URL scheme</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebengineurlscheme.html">QWebEngineUrlScheme</a></p>
 */
public class QWebEngineUrlScheme extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineUrlScheme.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#Flag-enum">QWebEngineUrlScheme::Flag</a></p>
     * 
     * @see Flags
     */
    public enum Flag implements QtFlagEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#Flag-enum">QWebEngineUrlScheme::SecureScheme</a></p>
         */
        SecureScheme(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#Flag-enum">QWebEngineUrlScheme::LocalScheme</a></p>
         */
        LocalScheme(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#Flag-enum">QWebEngineUrlScheme::LocalAccessAllowed</a></p>
         */
        LocalAccessAllowed(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#Flag-enum">QWebEngineUrlScheme::NoAccessAllowed</a></p>
         */
        NoAccessAllowed(8),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#Flag-enum">QWebEngineUrlScheme::ServiceWorkersAllowed</a></p>
         */
        ServiceWorkersAllowed(16),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#Flag-enum">QWebEngineUrlScheme::ViewSourceAllowed</a></p>
         */
        ViewSourceAllowed(32),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#Flag-enum">QWebEngineUrlScheme::ContentSecurityPolicyIgnored</a></p>
         */
        ContentSecurityPolicyIgnored(64),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#Flag-enum">QWebEngineUrlScheme::CorsEnabled</a></p>
         */
        CorsEnabled(128);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Flag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull Flags asFlags() {
            return new Flags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull Flags combined(@NonNull Flag e) {
            return new Flags(this, e);
        }

        /**
         * Creates a new {@link Flags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull Flags flags(@Nullable Flag @NonNull... values) {
            return new Flags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Flag resolve(int value) {
            switch (value) {
            case 1: return SecureScheme;
            case 2: return LocalScheme;
            case 4: return LocalAccessAllowed;
            case 8: return NoAccessAllowed;
            case 16: return ServiceWorkersAllowed;
            case 32: return ViewSourceAllowed;
            case 64: return ContentSecurityPolicyIgnored;
            case 128: return CorsEnabled;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Flag}
     */
    public static final class Flags extends QFlags<Flag> implements Comparable<Flags> {
        private static final long serialVersionUID = 0x92d9bce6c929c1c6L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new Flags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Flags(@Nullable Flag @NonNull... args){
            super(args);
        }

        /**
         * Creates a new Flags with given <code>value</code>.
         * @param value
         */
        public Flags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Flags
         */
        @Override
        public final @NonNull Flags combined(@StrictNonNull Flag e){
            return new Flags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull Flags setFlag(@Nullable Flag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull Flags setFlag(@Nullable Flag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Flags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull Flag @NonNull[] flags(){
            return super.flags(Flag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull Flags clone(){
            return new Flags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull Flags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#Syntax-enum">QWebEngineUrlScheme::Syntax</a></p>
     */
    public enum Syntax implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#Syntax-enum">QWebEngineUrlScheme::Syntax::HostPortAndUserInformation</a></p>
         */
        HostPortAndUserInformation(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#Syntax-enum">QWebEngineUrlScheme::Syntax::HostAndPort</a></p>
         */
        HostAndPort(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#Syntax-enum">QWebEngineUrlScheme::Syntax::Host</a></p>
         */
        Host(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#Syntax-enum">QWebEngineUrlScheme::Syntax::Path</a></p>
         */
        Path(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Syntax(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Syntax resolve(int value) {
            switch (value) {
            case 0: return HostPortAndUserInformation;
            case 1: return HostAndPort;
            case 2: return Host;
            case 3: return Path;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#QWebEngineUrlScheme">QWebEngineUrlScheme::QWebEngineUrlScheme()</a></p>
     */
    public QWebEngineUrlScheme(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QWebEngineUrlScheme instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#QWebEngineUrlScheme-1">QWebEngineUrlScheme::QWebEngineUrlScheme(QByteArray)</a></p>
     */
    public QWebEngineUrlScheme(io.qt.core.@NonNull QByteArray name){
        super((QPrivateConstructor)null);
        initialize_native(this, name);
    }
    
    private native static void initialize_native(QWebEngineUrlScheme instance, io.qt.core.QByteArray name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#QWebEngineUrlScheme-2">QWebEngineUrlScheme::QWebEngineUrlScheme(QWebEngineUrlScheme)</a></p>
     */
    public QWebEngineUrlScheme(io.qt.webengine.core.@NonNull QWebEngineUrlScheme that){
        super((QPrivateConstructor)null);
        initialize_native(this, that);
    }
    
    private native static void initialize_native(QWebEngineUrlScheme instance, io.qt.webengine.core.QWebEngineUrlScheme that);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#defaultPort">QWebEngineUrlScheme::defaultPort()const</a></p>
     */
    @QtUninvokable
    public final int defaultPort(){
        return defaultPort_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int defaultPort_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#flags">QWebEngineUrlScheme::flags()const</a></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineUrlScheme.@NonNull Flags flags(){
        return new io.qt.webengine.core.QWebEngineUrlScheme.Flags(flags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int flags_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#name">QWebEngineUrlScheme::name()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray name_native_constfct(long __this__nativeId);
    
    /**
     * @deprecated Use {@link #assign(io.qt.webengine.core.QWebEngineUrlScheme)} instead.
     */
    @Deprecated
    @QtUninvokable
    public final void set(io.qt.webengine.core.@NonNull QWebEngineUrlScheme that) {
        assign(that);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#operator-eq">QWebEngineUrlScheme::operator=(QWebEngineUrlScheme)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.webengine.core.@NonNull QWebEngineUrlScheme that){
        assign_native_cref_QWebEngineUrlScheme(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(that));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QWebEngineUrlScheme(long __this__nativeId, long that);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#operator-eq-eq">QWebEngineUrlScheme::operator==(QWebEngineUrlScheme)const</a></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.webengine.core.@NonNull QWebEngineUrlScheme that){
        return operator_equal_native_cref_QWebEngineUrlScheme_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(that));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QWebEngineUrlScheme_constfct(long __this__nativeId, long that);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#setDefaultPort">QWebEngineUrlScheme::setDefaultPort(int)</a></p>
     */
    @QtUninvokable
    public final void setDefaultPort(int newValue){
        setDefaultPort_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), newValue);
    }
    
    @QtUninvokable
    private native void setDefaultPort_native_int(long __this__nativeId, int newValue);
    
    /**
     * <p>Overloaded function for {@link #setFlags(io.qt.webengine.core.QWebEngineUrlScheme.Flags)}.</p>
     */
    @QtUninvokable
    public final void setFlags(io.qt.webengine.core.QWebEngineUrlScheme.@NonNull Flag @NonNull... newValue){
        setFlags(new io.qt.webengine.core.QWebEngineUrlScheme.Flags(newValue));
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#setFlags">QWebEngineUrlScheme::setFlags(QWebEngineUrlScheme::Flags)</a></p>
     */
    @QtUninvokable
    public final void setFlags(io.qt.webengine.core.QWebEngineUrlScheme.@NonNull Flags newValue){
        setFlags_native_QWebEngineUrlScheme_Flags(QtJambi_LibraryUtilities.internal.nativeId(this), newValue.value());
    }
    
    @QtUninvokable
    private native void setFlags_native_QWebEngineUrlScheme_Flags(long __this__nativeId, int newValue);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#setName">QWebEngineUrlScheme::setName(QByteArray)</a></p>
     */
    @QtUninvokable
    public final void setName(io.qt.core.@NonNull QByteArray newValue){
        setName_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newValue));
    }
    
    @QtUninvokable
    private native void setName_native_cref_QByteArray(long __this__nativeId, long newValue);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#setSyntax">QWebEngineUrlScheme::setSyntax(QWebEngineUrlScheme::Syntax)</a></p>
     */
    @QtUninvokable
    public final void setSyntax(io.qt.webengine.core.QWebEngineUrlScheme.@NonNull Syntax newValue){
        setSyntax_native_QWebEngineUrlScheme_Syntax(QtJambi_LibraryUtilities.internal.nativeId(this), newValue.value());
    }
    
    @QtUninvokable
    private native void setSyntax_native_QWebEngineUrlScheme_Syntax(long __this__nativeId, int newValue);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#syntax">QWebEngineUrlScheme::syntax()const</a></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineUrlScheme.@NonNull Syntax syntax(){
        return io.qt.webengine.core.QWebEngineUrlScheme.Syntax.resolve(syntax_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int syntax_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#registerScheme">QWebEngineUrlScheme::registerScheme(QWebEngineUrlScheme)</a></p>
     */
    public static void registerScheme(io.qt.webengine.core.@NonNull QWebEngineUrlScheme scheme){
        registerScheme_native_cref_QWebEngineUrlScheme(QtJambi_LibraryUtilities.internal.checkedNativeId(scheme));
    }
    
    private native static void registerScheme_native_cref_QWebEngineUrlScheme(long scheme);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlscheme.html#schemeByName">QWebEngineUrlScheme::schemeByName(QByteArray)</a></p>
     */
    public static io.qt.webengine.core.@NonNull QWebEngineUrlScheme schemeByName(io.qt.core.@NonNull QByteArray name){
        return schemeByName_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.checkedNativeId(name));
    }
    
    private native static io.qt.webengine.core.QWebEngineUrlScheme schemeByName_native_cref_QByteArray(long name);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineUrlScheme(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.webengine.core.QWebEngineUrlScheme) {
            return operator_equal((io.qt.webengine.core.QWebEngineUrlScheme) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QWebEngineUrlScheme clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QWebEngineUrlScheme clone_native(long __this_nativeId);
}
