package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Object to store the settings used by QWebEnginePage</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebenginesettings.html">QWebEngineSettings</a></p>
 */
public final class QWebEngineSettings extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::FontFamily</a></p>
     */
    public enum FontFamily implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::StandardFont</a></p>
         */
        StandardFont(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::FixedFont</a></p>
         */
        FixedFont(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::SerifFont</a></p>
         */
        SerifFont(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::SansSerifFont</a></p>
         */
        SansSerifFont(3),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::CursiveFont</a></p>
         */
        CursiveFont(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::FantasyFont</a></p>
         */
        FantasyFont(5),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::PictographFont</a></p>
         */
        PictographFont(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FontFamily(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FontFamily resolve(int value) {
            switch (value) {
            case 0: return StandardFont;
            case 1: return FixedFont;
            case 2: return SerifFont;
            case 3: return SansSerifFont;
            case 4: return CursiveFont;
            case 5: return FantasyFont;
            case 6: return PictographFont;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginesettings.html#FontSize-enum">QWebEngineSettings::FontSize</a></p>
     */
    public enum FontSize implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#FontSize-enum">QWebEngineSettings::MinimumFontSize</a></p>
         */
        MinimumFontSize(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#FontSize-enum">QWebEngineSettings::MinimumLogicalFontSize</a></p>
         */
        MinimumLogicalFontSize(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#FontSize-enum">QWebEngineSettings::DefaultFontSize</a></p>
         */
        DefaultFontSize(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#FontSize-enum">QWebEngineSettings::DefaultFixedFontSize</a></p>
         */
        DefaultFixedFontSize(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FontSize(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FontSize resolve(int value) {
            switch (value) {
            case 0: return MinimumFontSize;
            case 1: return MinimumLogicalFontSize;
            case 2: return DefaultFontSize;
            case 3: return DefaultFixedFontSize;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginesettings.html#UnknownUrlSchemePolicy-enum">QWebEngineSettings::UnknownUrlSchemePolicy</a></p>
     */
    public enum UnknownUrlSchemePolicy implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#UnknownUrlSchemePolicy-enum">QWebEngineSettings::InheritedUnknownUrlSchemePolicy</a></p>
         */
        InheritedUnknownUrlSchemePolicy(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#UnknownUrlSchemePolicy-enum">QWebEngineSettings::DisallowUnknownUrlSchemes</a></p>
         */
        DisallowUnknownUrlSchemes(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#UnknownUrlSchemePolicy-enum">QWebEngineSettings::AllowUnknownUrlSchemesFromUserInteraction</a></p>
         */
        AllowUnknownUrlSchemesFromUserInteraction(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#UnknownUrlSchemePolicy-enum">QWebEngineSettings::AllowAllUnknownUrlSchemes</a></p>
         */
        AllowAllUnknownUrlSchemes(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private UnknownUrlSchemePolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull UnknownUrlSchemePolicy resolve(int value) {
            switch (value) {
            case 0: return InheritedUnknownUrlSchemePolicy;
            case 1: return DisallowUnknownUrlSchemes;
            case 2: return AllowUnknownUrlSchemesFromUserInteraction;
            case 3: return AllowAllUnknownUrlSchemes;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::WebAttribute</a></p>
     */
    public enum WebAttribute implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::AutoLoadImages</a></p>
         */
        AutoLoadImages(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::JavascriptEnabled</a></p>
         */
        JavascriptEnabled(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::JavascriptCanOpenWindows</a></p>
         */
        JavascriptCanOpenWindows(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::JavascriptCanAccessClipboard</a></p>
         */
        JavascriptCanAccessClipboard(3),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::LinksIncludedInFocusChain</a></p>
         */
        LinksIncludedInFocusChain(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::LocalStorageEnabled</a></p>
         */
        LocalStorageEnabled(5),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::LocalContentCanAccessRemoteUrls</a></p>
         */
        LocalContentCanAccessRemoteUrls(6),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::XSSAuditingEnabled</a></p>
         */
        XSSAuditingEnabled(7),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::SpatialNavigationEnabled</a></p>
         */
        SpatialNavigationEnabled(8),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::LocalContentCanAccessFileUrls</a></p>
         */
        LocalContentCanAccessFileUrls(9),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::HyperlinkAuditingEnabled</a></p>
         */
        HyperlinkAuditingEnabled(10),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::ScrollAnimatorEnabled</a></p>
         */
        ScrollAnimatorEnabled(11),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::ErrorPageEnabled</a></p>
         */
        ErrorPageEnabled(12),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::PluginsEnabled</a></p>
         */
        PluginsEnabled(13),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::FullScreenSupportEnabled</a></p>
         */
        FullScreenSupportEnabled(14),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::ScreenCaptureEnabled</a></p>
         */
        ScreenCaptureEnabled(15),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::WebGLEnabled</a></p>
         */
        WebGLEnabled(16),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::Accelerated2dCanvasEnabled</a></p>
         */
        Accelerated2dCanvasEnabled(17),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::AutoLoadIconsForPage</a></p>
         */
        AutoLoadIconsForPage(18),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::TouchIconsEnabled</a></p>
         */
        TouchIconsEnabled(19),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::FocusOnNavigationEnabled</a></p>
         */
        FocusOnNavigationEnabled(20),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::PrintElementBackgrounds</a></p>
         */
        PrintElementBackgrounds(21),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::AllowRunningInsecureContent</a></p>
         */
        AllowRunningInsecureContent(22),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::AllowGeolocationOnInsecureOrigins</a></p>
         */
        AllowGeolocationOnInsecureOrigins(23),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::AllowWindowActivationFromJavaScript</a></p>
         */
        AllowWindowActivationFromJavaScript(24),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::ShowScrollBars</a></p>
         */
        ShowScrollBars(25),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::PlaybackRequiresUserGesture</a></p>
         */
        PlaybackRequiresUserGesture(26),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::WebRTCPublicInterfacesOnly</a></p>
         */
        WebRTCPublicInterfacesOnly(27),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::JavascriptCanPaste</a></p>
         */
        JavascriptCanPaste(28),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::DnsPrefetchEnabled</a></p>
         */
        DnsPrefetchEnabled(29),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::PdfViewerEnabled</a></p>
         */
        PdfViewerEnabled(30),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::NavigateOnDropEnabled</a></p>
         */
        NavigateOnDropEnabled(31);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private WebAttribute(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull WebAttribute resolve(int value) {
            switch (value) {
            case 0: return AutoLoadImages;
            case 1: return JavascriptEnabled;
            case 2: return JavascriptCanOpenWindows;
            case 3: return JavascriptCanAccessClipboard;
            case 4: return LinksIncludedInFocusChain;
            case 5: return LocalStorageEnabled;
            case 6: return LocalContentCanAccessRemoteUrls;
            case 7: return XSSAuditingEnabled;
            case 8: return SpatialNavigationEnabled;
            case 9: return LocalContentCanAccessFileUrls;
            case 10: return HyperlinkAuditingEnabled;
            case 11: return ScrollAnimatorEnabled;
            case 12: return ErrorPageEnabled;
            case 13: return PluginsEnabled;
            case 14: return FullScreenSupportEnabled;
            case 15: return ScreenCaptureEnabled;
            case 16: return WebGLEnabled;
            case 17: return Accelerated2dCanvasEnabled;
            case 18: return AutoLoadIconsForPage;
            case 19: return TouchIconsEnabled;
            case 20: return FocusOnNavigationEnabled;
            case 21: return PrintElementBackgrounds;
            case 22: return AllowRunningInsecureContent;
            case 23: return AllowGeolocationOnInsecureOrigins;
            case 24: return AllowWindowActivationFromJavaScript;
            case 25: return ShowScrollBars;
            case 26: return PlaybackRequiresUserGesture;
            case 27: return WebRTCPublicInterfacesOnly;
            case 28: return JavascriptCanPaste;
            case 29: return DnsPrefetchEnabled;
            case 30: return PdfViewerEnabled;
            case 31: return NavigateOnDropEnabled;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#defaultTextEncoding">QWebEngineSettings::defaultTextEncoding()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String defaultTextEncoding(){
        return defaultTextEncoding_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String defaultTextEncoding_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#fontFamily">QWebEngineSettings::fontFamily(QWebEngineSettings::FontFamily)const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String fontFamily(io.qt.webengine.core.QWebEngineSettings.@NonNull FontFamily which){
        return fontFamily_native_QWebEngineSettings_FontFamily_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), which.value());
    }
    
    @QtUninvokable
    private native java.lang.String fontFamily_native_QWebEngineSettings_FontFamily_constfct(long __this__nativeId, int which);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#fontSize">QWebEngineSettings::fontSize(QWebEngineSettings::FontSize)const</a></p>
     */
    @QtUninvokable
    public final int fontSize(io.qt.webengine.core.QWebEngineSettings.@NonNull FontSize type){
        return fontSize_native_QWebEngineSettings_FontSize_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native int fontSize_native_QWebEngineSettings_FontSize_constfct(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#resetAttribute">QWebEngineSettings::resetAttribute(QWebEngineSettings::WebAttribute)</a></p>
     */
    @QtUninvokable
    public final void resetAttribute(io.qt.webengine.core.QWebEngineSettings.@NonNull WebAttribute attr){
        resetAttribute_native_QWebEngineSettings_WebAttribute(QtJambi_LibraryUtilities.internal.nativeId(this), attr.value());
    }
    
    @QtUninvokable
    private native void resetAttribute_native_QWebEngineSettings_WebAttribute(long __this__nativeId, int attr);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#resetFontFamily">QWebEngineSettings::resetFontFamily(QWebEngineSettings::FontFamily)</a></p>
     */
    @QtUninvokable
    public final void resetFontFamily(io.qt.webengine.core.QWebEngineSettings.@NonNull FontFamily which){
        resetFontFamily_native_QWebEngineSettings_FontFamily(QtJambi_LibraryUtilities.internal.nativeId(this), which.value());
    }
    
    @QtUninvokable
    private native void resetFontFamily_native_QWebEngineSettings_FontFamily(long __this__nativeId, int which);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#resetFontSize">QWebEngineSettings::resetFontSize(QWebEngineSettings::FontSize)</a></p>
     */
    @QtUninvokable
    public final void resetFontSize(io.qt.webengine.core.QWebEngineSettings.@NonNull FontSize type){
        resetFontSize_native_QWebEngineSettings_FontSize(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native void resetFontSize_native_QWebEngineSettings_FontSize(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#resetUnknownUrlSchemePolicy">QWebEngineSettings::resetUnknownUrlSchemePolicy()</a></p>
     */
    @QtUninvokable
    public final void resetUnknownUrlSchemePolicy(){
        resetUnknownUrlSchemePolicy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void resetUnknownUrlSchemePolicy_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#setAttribute">QWebEngineSettings::setAttribute(QWebEngineSettings::WebAttribute,bool)</a></p>
     */
    @QtUninvokable
    public final void setAttribute(io.qt.webengine.core.QWebEngineSettings.@NonNull WebAttribute attr, boolean on){
        setAttribute_native_QWebEngineSettings_WebAttribute_bool(QtJambi_LibraryUtilities.internal.nativeId(this), attr.value(), on);
    }
    
    @QtUninvokable
    private native void setAttribute_native_QWebEngineSettings_WebAttribute_bool(long __this__nativeId, int attr, boolean on);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#setDefaultTextEncoding">QWebEngineSettings::setDefaultTextEncoding(QString)</a></p>
     */
    @QtUninvokable
    public final void setDefaultTextEncoding(java.lang.@NonNull String encoding){
        setDefaultTextEncoding_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), encoding);
    }
    
    @QtUninvokable
    private native void setDefaultTextEncoding_native_cref_QString(long __this__nativeId, java.lang.String encoding);
    
    @QtUninvokable
    public final void setFontFamily(io.qt.webengine.core.QWebEngineSettings.@NonNull FontFamily which, java.lang.@NonNull String family){
        setFontFamily_native_QWebEngineSettings_FontFamily_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), which.value(), family);
    }
    
    @QtUninvokable
    private native void setFontFamily_native_QWebEngineSettings_FontFamily_cref_QString(long __this__nativeId, int which, java.lang.String family);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#setFontSize">QWebEngineSettings::setFontSize(QWebEngineSettings::FontSize,int)</a></p>
     */
    @QtUninvokable
    public final void setFontSize(io.qt.webengine.core.QWebEngineSettings.@NonNull FontSize type, int size){
        setFontSize_native_QWebEngineSettings_FontSize_int(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), size);
    }
    
    @QtUninvokable
    private native void setFontSize_native_QWebEngineSettings_FontSize_int(long __this__nativeId, int type, int size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#setUnknownUrlSchemePolicy">QWebEngineSettings::setUnknownUrlSchemePolicy(QWebEngineSettings::UnknownUrlSchemePolicy)</a></p>
     */
    @QtUninvokable
    public final void setUnknownUrlSchemePolicy(io.qt.webengine.core.QWebEngineSettings.@NonNull UnknownUrlSchemePolicy policy){
        setUnknownUrlSchemePolicy_native_QWebEngineSettings_UnknownUrlSchemePolicy(QtJambi_LibraryUtilities.internal.nativeId(this), policy.value());
    }
    
    @QtUninvokable
    private native void setUnknownUrlSchemePolicy_native_QWebEngineSettings_UnknownUrlSchemePolicy(long __this__nativeId, int policy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#testAttribute">QWebEngineSettings::testAttribute(QWebEngineSettings::WebAttribute)const</a></p>
     */
    @QtUninvokable
    public final boolean testAttribute(io.qt.webengine.core.QWebEngineSettings.@NonNull WebAttribute attr){
        return testAttribute_native_QWebEngineSettings_WebAttribute_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), attr.value());
    }
    
    @QtUninvokable
    private native boolean testAttribute_native_QWebEngineSettings_WebAttribute_constfct(long __this__nativeId, int attr);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#unknownUrlSchemePolicy">QWebEngineSettings::unknownUrlSchemePolicy()const</a></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineSettings.@NonNull UnknownUrlSchemePolicy unknownUrlSchemePolicy(){
        return io.qt.webengine.core.QWebEngineSettings.UnknownUrlSchemePolicy.resolve(unknownUrlSchemePolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int unknownUrlSchemePolicy_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineSettings(QPrivateConstructor p) { super(p); } 
    
}
