package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Enables accepting or rejecting requests for entering and exiting the fullscreen mode</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebenginefullscreenrequest.html">QWebEngineFullScreenRequest</a></p>
 */
public class QWebEngineFullScreenRequest extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineFullScreenRequest.class);
    
    
    public QWebEngineFullScreenRequest(io.qt.webengine.core.@NonNull QWebEngineFullScreenRequest other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebEngineFullScreenRequest instance, io.qt.webengine.core.QWebEngineFullScreenRequest other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginefullscreenrequest.html#accept">QWebEngineFullScreenRequest::accept()</a></p>
     */
    public final void accept(){
        accept_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void accept_native(long __this__nativeId);
    
    /**
     * @deprecated Use {@link #assign(io.qt.webengine.core.QWebEngineFullScreenRequest)} instead.
     */
    @Deprecated
    @QtUninvokable
    public final void set(io.qt.webengine.core.@NonNull QWebEngineFullScreenRequest other) {
        assign(other);
    }
    
    @QtUninvokable
    public final void assign(io.qt.webengine.core.@NonNull QWebEngineFullScreenRequest other){
        assign_native_cref_QWebEngineFullScreenRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QWebEngineFullScreenRequest(long __this__nativeId, long other);
    
    @QtUninvokable
    private final boolean operator_equal(io.qt.webengine.core.@NonNull QWebEngineFullScreenRequest arg2){
        return operator_equal_native_cref_QWebEngineFullScreenRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg2));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QWebEngineFullScreenRequest(long __this__nativeId, long arg2);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #origin()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getOrigin() {
        return origin();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginefullscreenrequest.html#origin">QWebEngineFullScreenRequest::origin()const</a></p>
     */
    @QtPropertyReader(name="origin")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl origin(){
        return origin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl origin_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginefullscreenrequest.html#reject">QWebEngineFullScreenRequest::reject()</a></p>
     */
    public final void reject(){
        reject_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void reject_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #toggleOn()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getToggleOn() {
        return toggleOn();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginefullscreenrequest.html#toggleOn">QWebEngineFullScreenRequest::toggleOn()const</a></p>
     */
    @QtPropertyReader(name="toggleOn")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean toggleOn(){
        return toggleOn_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean toggleOn_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineFullScreenRequest(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.webengine.core.QWebEngineFullScreenRequest) {
            return operator_equal((io.qt.webengine.core.QWebEngineFullScreenRequest) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QWebEngineFullScreenRequest clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QWebEngineFullScreenRequest clone_native(long __this_nativeId);
}
