package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Encapsulates a JavaScript program</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebenginescript.html">QWebEngineScript</a></p>
 */
public class QWebEngineScript extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineScript.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginescript.html#InjectionPoint-enum">QWebEngineScript::InjectionPoint</a></p>
     */
    public enum InjectionPoint implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginescript.html#InjectionPoint-enum">QWebEngineScript::Deferred</a></p>
         */
        Deferred(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginescript.html#InjectionPoint-enum">QWebEngineScript::DocumentReady</a></p>
         */
        DocumentReady(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginescript.html#InjectionPoint-enum">QWebEngineScript::DocumentCreation</a></p>
         */
        DocumentCreation(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private InjectionPoint(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull InjectionPoint resolve(int value) {
            switch (value) {
            case 0: return Deferred;
            case 1: return DocumentReady;
            case 2: return DocumentCreation;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginescript.html#ScriptWorldId-enum">QWebEngineScript::ScriptWorldId</a></p>
     */
    public enum ScriptWorldId implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginescript.html#ScriptWorldId-enum">QWebEngineScript::MainWorld</a></p>
         */
        MainWorld(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginescript.html#ScriptWorldId-enum">QWebEngineScript::ApplicationWorld</a></p>
         */
        ApplicationWorld(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginescript.html#ScriptWorldId-enum">QWebEngineScript::UserWorld</a></p>
         */
        UserWorld(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ScriptWorldId(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ScriptWorldId resolve(int value) {
            switch (value) {
            case 0: return MainWorld;
            case 1: return ApplicationWorld;
            case 2: return UserWorld;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#QWebEngineScript">QWebEngineScript::QWebEngineScript()</a></p>
     */
    public QWebEngineScript(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QWebEngineScript instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#QWebEngineScript-1">QWebEngineScript::QWebEngineScript(QWebEngineScript)</a></p>
     */
    public QWebEngineScript(io.qt.webengine.core.@NonNull QWebEngineScript other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebEngineScript instance, io.qt.webengine.core.QWebEngineScript other);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #injectionPoint()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineScript.@NonNull InjectionPoint getInjectionPoint() {
        return injectionPoint();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#injectionPoint">QWebEngineScript::injectionPoint()const</a></p>
     */
    @QtPropertyReader(name="injectionPoint")
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineScript.@NonNull InjectionPoint injectionPoint(){
        return io.qt.webengine.core.QWebEngineScript.InjectionPoint.resolve(injectionPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int injectionPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #name()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getName() {
        return name();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#name">QWebEngineScript::name()const</a></p>
     */
    @QtPropertyReader(name="name")
    @QtUninvokable
    public final java.lang.@NonNull String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * @deprecated Use {@link #assign(io.qt.webengine.core.QWebEngineScript)} instead.
     */
    @Deprecated
    @QtUninvokable
    public final void set(io.qt.webengine.core.@NonNull QWebEngineScript other) {
        assign(other);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#operator-eq">QWebEngineScript::operator=(QWebEngineScript)</a></p>
     */
    @QtUninvokable
    public final void assign(io.qt.webengine.core.@NonNull QWebEngineScript other){
        assign_native_cref_QWebEngineScript(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QWebEngineScript(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#operator-eq-eq">QWebEngineScript::operator==(QWebEngineScript)const</a></p>
     */
    @QtUninvokable
    private final boolean operator_equal(io.qt.webengine.core.@NonNull QWebEngineScript other){
        return operator_equal_native_cref_QWebEngineScript_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QWebEngineScript_constfct(long __this__nativeId, long other);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #runsOnSubFrames()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getRunsOnSubFrames() {
        return runsOnSubFrames();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#runsOnSubFrames">QWebEngineScript::runsOnSubFrames()const</a></p>
     */
    @QtPropertyReader(name="runsOnSubFrames")
    @QtUninvokable
    public final boolean runsOnSubFrames(){
        return runsOnSubFrames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean runsOnSubFrames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#setInjectionPoint">QWebEngineScript::setInjectionPoint(QWebEngineScript::InjectionPoint)</a></p>
     */
    @QtPropertyWriter(name="injectionPoint")
    @QtUninvokable
    public final void setInjectionPoint(io.qt.webengine.core.QWebEngineScript.@NonNull InjectionPoint arg__1){
        setInjectionPoint_native_QWebEngineScript_InjectionPoint(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @QtUninvokable
    private native void setInjectionPoint_native_QWebEngineScript_InjectionPoint(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#setName">QWebEngineScript::setName(QString)</a></p>
     */
    @QtPropertyWriter(name="name")
    @QtUninvokable
    public final void setName(java.lang.@NonNull String arg__1){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#setRunsOnSubFrames">QWebEngineScript::setRunsOnSubFrames(bool)</a></p>
     */
    @QtPropertyWriter(name="runsOnSubFrames")
    @QtUninvokable
    public final void setRunsOnSubFrames(boolean on){
        setRunsOnSubFrames_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), on);
    }
    
    @QtUninvokable
    private native void setRunsOnSubFrames_native_bool(long __this__nativeId, boolean on);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#setSourceCode">QWebEngineScript::setSourceCode(QString)</a></p>
     */
    @QtPropertyWriter(name="sourceCode")
    @QtUninvokable
    public final void setSourceCode(java.lang.@NonNull String arg__1){
        setSourceCode_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setSourceCode_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#sourceUrl-prop">QWebEngineScript::setSourceUrl(QUrl)</a></p>
     */
    @QtPropertyWriter(name="sourceUrl")
    @QtUninvokable
    public final void setSourceUrl(io.qt.core.@NonNull QUrl url){
        setSourceUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void setSourceUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#setWorldId">QWebEngineScript::setWorldId(quint32)</a></p>
     */
    @QtPropertyWriter(name="worldId")
    @QtUninvokable
    public final void setWorldId(int arg__1){
        setWorldId_native_quint32(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @QtUninvokable
    private native void setWorldId_native_quint32(long __this__nativeId, int arg__1);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sourceCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getSourceCode() {
        return sourceCode();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#sourceCode">QWebEngineScript::sourceCode()const</a></p>
     */
    @QtPropertyReader(name="sourceCode")
    @QtUninvokable
    public final java.lang.@NonNull String sourceCode(){
        return sourceCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String sourceCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sourceUrl()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getSourceUrl() {
        return sourceUrl();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#sourceUrl-prop">QWebEngineScript::sourceUrl()const</a></p>
     */
    @QtPropertyReader(name="sourceUrl")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl sourceUrl(){
        return sourceUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl sourceUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#swap">QWebEngineScript::swap(QWebEngineScript&amp;)</a></p>
     */
    @QtUninvokable
    public final void swap(io.qt.webengine.core.@StrictNonNull QWebEngineScript other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QWebEngineScript(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void swap_native_ref_QWebEngineScript(long __this__nativeId, long other);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #worldId()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getWorldId() {
        return worldId();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#worldId">QWebEngineScript::worldId()const</a></p>
     */
    @QtPropertyReader(name="worldId")
    @QtUninvokable
    public final int worldId(){
        return worldId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int worldId_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineScript(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.webengine.core.QWebEngineScript) {
            return operator_equal((io.qt.webengine.core.QWebEngineScript) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    @Override
    @QtUninvokable
    public @NonNull String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    @QtUninvokable
    @Override
    public QWebEngineScript clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QWebEngineScript clone_native(long __this_nativeId);
}
