package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>A utility type for the WebEngineView::loadingChanged signal</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html">QWebEngineLoadingInfo</a></p>
 */
public class QWebEngineLoadingInfo extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineLoadingInfo.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::ErrorDomain</a></p>
     */
    public enum ErrorDomain implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::NoErrorDomain</a></p>
         */
        NoErrorDomain(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::InternalErrorDomain</a></p>
         */
        InternalErrorDomain(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::ConnectionErrorDomain</a></p>
         */
        ConnectionErrorDomain(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::CertificateErrorDomain</a></p>
         */
        CertificateErrorDomain(3),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::HttpErrorDomain</a></p>
         */
        HttpErrorDomain(4),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::FtpErrorDomain</a></p>
         */
        FtpErrorDomain(5),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::DnsErrorDomain</a></p>
         */
        DnsErrorDomain(6),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::HttpStatusCodeDomain</a></p>
         */
        HttpStatusCodeDomain(7);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ErrorDomain(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ErrorDomain resolve(int value) {
            switch (value) {
            case 0: return NoErrorDomain;
            case 1: return InternalErrorDomain;
            case 2: return ConnectionErrorDomain;
            case 3: return CertificateErrorDomain;
            case 4: return HttpErrorDomain;
            case 5: return FtpErrorDomain;
            case 6: return DnsErrorDomain;
            case 7: return HttpStatusCodeDomain;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#LoadStatus-enum">QWebEngineLoadingInfo::LoadStatus</a></p>
     */
    public enum LoadStatus implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#LoadStatus-enum">QWebEngineLoadingInfo::LoadStartedStatus</a></p>
         */
        LoadStartedStatus(0),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#LoadStatus-enum">QWebEngineLoadingInfo::LoadStoppedStatus</a></p>
         */
        LoadStoppedStatus(1),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#LoadStatus-enum">QWebEngineLoadingInfo::LoadSucceededStatus</a></p>
         */
        LoadSucceededStatus(2),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#LoadStatus-enum">QWebEngineLoadingInfo::LoadFailedStatus</a></p>
         */
        LoadFailedStatus(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private LoadStatus(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull LoadStatus resolve(int value) {
            switch (value) {
            case 0: return LoadStartedStatus;
            case 1: return LoadStoppedStatus;
            case 2: return LoadSucceededStatus;
            case 3: return LoadFailedStatus;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    public QWebEngineLoadingInfo(io.qt.webengine.core.@StrictNonNull QWebEngineLoadingInfo other){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebEngineLoadingInfo instance, io.qt.webengine.core.QWebEngineLoadingInfo other);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #errorCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getErrorCode() {
        return errorCode();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#errorCode-prop">QWebEngineLoadingInfo::errorCode()const</a></p>
     */
    @QtPropertyReader(name="errorCode")
    @QtPropertyConstant
    @QtUninvokable
    public final int errorCode(){
        return errorCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int errorCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #errorDomain()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineLoadingInfo.@NonNull ErrorDomain getErrorDomain() {
        return errorDomain();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#errorDomain-prop">QWebEngineLoadingInfo::errorDomain()const</a></p>
     */
    @QtPropertyReader(name="errorDomain")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineLoadingInfo.@NonNull ErrorDomain errorDomain(){
        return io.qt.webengine.core.QWebEngineLoadingInfo.ErrorDomain.resolve(errorDomain_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int errorDomain_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #errorString()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getErrorString() {
        return errorString();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#errorString-prop">QWebEngineLoadingInfo::errorString()const</a></p>
     */
    @QtPropertyReader(name="errorString")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#isErrorPage-prop">QWebEngineLoadingInfo::isErrorPage()const</a></p>
     */
    @QtPropertyReader(name="isErrorPage")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean isErrorPage(){
        return isErrorPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isErrorPage_native_constfct(long __this__nativeId);
    
    /**
     * @deprecated Use {@link #assign(io.qt.webengine.core.QWebEngineLoadingInfo)} instead.
     */
    @Deprecated
    @QtUninvokable
    public final void set(io.qt.webengine.core.@StrictNonNull QWebEngineLoadingInfo other) {
        assign(other);
    }
    
    @QtUninvokable
    public final void assign(io.qt.webengine.core.@StrictNonNull QWebEngineLoadingInfo other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        assign_native_cref_QWebEngineLoadingInfo(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QWebEngineLoadingInfo(long __this__nativeId, long other);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #status()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineLoadingInfo.@NonNull LoadStatus getStatus() {
        return status();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#status-prop">QWebEngineLoadingInfo::status()const</a></p>
     */
    @QtPropertyReader(name="status")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineLoadingInfo.@NonNull LoadStatus status(){
        return io.qt.webengine.core.QWebEngineLoadingInfo.LoadStatus.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #url()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getUrl() {
        return url();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#url">QWebEngineLoadingInfo::url()const</a></p>
     */
    @QtPropertyReader(name="url")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineLoadingInfo(QPrivateConstructor p) { super(p); } 
    
    
    @QtUninvokable
    @Override
    public QWebEngineLoadingInfo clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QWebEngineLoadingInfo clone_native(long __this_nativeId);
}
