package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>A data model that represents the history of a web engine page</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebenginehistorymodel.html">QWebEngineHistoryModel</a></p>
 */
public final class QWebEngineHistoryModel extends io.qt.core.QAbstractListModel
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineHistoryModel.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginehistorymodel.html#Roles-enum">QWebEngineHistoryModel::Roles</a></p>
     */
    @QtUnlistedEnum
    public enum Roles implements QtEnumerator {
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginehistorymodel.html#Roles-enum">QWebEngineHistoryModel::UrlRole</a></p>
         */
        UrlRole(256),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginehistorymodel.html#Roles-enum">QWebEngineHistoryModel::TitleRole</a></p>
         */
        TitleRole(257),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginehistorymodel.html#Roles-enum">QWebEngineHistoryModel::OffsetRole</a></p>
         */
        OffsetRole(258),
        /**
         * <p>Representing <a href="https://doc.qt.io/qt/qwebenginehistorymodel.html#Roles-enum">QWebEngineHistoryModel::IconUrlRole</a></p>
         */
        IconUrlRole(259);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Roles(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Roles resolve(int value) {
            switch (value) {
            case 256: return UrlRole;
            case 257: return TitleRole;
            case 258: return OffsetRole;
            case 259: return IconUrlRole;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    @QtUninvokable
    public final void reset(){
        reset_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void reset_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#data">QAbstractItemModel::data(QModelIndex,int)const</a></p>
     */
    @QtUninvokable
    public java.lang.Object data(io.qt.core.@NonNull QModelIndex index, int role){
        return data_native_cref_QModelIndex_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index), role);
    }
    
    @QtUninvokable
    private native java.lang.Object data_native_cref_QModelIndex_int_constfct(long __this__nativeId, long index, int role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#roleNames">QAbstractItemModel::roleNames()const</a></p>
     */
    @QtUninvokable
    public java.util.@NonNull Map<java.lang.@QtPrimitiveType@NonNull Integer, io.qt.core.@NonNull QByteArray> roleNames(){
        return roleNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.util.Map<java.lang.@QtPrimitiveType Integer, io.qt.core.QByteArray> roleNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#rowCount">QAbstractItemModel::rowCount(QModelIndex)const</a></p>
     */
    @QtUninvokable
    public int rowCount(io.qt.core.@NonNull QModelIndex parent){
        return rowCount_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @QtUninvokable
    private native int rowCount_native_cref_QModelIndex_constfct(long __this__nativeId, long parent);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineHistoryModel(QPrivateConstructor p) { super(p); } 
    
}
