package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Represents a custom URL request</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html">QWebEngineUrlRequestJob</a></p>
 */
public final class QWebEngineUrlRequestJob extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineUrlRequestJob.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#Error-enum">QWebEngineUrlRequestJob::Error</a></p>
     */
    public enum Error implements QtEnumerator {
        NoError(0),
        UrlNotFound(1),
        UrlInvalid(2),
        RequestAborted(3),
        RequestDenied(4),
        RequestFailed(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return UrlNotFound;
            case 2: return UrlInvalid;
            case 3: return RequestAborted;
            case 4: return RequestDenied;
            case 5: return RequestFailed;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#fail">QWebEngineUrlRequestJob::fail(QWebEngineUrlRequestJob::Error)</a></p>
     */
    @QtUninvokable
    public final void fail(io.qt.webengine.core.QWebEngineUrlRequestJob.@NonNull Error error){
        fail_native_QWebEngineUrlRequestJob_Error(QtJambi_LibraryUtilities.internal.nativeId(this), error.value());
    }
    
    @QtUninvokable
    private native void fail_native_QWebEngineUrlRequestJob_Error(long __this__nativeId, int error);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#initiator">QWebEngineUrlRequestJob::initiator()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl initiator(){
        return initiator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl initiator_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#redirect">QWebEngineUrlRequestJob::redirect(QUrl)</a></p>
     */
    @QtUninvokable
    public final void redirect(io.qt.core.@NonNull QUrl url){
        redirect_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void redirect_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#reply">QWebEngineUrlRequestJob::reply(QByteArray,QIODevice*)</a></p>
     */
    @QtUninvokable
    public final void reply(io.qt.core.@NonNull QByteArray contentType, io.qt.core.@Nullable QIODevice device){
        reply_native_cref_QByteArray_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(contentType), QtJambi_LibraryUtilities.internal.checkedNativeId(device));
    }
    
    @QtUninvokable
    private native void reply_native_cref_QByteArray_QIODevice_ptr(long __this__nativeId, long contentType, long device);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#requestHeaders">QWebEngineUrlRequestJob::requestHeaders()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QMap<io.qt.core.@NonNull QByteArray, io.qt.core.@NonNull QByteArray> requestHeaders(){
        return requestHeaders_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QMap<io.qt.core.QByteArray, io.qt.core.QByteArray> requestHeaders_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#requestMethod">QWebEngineUrlRequestJob::requestMethod()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray requestMethod(){
        return requestMethod_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray requestMethod_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestjob.html#requestUrl">QWebEngineUrlRequestJob::requestUrl()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl requestUrl(){
        return requestUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl requestUrl_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineUrlRequestJob(QPrivateConstructor p) { super(p); } 
    
}
