package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Object to store the settings used by QWebEnginePage</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebenginesettings.html">QWebEngineSettings</a></p>
 */
public final class QWebEngineSettings extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginesettings.html#FontFamily-enum">QWebEngineSettings::FontFamily</a></p>
     */
    public enum FontFamily implements QtEnumerator {
        StandardFont(0),
        FixedFont(1),
        SerifFont(2),
        SansSerifFont(3),
        CursiveFont(4),
        FantasyFont(5),
        PictographFont(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FontFamily(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static FontFamily resolve(int value) {
            switch (value) {
            case 0: return StandardFont;
            case 1: return FixedFont;
            case 2: return SerifFont;
            case 3: return SansSerifFont;
            case 4: return CursiveFont;
            case 5: return FantasyFont;
            case 6: return PictographFont;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginesettings.html#FontSize-enum">QWebEngineSettings::FontSize</a></p>
     */
    public enum FontSize implements QtEnumerator {
        MinimumFontSize(0),
        MinimumLogicalFontSize(1),
        DefaultFontSize(2),
        DefaultFixedFontSize(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FontSize(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static FontSize resolve(int value) {
            switch (value) {
            case 0: return MinimumFontSize;
            case 1: return MinimumLogicalFontSize;
            case 2: return DefaultFontSize;
            case 3: return DefaultFixedFontSize;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginesettings.html#UnknownUrlSchemePolicy-enum">QWebEngineSettings::UnknownUrlSchemePolicy</a></p>
     */
    public enum UnknownUrlSchemePolicy implements QtEnumerator {
        InheritedUnknownUrlSchemePolicy(0),
        DisallowUnknownUrlSchemes(1),
        AllowUnknownUrlSchemesFromUserInteraction(2),
        AllowAllUnknownUrlSchemes(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private UnknownUrlSchemePolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static UnknownUrlSchemePolicy resolve(int value) {
            switch (value) {
            case 0: return InheritedUnknownUrlSchemePolicy;
            case 1: return DisallowUnknownUrlSchemes;
            case 2: return AllowUnknownUrlSchemesFromUserInteraction;
            case 3: return AllowAllUnknownUrlSchemes;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginesettings.html#WebAttribute-enum">QWebEngineSettings::WebAttribute</a></p>
     */
    public enum WebAttribute implements QtEnumerator {
        AutoLoadImages(0),
        JavascriptEnabled(1),
        JavascriptCanOpenWindows(2),
        JavascriptCanAccessClipboard(3),
        LinksIncludedInFocusChain(4),
        LocalStorageEnabled(5),
        LocalContentCanAccessRemoteUrls(6),
        XSSAuditingEnabled(7),
        SpatialNavigationEnabled(8),
        LocalContentCanAccessFileUrls(9),
        HyperlinkAuditingEnabled(10),
        ScrollAnimatorEnabled(11),
        ErrorPageEnabled(12),
        PluginsEnabled(13),
        FullScreenSupportEnabled(14),
        ScreenCaptureEnabled(15),
        WebGLEnabled(16),
        Accelerated2dCanvasEnabled(17),
        AutoLoadIconsForPage(18),
        TouchIconsEnabled(19),
        FocusOnNavigationEnabled(20),
        PrintElementBackgrounds(21),
        AllowRunningInsecureContent(22),
        AllowGeolocationOnInsecureOrigins(23),
        AllowWindowActivationFromJavaScript(24),
        ShowScrollBars(25),
        PlaybackRequiresUserGesture(26),
        WebRTCPublicInterfacesOnly(27),
        JavascriptCanPaste(28),
        DnsPrefetchEnabled(29),
        PdfViewerEnabled(30),
        NavigateOnDropEnabled(31);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private WebAttribute(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static WebAttribute resolve(int value) {
            switch (value) {
            case 0: return AutoLoadImages;
            case 1: return JavascriptEnabled;
            case 2: return JavascriptCanOpenWindows;
            case 3: return JavascriptCanAccessClipboard;
            case 4: return LinksIncludedInFocusChain;
            case 5: return LocalStorageEnabled;
            case 6: return LocalContentCanAccessRemoteUrls;
            case 7: return XSSAuditingEnabled;
            case 8: return SpatialNavigationEnabled;
            case 9: return LocalContentCanAccessFileUrls;
            case 10: return HyperlinkAuditingEnabled;
            case 11: return ScrollAnimatorEnabled;
            case 12: return ErrorPageEnabled;
            case 13: return PluginsEnabled;
            case 14: return FullScreenSupportEnabled;
            case 15: return ScreenCaptureEnabled;
            case 16: return WebGLEnabled;
            case 17: return Accelerated2dCanvasEnabled;
            case 18: return AutoLoadIconsForPage;
            case 19: return TouchIconsEnabled;
            case 20: return FocusOnNavigationEnabled;
            case 21: return PrintElementBackgrounds;
            case 22: return AllowRunningInsecureContent;
            case 23: return AllowGeolocationOnInsecureOrigins;
            case 24: return AllowWindowActivationFromJavaScript;
            case 25: return ShowScrollBars;
            case 26: return PlaybackRequiresUserGesture;
            case 27: return WebRTCPublicInterfacesOnly;
            case 28: return JavascriptCanPaste;
            case 29: return DnsPrefetchEnabled;
            case 30: return PdfViewerEnabled;
            case 31: return NavigateOnDropEnabled;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#defaultTextEncoding">QWebEngineSettings::defaultTextEncoding()const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String defaultTextEncoding(){
        return defaultTextEncoding_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String defaultTextEncoding_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#fontFamily">QWebEngineSettings::fontFamily(QWebEngineSettings::FontFamily)const</a></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String fontFamily(io.qt.webengine.core.QWebEngineSettings.@NonNull FontFamily which){
        return fontFamily_native_QWebEngineSettings_FontFamily_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), which.value());
    }
    
    @QtUninvokable
    private native java.lang.String fontFamily_native_QWebEngineSettings_FontFamily_constfct(long __this__nativeId, int which);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#fontSize">QWebEngineSettings::fontSize(QWebEngineSettings::FontSize)const</a></p>
     */
    @QtUninvokable
    public final int fontSize(io.qt.webengine.core.QWebEngineSettings.@NonNull FontSize type){
        return fontSize_native_QWebEngineSettings_FontSize_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native int fontSize_native_QWebEngineSettings_FontSize_constfct(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#resetAttribute">QWebEngineSettings::resetAttribute(QWebEngineSettings::WebAttribute)</a></p>
     */
    @QtUninvokable
    public final void resetAttribute(io.qt.webengine.core.QWebEngineSettings.@NonNull WebAttribute attr){
        resetAttribute_native_QWebEngineSettings_WebAttribute(QtJambi_LibraryUtilities.internal.nativeId(this), attr.value());
    }
    
    @QtUninvokable
    private native void resetAttribute_native_QWebEngineSettings_WebAttribute(long __this__nativeId, int attr);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#resetFontFamily">QWebEngineSettings::resetFontFamily(QWebEngineSettings::FontFamily)</a></p>
     */
    @QtUninvokable
    public final void resetFontFamily(io.qt.webengine.core.QWebEngineSettings.@NonNull FontFamily which){
        resetFontFamily_native_QWebEngineSettings_FontFamily(QtJambi_LibraryUtilities.internal.nativeId(this), which.value());
    }
    
    @QtUninvokable
    private native void resetFontFamily_native_QWebEngineSettings_FontFamily(long __this__nativeId, int which);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#resetFontSize">QWebEngineSettings::resetFontSize(QWebEngineSettings::FontSize)</a></p>
     */
    @QtUninvokable
    public final void resetFontSize(io.qt.webengine.core.QWebEngineSettings.@NonNull FontSize type){
        resetFontSize_native_QWebEngineSettings_FontSize(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native void resetFontSize_native_QWebEngineSettings_FontSize(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#resetUnknownUrlSchemePolicy">QWebEngineSettings::resetUnknownUrlSchemePolicy()</a></p>
     */
    @QtUninvokable
    public final void resetUnknownUrlSchemePolicy(){
        resetUnknownUrlSchemePolicy_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void resetUnknownUrlSchemePolicy_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#setAttribute">QWebEngineSettings::setAttribute(QWebEngineSettings::WebAttribute,bool)</a></p>
     */
    @QtUninvokable
    public final void setAttribute(io.qt.webengine.core.QWebEngineSettings.@NonNull WebAttribute attr, boolean on){
        setAttribute_native_QWebEngineSettings_WebAttribute_bool(QtJambi_LibraryUtilities.internal.nativeId(this), attr.value(), on);
    }
    
    @QtUninvokable
    private native void setAttribute_native_QWebEngineSettings_WebAttribute_bool(long __this__nativeId, int attr, boolean on);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#setDefaultTextEncoding">QWebEngineSettings::setDefaultTextEncoding(QString)</a></p>
     */
    @QtUninvokable
    public final void setDefaultTextEncoding(java.lang.@NonNull String encoding){
        setDefaultTextEncoding_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), encoding);
    }
    
    @QtUninvokable
    private native void setDefaultTextEncoding_native_cref_QString(long __this__nativeId, java.lang.String encoding);
    
    @QtUninvokable
    public final void setFontFamily(io.qt.webengine.core.QWebEngineSettings.@NonNull FontFamily which, java.lang.@NonNull String family){
        setFontFamily_native_QWebEngineSettings_FontFamily_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), which.value(), family);
    }
    
    @QtUninvokable
    private native void setFontFamily_native_QWebEngineSettings_FontFamily_cref_QString(long __this__nativeId, int which, java.lang.String family);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#setFontSize">QWebEngineSettings::setFontSize(QWebEngineSettings::FontSize,int)</a></p>
     */
    @QtUninvokable
    public final void setFontSize(io.qt.webengine.core.QWebEngineSettings.@NonNull FontSize type, int size){
        setFontSize_native_QWebEngineSettings_FontSize_int(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), size);
    }
    
    @QtUninvokable
    private native void setFontSize_native_QWebEngineSettings_FontSize_int(long __this__nativeId, int type, int size);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#setUnknownUrlSchemePolicy">QWebEngineSettings::setUnknownUrlSchemePolicy(QWebEngineSettings::UnknownUrlSchemePolicy)</a></p>
     */
    @QtUninvokable
    public final void setUnknownUrlSchemePolicy(io.qt.webengine.core.QWebEngineSettings.@NonNull UnknownUrlSchemePolicy policy){
        setUnknownUrlSchemePolicy_native_QWebEngineSettings_UnknownUrlSchemePolicy(QtJambi_LibraryUtilities.internal.nativeId(this), policy.value());
    }
    
    @QtUninvokable
    private native void setUnknownUrlSchemePolicy_native_QWebEngineSettings_UnknownUrlSchemePolicy(long __this__nativeId, int policy);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#testAttribute">QWebEngineSettings::testAttribute(QWebEngineSettings::WebAttribute)const</a></p>
     */
    @QtUninvokable
    public final boolean testAttribute(io.qt.webengine.core.QWebEngineSettings.@NonNull WebAttribute attr){
        return testAttribute_native_QWebEngineSettings_WebAttribute_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), attr.value());
    }
    
    @QtUninvokable
    private native boolean testAttribute_native_QWebEngineSettings_WebAttribute_constfct(long __this__nativeId, int attr);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginesettings.html#unknownUrlSchemePolicy">QWebEngineSettings::unknownUrlSchemePolicy()const</a></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineSettings.@NonNull UnknownUrlSchemePolicy unknownUrlSchemePolicy(){
        return io.qt.webengine.core.QWebEngineSettings.UnknownUrlSchemePolicy.resolve(unknownUrlSchemePolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int unknownUrlSchemePolicy_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineSettings(QPrivateConstructor p) { super(p); } 
    
}
