package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Represents a collection of user scripts</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebenginescriptcollection.html">QWebEngineScriptCollection</a></p>
 */
public final class QWebEngineScriptCollection extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescriptcollection.html#clear">QWebEngineScriptCollection::clear()</a></p>
     */
    @QtUninvokable
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescriptcollection.html#contains">QWebEngineScriptCollection::contains(QWebEngineScript)const</a></p>
     */
    @QtUninvokable
    public final boolean contains(io.qt.webengine.core.@NonNull QWebEngineScript value){
        return contains_native_cref_QWebEngineScript_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native boolean contains_native_cref_QWebEngineScript_constfct(long __this__nativeId, long value);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescriptcollection.html#count">QWebEngineScriptCollection::count()const</a></p>
     */
    @QtUninvokable
    public final int count(){
        return count_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int count_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescriptcollection.html#find">QWebEngineScriptCollection::find(QString)const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.webengine.core.@NonNull QWebEngineScript> find(java.lang.@NonNull String name){
        return find_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.webengine.core.QWebEngineScript> find_native_cref_QString_constfct(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescriptcollection.html#insert-1">QWebEngineScriptCollection::insert(QList&lt;QWebEngineScript&gt;)</a></p>
     */
    @QtUninvokable
    public final void insert(java.util.@NonNull Collection<? extends io.qt.webengine.core.@NonNull QWebEngineScript> list){
        insert_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), list);
    }
    
    @QtUninvokable
    private native void insert_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.webengine.core.QWebEngineScript> list);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescriptcollection.html#insert">QWebEngineScriptCollection::insert(QWebEngineScript)</a></p>
     */
    @QtUninvokable
    public final void insert(io.qt.webengine.core.@NonNull QWebEngineScript arg__1){
        insert_native_cref_QWebEngineScript(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void insert_native_cref_QWebEngineScript(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescriptcollection.html#isEmpty">QWebEngineScriptCollection::isEmpty()const</a></p>
     */
    @QtUninvokable
    public final boolean isEmpty(){
        return isEmpty_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isEmpty_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescriptcollection.html#remove">QWebEngineScriptCollection::remove(QWebEngineScript)</a></p>
     */
    @QtUninvokable
    public final boolean remove(io.qt.webengine.core.@NonNull QWebEngineScript arg__1){
        return remove_native_cref_QWebEngineScript(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native boolean remove_native_cref_QWebEngineScript(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescriptcollection.html#toList">QWebEngineScriptCollection::toList()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.webengine.core.@NonNull QWebEngineScript> toList(){
        return toList_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.webengine.core.QWebEngineScript> toList_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineScriptCollection(QPrivateConstructor p) { super(p); } 
    
}
