package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>A utility type for the QWebEnginePage::newWindowRequested() signal</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebenginenewwindowrequest.html">QWebEngineNewWindowRequest</a></p>
 */
public final class QWebEngineNewWindowRequest extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineNewWindowRequest.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginenewwindowrequest.html#DestinationType-enum">QWebEngineNewWindowRequest::DestinationType</a></p>
     */
    public enum DestinationType implements QtEnumerator {
        InNewWindow(0),
        InNewTab(1),
        InNewDialog(2),
        InNewBackgroundTab(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DestinationType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DestinationType resolve(int value) {
            switch (value) {
            case 0: return InNewWindow;
            case 1: return InNewTab;
            case 2: return InNewDialog;
            case 3: return InNewBackgroundTab;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Kotlin property getter. In Java use {@link #destination()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineNewWindowRequest.@NonNull DestinationType getDestination() {
        return destination();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginenewwindowrequest.html#destination-prop">QWebEngineNewWindowRequest::destination()const</a></p>
     */
    @QtPropertyReader(name="destination")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineNewWindowRequest.@NonNull DestinationType destination(){
        return io.qt.webengine.core.QWebEngineNewWindowRequest.DestinationType.resolve(destination_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int destination_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isUserInitiated()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getUserInitiated() {
        return isUserInitiated();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginenewwindowrequest.html#userInitiated-prop">QWebEngineNewWindowRequest::isUserInitiated()const</a></p>
     */
    @QtPropertyReader(name="userInitiated")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean isUserInitiated(){
        return isUserInitiated_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isUserInitiated_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginenewwindowrequest.html#openIn">QWebEngineNewWindowRequest::openIn(QWebEnginePage*)</a></p>
     */
    @QtUninvokable
    public final void openIn(io.qt.webengine.core.@Nullable QWebEnginePage arg__1){
        openIn_native_QWebEnginePage_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void openIn_native_QWebEnginePage_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #requestedGeometry()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRect getRequestedGeometry() {
        return requestedGeometry();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginenewwindowrequest.html#requestedGeometry-prop">QWebEngineNewWindowRequest::requestedGeometry()const</a></p>
     */
    @QtPropertyReader(name="requestedGeometry")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QRect requestedGeometry(){
        return requestedGeometry_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRect requestedGeometry_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #requestedUrl()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getRequestedUrl() {
        return requestedUrl();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginenewwindowrequest.html#requestedUrl-prop">QWebEngineNewWindowRequest::requestedUrl()const</a></p>
     */
    @QtPropertyReader(name="requestedUrl")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl requestedUrl(){
        return requestedUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl requestedUrl_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineNewWindowRequest(QPrivateConstructor p) { super(p); } 
    
}
