package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Request for populating or extending a context menu with actions</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html">QWebEngineContextMenuRequest</a></p>
 */
public final class QWebEngineContextMenuRequest extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineContextMenuRequest.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#EditFlag-enum">QWebEngineContextMenuRequest::EditFlag</a></p>
     * 
     * @see EditFlags
     */
    public enum EditFlag implements QtFlagEnumerator {
        CanUndo(1),
        CanRedo(2),
        CanCut(4),
        CanCopy(8),
        CanPaste(16),
        CanDelete(32),
        CanSelectAll(64),
        CanTranslate(128),
        CanEditRichly(256);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private EditFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public EditFlags asFlags() {
            return new EditFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public EditFlags combined(EditFlag e) {
            return new EditFlags(this, e);
        }

        /**
         * Creates a new {@link EditFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static EditFlags flags(EditFlag ... values) {
            return new EditFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static EditFlag resolve(int value) {
            switch (value) {
            case 1: return CanUndo;
            case 2: return CanRedo;
            case 4: return CanCut;
            case 8: return CanCopy;
            case 16: return CanPaste;
            case 32: return CanDelete;
            case 64: return CanSelectAll;
            case 128: return CanTranslate;
            case 256: return CanEditRichly;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link EditFlag}
     */
    public static final class EditFlags extends QFlags<EditFlag> implements Comparable<EditFlags> {
        private static final long serialVersionUID = 0x6471c7474d16e451L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new EditFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public EditFlags(EditFlag ... args){
            super(args);
        }

        /**
         * Creates a new EditFlags with given <code>value</code>.
         * @param value
         */
        public EditFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new EditFlags
         */
        @Override
        public final EditFlags combined(EditFlag e){
            return new EditFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final EditFlags setFlag(EditFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final EditFlags setFlag(EditFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this EditFlags.
         * @return array of enum entries
         */
        @Override
        public final EditFlag[] flags(){
            return super.flags(EditFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final EditFlags clone(){
            return new EditFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(EditFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaFlag-enum">QWebEngineContextMenuRequest::MediaFlag</a></p>
     * 
     * @see MediaFlags
     */
    public enum MediaFlag implements QtFlagEnumerator {
        MediaInError(1),
        MediaPaused(2),
        MediaMuted(4),
        MediaLoop(8),
        MediaCanSave(16),
        MediaHasAudio(32),
        MediaCanToggleControls(64),
        MediaControls(128),
        MediaCanPrint(256),
        MediaCanRotate(512);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private MediaFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public MediaFlags asFlags() {
            return new MediaFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public MediaFlags combined(MediaFlag e) {
            return new MediaFlags(this, e);
        }

        /**
         * Creates a new {@link MediaFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static MediaFlags flags(MediaFlag ... values) {
            return new MediaFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static MediaFlag resolve(int value) {
            switch (value) {
            case 1: return MediaInError;
            case 2: return MediaPaused;
            case 4: return MediaMuted;
            case 8: return MediaLoop;
            case 16: return MediaCanSave;
            case 32: return MediaHasAudio;
            case 64: return MediaCanToggleControls;
            case 128: return MediaControls;
            case 256: return MediaCanPrint;
            case 512: return MediaCanRotate;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link MediaFlag}
     */
    public static final class MediaFlags extends QFlags<MediaFlag> implements Comparable<MediaFlags> {
        private static final long serialVersionUID = 0xa5bae86f204e2f26L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new MediaFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public MediaFlags(MediaFlag ... args){
            super(args);
        }

        /**
         * Creates a new MediaFlags with given <code>value</code>.
         * @param value
         */
        public MediaFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new MediaFlags
         */
        @Override
        public final MediaFlags combined(MediaFlag e){
            return new MediaFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final MediaFlags setFlag(MediaFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final MediaFlags setFlag(MediaFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this MediaFlags.
         * @return array of enum entries
         */
        @Override
        public final MediaFlag[] flags(){
            return super.flags(MediaFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final MediaFlags clone(){
            return new MediaFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(MediaFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#MediaType-enum">QWebEngineContextMenuRequest::MediaType</a></p>
     */
    public enum MediaType implements QtEnumerator {
        MediaTypeNone(0),
        MediaTypeImage(1),
        MediaTypeVideo(2),
        MediaTypeAudio(3),
        MediaTypeCanvas(4),
        MediaTypeFile(5),
        MediaTypePlugin(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private MediaType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static MediaType resolve(int value) {
            switch (value) {
            case 0: return MediaTypeNone;
            case 1: return MediaTypeImage;
            case 2: return MediaTypeVideo;
            case 3: return MediaTypeAudio;
            case 4: return MediaTypeCanvas;
            case 5: return MediaTypeFile;
            case 6: return MediaTypePlugin;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Kotlin property getter. In Java use {@link #editFlags()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineContextMenuRequest.@NonNull EditFlags getEditFlags() {
        return editFlags();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#editFlags">QWebEngineContextMenuRequest::editFlags()const</a></p>
     */
    @QtPropertyReader(name="editFlags")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineContextMenuRequest.@NonNull EditFlags editFlags(){
        return new io.qt.webengine.core.QWebEngineContextMenuRequest.EditFlags(editFlags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int editFlags_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isAccepted()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getAccepted() {
        return isAccepted();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#accepted-prop">QWebEngineContextMenuRequest::isAccepted()const</a></p>
     */
    @QtPropertyReader(name="accepted")
    @QtUninvokable
    public final boolean isAccepted(){
        return isAccepted_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAccepted_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#isContentEditable">QWebEngineContextMenuRequest::isContentEditable()const</a></p>
     */
    @QtPropertyReader(name="isContentEditable")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean isContentEditable(){
        return isContentEditable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isContentEditable_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #linkText()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getLinkText() {
        return linkText();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#linkText">QWebEngineContextMenuRequest::linkText()const</a></p>
     */
    @QtPropertyReader(name="linkText")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String linkText(){
        return linkText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String linkText_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #linkUrl()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getLinkUrl() {
        return linkUrl();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#linkUrl">QWebEngineContextMenuRequest::linkUrl()const</a></p>
     */
    @QtPropertyReader(name="linkUrl")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl linkUrl(){
        return linkUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl linkUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #mediaFlags()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineContextMenuRequest.@NonNull MediaFlags getMediaFlags() {
        return mediaFlags();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#mediaFlags">QWebEngineContextMenuRequest::mediaFlags()const</a></p>
     */
    @QtPropertyReader(name="mediaFlags")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineContextMenuRequest.@NonNull MediaFlags mediaFlags(){
        return new io.qt.webengine.core.QWebEngineContextMenuRequest.MediaFlags(mediaFlags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int mediaFlags_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #mediaType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineContextMenuRequest.@NonNull MediaType getMediaType() {
        return mediaType();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#mediaType">QWebEngineContextMenuRequest::mediaType()const</a></p>
     */
    @QtPropertyReader(name="mediaType")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineContextMenuRequest.@NonNull MediaType mediaType(){
        return io.qt.webengine.core.QWebEngineContextMenuRequest.MediaType.resolve(mediaType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int mediaType_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #mediaUrl()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getMediaUrl() {
        return mediaUrl();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#mediaUrl">QWebEngineContextMenuRequest::mediaUrl()const</a></p>
     */
    @QtPropertyReader(name="mediaUrl")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl mediaUrl(){
        return mediaUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl mediaUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #misspelledWord()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getMisspelledWord() {
        return misspelledWord();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#misspelledWord">QWebEngineContextMenuRequest::misspelledWord()const</a></p>
     */
    @QtPropertyReader(name="misspelledWord")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String misspelledWord(){
        return misspelledWord_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String misspelledWord_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #position()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint getPosition() {
        return position();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#position">QWebEngineContextMenuRequest::position()const</a></p>
     */
    @QtPropertyReader(name="position")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QPoint position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QPoint position_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #selectedText()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getSelectedText() {
        return selectedText();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#selectedText">QWebEngineContextMenuRequest::selectedText()const</a></p>
     */
    @QtPropertyReader(name="selectedText")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String selectedText(){
        return selectedText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String selectedText_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#accepted-prop">QWebEngineContextMenuRequest::setAccepted(bool)</a></p>
     */
    @QtPropertyWriter(name="accepted")
    @QtUninvokable
    public final void setAccepted(boolean accepted){
        setAccepted_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), accepted);
    }
    
    @QtUninvokable
    private native void setAccepted_native_bool(long __this__nativeId, boolean accepted);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #spellCheckerSuggestions()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getSpellCheckerSuggestions() {
        return spellCheckerSuggestions();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecontextmenurequest.html#spellCheckerSuggestions">QWebEngineContextMenuRequest::spellCheckerSuggestions()const</a></p>
     */
    @QtPropertyReader(name="spellCheckerSuggestions")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList spellCheckerSuggestions(){
        return spellCheckerSuggestions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList spellCheckerSuggestions_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineContextMenuRequest(QPrivateConstructor p) { super(p); } 
    
}
