package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Information about a certificate error</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebenginecertificateerror.html">QWebEngineCertificateError</a></p>
 */
public final class QWebEngineCertificateError extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineCertificateError.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginecertificateerror.html#Type-enum">QWebEngineCertificateError::Type</a></p>
     */
    public enum Type implements QtEnumerator {
        SslPinnedKeyNotInCertificateChain(-150),
        CertificateCommonNameInvalid(-200),
        CertificateDateInvalid(-201),
        CertificateAuthorityInvalid(-202),
        CertificateContainsErrors(-203),
        CertificateNoRevocationMechanism(-204),
        CertificateUnableToCheckRevocation(-205),
        CertificateRevoked(-206),
        CertificateInvalid(-207),
        CertificateWeakSignatureAlgorithm(-208),
        CertificateNonUniqueName(-210),
        CertificateWeakKey(-211),
        CertificateNameConstraintViolation(-212),
        CertificateValidityTooLong(-213),
        CertificateTransparencyRequired(-214),
        CertificateSymantecLegacy(-215),
        CertificateKnownInterceptionBlocked(-217),
        SslObsoleteVersion(-218);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Type(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Type resolve(int value) {
            switch (value) {
            case -150: return SslPinnedKeyNotInCertificateChain;
            case -200: return CertificateCommonNameInvalid;
            case -201: return CertificateDateInvalid;
            case -202: return CertificateAuthorityInvalid;
            case -203: return CertificateContainsErrors;
            case -204: return CertificateNoRevocationMechanism;
            case -205: return CertificateUnableToCheckRevocation;
            case -206: return CertificateRevoked;
            case -207: return CertificateInvalid;
            case -208: return CertificateWeakSignatureAlgorithm;
            case -210: return CertificateNonUniqueName;
            case -211: return CertificateWeakKey;
            case -212: return CertificateNameConstraintViolation;
            case -213: return CertificateValidityTooLong;
            case -214: return CertificateTransparencyRequired;
            case -215: return CertificateSymantecLegacy;
            case -217: return CertificateKnownInterceptionBlocked;
            case -218: return SslObsoleteVersion;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    public QWebEngineCertificateError(io.qt.webengine.core.@NonNull QWebEngineCertificateError other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebEngineCertificateError instance, io.qt.webengine.core.QWebEngineCertificateError other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecertificateerror.html#acceptCertificate">QWebEngineCertificateError::acceptCertificate()</a></p>
     */
    public final void acceptCertificate(){
        acceptCertificate_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void acceptCertificate_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecertificateerror.html#certificateChain">QWebEngineCertificateError::certificateChain()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.network.@NonNull QSslCertificate> certificateChain(){
        return certificateChain_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.network.QSslCertificate> certificateChain_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecertificateerror.html#defer">QWebEngineCertificateError::defer()</a></p>
     */
    public final void defer(){
        defer_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void defer_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #description()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getDescription() {
        return description();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecertificateerror.html#description">QWebEngineCertificateError::description()const</a></p>
     */
    @QtPropertyReader(name="description")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String description(){
        return description_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String description_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isOverridable()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getOverridable() {
        return isOverridable();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecertificateerror.html#overridable-prop">QWebEngineCertificateError::isOverridable()const</a></p>
     */
    @QtPropertyReader(name="overridable")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean isOverridable(){
        return isOverridable_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isOverridable_native_constfct(long __this__nativeId);
    
    @QtUninvokable
    public final void assign(io.qt.webengine.core.@NonNull QWebEngineCertificateError other){
        assign_native_cref_QWebEngineCertificateError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_QWebEngineCertificateError(long __this__nativeId, long other);
    
    @QtUninvokable
    private final boolean operator_equal(io.qt.webengine.core.@NonNull QWebEngineCertificateError arg2){
        return operator_equal_native_cref_QWebEngineCertificateError(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg2));
    }
    
    @QtUninvokable
    private native boolean operator_equal_native_cref_QWebEngineCertificateError(long __this__nativeId, long arg2);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecertificateerror.html#rejectCertificate">QWebEngineCertificateError::rejectCertificate()</a></p>
     */
    public final void rejectCertificate(){
        rejectCertificate_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void rejectCertificate_native(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #type()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineCertificateError.@NonNull Type getType() {
        return type();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecertificateerror.html#type">QWebEngineCertificateError::type()const</a></p>
     */
    @QtPropertyReader(name="type")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineCertificateError.@NonNull Type type(){
        return io.qt.webengine.core.QWebEngineCertificateError.Type.resolve(type_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int type_native_constfct(long __this__nativeId);
    
    /**
     * <p>Kotlin property getter. In Java use {@link #url()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getUrl() {
        return url();
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecertificateerror.html#url">QWebEngineCertificateError::url()const</a></p>
     */
    @QtPropertyReader(name="url")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineCertificateError(QPrivateConstructor p) { super(p); } 
    

    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.webengine.core.QWebEngineCertificateError) {
            return operator_equal((io.qt.webengine.core.QWebEngineCertificateError) other);
        }

        return false;
    }


    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @QtUninvokable
    @Override
    public QWebEngineCertificateError clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QWebEngineCertificateError clone_native(long __this_nativeId);
}
