package io.qt.webengine.core;


/**
 * <p>Enables accepting or rejecting requests for local file system access from JavaScript applications</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html">QWebEngineFileSystemAccessRequest</a></p>
 */
public class QWebEngineFileSystemAccessRequest extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineFileSystemAccessRequest.class);
    
    /**
     * <p>Java wrapper for Qt enum QWebEngineFileSystemAccessRequest::AccessFlag</p>
     * 
     * @see AccessFlags
     */
    public enum AccessFlag implements io.qt.QtFlagEnumerator {
        Read(1),
        Write(2);

        private AccessFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public AccessFlags asFlags() {
            return new AccessFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public AccessFlags combined(AccessFlag e) {
            return new AccessFlags(this, e);
        }

        /**
         * Creates a new {@link AccessFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static AccessFlags flags(AccessFlag ... values) {
            return new AccessFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AccessFlag resolve(int value) {
            switch (value) {
            case 1: return Read;
            case 2: return Write;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link AccessFlag}
     */
    public static final class AccessFlags extends io.qt.QFlags<AccessFlag> implements Comparable<AccessFlags> {
        private static final long serialVersionUID = 0x354c56a0ae87271cL;

        /**
         * Creates a new AccessFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public AccessFlags(AccessFlag ... args){
            super(args);
        }

        /**
         * Creates a new AccessFlags with given <code>value</code>.
         * @param value
         */
        public AccessFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new AccessFlags
         */
        @Override
        public final AccessFlags combined(AccessFlag e){
            return new AccessFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final AccessFlags setFlag(AccessFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final AccessFlags setFlag(AccessFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this AccessFlags.
         * @return array of enum entries
         */
        @Override
        public final AccessFlag[] flags(){
            return super.flags(AccessFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final AccessFlags clone(){
            return new AccessFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(AccessFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum QWebEngineFileSystemAccessRequest::HandleType</p>
     */
    public enum HandleType implements io.qt.QtEnumerator {
        File(0),
        Directory(1);

        private HandleType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static HandleType resolve(int value) {
            switch (value) {
            case 0: return File;
            case 1: return Directory;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    public QWebEngineFileSystemAccessRequest(io.qt.webengine.core.QWebEngineFileSystemAccessRequest other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebEngineFileSystemAccessRequest instance, io.qt.webengine.core.QWebEngineFileSystemAccessRequest other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html#accept">QWebEngineFileSystemAccessRequest::accept()</a></p>
     */
    public final void accept(){
        accept_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void accept_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html#accessFlags-prop">QWebEngineFileSystemAccessRequest::accessFlags()const</a></p>
     */
    @io.qt.QtPropertyReader(name="accessFlags")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineFileSystemAccessRequest.AccessFlags accessFlags(){
        return new io.qt.webengine.core.QWebEngineFileSystemAccessRequest.AccessFlags(accessFlags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int accessFlags_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html#filePath-prop">QWebEngineFileSystemAccessRequest::filePath()const</a></p>
     */
    @io.qt.QtPropertyReader(name="filePath")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl filePath(){
        return filePath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl filePath_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html#handleType-prop">QWebEngineFileSystemAccessRequest::handleType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="handleType")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineFileSystemAccessRequest.HandleType handleType(){
        return io.qt.webengine.core.QWebEngineFileSystemAccessRequest.HandleType.resolve(handleType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int handleType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html#operator-eq-eq">operator==(QWebEngineFileSystemAccessRequest,QWebEngineFileSystemAccessRequest)</a></p>
     */
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.webengine.core.QWebEngineFileSystemAccessRequest rhs){
        return operator_equal_native_cref_QWebEngineFileSystemAccessRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rhs));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QWebEngineFileSystemAccessRequest(long __this__nativeId, long rhs);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html#origin-prop">QWebEngineFileSystemAccessRequest::origin()const</a></p>
     */
    @io.qt.QtPropertyReader(name="origin")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl origin(){
        return origin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl origin_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginefilesystemaccessrequest.html#reject">QWebEngineFileSystemAccessRequest::reject()</a></p>
     */
    public final void reject(){
        reject_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void reject_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void swap(io.qt.webengine.core.QWebEngineFileSystemAccessRequest other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QWebEngineFileSystemAccessRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void swap_native_ref_QWebEngineFileSystemAccessRequest(long __this__nativeId, long other);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QWebEngineFileSystemAccessRequest(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.webengine.core.QWebEngineFileSystemAccessRequest) {
            return operator_equal((io.qt.webengine.core.QWebEngineFileSystemAccessRequest) other);
        }

        return false;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @Override
    public QWebEngineFileSystemAccessRequest clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QWebEngineFileSystemAccessRequest clone_native(long __this_nativeId);
}
