package io.qt.webengine.core;


/**
 * <p>A utility type for the WebEngineView::loadingChanged signal</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html">QWebEngineLoadingInfo</a></p>
 */
public class QWebEngineLoadingInfo extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineLoadingInfo.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#ErrorDomain-enum">QWebEngineLoadingInfo::ErrorDomain</a></p>
     */
    public enum ErrorDomain implements io.qt.QtEnumerator {
        NoErrorDomain(0),
        InternalErrorDomain(1),
        ConnectionErrorDomain(2),
        CertificateErrorDomain(3),
        HttpErrorDomain(4),
        FtpErrorDomain(5),
        DnsErrorDomain(6);

        private ErrorDomain(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ErrorDomain resolve(int value) {
            switch (value) {
            case 0: return NoErrorDomain;
            case 1: return InternalErrorDomain;
            case 2: return ConnectionErrorDomain;
            case 3: return CertificateErrorDomain;
            case 4: return HttpErrorDomain;
            case 5: return FtpErrorDomain;
            case 6: return DnsErrorDomain;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#LoadStatus-enum">QWebEngineLoadingInfo::LoadStatus</a></p>
     */
    public enum LoadStatus implements io.qt.QtEnumerator {
        LoadStartedStatus(0),
        LoadStoppedStatus(1),
        LoadSucceededStatus(2),
        LoadFailedStatus(3);

        private LoadStatus(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static LoadStatus resolve(int value) {
            switch (value) {
            case 0: return LoadStartedStatus;
            case 1: return LoadStoppedStatus;
            case 2: return LoadSucceededStatus;
            case 3: return LoadFailedStatus;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    public QWebEngineLoadingInfo(io.qt.webengine.core.QWebEngineLoadingInfo other){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebEngineLoadingInfo instance, io.qt.webengine.core.QWebEngineLoadingInfo other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#errorCode-prop">QWebEngineLoadingInfo::errorCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="errorCode")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int errorCode(){
        return errorCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int errorCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#errorDomain-prop">QWebEngineLoadingInfo::errorDomain()const</a></p>
     */
    @io.qt.QtPropertyReader(name="errorDomain")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineLoadingInfo.ErrorDomain errorDomain(){
        return io.qt.webengine.core.QWebEngineLoadingInfo.ErrorDomain.resolve(errorDomain_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int errorDomain_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#errorString-prop">QWebEngineLoadingInfo::errorString()const</a></p>
     */
    @io.qt.QtPropertyReader(name="errorString")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final java.lang.String errorString(){
        return errorString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String errorString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#isErrorPage-prop">QWebEngineLoadingInfo::isErrorPage()const</a></p>
     */
    @io.qt.QtPropertyReader(name="isErrorPage")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final boolean isErrorPage(){
        return isErrorPage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isErrorPage_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final void set(io.qt.webengine.core.QWebEngineLoadingInfo other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        set_native_cref_QWebEngineLoadingInfo(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void set_native_cref_QWebEngineLoadingInfo(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#status-prop">QWebEngineLoadingInfo::status()const</a></p>
     */
    @io.qt.QtPropertyReader(name="status")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineLoadingInfo.LoadStatus status(){
        return io.qt.webengine.core.QWebEngineLoadingInfo.LoadStatus.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineloadinginfo.html#url">QWebEngineLoadingInfo::url()const</a></p>
     */
    @io.qt.QtPropertyReader(name="url")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QWebEngineLoadingInfo(QPrivateConstructor p) { super(p); } 
    
}
