package io.qt.webengine.core;


/**
 * <p>Access to Chromium's cookies</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebenginecookiestore.html">QWebEngineCookieStore</a></p>
 */
public final class QWebEngineCookieStore extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineCookieStore.class);
    

    /**
     * <p>QWebEngineCookieStore::FilterRequest struct is used in conjunction with QWebEngineCookieStore::setCookieFilter() and is the type filterCallback operates on</p>
     * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebenginecookiestore-filterrequest.html">QWebEngineCookieStore::FilterRequest</a></p>
     */
    public static class FilterRequest extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public FilterRequest(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(FilterRequest instance);
        
        /**
         * <p>See <a href="https://doc.qt.io/qt/qpdfdocumentrenderoptions.html#operator-eq-eq-1">operator==(QWebEngineCookieStore::FilterRequest,QWebEngineCookieStore::FilterRequest)</a></p>
         */
        @io.qt.QtUninvokable
        private final boolean operator_equal(io.qt.webengine.core.QWebEngineCookieStore.FilterRequest arg2){
            return operator_equal_native_cref_QWebEngineCookieStore_FilterRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg2));
        }
        
        @io.qt.QtUninvokable
        private native boolean operator_equal_native_cref_QWebEngineCookieStore_FilterRequest(long __this__nativeId, long arg2);
        
        /**
         * <p>URL that was navigated to</p>
         * <p>See <a href="https://doc.qt.io/qt/qwebenginecookiestore-filterrequest.html#firstPartyUrl-var">QWebEngineCookieStore::FilterRequest::firstPartyUrl</a></p>
         */
        @io.qt.QtUninvokable
        public final void setFirstPartyUrl(io.qt.core.QUrl firstPartyUrl){
            setFirstPartyUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(firstPartyUrl));
        }
        
        @io.qt.QtUninvokable
        private native void setFirstPartyUrl_native_cref_QUrl(long __this__nativeId, long firstPartyUrl);
        
        /**
         * <p>URL that was navigated to</p>
         * <p>See <a href="https://doc.qt.io/qt/qwebenginecookiestore-filterrequest.html#firstPartyUrl-var">QWebEngineCookieStore::FilterRequest::firstPartyUrl</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.core.QUrl firstPartyUrl(){
            return firstPartyUrl_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.core.QUrl firstPartyUrl_native(long __this__nativeId);
        
        /**
         * <p>URL of the script or content accessing a cookie</p>
         * <p>See <a href="https://doc.qt.io/qt/qwebenginecookiestore-filterrequest.html#origin-var">QWebEngineCookieStore::FilterRequest::origin</a></p>
         */
        @io.qt.QtUninvokable
        public final void setOrigin(io.qt.core.QUrl origin){
            setOrigin_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(origin));
        }
        
        @io.qt.QtUninvokable
        private native void setOrigin_native_cref_QUrl(long __this__nativeId, long origin);
        
        /**
         * <p>URL of the script or content accessing a cookie</p>
         * <p>See <a href="https://doc.qt.io/qt/qwebenginecookiestore-filterrequest.html#origin-var">QWebEngineCookieStore::FilterRequest::origin</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.core.QUrl origin(){
            return origin_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.core.QUrl origin_native(long __this__nativeId);
        
        /**
         * <p>Whether this is considered a third-party access</p>
         * <p>See <a href="https://doc.qt.io/qt/qwebenginecookiestore-filterrequest.html#thirdParty-var">QWebEngineCookieStore::FilterRequest::thirdParty</a></p>
         */
        @io.qt.QtUninvokable
        public final void setThirdParty(boolean thirdParty){
            setThirdParty_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), thirdParty);
        }
        
        @io.qt.QtUninvokable
        private native void setThirdParty_native_bool(long __this__nativeId, boolean thirdParty);
        
        /**
         * <p>Whether this is considered a third-party access</p>
         * <p>See <a href="https://doc.qt.io/qt/qwebenginecookiestore-filterrequest.html#thirdParty-var">QWebEngineCookieStore::FilterRequest::thirdParty</a></p>
         */
        @io.qt.QtUninvokable
        public final boolean thirdParty(){
            return thirdParty_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean thirdParty_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected FilterRequest(QPrivateConstructor p) { super(p); } 
        

        @Override
        @io.qt.QtUninvokable
        public boolean equals(Object other) {
            if (other instanceof io.qt.webengine.core.QWebEngineCookieStore.FilterRequest) {
                return operator_equal((io.qt.webengine.core.QWebEngineCookieStore.FilterRequest) other);
            }

            return false;
        }


        @io.qt.QtUninvokable
        @Override
        public int hashCode() {
            return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native static int hashCode_native(long __this_nativeId);
        
        @Override
        public FilterRequest clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native FilterRequest clone_native(long __this_nativeId);
    }


    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecookiestore.html#cookieAdded">QWebEngineCookieStore::cookieAdded(QNetworkCookie)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final Signal1<io.qt.network.QNetworkCookie> cookieAdded = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecookiestore.html#cookieRemoved">QWebEngineCookieStore::cookieRemoved(QNetworkCookie)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final Signal1<io.qt.network.QNetworkCookie> cookieRemoved = new Signal1<>();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecookiestore.html#deleteAllCookies">QWebEngineCookieStore::deleteAllCookies()</a></p>
     */
    @io.qt.QtUninvokable
    public final void deleteAllCookies(){
        deleteAllCookies_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void deleteAllCookies_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #deleteCookie(io.qt.network.QNetworkCookie, io.qt.core.QUrl)}
     *  with <code>origin = new io.qt.core.QUrl()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void deleteCookie(io.qt.network.QNetworkCookie cookie) {
        deleteCookie(cookie, new io.qt.core.QUrl());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecookiestore.html#deleteCookie">QWebEngineCookieStore::deleteCookie(QNetworkCookie,QUrl)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void deleteCookie(io.qt.network.QNetworkCookie cookie, io.qt.core.QUrl origin){
        deleteCookie_native_cref_QNetworkCookie_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(cookie), QtJambi_LibraryUtilities.internal.checkedNativeId(origin));
    }
    
    @io.qt.QtUninvokable
    private native void deleteCookie_native_cref_QNetworkCookie_cref_QUrl(long __this__nativeId, long cookie, long origin);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecookiestore.html#deleteSessionCookies">QWebEngineCookieStore::deleteSessionCookies()</a></p>
     */
    @io.qt.QtUninvokable
    public final void deleteSessionCookies(){
        deleteSessionCookies_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void deleteSessionCookies_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecookiestore.html#loadAllCookies">QWebEngineCookieStore::loadAllCookies()</a></p>
     */
    @io.qt.QtUninvokable
    public final void loadAllCookies(){
        loadAllCookies_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void loadAllCookies_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #setCookie(io.qt.network.QNetworkCookie, io.qt.core.QUrl)}
     *  with <code>origin = new io.qt.core.QUrl()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void setCookie(io.qt.network.QNetworkCookie cookie) {
        setCookie(cookie, new io.qt.core.QUrl());
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginecookiestore.html#setCookie">QWebEngineCookieStore::setCookie(QNetworkCookie,QUrl)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void setCookie(io.qt.network.QNetworkCookie cookie, io.qt.core.QUrl origin){
        setCookie_native_cref_QNetworkCookie_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(cookie), QtJambi_LibraryUtilities.internal.checkedNativeId(origin));
    }
    
    @io.qt.QtUninvokable
    private native void setCookie_native_cref_QNetworkCookie_cref_QUrl(long __this__nativeId, long cookie, long origin);
    
    @io.qt.QtUninvokable
    public final void setCookieFilter(java.util.function.Predicate<FilterRequest> filterCallback){
        setCookieFilter_native_cref_QWebEngineCookieStore_CookieFilter(QtJambi_LibraryUtilities.internal.nativeId(this), filterCallback);
    }
    
    @io.qt.QtUninvokable
    private native void setCookieFilter_native_cref_QWebEngineCookieStore_CookieFilter(long __this__nativeId, java.util.function.Predicate<FilterRequest> filterCallback);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QWebEngineCookieStore(QPrivateConstructor p) { super(p); } 
    
}
