package io.qt.webengine.core;


/**
 * <p>Web engine profile shared by multiple pages</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qwebengineprofile.html">QWebEngineProfile</a></p>
 */
public class QWebEngineProfile extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcUrlRequestInterceptor = null;
    @io.qt.QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcUrlSchemeHandler;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineProfile.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebengineprofile.html#HttpCacheType-enum">QWebEngineProfile::HttpCacheType</a></p>
     */
    public enum HttpCacheType implements io.qt.QtEnumerator {
        MemoryHttpCache(0),
        DiskHttpCache(1),
        NoCache(2);

        private HttpCacheType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static HttpCacheType resolve(int value) {
            switch (value) {
            case 0: return MemoryHttpCache;
            case 1: return DiskHttpCache;
            case 2: return NoCache;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebengineprofile.html#PersistentCookiesPolicy-enum">QWebEngineProfile::PersistentCookiesPolicy</a></p>
     */
    public enum PersistentCookiesPolicy implements io.qt.QtEnumerator {
        NoPersistentCookies(0),
        AllowPersistentCookies(1),
        ForcePersistentCookies(2);

        private PersistentCookiesPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PersistentCookiesPolicy resolve(int value) {
            switch (value) {
            case 0: return NoPersistentCookies;
            case 1: return AllowPersistentCookies;
            case 2: return ForcePersistentCookies;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Java wrapper for Qt function pointer std::function&lt;void(const QIcon&amp;,const QUrl&amp;)&gt;</p>
     */
    @FunctionalInterface
    public interface IconAvailableCallback2 extends io.qt.QtObjectInterface, java.util.function.BiConsumer<io.qt.gui.QIcon, io.qt.core.QUrl> {

        @Override
        public void accept(io.qt.gui.QIcon arg__1, io.qt.core.QUrl arg__2);

        /**
         * <p>Implementor class for interface {@link IconAvailableCallback2}</p>
         */
        public static abstract class Impl extends io.qt.QtObject implements IconAvailableCallback2{
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }

            protected Impl(QPrivateConstructor p){
                super(p);
            }

            private static native void initialize_native(IconAvailableCallback2 instance);

            @io.qt.NativeAccess
            private final static class ConcreteWrapper extends Impl {
                private ConcreteWrapper(QPrivateConstructor c){
                    super(c);
                }

                @Override
                public void accept(io.qt.gui.QIcon arg__1, io.qt.core.QUrl arg__2){
                    accept_native(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
                }

                private native void accept_native(long arg__1, long arg__2);
            }

        }
    }


    /**
     * <p>Java wrapper for Qt function pointer std::function&lt;void(const QIcon&amp;,const QUrl&amp;,const QUrl&amp;)&gt;</p>
     */
    @FunctionalInterface
    public interface IconAvailableCallback3 extends io.qt.QtObjectInterface {

        public void accept(io.qt.gui.QIcon arg__1, io.qt.core.QUrl arg__2, io.qt.core.QUrl arg__3);

        /**
         * <p>Implementor class for interface {@link IconAvailableCallback3}</p>
         */
        public static abstract class Impl extends io.qt.QtObject implements IconAvailableCallback3{
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }

            protected Impl(QPrivateConstructor p){
                super(p);
            }

            private static native void initialize_native(IconAvailableCallback3 instance);

            @io.qt.NativeAccess
            private final static class ConcreteWrapper extends Impl {
                private ConcreteWrapper(QPrivateConstructor c){
                    super(c);
                }

                @Override
                public void accept(io.qt.gui.QIcon arg__1, io.qt.core.QUrl arg__2, io.qt.core.QUrl arg__3){
                    accept_native(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__3));
                }

                private native void accept_native(long arg__1, long arg__2, long arg__3);
            }

        }
    }


    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#downloadRequested">QWebEngineProfile::downloadRequested(QWebEngineDownloadRequest*)</a></p>
     */
    public final Signal1<io.qt.webengine.core.QWebEngineDownloadRequest> downloadRequested = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QWebEngineProfile(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QWebEngineProfile() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#QWebEngineProfile">QWebEngineProfile::QWebEngineProfile(QObject*)</a></p>
     */
    public QWebEngineProfile(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QWebEngineProfile instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QWebEngineProfile(java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QWebEngineProfile(java.lang.String name) {
        this(name, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#QWebEngineProfile-1">QWebEngineProfile::QWebEngineProfile(QString,QObject*)</a></p>
     */
    public QWebEngineProfile(java.lang.String name, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, name, parent);
    }
    
    private native static void initialize_native(QWebEngineProfile instance, java.lang.String name, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#cachePath">QWebEngineProfile::cachePath()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String cachePath(){
        return cachePath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String cachePath_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#clearAllVisitedLinks">QWebEngineProfile::clearAllVisitedLinks()</a></p>
     */
    @io.qt.QtUninvokable
    public final void clearAllVisitedLinks(){
        clearAllVisitedLinks_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void clearAllVisitedLinks_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#clearHttpCache">QWebEngineProfile::clearHttpCache()</a></p>
     */
    @io.qt.QtUninvokable
    public final void clearHttpCache(){
        clearHttpCache_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void clearHttpCache_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#clearVisitedLinks">QWebEngineProfile::clearVisitedLinks(QList&lt;QUrl&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void clearVisitedLinks(java.util.Collection<? extends io.qt.core.QUrl> urls){
        clearVisitedLinks_native_cref_QList(QtJambi_LibraryUtilities.internal.nativeId(this), urls);
    }
    
    @io.qt.QtUninvokable
    private native void clearVisitedLinks_native_cref_QList(long __this__nativeId, java.util.Collection<? extends io.qt.core.QUrl> urls);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#clientCertificateStore">QWebEngineProfile::clientCertificateStore()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineClientCertificateStore clientCertificateStore(){
        return clientCertificateStore_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.core.QWebEngineClientCertificateStore clientCertificateStore_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#cookieStore">QWebEngineProfile::cookieStore()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineCookieStore cookieStore(){
        return cookieStore_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.core.QWebEngineCookieStore cookieStore_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#downloadPath">QWebEngineProfile::downloadPath()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String downloadPath(){
        return downloadPath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String downloadPath_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#httpAcceptLanguage">QWebEngineProfile::httpAcceptLanguage()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String httpAcceptLanguage(){
        return httpAcceptLanguage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String httpAcceptLanguage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#httpCacheMaximumSize">QWebEngineProfile::httpCacheMaximumSize()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int httpCacheMaximumSize(){
        return httpCacheMaximumSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int httpCacheMaximumSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#httpCacheType">QWebEngineProfile::httpCacheType()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineProfile.HttpCacheType httpCacheType(){
        return io.qt.webengine.core.QWebEngineProfile.HttpCacheType.resolve(httpCacheType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int httpCacheType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#httpUserAgent">QWebEngineProfile::httpUserAgent()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String httpUserAgent(){
        return httpUserAgent_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String httpUserAgent_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#installUrlSchemeHandler">QWebEngineProfile::installUrlSchemeHandler(QByteArray,QWebEngineUrlSchemeHandler*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void installUrlSchemeHandler(io.qt.core.QByteArray scheme, io.qt.webengine.core.QWebEngineUrlSchemeHandler arg__2){
        installUrlSchemeHandler_native_cref_QByteArray_QWebEngineUrlSchemeHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scheme), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
        if (arg__2 != null) {
            if(__rcUrlSchemeHandler==null)
                __rcUrlSchemeHandler = QtJambi_LibraryUtilities.internal.newRCList();
            __rcUrlSchemeHandler.add(arg__2);
        }
    }
    
    @io.qt.QtUninvokable
    private native void installUrlSchemeHandler_native_cref_QByteArray_QWebEngineUrlSchemeHandler_ptr(long __this__nativeId, long scheme, long arg__2);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#isOffTheRecord">QWebEngineProfile::isOffTheRecord()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isOffTheRecord(){
        return isOffTheRecord_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isOffTheRecord_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#isSpellCheckEnabled">QWebEngineProfile::isSpellCheckEnabled()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isSpellCheckEnabled(){
        return isSpellCheckEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSpellCheckEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#persistentCookiesPolicy">QWebEngineProfile::persistentCookiesPolicy()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineProfile.PersistentCookiesPolicy persistentCookiesPolicy(){
        return io.qt.webengine.core.QWebEngineProfile.PersistentCookiesPolicy.resolve(persistentCookiesPolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int persistentCookiesPolicy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#persistentStoragePath">QWebEngineProfile::persistentStoragePath()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String persistentStoragePath(){
        return persistentStoragePath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String persistentStoragePath_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#removeAllUrlSchemeHandlers">QWebEngineProfile::removeAllUrlSchemeHandlers()</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeAllUrlSchemeHandlers(){
        removeAllUrlSchemeHandlers_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void removeAllUrlSchemeHandlers_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#removeUrlScheme">QWebEngineProfile::removeUrlScheme(QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeUrlScheme(io.qt.core.QByteArray scheme){
        removeUrlScheme_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scheme));
    }
    
    @io.qt.QtUninvokable
    private native void removeUrlScheme_native_cref_QByteArray(long __this__nativeId, long scheme);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#removeUrlSchemeHandler">QWebEngineProfile::removeUrlSchemeHandler(QWebEngineUrlSchemeHandler*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeUrlSchemeHandler(io.qt.webengine.core.QWebEngineUrlSchemeHandler arg__1){
        removeUrlSchemeHandler_native_QWebEngineUrlSchemeHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
        if (arg__1 != null) {
            while (__rcUrlSchemeHandler != null && __rcUrlSchemeHandler.remove(arg__1)) ;
        }
    }
    
    @io.qt.QtUninvokable
    private native void removeUrlSchemeHandler_native_QWebEngineUrlSchemeHandler_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#requestIconForIconURL">QWebEngineProfile::requestIconForIconURL(const QUrl&amp;,int,std::function&lt;void(const QIcon&amp;,const QUrl&amp;)&gt;)const</a></p>
     */
    @io.qt.QtUninvokable
    public final void requestIconForIconURL(io.qt.core.QUrl url, int desiredSizeInPixel, io.qt.webengine.core.QWebEngineProfile.IconAvailableCallback2 iconAvailableCallback){
        requestIconForIconURL_native_cref_QUrl_int_QWebEngineProfile_IconAvailableCallback2_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), desiredSizeInPixel, iconAvailableCallback);
    }
    
    @io.qt.QtUninvokable
    private native void requestIconForIconURL_native_cref_QUrl_int_QWebEngineProfile_IconAvailableCallback2_constfct(long __this__nativeId, long url, int desiredSizeInPixel, io.qt.webengine.core.QWebEngineProfile.IconAvailableCallback2 iconAvailableCallback);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#requestIconForPageURL">QWebEngineProfile::requestIconForPageURL(const QUrl&amp;,int,std::function&lt;void(const QIcon&amp;,const QUrl&amp;,const QUrl&amp;)&gt;)const</a></p>
     */
    @io.qt.QtUninvokable
    public final void requestIconForPageURL(io.qt.core.QUrl url, int desiredSizeInPixel, io.qt.webengine.core.QWebEngineProfile.IconAvailableCallback3 iconAvailableCallback){
        requestIconForPageURL_native_cref_QUrl_int_QWebEngineProfile_IconAvailableCallback3_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), desiredSizeInPixel, iconAvailableCallback);
    }
    
    @io.qt.QtUninvokable
    private native void requestIconForPageURL_native_cref_QUrl_int_QWebEngineProfile_IconAvailableCallback3_constfct(long __this__nativeId, long url, int desiredSizeInPixel, io.qt.webengine.core.QWebEngineProfile.IconAvailableCallback3 iconAvailableCallback);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#scripts">QWebEngineProfile::scripts()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineScriptCollection scripts(){
        return scripts_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.core.QWebEngineScriptCollection scripts_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#setCachePath">QWebEngineProfile::setCachePath(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setCachePath(java.lang.String path){
        setCachePath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @io.qt.QtUninvokable
    private native void setCachePath_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#setDownloadPath">QWebEngineProfile::setDownloadPath(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDownloadPath(java.lang.String path){
        setDownloadPath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @io.qt.QtUninvokable
    private native void setDownloadPath_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#setHttpAcceptLanguage">QWebEngineProfile::setHttpAcceptLanguage(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setHttpAcceptLanguage(java.lang.String httpAcceptLanguage){
        setHttpAcceptLanguage_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), httpAcceptLanguage);
    }
    
    @io.qt.QtUninvokable
    private native void setHttpAcceptLanguage_native_cref_QString(long __this__nativeId, java.lang.String httpAcceptLanguage);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#setHttpCacheMaximumSize">QWebEngineProfile::setHttpCacheMaximumSize(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setHttpCacheMaximumSize(int maxSize){
        setHttpCacheMaximumSize_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), maxSize);
    }
    
    @io.qt.QtUninvokable
    private native void setHttpCacheMaximumSize_native_int(long __this__nativeId, int maxSize);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#setHttpCacheType">QWebEngineProfile::setHttpCacheType(QWebEngineProfile::HttpCacheType)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setHttpCacheType(io.qt.webengine.core.QWebEngineProfile.HttpCacheType arg__1){
        setHttpCacheType_native_QWebEngineProfile_HttpCacheType(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @io.qt.QtUninvokable
    private native void setHttpCacheType_native_QWebEngineProfile_HttpCacheType(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#setHttpUserAgent">QWebEngineProfile::setHttpUserAgent(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setHttpUserAgent(java.lang.String userAgent){
        setHttpUserAgent_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), userAgent);
    }
    
    @io.qt.QtUninvokable
    private native void setHttpUserAgent_native_cref_QString(long __this__nativeId, java.lang.String userAgent);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#setNotificationPresenter">QWebEngineProfile::setNotificationPresenter(std::function&lt;void(std::unique_ptr&lt;QWebEngineNotification&gt;)&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setNotificationPresenter(java.util.function.Consumer<QWebEngineNotification> notificationPresenter){
        setNotificationPresenter_native_QWebEngineProfile_NotificationPresenter(QtJambi_LibraryUtilities.internal.nativeId(this), notificationPresenter);
    }
    
    @io.qt.QtUninvokable
    private native void setNotificationPresenter_native_QWebEngineProfile_NotificationPresenter(long __this__nativeId, java.util.function.Consumer<QWebEngineNotification> notificationPresenter);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#setPersistentCookiesPolicy">QWebEngineProfile::setPersistentCookiesPolicy(QWebEngineProfile::PersistentCookiesPolicy)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPersistentCookiesPolicy(io.qt.webengine.core.QWebEngineProfile.PersistentCookiesPolicy arg__1){
        setPersistentCookiesPolicy_native_QWebEngineProfile_PersistentCookiesPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @io.qt.QtUninvokable
    private native void setPersistentCookiesPolicy_native_QWebEngineProfile_PersistentCookiesPolicy(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#setPersistentStoragePath">QWebEngineProfile::setPersistentStoragePath(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPersistentStoragePath(java.lang.String path){
        setPersistentStoragePath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @io.qt.QtUninvokable
    private native void setPersistentStoragePath_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#setSpellCheckEnabled">QWebEngineProfile::setSpellCheckEnabled(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSpellCheckEnabled(boolean enabled){
        setSpellCheckEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setSpellCheckEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#setSpellCheckLanguages">QWebEngineProfile::setSpellCheckLanguages(QStringList)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSpellCheckLanguages(java.util.Collection<java.lang.String> languages){
        setSpellCheckLanguages_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), languages);
    }
    
    @io.qt.QtUninvokable
    private native void setSpellCheckLanguages_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> languages);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#setUrlRequestInterceptor">QWebEngineProfile::setUrlRequestInterceptor(QWebEngineUrlRequestInterceptor*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUrlRequestInterceptor(io.qt.webengine.core.QWebEngineUrlRequestInterceptor interceptor){
        setUrlRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(interceptor));
        __rcUrlRequestInterceptor = interceptor;
    }
    
    @io.qt.QtUninvokable
    private native void setUrlRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(long __this__nativeId, long interceptor);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#settings">QWebEngineProfile::settings()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineSettings settings(){
        return settings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.core.QWebEngineSettings settings_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#spellCheckLanguages">QWebEngineProfile::spellCheckLanguages()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList spellCheckLanguages(){
        return spellCheckLanguages_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList spellCheckLanguages_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#storageName">QWebEngineProfile::storageName()const</a></p>
     */
    @io.qt.QtUninvokable
    public final java.lang.String storageName(){
        return storageName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String storageName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#urlSchemeHandler">QWebEngineProfile::urlSchemeHandler(QByteArray)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineUrlSchemeHandler urlSchemeHandler(io.qt.core.QByteArray arg__1){
        return urlSchemeHandler_native_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.core.QWebEngineUrlSchemeHandler urlSchemeHandler_native_cref_QByteArray_constfct(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#visitedLinksContainsUrl">QWebEngineProfile::visitedLinksContainsUrl(QUrl)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean visitedLinksContainsUrl(io.qt.core.QUrl url){
        return visitedLinksContainsUrl_native_cref_QUrl_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @io.qt.QtUninvokable
    private native boolean visitedLinksContainsUrl_native_cref_QUrl_constfct(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineprofile.html#defaultProfile">QWebEngineProfile::defaultProfile()</a></p>
     */
    public native static io.qt.webengine.core.QWebEngineProfile defaultProfile();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QWebEngineProfile(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QWebEngineProfile(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QWebEngineProfile instance, QDeclarativeConstructor constructor);
    
}
