package io.qt.webengine.core;


/**
 * <p>Information about URL requests</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html">QWebEngineUrlRequestInfo</a></p>
 */
public final class QWebEngineUrlRequestInfo extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::NavigationType</a></p>
     */
    public enum NavigationType implements io.qt.QtEnumerator {
        NavigationTypeLink(0),
        NavigationTypeTyped(1),
        NavigationTypeFormSubmitted(2),
        NavigationTypeBackForward(3),
        NavigationTypeReload(4),
        NavigationTypeOther(5),
        NavigationTypeRedirect(6);

        private NavigationType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static NavigationType resolve(int value) {
            switch (value) {
            case 0: return NavigationTypeLink;
            case 1: return NavigationTypeTyped;
            case 2: return NavigationTypeFormSubmitted;
            case 3: return NavigationTypeBackForward;
            case 4: return NavigationTypeReload;
            case 5: return NavigationTypeOther;
            case 6: return NavigationTypeRedirect;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceType</a></p>
     */
    @io.qt.QtRejectedEntries({"ResourceTypeLast"})
    public enum ResourceType implements io.qt.QtEnumerator {
        ResourceTypeMainFrame(0),
        ResourceTypeSubFrame(1),
        ResourceTypeStylesheet(2),
        ResourceTypeScript(3),
        ResourceTypeImage(4),
        ResourceTypeFontResource(5),
        ResourceTypeSubResource(6),
        ResourceTypeObject(7),
        ResourceTypeMedia(8),
        ResourceTypeWorker(9),
        ResourceTypeSharedWorker(10),
        ResourceTypePrefetch(11),
        ResourceTypeFavicon(12),
        ResourceTypeXhr(13),
        ResourceTypePing(14),
        ResourceTypeServiceWorker(15),
        ResourceTypeCspReport(16),
        ResourceTypePluginResource(17),
        ResourceTypeNavigationPreloadMainFrame(19),
        ResourceTypeNavigationPreloadSubFrame(20),
        ResourceTypeLast(20),
        ResourceTypeUnknown(255);

        private ResourceType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ResourceType resolve(int value) {
            switch (value) {
            case 0: return ResourceTypeMainFrame;
            case 1: return ResourceTypeSubFrame;
            case 2: return ResourceTypeStylesheet;
            case 3: return ResourceTypeScript;
            case 4: return ResourceTypeImage;
            case 5: return ResourceTypeFontResource;
            case 6: return ResourceTypeSubResource;
            case 7: return ResourceTypeObject;
            case 8: return ResourceTypeMedia;
            case 9: return ResourceTypeWorker;
            case 10: return ResourceTypeSharedWorker;
            case 11: return ResourceTypePrefetch;
            case 12: return ResourceTypeFavicon;
            case 13: return ResourceTypeXhr;
            case 14: return ResourceTypePing;
            case 15: return ResourceTypeServiceWorker;
            case 16: return ResourceTypeCspReport;
            case 17: return ResourceTypePluginResource;
            case 19: return ResourceTypeNavigationPreloadMainFrame;
            case 20: return ResourceTypeNavigationPreloadSubFrame;
            case 255: return ResourceTypeUnknown;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#block">QWebEngineUrlRequestInfo::block(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void block(boolean shouldBlock){
        block_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), shouldBlock);
    }
    
    @io.qt.QtUninvokable
    private native void block_native_bool(long __this__nativeId, boolean shouldBlock);
    
    @io.qt.QtUninvokable
    public final boolean changed(){
        return changed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean changed_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#firstPartyUrl">QWebEngineUrlRequestInfo::firstPartyUrl()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl firstPartyUrl(){
        return firstPartyUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl firstPartyUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#initiator">QWebEngineUrlRequestInfo::initiator()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl initiator(){
        return initiator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl initiator_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#navigationType">QWebEngineUrlRequestInfo::navigationType()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineUrlRequestInfo.NavigationType navigationType(){
        return io.qt.webengine.core.QWebEngineUrlRequestInfo.NavigationType.resolve(navigationType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int navigationType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#redirect">QWebEngineUrlRequestInfo::redirect(QUrl)</a></p>
     */
    @io.qt.QtUninvokable
    public final void redirect(io.qt.core.QUrl url){
        redirect_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @io.qt.QtUninvokable
    private native void redirect_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#requestMethod">QWebEngineUrlRequestInfo::requestMethod()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray requestMethod(){
        return requestMethod_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray requestMethod_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#requestUrl">QWebEngineUrlRequestInfo::requestUrl()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl requestUrl(){
        return requestUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl requestUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#resourceType">QWebEngineUrlRequestInfo::resourceType()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineUrlRequestInfo.ResourceType resourceType(){
        return io.qt.webengine.core.QWebEngineUrlRequestInfo.ResourceType.resolve(resourceType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int resourceType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebengineurlrequestinfo.html#setHttpHeader">QWebEngineUrlRequestInfo::setHttpHeader(QByteArray,QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setHttpHeader(io.qt.core.QByteArray name, io.qt.core.QByteArray value){
        setHttpHeader_native_cref_QByteArray_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setHttpHeader_native_cref_QByteArray_cref_QByteArray(long __this__nativeId, long name, long value);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QWebEngineUrlRequestInfo(QPrivateConstructor p) { super(p); } 
    
}
