package io.qt.webengine.core;


/**
 * <p>Encapsulates a JavaScript program</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qwebenginescript.html">QWebEngineScript</a></p>
 */
public class QWebEngineScript extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineScript.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginescript.html#InjectionPoint-enum">QWebEngineScript::InjectionPoint</a></p>
     */
    public enum InjectionPoint implements io.qt.QtEnumerator {
        Deferred(0),
        DocumentReady(1),
        DocumentCreation(2);

        private InjectionPoint(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static InjectionPoint resolve(int value) {
            switch (value) {
            case 0: return Deferred;
            case 1: return DocumentReady;
            case 2: return DocumentCreation;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginescript.html#ScriptWorldId-enum">QWebEngineScript::ScriptWorldId</a></p>
     */
    public enum ScriptWorldId implements io.qt.QtEnumerator {
        MainWorld(0),
        ApplicationWorld(1),
        UserWorld(2);

        private ScriptWorldId(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ScriptWorldId resolve(int value) {
            switch (value) {
            case 0: return MainWorld;
            case 1: return ApplicationWorld;
            case 2: return UserWorld;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#QWebEngineScript">QWebEngineScript::QWebEngineScript()</a></p>
     */
    public QWebEngineScript(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QWebEngineScript instance);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#QWebEngineScript-1">QWebEngineScript::QWebEngineScript(QWebEngineScript)</a></p>
     */
    public QWebEngineScript(io.qt.webengine.core.QWebEngineScript other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebEngineScript instance, io.qt.webengine.core.QWebEngineScript other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#injectionPoint">QWebEngineScript::injectionPoint()const</a></p>
     */
    @io.qt.QtPropertyReader(name="injectionPoint")
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineScript.InjectionPoint injectionPoint(){
        return io.qt.webengine.core.QWebEngineScript.InjectionPoint.resolve(injectionPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int injectionPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#name">QWebEngineScript::name()const</a></p>
     */
    @io.qt.QtPropertyReader(name="name")
    @io.qt.QtUninvokable
    public final java.lang.String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#operator-eq">QWebEngineScript::operator=(QWebEngineScript)</a></p>
     */
    @io.qt.QtUninvokable
    public final void set(io.qt.webengine.core.QWebEngineScript other){
        set_native_cref_QWebEngineScript(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void set_native_cref_QWebEngineScript(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#operator-eq-eq">QWebEngineScript::operator==(QWebEngineScript)const</a></p>
     */
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.webengine.core.QWebEngineScript other){
        return operator_equal_native_cref_QWebEngineScript_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QWebEngineScript_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#runsOnSubFrames">QWebEngineScript::runsOnSubFrames()const</a></p>
     */
    @io.qt.QtPropertyReader(name="runsOnSubFrames")
    @io.qt.QtUninvokable
    public final boolean runsOnSubFrames(){
        return runsOnSubFrames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean runsOnSubFrames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#setInjectionPoint">QWebEngineScript::setInjectionPoint(QWebEngineScript::InjectionPoint)</a></p>
     */
    @io.qt.QtPropertyWriter(name="injectionPoint")
    @io.qt.QtUninvokable
    public final void setInjectionPoint(io.qt.webengine.core.QWebEngineScript.InjectionPoint arg__1){
        setInjectionPoint_native_QWebEngineScript_InjectionPoint(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @io.qt.QtUninvokable
    private native void setInjectionPoint_native_QWebEngineScript_InjectionPoint(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#setName">QWebEngineScript::setName(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="name")
    @io.qt.QtUninvokable
    public final void setName(java.lang.String arg__1){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#setRunsOnSubFrames">QWebEngineScript::setRunsOnSubFrames(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="runsOnSubFrames")
    @io.qt.QtUninvokable
    public final void setRunsOnSubFrames(boolean on){
        setRunsOnSubFrames_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), on);
    }
    
    @io.qt.QtUninvokable
    private native void setRunsOnSubFrames_native_bool(long __this__nativeId, boolean on);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#setSourceCode">QWebEngineScript::setSourceCode(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sourceCode")
    @io.qt.QtUninvokable
    public final void setSourceCode(java.lang.String arg__1){
        setSourceCode_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setSourceCode_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#sourceUrl-prop">QWebEngineScript::setSourceUrl(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sourceUrl")
    @io.qt.QtUninvokable
    public final void setSourceUrl(io.qt.core.QUrl url){
        setSourceUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @io.qt.QtUninvokable
    private native void setSourceUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#setWorldId">QWebEngineScript::setWorldId(quint32)</a></p>
     */
    @io.qt.QtPropertyWriter(name="worldId")
    @io.qt.QtUninvokable
    public final void setWorldId(int arg__1){
        setWorldId_native_unsigned_int(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setWorldId_native_unsigned_int(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#sourceCode">QWebEngineScript::sourceCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sourceCode")
    @io.qt.QtUninvokable
    public final java.lang.String sourceCode(){
        return sourceCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String sourceCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#sourceUrl-prop">QWebEngineScript::sourceUrl()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sourceUrl")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl sourceUrl(){
        return sourceUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl sourceUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#swap">QWebEngineScript::swap(QWebEngineScript&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void swap(io.qt.webengine.core.QWebEngineScript other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QWebEngineScript(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void swap_native_ref_QWebEngineScript(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginescript.html#worldId">QWebEngineScript::worldId()const</a></p>
     */
    @io.qt.QtPropertyReader(name="worldId")
    @io.qt.QtUninvokable
    public final int worldId(){
        return worldId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int worldId_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QWebEngineScript(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.webengine.core.QWebEngineScript) {
            return operator_equal((io.qt.webengine.core.QWebEngineScript) other);
        }

        return false;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);

    @Override
    @io.qt.QtUninvokable
    public String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private static native String toString_native(long __this_nativeId);
    
    @Override
    public QWebEngineScript clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QWebEngineScript clone_native(long __this_nativeId);
}
