package io.qt.webengine.core;


/**
 * <p>Information about a download</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html">QWebEngineDownloadRequest</a></p>
 */
public final class QWebEngineDownloadRequest extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineDownloadRequest.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadInterruptReason-enum">QWebEngineDownloadRequest::DownloadInterruptReason</a></p>
     */
    public enum DownloadInterruptReason implements io.qt.QtEnumerator {
        NoReason(0),
        FileFailed(1),
        FileAccessDenied(2),
        FileNoSpace(3),
        FileNameTooLong(5),
        FileTooLarge(6),
        FileVirusInfected(7),
        FileTransientError(10),
        FileBlocked(11),
        FileSecurityCheckFailed(12),
        FileTooShort(13),
        FileHashMismatch(14),
        NetworkFailed(20),
        NetworkTimeout(21),
        NetworkDisconnected(22),
        NetworkServerDown(23),
        NetworkInvalidRequest(24),
        ServerFailed(30),
        ServerBadContent(33),
        ServerUnauthorized(34),
        ServerCertProblem(35),
        ServerForbidden(36),
        ServerUnreachable(37),
        UserCanceled(40);

        private DownloadInterruptReason(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DownloadInterruptReason resolve(int value) {
            switch (value) {
            case 0: return NoReason;
            case 1: return FileFailed;
            case 2: return FileAccessDenied;
            case 3: return FileNoSpace;
            case 5: return FileNameTooLong;
            case 6: return FileTooLarge;
            case 7: return FileVirusInfected;
            case 10: return FileTransientError;
            case 11: return FileBlocked;
            case 12: return FileSecurityCheckFailed;
            case 13: return FileTooShort;
            case 14: return FileHashMismatch;
            case 20: return NetworkFailed;
            case 21: return NetworkTimeout;
            case 22: return NetworkDisconnected;
            case 23: return NetworkServerDown;
            case 24: return NetworkInvalidRequest;
            case 30: return ServerFailed;
            case 33: return ServerBadContent;
            case 34: return ServerUnauthorized;
            case 35: return ServerCertProblem;
            case 36: return ServerForbidden;
            case 37: return ServerUnreachable;
            case 40: return UserCanceled;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#DownloadState-enum">QWebEngineDownloadRequest::DownloadState</a></p>
     */
    public enum DownloadState implements io.qt.QtEnumerator {
        DownloadRequested(0),
        DownloadInProgress(1),
        DownloadCompleted(2),
        DownloadCancelled(3),
        DownloadInterrupted(4);

        private DownloadState(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DownloadState resolve(int value) {
            switch (value) {
            case 0: return DownloadRequested;
            case 1: return DownloadInProgress;
            case 2: return DownloadCompleted;
            case 3: return DownloadCancelled;
            case 4: return DownloadInterrupted;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#SavePageFormat-enum">QWebEngineDownloadRequest::SavePageFormat</a></p>
     */
    public enum SavePageFormat implements io.qt.QtEnumerator {
        UnknownSaveFormat(-1),
        SingleHtmlSaveFormat(0),
        CompleteHtmlSaveFormat(1),
        MimeHtmlSaveFormat(2);

        private SavePageFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static SavePageFormat resolve(int value) {
            switch (value) {
            case -1: return UnknownSaveFormat;
            case 0: return SingleHtmlSaveFormat;
            case 1: return CompleteHtmlSaveFormat;
            case 2: return MimeHtmlSaveFormat;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#downloadDirectory-prop">QWebEngineDownloadRequest::downloadDirectoryChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="downloadDirectory")
    public final Signal0 downloadDirectoryChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#downloadFileName-prop">QWebEngineDownloadRequest::downloadFileNameChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="downloadFileName")
    public final Signal0 downloadFileNameChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#interruptReasonChanged">QWebEngineDownloadRequest::interruptReasonChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="interruptReason")
    public final Signal0 interruptReasonChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#isFinished-prop">QWebEngineDownloadRequest::isFinishedChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="isFinished")
    public final Signal0 isFinishedChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#isPausedChanged">QWebEngineDownloadRequest::isPausedChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="isPaused")
    public final Signal0 isPausedChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#receivedBytes-prop">QWebEngineDownloadRequest::receivedBytesChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="receivedBytes")
    public final Signal0 receivedBytesChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#savePageFormat-prop">QWebEngineDownloadRequest::savePageFormatChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="savePageFormat")
    public final Signal0 savePageFormatChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#stateChanged">QWebEngineDownloadRequest::stateChanged(QWebEngineDownloadRequest::DownloadState)</a></p>
     */
    @io.qt.QtPropertyNotify(name="state")
    public final Signal1<io.qt.webengine.core.QWebEngineDownloadRequest.DownloadState> stateChanged = new Signal1<>();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#totalBytes-prop">QWebEngineDownloadRequest::totalBytesChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="totalBytes")
    public final Signal0 totalBytesChanged = new Signal0();
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#accept">QWebEngineDownloadRequest::accept()</a></p>
     */
    public final void accept(){
        accept_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void accept_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#cancel">QWebEngineDownloadRequest::cancel()</a></p>
     */
    public final void cancel(){
        cancel_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void cancel_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#downloadDirectory">QWebEngineDownloadRequest::downloadDirectory()const</a></p>
     */
    @io.qt.QtPropertyReader(name="downloadDirectory")
    @io.qt.QtUninvokable
    public final java.lang.String downloadDirectory(){
        return downloadDirectory_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String downloadDirectory_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#downloadFileName">QWebEngineDownloadRequest::downloadFileName()const</a></p>
     */
    @io.qt.QtPropertyReader(name="downloadFileName")
    @io.qt.QtUninvokable
    public final java.lang.String downloadFileName(){
        return downloadFileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String downloadFileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#id">QWebEngineDownloadRequest::id()const</a></p>
     */
    @io.qt.QtPropertyReader(name="id")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final int id(){
        return id_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int id_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#interruptReason">QWebEngineDownloadRequest::interruptReason()const</a></p>
     */
    @io.qt.QtPropertyReader(name="interruptReason")
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineDownloadRequest.DownloadInterruptReason interruptReason(){
        return io.qt.webengine.core.QWebEngineDownloadRequest.DownloadInterruptReason.resolve(interruptReason_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int interruptReason_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#interruptReasonString">QWebEngineDownloadRequest::interruptReasonString()const</a></p>
     */
    @io.qt.QtPropertyReader(name="interruptReasonString")
    @io.qt.QtUninvokable
    public final java.lang.String interruptReasonString(){
        return interruptReasonString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String interruptReasonString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#isFinished-prop">QWebEngineDownloadRequest::isFinished()const</a></p>
     */
    @io.qt.QtPropertyReader(name="isFinished")
    @io.qt.QtUninvokable
    public final boolean isFinished(){
        return isFinished_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isFinished_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#isPaused-prop">QWebEngineDownloadRequest::isPaused()const</a></p>
     */
    @io.qt.QtPropertyReader(name="isPaused")
    @io.qt.QtUninvokable
    public final boolean isPaused(){
        return isPaused_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isPaused_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#isSavePageDownload">QWebEngineDownloadRequest::isSavePageDownload()const</a></p>
     */
    @io.qt.QtPropertyReader(name="isSavePageDownload")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final boolean isSavePageDownload(){
        return isSavePageDownload_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSavePageDownload_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#mimeType">QWebEngineDownloadRequest::mimeType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="mimeType")
    @io.qt.QtUninvokable
    public final java.lang.String mimeType(){
        return mimeType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String mimeType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#page">QWebEngineDownloadRequest::page()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEnginePage page(){
        return page_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.core.QWebEnginePage page_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#pause">QWebEngineDownloadRequest::pause()</a></p>
     */
    public final void pause(){
        pause_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void pause_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#receivedBytes">QWebEngineDownloadRequest::receivedBytes()const</a></p>
     */
    @io.qt.QtPropertyReader(name="receivedBytes")
    @io.qt.QtUninvokable
    public final long receivedBytes(){
        return receivedBytes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native long receivedBytes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#resume">QWebEngineDownloadRequest::resume()</a></p>
     */
    public final void resume(){
        resume_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void resume_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#savePageFormat">QWebEngineDownloadRequest::savePageFormat()const</a></p>
     */
    @io.qt.QtPropertyReader(name="savePageFormat")
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineDownloadRequest.SavePageFormat savePageFormat(){
        return io.qt.webengine.core.QWebEngineDownloadRequest.SavePageFormat.resolve(savePageFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int savePageFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#setDownloadDirectory">QWebEngineDownloadRequest::setDownloadDirectory(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="downloadDirectory")
    @io.qt.QtUninvokable
    public final void setDownloadDirectory(java.lang.String directory){
        setDownloadDirectory_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), directory);
    }
    
    @io.qt.QtUninvokable
    private native void setDownloadDirectory_native_cref_QString(long __this__nativeId, java.lang.String directory);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#setDownloadFileName">QWebEngineDownloadRequest::setDownloadFileName(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="downloadFileName")
    @io.qt.QtUninvokable
    public final void setDownloadFileName(java.lang.String fileName){
        setDownloadFileName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    @io.qt.QtUninvokable
    private native void setDownloadFileName_native_cref_QString(long __this__nativeId, java.lang.String fileName);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#setSavePageFormat">QWebEngineDownloadRequest::setSavePageFormat(QWebEngineDownloadRequest::SavePageFormat)</a></p>
     */
    @io.qt.QtPropertyWriter(name="savePageFormat")
    @io.qt.QtUninvokable
    public final void setSavePageFormat(io.qt.webengine.core.QWebEngineDownloadRequest.SavePageFormat format){
        setSavePageFormat_native_QWebEngineDownloadRequest_SavePageFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @io.qt.QtUninvokable
    private native void setSavePageFormat_native_QWebEngineDownloadRequest_SavePageFormat(long __this__nativeId, int format);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#state">QWebEngineDownloadRequest::state()const</a></p>
     */
    @io.qt.QtPropertyReader(name="state")
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineDownloadRequest.DownloadState state(){
        return io.qt.webengine.core.QWebEngineDownloadRequest.DownloadState.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#suggestedFileName">QWebEngineDownloadRequest::suggestedFileName()const</a></p>
     */
    @io.qt.QtPropertyReader(name="suggestedFileName")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final java.lang.String suggestedFileName(){
        return suggestedFileName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String suggestedFileName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#totalBytes">QWebEngineDownloadRequest::totalBytes()const</a></p>
     */
    @io.qt.QtPropertyReader(name="totalBytes")
    @io.qt.QtUninvokable
    public final long totalBytes(){
        return totalBytes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native long totalBytes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qwebenginedownloadrequest.html#url">QWebEngineDownloadRequest::url()const</a></p>
     */
    @io.qt.QtPropertyReader(name="url")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QWebEngineDownloadRequest(QPrivateConstructor p) { super(p); } 
    
}
