package io.qt.webengine.core;


/**
 * <p>A data model that represents the history of a web engine page</p>
 * <p>Java wrapper for Qt's class <a href="https://doc.qt.io/qt/qwebenginehistorymodel.html">QWebEngineHistoryModel</a></p>
 */
public final class QWebEngineHistoryModel extends io.qt.core.QAbstractListModel
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineHistoryModel.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qwebenginehistorymodel.html#Roles-enum">QWebEngineHistoryModel::Roles</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum Roles implements io.qt.QtEnumerator {
        UrlRole(256),
        TitleRole(257),
        OffsetRole(258),
        IconUrlRole(259);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Roles(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Roles resolve(int value) {
            switch (value) {
            case 256: return UrlRole;
            case 257: return TitleRole;
            case 258: return OffsetRole;
            case 259: return IconUrlRole;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    @io.qt.QtUninvokable
    public final void reset(){
        reset_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void reset_native(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#data">QAbstractItemModel::data(QModelIndex,int)const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.Object data(io.qt.core.QModelIndex index, int role){
        return data_native_cref_QModelIndex_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(index), role);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object data_native_cref_QModelIndex_int_constfct(long __this__nativeId, long index, int role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#roleNames">QAbstractItemModel::roleNames()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.util.Map<java.lang.Integer, io.qt.core.QByteArray> roleNames(){
        return roleNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.util.Map<java.lang.Integer, io.qt.core.QByteArray> roleNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#rowCount">QAbstractItemModel::rowCount(QModelIndex)const</a></p>
     */
    @io.qt.QtUninvokable
    public int rowCount(io.qt.core.QModelIndex parent){
        return rowCount_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @io.qt.QtUninvokable
    private native int rowCount_native_cref_QModelIndex_constfct(long __this__nativeId, long parent);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QWebEngineHistoryModel(QPrivateConstructor p) { super(p); } 
    
}
