package io.qt.webengine.core;


/**
 * <p>Represents a custom URL request</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qwebengineurlrequestjob.html">QWebEngineUrlRequestJob</a></p>
 */
public final class QWebEngineUrlRequestJob extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWebEngineUrlRequestJob.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebengineurlrequestjob.html#Error-enum">QWebEngineUrlRequestJob::Error</a></p>
     */
    public enum Error implements io.qt.QtEnumerator {
        NoError(0),
        UrlNotFound(1),
        UrlInvalid(2),
        RequestAborted(3),
        RequestDenied(4),
        RequestFailed(5);

        private Error(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Error resolve(int value) {
            switch (value) {
            case 0: return NoError;
            case 1: return UrlNotFound;
            case 2: return UrlInvalid;
            case 3: return RequestAborted;
            case 4: return RequestDenied;
            case 5: return RequestFailed;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestjob.html#fail">QWebEngineUrlRequestJob::fail(QWebEngineUrlRequestJob::Error)</a></p>
     */
    @io.qt.QtUninvokable
    public final void fail(io.qt.webengine.core.QWebEngineUrlRequestJob.Error error){
        fail_native_QWebEngineUrlRequestJob_Error(QtJambi_LibraryUtilities.internal.nativeId(this), error.value());
    }
    
    @io.qt.QtUninvokable
    private native void fail_native_QWebEngineUrlRequestJob_Error(long __this__nativeId, int error);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestjob.html#initiator">QWebEngineUrlRequestJob::initiator()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl initiator(){
        return initiator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl initiator_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestjob.html#redirect">QWebEngineUrlRequestJob::redirect(QUrl)</a></p>
     */
    @io.qt.QtUninvokable
    public final void redirect(io.qt.core.QUrl url){
        redirect_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @io.qt.QtUninvokable
    private native void redirect_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestjob.html#reply">QWebEngineUrlRequestJob::reply(QByteArray,QIODevice*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void reply(io.qt.core.QByteArray contentType, io.qt.core.QIODevice device){
        reply_native_cref_QByteArray_QIODevice_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(contentType), QtJambi_LibraryUtilities.internal.checkedNativeId(device));
    }
    
    @io.qt.QtUninvokable
    private native void reply_native_cref_QByteArray_QIODevice_ptr(long __this__nativeId, long contentType, long device);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestjob.html#requestHeaders">QWebEngineUrlRequestJob::requestHeaders()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QMap<io.qt.core.QByteArray, io.qt.core.QByteArray> requestHeaders(){
        return requestHeaders_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QMap<io.qt.core.QByteArray, io.qt.core.QByteArray> requestHeaders_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestjob.html#requestMethod">QWebEngineUrlRequestJob::requestMethod()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray requestMethod(){
        return requestMethod_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray requestMethod_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestjob.html#requestUrl">QWebEngineUrlRequestJob::requestUrl()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl requestUrl(){
        return requestUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl requestUrl_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QWebEngineUrlRequestJob(QPrivateConstructor p) { super(p); } 
    
}
