package io.qt.webengine.core;


/**
 * <p>Holds a request to be sent with WebEngine</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html">QWebEngineHttpRequest</a></p>
 */
public class QWebEngineHttpRequest extends io.qt.QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#Method-enum">QWebEngineHttpRequest::Method</a></p>
     */
    public enum Method implements io.qt.QtEnumerator {
        Get(0),
        Post(1);

        private Method(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Method resolve(int value) {
            switch (value) {
            case 0: return Get;
            case 1: return Post;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QWebEngineHttpRequest(io.qt.core.QUrl, io.qt.webengine.core.QWebEngineHttpRequest.Method)}
     *  with <code>method = io.qt.webengine.core.QWebEngineHttpRequest.Method.Get</code>.</p>
     */
    public QWebEngineHttpRequest(io.qt.core.QUrl url) {
        this(url, io.qt.webengine.core.QWebEngineHttpRequest.Method.Get);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QWebEngineHttpRequest(io.qt.core.QUrl, io.qt.webengine.core.QWebEngineHttpRequest.Method)}</p>
     * <p>with: </p><ul>
     * <li><code>url = new io.qt.core.QUrl()</code></li>
     * <li><code>method = io.qt.webengine.core.QWebEngineHttpRequest.Method.Get</code></li>
     * </ul>
     */
    public QWebEngineHttpRequest() {
        this(new io.qt.core.QUrl(), io.qt.webengine.core.QWebEngineHttpRequest.Method.Get);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#QWebEngineHttpRequest">QWebEngineHttpRequest::QWebEngineHttpRequest(QUrl,QWebEngineHttpRequest::Method)</a></p>
     */
    public QWebEngineHttpRequest(io.qt.core.QUrl url, io.qt.webengine.core.QWebEngineHttpRequest.Method method){
        super((QPrivateConstructor)null);
        initialize_native(this, url, method);
    }
    
    private native static void initialize_native(QWebEngineHttpRequest instance, io.qt.core.QUrl url, io.qt.webengine.core.QWebEngineHttpRequest.Method method);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#QWebEngineHttpRequest-1">QWebEngineHttpRequest::QWebEngineHttpRequest(QWebEngineHttpRequest)</a></p>
     */
    public QWebEngineHttpRequest(io.qt.webengine.core.QWebEngineHttpRequest other){
        super((QPrivateConstructor)null);
        initialize_native(this, other);
    }
    
    private native static void initialize_native(QWebEngineHttpRequest instance, io.qt.webengine.core.QWebEngineHttpRequest other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#hasHeader">QWebEngineHttpRequest::hasHeader(QByteArray)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean hasHeader(io.qt.core.QByteArray headerName){
        return hasHeader_native_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(headerName));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasHeader_native_cref_QByteArray_constfct(long __this__nativeId, long headerName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#header">QWebEngineHttpRequest::header(QByteArray)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray header(io.qt.core.QByteArray headerName){
        return header_native_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(headerName));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray header_native_cref_QByteArray_constfct(long __this__nativeId, long headerName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#headers">QWebEngineHttpRequest::headers()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QVector<io.qt.core.QByteArray> headers(){
        return headers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QVector<io.qt.core.QByteArray> headers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#method">QWebEngineHttpRequest::method()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineHttpRequest.Method method(){
        return io.qt.webengine.core.QWebEngineHttpRequest.Method.resolve(method_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int method_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#operator-eq-1">QWebEngineHttpRequest::operator=(QWebEngineHttpRequest)</a></p>
     */
    @io.qt.QtUninvokable
    public final void set(io.qt.webengine.core.QWebEngineHttpRequest other){
        set_native_cref_QWebEngineHttpRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void set_native_cref_QWebEngineHttpRequest(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#operator-eq-eq">QWebEngineHttpRequest::operator==(QWebEngineHttpRequest)const</a></p>
     */
    @io.qt.QtUninvokable
    private final boolean operator_equal(io.qt.webengine.core.QWebEngineHttpRequest other){
        return operator_equal_native_cref_QWebEngineHttpRequest_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native boolean operator_equal_native_cref_QWebEngineHttpRequest_constfct(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#postData">QWebEngineHttpRequest::postData()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray postData(){
        return postData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray postData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#setHeader">QWebEngineHttpRequest::setHeader(QByteArray,QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setHeader(io.qt.core.QByteArray headerName, io.qt.core.QByteArray value){
        setHeader_native_cref_QByteArray_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(headerName), QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @io.qt.QtUninvokable
    private native void setHeader_native_cref_QByteArray_cref_QByteArray(long __this__nativeId, long headerName, long value);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#setMethod">QWebEngineHttpRequest::setMethod(QWebEngineHttpRequest::Method)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setMethod(io.qt.webengine.core.QWebEngineHttpRequest.Method method){
        setMethod_native_QWebEngineHttpRequest_Method(QtJambi_LibraryUtilities.internal.nativeId(this), method.value());
    }
    
    @io.qt.QtUninvokable
    private native void setMethod_native_QWebEngineHttpRequest_Method(long __this__nativeId, int method);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#setPostData">QWebEngineHttpRequest::setPostData(QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPostData(io.qt.core.QByteArray postData){
        setPostData_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(postData));
    }
    
    @io.qt.QtUninvokable
    private native void setPostData_native_cref_QByteArray(long __this__nativeId, long postData);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#setUrl">QWebEngineHttpRequest::setUrl(QUrl)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setUrl(io.qt.core.QUrl url){
        setUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @io.qt.QtUninvokable
    private native void setUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#swap">QWebEngineHttpRequest::swap(QWebEngineHttpRequest&amp;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void swap(io.qt.webengine.core.QWebEngineHttpRequest other){
        java.util.Objects.requireNonNull(other, "Argument 'other': null not expected.");
        swap_native_ref_QWebEngineHttpRequest(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @io.qt.QtUninvokable
    private native void swap_native_ref_QWebEngineHttpRequest(long __this__nativeId, long other);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#unsetHeader">QWebEngineHttpRequest::unsetHeader(QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void unsetHeader(io.qt.core.QByteArray headerName){
        unsetHeader_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(headerName));
    }
    
    @io.qt.QtUninvokable
    private native void unsetHeader_native_cref_QByteArray(long __this__nativeId, long headerName);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#url">QWebEngineHttpRequest::url()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl url(){
        return url_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl url_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebenginehttprequest.html#postRequest">QWebEngineHttpRequest::postRequest(QUrl,QMap&lt;QString,QString&gt;)</a></p>
     */
    public static io.qt.webengine.core.QWebEngineHttpRequest postRequest(io.qt.core.QUrl url, java.util.Map<java.lang.String, java.lang.String> postData){
        return postRequest_native_cref_QUrl_cref_QMap(QtJambi_LibraryUtilities.internal.checkedNativeId(url), postData);
    }
    
    private native static io.qt.webengine.core.QWebEngineHttpRequest postRequest_native_cref_QUrl_cref_QMap(long url, java.util.Map<java.lang.String, java.lang.String> postData);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QWebEngineHttpRequest(QPrivateConstructor p) { super(p); } 
    

    @Override
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        if (other instanceof io.qt.webengine.core.QWebEngineHttpRequest) {
            return operator_equal((io.qt.webengine.core.QWebEngineHttpRequest) other);
        }

        return false;
    }


    @io.qt.QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    @Override
    public QWebEngineHttpRequest clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private native QWebEngineHttpRequest clone_native(long __this_nativeId);
}
