package io.qt.webengine.core;

import io.qt.*;
import static io.qt.QtUtilities.*;

final class QtJambi_LibraryUtilities {

    final static int qtMajorVersion = 5;

    final static int qtMinorVersion = 15;

    final static int qtJambiPatch = 15;

    final static InternalAccess internal;

    static{
        try {
            initializePackage("io.qt.core");
            loadQtLibrary("DBus", LibraryRequirementMode.ProvideOnly, "macos", "linux");
            loadQtLibrary("OpenGL", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("PrintSupport", LibraryRequirementMode.ProvideOnly, "macos");
            loadQtLibrary("Qml", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("QmlModels", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("Quick", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("Svg", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("VirtualKeyboard", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("WaylandClient", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("WaylandEglClientHwIntegration", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("Widgets", LibraryRequirementMode.ProvideOnly, "linux", "macos");
            loadQtLibrary("WlShellIntegration", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("Network", LibraryRequirementMode.Mandatory);
            loadUtilityLibrary("libGLESv2", LibraryRequirementMode.Optional, "windows");
            loadUtilityLibrary("libEGL", LibraryRequirementMode.Optional, "windows");
            loadQtLibrary("Gui", LibraryRequirementMode.Mandatory);
            loadQtLibrary("Qml", LibraryRequirementMode.Mandatory);
            loadQtLibrary("QmlModels", LibraryRequirementMode.Mandatory);
            loadQtLibrary("Quick", LibraryRequirementMode.Mandatory);
            loadQtLibrary("WebChannel", LibraryRequirementMode.Mandatory);
            loadQtLibrary("Positioning", LibraryRequirementMode.Mandatory);
            loadQtLibrary("DBus", LibraryRequirementMode.Optional);
            loadQtLibrary("WebEngineCore", LibraryRequirementMode.Mandatory);
            loadQtJambiLibrary("WebEngineCore");
        } catch(Error t) {
            throw t;
        } catch(Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
        internal = internalAccess();
    }
    private static native InternalAccess internalAccess();

    static void initialize() { };

    private QtJambi_LibraryUtilities() throws InstantiationError { throw new InstantiationError("Cannot instantiate QtJambi_LibraryUtilities."); }
}

