package io.qt.webengine.core;

import io.qt.*;


/**
 * <p>Information about URL requests</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html">QWebEngineUrlRequestInfo</a></p>
 */
public final class QWebEngineUrlRequestInfo extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::NavigationType</a></p>
     */
    public enum NavigationType implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::NavigationTypeLink</a></p>
         */
        NavigationTypeLink(0),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::NavigationTypeTyped</a></p>
         */
        NavigationTypeTyped(1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::NavigationTypeFormSubmitted</a></p>
         */
        NavigationTypeFormSubmitted(2),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::NavigationTypeBackForward</a></p>
         */
        NavigationTypeBackForward(3),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::NavigationTypeReload</a></p>
         */
        NavigationTypeReload(4),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::NavigationTypeOther</a></p>
         */
        NavigationTypeOther(5),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#NavigationType-enum">QWebEngineUrlRequestInfo::NavigationTypeRedirect</a></p>
         */
        NavigationTypeRedirect(6);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private NavigationType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull NavigationType resolve(int value) {
            switch (value) {
            case 0: return NavigationTypeLink;
            case 1: return NavigationTypeTyped;
            case 2: return NavigationTypeFormSubmitted;
            case 3: return NavigationTypeBackForward;
            case 4: return NavigationTypeReload;
            case 5: return NavigationTypeOther;
            case 6: return NavigationTypeRedirect;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceType</a></p>
     */
    @QtRejectedEntries({"ResourceTypeLast"})
    public enum ResourceType implements QtEnumerator {
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeMainFrame</a></p>
         */
        ResourceTypeMainFrame(0),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeSubFrame</a></p>
         */
        ResourceTypeSubFrame(1),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeStylesheet</a></p>
         */
        ResourceTypeStylesheet(2),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeScript</a></p>
         */
        ResourceTypeScript(3),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeImage</a></p>
         */
        ResourceTypeImage(4),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeFontResource</a></p>
         */
        ResourceTypeFontResource(5),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeSubResource</a></p>
         */
        ResourceTypeSubResource(6),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeObject</a></p>
         */
        ResourceTypeObject(7),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeMedia</a></p>
         */
        ResourceTypeMedia(8),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeWorker</a></p>
         */
        ResourceTypeWorker(9),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeSharedWorker</a></p>
         */
        ResourceTypeSharedWorker(10),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypePrefetch</a></p>
         */
        ResourceTypePrefetch(11),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeFavicon</a></p>
         */
        ResourceTypeFavicon(12),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeXhr</a></p>
         */
        ResourceTypeXhr(13),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypePing</a></p>
         */
        ResourceTypePing(14),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeServiceWorker</a></p>
         */
        ResourceTypeServiceWorker(15),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeCspReport</a></p>
         */
        ResourceTypeCspReport(16),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypePluginResource</a></p>
         */
        ResourceTypePluginResource(17),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeNavigationPreloadMainFrame</a></p>
         */
        ResourceTypeNavigationPreloadMainFrame(19),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeNavigationPreloadSubFrame</a></p>
         */
        ResourceTypeNavigationPreloadSubFrame(20),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeLast</a></p>
         */
        ResourceTypeLast(20),
        /**
         * <p>Representing <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#ResourceType-enum">QWebEngineUrlRequestInfo::ResourceTypeUnknown</a></p>
         */
        ResourceTypeUnknown(255);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ResourceType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ResourceType resolve(int value) {
            switch (value) {
            case 0: return ResourceTypeMainFrame;
            case 1: return ResourceTypeSubFrame;
            case 2: return ResourceTypeStylesheet;
            case 3: return ResourceTypeScript;
            case 4: return ResourceTypeImage;
            case 5: return ResourceTypeFontResource;
            case 6: return ResourceTypeSubResource;
            case 7: return ResourceTypeObject;
            case 8: return ResourceTypeMedia;
            case 9: return ResourceTypeWorker;
            case 10: return ResourceTypeSharedWorker;
            case 11: return ResourceTypePrefetch;
            case 12: return ResourceTypeFavicon;
            case 13: return ResourceTypeXhr;
            case 14: return ResourceTypePing;
            case 15: return ResourceTypeServiceWorker;
            case 16: return ResourceTypeCspReport;
            case 17: return ResourceTypePluginResource;
            case 19: return ResourceTypeNavigationPreloadMainFrame;
            case 20: return ResourceTypeNavigationPreloadSubFrame;
            case 255: return ResourceTypeUnknown;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#block">QWebEngineUrlRequestInfo::block(bool)</a></p>
     */
    @QtUninvokable
    public final void block(boolean shouldBlock){
        block_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), shouldBlock);
    }
    
    @QtUninvokable
    private native void block_native_bool(long __this__nativeId, boolean shouldBlock);
    
    @QtUninvokable
    public final boolean changed(){
        return changed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean changed_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#firstPartyUrl">QWebEngineUrlRequestInfo::firstPartyUrl()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl firstPartyUrl(){
        return firstPartyUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl firstPartyUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#initiator">QWebEngineUrlRequestInfo::initiator()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl initiator(){
        return initiator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl initiator_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#navigationType">QWebEngineUrlRequestInfo::navigationType()const</a></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineUrlRequestInfo.@NonNull NavigationType navigationType(){
        return io.qt.webengine.core.QWebEngineUrlRequestInfo.NavigationType.resolve(navigationType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int navigationType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#redirect">QWebEngineUrlRequestInfo::redirect(QUrl)</a></p>
     */
    @QtUninvokable
    public final void redirect(io.qt.core.@NonNull QUrl url){
        redirect_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    @QtUninvokable
    private native void redirect_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#requestMethod">QWebEngineUrlRequestInfo::requestMethod()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray requestMethod(){
        return requestMethod_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray requestMethod_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#requestUrl">QWebEngineUrlRequestInfo::requestUrl()const</a></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl requestUrl(){
        return requestUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl requestUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#resourceType">QWebEngineUrlRequestInfo::resourceType()const</a></p>
     */
    @QtUninvokable
    public final io.qt.webengine.core.QWebEngineUrlRequestInfo.@NonNull ResourceType resourceType(){
        return io.qt.webengine.core.QWebEngineUrlRequestInfo.ResourceType.resolve(resourceType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int resourceType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwebengineurlrequestinfo.html#setHttpHeader">QWebEngineUrlRequestInfo::setHttpHeader(QByteArray,QByteArray)</a></p>
     */
    @QtUninvokable
    public final void setHttpHeader(io.qt.core.@NonNull QByteArray name, io.qt.core.@NonNull QByteArray value){
        setHttpHeader_native_cref_QByteArray_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(name), QtJambi_LibraryUtilities.internal.checkedNativeId(value));
    }
    
    @QtUninvokable
    private native void setHttpHeader_native_cref_QByteArray_cref_QByteArray(long __this__nativeId, long name, long value);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @NativeAccess
    protected QWebEngineUrlRequestInfo(QPrivateConstructor p) { super(p); } 
    
}
