package io.qt.webengine;


/**
 * <p>Web engine profile shared by multiple pages</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html">QQuickWebEngineProfile</a></p>
 */
public class QQuickWebEngineProfile extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private java.util.Collection<Object> __rcUrlSchemeHandler;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcUrlRequestInterceptor = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuickWebEngineProfile.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#HttpCacheType-enum">QQuickWebEngineProfile::HttpCacheType</a></p>
     */
    public enum HttpCacheType implements io.qt.QtEnumerator {
        MemoryHttpCache(0),
        DiskHttpCache(1),
        NoCache(2);

        private HttpCacheType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static HttpCacheType resolve(int value) {
            switch (value) {
            case 0: return MemoryHttpCache;
            case 1: return DiskHttpCache;
            case 2: return NoCache;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#PersistentCookiesPolicy-enum">QQuickWebEngineProfile::PersistentCookiesPolicy</a></p>
     */
    public enum PersistentCookiesPolicy implements io.qt.QtEnumerator {
        NoPersistentCookies(0),
        AllowPersistentCookies(1),
        ForcePersistentCookies(2);

        private PersistentCookiesPolicy(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PersistentCookiesPolicy resolve(int value) {
            switch (value) {
            case 0: return NoPersistentCookies;
            case 1: return AllowPersistentCookies;
            case 2: return ForcePersistentCookies;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#cachePath-prop">QQuickWebEngineProfile::cachePathChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="cachePath")
    public final Signal0 cachePathChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#downloadPath-prop">QQuickWebEngineProfile::downloadPathChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="downloadPath")
    public final Signal0 downloadPathChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpAcceptLanguage-prop">QQuickWebEngineProfile::httpAcceptLanguageChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="httpAcceptLanguage")
    public final Signal0 httpAcceptLanguageChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpCacheMaximumSize-prop">QQuickWebEngineProfile::httpCacheMaximumSizeChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="httpCacheMaximumSize")
    public final Signal0 httpCacheMaximumSizeChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpCacheType-prop">QQuickWebEngineProfile::httpCacheTypeChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="httpCacheType")
    public final Signal0 httpCacheTypeChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpUserAgent-prop">QQuickWebEngineProfile::httpUserAgentChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="httpUserAgent")
    public final Signal0 httpUserAgentChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#offTheRecord-prop">QQuickWebEngineProfile::offTheRecordChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="offTheRecord")
    public final Signal0 offTheRecordChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#persistentCookiesPolicy-prop">QQuickWebEngineProfile::persistentCookiesPolicyChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="persistentCookiesPolicy")
    public final Signal0 persistentCookiesPolicyChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#persistentStoragePath-prop">QQuickWebEngineProfile::persistentStoragePathChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="persistentStoragePath")
    public final Signal0 persistentStoragePathChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#presentNotification">QQuickWebEngineProfile::presentNotification(QWebEngineNotification*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public final Signal1<io.qt.webengine.core.QWebEngineNotification> presentNotification = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#spellCheckEnabled-prop">QQuickWebEngineProfile::spellCheckEnabledChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="spellCheckEnabled")
    public final Signal0 spellCheckEnabledChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#spellCheckLanguages-prop">QQuickWebEngineProfile::spellCheckLanguagesChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="spellCheckLanguages")
    public final Signal0 spellCheckLanguagesChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#storageName-prop">QQuickWebEngineProfile::storageNameChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="storageName")
    public final Signal0 storageNameChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#useForGlobalCertificateVerification-prop">QQuickWebEngineProfile::useForGlobalCertificateVerificationChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="useForGlobalCertificateVerification")
    public final Signal0 useForGlobalCertificateVerificationChanged = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QQuickWebEngineProfile(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuickWebEngineProfile() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#QQuickWebEngineProfile">QQuickWebEngineProfile::QQuickWebEngineProfile(QObject*)</a></p>
     */
    public QQuickWebEngineProfile(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQuickWebEngineProfile instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#cachePath-prop">QQuickWebEngineProfile::cachePath()const</a></p>
     */
    @io.qt.QtPropertyReader(name="cachePath")
    @io.qt.QtUninvokable
    public final java.lang.String cachePath(){
        return cachePath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String cachePath_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#clearHttpCache">QQuickWebEngineProfile::clearHttpCache()</a></p>
     */
    public final void clearHttpCache(){
        clearHttpCache_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void clearHttpCache_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#clientCertificateStore">QQuickWebEngineProfile::clientCertificateStore()</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineClientCertificateStore clientCertificateStore(){
        return clientCertificateStore_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.core.QWebEngineClientCertificateStore clientCertificateStore_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#cookieStore">QQuickWebEngineProfile::cookieStore()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineCookieStore cookieStore(){
        return cookieStore_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.core.QWebEngineCookieStore cookieStore_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#downloadPath-prop">QQuickWebEngineProfile::downloadPath()const</a></p>
     */
    @io.qt.QtPropertyReader(name="downloadPath")
    @io.qt.QtUninvokable
    public final java.lang.String downloadPath(){
        return downloadPath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String downloadPath_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpAcceptLanguage-prop">QQuickWebEngineProfile::httpAcceptLanguage()const</a></p>
     */
    @io.qt.QtPropertyReader(name="httpAcceptLanguage")
    @io.qt.QtUninvokable
    public final java.lang.String httpAcceptLanguage(){
        return httpAcceptLanguage_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String httpAcceptLanguage_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpCacheMaximumSize-prop">QQuickWebEngineProfile::httpCacheMaximumSize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="httpCacheMaximumSize")
    @io.qt.QtUninvokable
    public final int httpCacheMaximumSize(){
        return httpCacheMaximumSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int httpCacheMaximumSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpCacheType-prop">QQuickWebEngineProfile::httpCacheType()const</a></p>
     */
    @io.qt.QtPropertyReader(name="httpCacheType")
    @io.qt.QtUninvokable
    public final io.qt.webengine.QQuickWebEngineProfile.HttpCacheType httpCacheType(){
        return io.qt.webengine.QQuickWebEngineProfile.HttpCacheType.resolve(httpCacheType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int httpCacheType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpUserAgent-prop">QQuickWebEngineProfile::httpUserAgent()const</a></p>
     */
    @io.qt.QtPropertyReader(name="httpUserAgent")
    @io.qt.QtUninvokable
    public final java.lang.String httpUserAgent(){
        return httpUserAgent_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String httpUserAgent_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#installUrlSchemeHandler">QQuickWebEngineProfile::installUrlSchemeHandler(QByteArray,QWebEngineUrlSchemeHandler*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void installUrlSchemeHandler(io.qt.core.QByteArray scheme, io.qt.webengine.core.QWebEngineUrlSchemeHandler arg__2){
        installUrlSchemeHandler_native_cref_QByteArray_QWebEngineUrlSchemeHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scheme), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
        if (arg__2 != null) {
            if(__rcUrlSchemeHandler==null)
                __rcUrlSchemeHandler = QtJambi_LibraryUtilities.internal.newRCList();
            __rcUrlSchemeHandler.add(arg__2);
        }
    }
    
    @io.qt.QtUninvokable
    private native void installUrlSchemeHandler_native_cref_QByteArray_QWebEngineUrlSchemeHandler_ptr(long __this__nativeId, long scheme, long arg__2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#offTheRecord-prop">QQuickWebEngineProfile::isOffTheRecord()const</a></p>
     */
    @io.qt.QtPropertyReader(name="offTheRecord")
    @io.qt.QtUninvokable
    public final boolean isOffTheRecord(){
        return isOffTheRecord_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isOffTheRecord_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#spellCheckEnabled-prop">QQuickWebEngineProfile::isSpellCheckEnabled()const</a></p>
     */
    @io.qt.QtPropertyReader(name="spellCheckEnabled")
    @io.qt.QtUninvokable
    public final boolean isSpellCheckEnabled(){
        return isSpellCheckEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSpellCheckEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#useForGlobalCertificateVerification-prop">QQuickWebEngineProfile::isUsedForGlobalCertificateVerification()const</a></p>
     */
    @io.qt.QtPropertyReader(name="useForGlobalCertificateVerification")
    @io.qt.QtUninvokable
    public final boolean isUsedForGlobalCertificateVerification(){
        return isUsedForGlobalCertificateVerification_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isUsedForGlobalCertificateVerification_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#persistentCookiesPolicy-prop">QQuickWebEngineProfile::persistentCookiesPolicy()const</a></p>
     */
    @io.qt.QtPropertyReader(name="persistentCookiesPolicy")
    @io.qt.QtUninvokable
    public final io.qt.webengine.QQuickWebEngineProfile.PersistentCookiesPolicy persistentCookiesPolicy(){
        return io.qt.webengine.QQuickWebEngineProfile.PersistentCookiesPolicy.resolve(persistentCookiesPolicy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int persistentCookiesPolicy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#persistentStoragePath-prop">QQuickWebEngineProfile::persistentStoragePath()const</a></p>
     */
    @io.qt.QtPropertyReader(name="persistentStoragePath")
    @io.qt.QtUninvokable
    public final java.lang.String persistentStoragePath(){
        return persistentStoragePath_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String persistentStoragePath_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#removeAllUrlSchemeHandlers">QQuickWebEngineProfile::removeAllUrlSchemeHandlers()</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeAllUrlSchemeHandlers(){
        removeAllUrlSchemeHandlers_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void removeAllUrlSchemeHandlers_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#removeUrlScheme">QQuickWebEngineProfile::removeUrlScheme(QByteArray)</a></p>
     */
    @io.qt.QtUninvokable
    public final void removeUrlScheme(io.qt.core.QByteArray scheme){
        removeUrlScheme_native_cref_QByteArray(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(scheme));
    }
    
    @io.qt.QtUninvokable
    private native void removeUrlScheme_native_cref_QByteArray(long __this__nativeId, long scheme);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#removeUrlSchemeHandler">QQuickWebEngineProfile::removeUrlSchemeHandler(QWebEngineUrlSchemeHandler*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void removeUrlSchemeHandler(io.qt.webengine.core.QWebEngineUrlSchemeHandler arg__1){
        removeUrlSchemeHandler_native_QWebEngineUrlSchemeHandler_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
        if (arg__1 != null) {
            while (__rcUrlSchemeHandler != null && __rcUrlSchemeHandler.remove(arg__1)) ;
        }
    }
    
    @io.qt.QtUninvokable
    private native void removeUrlSchemeHandler_native_QWebEngineUrlSchemeHandler_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#cachePath-prop">QQuickWebEngineProfile::setCachePath(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="cachePath")
    @io.qt.QtUninvokable
    public final void setCachePath(java.lang.String path){
        setCachePath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @io.qt.QtUninvokable
    private native void setCachePath_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#downloadPath-prop">QQuickWebEngineProfile::setDownloadPath(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="downloadPath")
    @io.qt.QtUninvokable
    public final void setDownloadPath(java.lang.String path){
        setDownloadPath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @io.qt.QtUninvokable
    private native void setDownloadPath_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpAcceptLanguage-prop">QQuickWebEngineProfile::setHttpAcceptLanguage(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="httpAcceptLanguage")
    @io.qt.QtUninvokable
    public final void setHttpAcceptLanguage(java.lang.String httpAcceptLanguage){
        setHttpAcceptLanguage_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), httpAcceptLanguage);
    }
    
    @io.qt.QtUninvokable
    private native void setHttpAcceptLanguage_native_cref_QString(long __this__nativeId, java.lang.String httpAcceptLanguage);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpCacheMaximumSize-prop">QQuickWebEngineProfile::setHttpCacheMaximumSize(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="httpCacheMaximumSize")
    @io.qt.QtUninvokable
    public final void setHttpCacheMaximumSize(int maxSize){
        setHttpCacheMaximumSize_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), maxSize);
    }
    
    @io.qt.QtUninvokable
    private native void setHttpCacheMaximumSize_native_int(long __this__nativeId, int maxSize);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpCacheType-prop">QQuickWebEngineProfile::setHttpCacheType(QQuickWebEngineProfile::HttpCacheType)</a></p>
     */
    @io.qt.QtPropertyWriter(name="httpCacheType")
    @io.qt.QtUninvokable
    public final void setHttpCacheType(io.qt.webengine.QQuickWebEngineProfile.HttpCacheType arg__1){
        setHttpCacheType_native_QQuickWebEngineProfile_HttpCacheType(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @io.qt.QtUninvokable
    private native void setHttpCacheType_native_QQuickWebEngineProfile_HttpCacheType(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#httpUserAgent-prop">QQuickWebEngineProfile::setHttpUserAgent(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="httpUserAgent")
    @io.qt.QtUninvokable
    public final void setHttpUserAgent(java.lang.String userAgent){
        setHttpUserAgent_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), userAgent);
    }
    
    @io.qt.QtUninvokable
    private native void setHttpUserAgent_native_cref_QString(long __this__nativeId, java.lang.String userAgent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#offTheRecord-prop">QQuickWebEngineProfile::setOffTheRecord(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="offTheRecord")
    @io.qt.QtUninvokable
    public final void setOffTheRecord(boolean offTheRecord){
        setOffTheRecord_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), offTheRecord);
    }
    
    @io.qt.QtUninvokable
    private native void setOffTheRecord_native_bool(long __this__nativeId, boolean offTheRecord);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#persistentCookiesPolicy-prop">QQuickWebEngineProfile::setPersistentCookiesPolicy(QQuickWebEngineProfile::PersistentCookiesPolicy)</a></p>
     */
    @io.qt.QtPropertyWriter(name="persistentCookiesPolicy")
    @io.qt.QtUninvokable
    public final void setPersistentCookiesPolicy(io.qt.webengine.QQuickWebEngineProfile.PersistentCookiesPolicy arg__1){
        setPersistentCookiesPolicy_native_QQuickWebEngineProfile_PersistentCookiesPolicy(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @io.qt.QtUninvokable
    private native void setPersistentCookiesPolicy_native_QQuickWebEngineProfile_PersistentCookiesPolicy(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#persistentStoragePath-prop">QQuickWebEngineProfile::setPersistentStoragePath(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="persistentStoragePath")
    @io.qt.QtUninvokable
    public final void setPersistentStoragePath(java.lang.String path){
        setPersistentStoragePath_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), path);
    }
    
    @io.qt.QtUninvokable
    private native void setPersistentStoragePath_native_cref_QString(long __this__nativeId, java.lang.String path);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile-obsolete.html#setRequestInterceptor">QQuickWebEngineProfile::setRequestInterceptor(QWebEngineUrlRequestInterceptor*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void setRequestInterceptor(io.qt.webengine.core.QWebEngineUrlRequestInterceptor interceptor){
        setRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(interceptor));
        __rcUrlRequestInterceptor = interceptor;
    }
    
    @io.qt.QtUninvokable
    private native void setRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(long __this__nativeId, long interceptor);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#spellCheckEnabled-prop">QQuickWebEngineProfile::setSpellCheckEnabled(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="spellCheckEnabled")
    @io.qt.QtUninvokable
    public final void setSpellCheckEnabled(boolean enabled){
        setSpellCheckEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setSpellCheckEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#spellCheckLanguages-prop">QQuickWebEngineProfile::setSpellCheckLanguages(QStringList)</a></p>
     */
    @io.qt.QtPropertyWriter(name="spellCheckLanguages")
    @io.qt.QtUninvokable
    public final void setSpellCheckLanguages(java.util.Collection<java.lang.String> languages){
        setSpellCheckLanguages_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), languages);
    }
    
    @io.qt.QtUninvokable
    private native void setSpellCheckLanguages_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> languages);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#storageName-prop">QQuickWebEngineProfile::setStorageName(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="storageName")
    @io.qt.QtUninvokable
    public final void setStorageName(java.lang.String name){
        setStorageName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    @io.qt.QtUninvokable
    private native void setStorageName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#setUrlRequestInterceptor">QQuickWebEngineProfile::setUrlRequestInterceptor(QWebEngineUrlRequestInterceptor*)</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final void setUrlRequestInterceptor(io.qt.webengine.core.QWebEngineUrlRequestInterceptor interceptor){
        setUrlRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(interceptor));
        __rcUrlRequestInterceptor = interceptor;
    }
    
    @io.qt.QtUninvokable
    private native void setUrlRequestInterceptor_native_QWebEngineUrlRequestInterceptor_ptr(long __this__nativeId, long interceptor);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#useForGlobalCertificateVerification-prop">QQuickWebEngineProfile::setUseForGlobalCertificateVerification(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="useForGlobalCertificateVerification")
    @io.qt.QtUninvokable
    public final void setUseForGlobalCertificateVerification(boolean b){
        setUseForGlobalCertificateVerification_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), b);
    }
    
    @io.qt.QtUninvokable
    private native void setUseForGlobalCertificateVerification_native_bool(long __this__nativeId, boolean b);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#spellCheckLanguages">QQuickWebEngineProfile::spellCheckLanguages()const</a></p>
     */
    @io.qt.QtPropertyReader(name="spellCheckLanguages")
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList spellCheckLanguages(){
        return spellCheckLanguages_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList spellCheckLanguages_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#storageName-prop">QQuickWebEngineProfile::storageName()const</a></p>
     */
    @io.qt.QtPropertyReader(name="storageName")
    @io.qt.QtUninvokable
    public final java.lang.String storageName(){
        return storageName_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String storageName_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#urlSchemeHandler">QQuickWebEngineProfile::urlSchemeHandler(QByteArray)const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.webengine.core.QWebEngineUrlSchemeHandler urlSchemeHandler(io.qt.core.QByteArray arg__1){
        return urlSchemeHandler_native_cref_QByteArray_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.webengine.core.QWebEngineUrlSchemeHandler urlSchemeHandler_native_cref_QByteArray_constfct(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#userScripts-prop">QQuickWebEngineProfile::userScripts()</a></p>
     */
    @io.qt.QtPropertyReader(name="userScripts")
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlListProperty<io.qt.webengine.QQuickWebEngineScript> userScripts(){
        return userScripts_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlListProperty<io.qt.webengine.QQuickWebEngineScript> userScripts_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebengineprofile.html#defaultProfile">QQuickWebEngineProfile::defaultProfile()</a></p>
     */
    public native static io.qt.webengine.QQuickWebEngineProfile defaultProfile();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuickWebEngineProfile(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQuickWebEngineProfile(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQuickWebEngineProfile instance, QDeclarativeConstructor constructor);
    
}
