package io.qt.webengine;


/**
 * <p>Enables the injection of scripts in the JavaScript engine</p>
 * <p>Java wrapper for Qt's class <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html">QQuickWebEngineScript</a></p>
 */
public class QQuickWebEngineScript extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuickWebEngineScript.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#InjectionPoint-enum">QQuickWebEngineScript::InjectionPoint</a></p>
     */
    public enum InjectionPoint implements io.qt.QtEnumerator {
        Deferred(0),
        DocumentReady(1),
        DocumentCreation(2);

        private InjectionPoint(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static InjectionPoint resolve(int value) {
            switch (value) {
            case 0: return Deferred;
            case 1: return DocumentReady;
            case 2: return DocumentCreation;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#ScriptWorldId-enum">QQuickWebEngineScript::ScriptWorldId</a></p>
     */
    public enum ScriptWorldId implements io.qt.QtEnumerator {
        MainWorld(0),
        ApplicationWorld(1),
        UserWorld(2);

        private ScriptWorldId(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ScriptWorldId resolve(int value) {
            switch (value) {
            case 0: return MainWorld;
            case 1: return ApplicationWorld;
            case 2: return UserWorld;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#injectionPoint-prop">QQuickWebEngineScript::injectionPointChanged(QQuickWebEngineScript::InjectionPoint)</a></p>
     */
    @io.qt.QtPropertyNotify(name="injectionPoint")
    public final Signal1<io.qt.webengine.QQuickWebEngineScript.InjectionPoint> injectionPointChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#name-prop">QQuickWebEngineScript::nameChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="name")
    public final Signal1<java.lang.String> nameChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#runOnSubframes-prop">QQuickWebEngineScript::runOnSubframesChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="runOnSubframes")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> runOnSubframesChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#sourceCode-prop">QQuickWebEngineScript::sourceCodeChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sourceCode")
    public final Signal1<java.lang.String> sourceCodeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#sourceUrl-prop">QQuickWebEngineScript::sourceUrlChanged(QUrl)</a></p>
     */
    @io.qt.QtPropertyNotify(name="sourceUrl")
    public final Signal1<io.qt.core.QUrl> sourceUrlChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#worldId-prop">QQuickWebEngineScript::worldIdChanged(QQuickWebEngineScript::ScriptWorldId)</a></p>
     */
    @io.qt.QtPropertyNotify(name="worldId")
    public final Signal1<io.qt.webengine.QQuickWebEngineScript.ScriptWorldId> worldIdChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QQuickWebEngineScript(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuickWebEngineScript() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#QQuickWebEngineScript">QQuickWebEngineScript::QQuickWebEngineScript(QObject*)</a></p>
     */
    public QQuickWebEngineScript(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQuickWebEngineScript instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#injectionPoint-prop">QQuickWebEngineScript::injectionPoint()const</a></p>
     */
    @io.qt.QtPropertyReader(name="injectionPoint")
    @io.qt.QtUninvokable
    public final io.qt.webengine.QQuickWebEngineScript.InjectionPoint injectionPoint(){
        return io.qt.webengine.QQuickWebEngineScript.InjectionPoint.resolve(injectionPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int injectionPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#name-prop">QQuickWebEngineScript::name()const</a></p>
     */
    @io.qt.QtPropertyReader(name="name")
    @io.qt.QtUninvokable
    public final java.lang.String name(){
        return name_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String name_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#runOnSubframes-prop">QQuickWebEngineScript::runOnSubframes()const</a></p>
     */
    @io.qt.QtPropertyReader(name="runOnSubframes")
    @io.qt.QtUninvokable
    public final boolean runOnSubframes(){
        return runOnSubframes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean runOnSubframes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#injectionPoint-prop">QQuickWebEngineScript::setInjectionPoint(QQuickWebEngineScript::InjectionPoint)</a></p>
     */
    @io.qt.QtPropertyWriter(name="injectionPoint")
    public final void setInjectionPoint(io.qt.webengine.QQuickWebEngineScript.InjectionPoint injectionPoint){
        setInjectionPoint_native_QQuickWebEngineScript_InjectionPoint(QtJambi_LibraryUtilities.internal.nativeId(this), injectionPoint.value());
    }
    
    private native void setInjectionPoint_native_QQuickWebEngineScript_InjectionPoint(long __this__nativeId, int injectionPoint);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#name-prop">QQuickWebEngineScript::setName(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="name")
    public final void setName(java.lang.String name){
        setName_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), name);
    }
    
    private native void setName_native_cref_QString(long __this__nativeId, java.lang.String name);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#runOnSubframes-prop">QQuickWebEngineScript::setRunOnSubframes(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="runOnSubframes")
    public final void setRunOnSubframes(boolean on){
        setRunOnSubframes_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), on);
    }
    
    private native void setRunOnSubframes_native_bool(long __this__nativeId, boolean on);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#sourceCode-prop">QQuickWebEngineScript::setSourceCode(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sourceCode")
    public final void setSourceCode(java.lang.String code){
        setSourceCode_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), code);
    }
    
    private native void setSourceCode_native_cref_QString(long __this__nativeId, java.lang.String code);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#sourceUrl-prop">QQuickWebEngineScript::setSourceUrl(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="sourceUrl")
    public final void setSourceUrl(io.qt.core.QUrl url){
        setSourceUrl_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url));
    }
    
    private native void setSourceUrl_native_cref_QUrl(long __this__nativeId, long url);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#worldId-prop">QQuickWebEngineScript::setWorldId(QQuickWebEngineScript::ScriptWorldId)</a></p>
     */
    @io.qt.QtPropertyWriter(name="worldId")
    public final void setWorldId(io.qt.webengine.QQuickWebEngineScript.ScriptWorldId scriptWorldId){
        setWorldId_native_QQuickWebEngineScript_ScriptWorldId(QtJambi_LibraryUtilities.internal.nativeId(this), scriptWorldId.value());
    }
    
    private native void setWorldId_native_QQuickWebEngineScript_ScriptWorldId(long __this__nativeId, int scriptWorldId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#sourceCode-prop">QQuickWebEngineScript::sourceCode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sourceCode")
    @io.qt.QtUninvokable
    public final java.lang.String sourceCode(){
        return sourceCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String sourceCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#sourceUrl-prop">QQuickWebEngineScript::sourceUrl()const</a></p>
     */
    @io.qt.QtPropertyReader(name="sourceUrl")
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl sourceUrl(){
        return sourceUrl_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl sourceUrl_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#toString">QQuickWebEngineScript::toString()const</a></p>
     */
    public final java.lang.String toString(){
        return toString_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native java.lang.String toString_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwebenginescript.html#worldId-prop">QQuickWebEngineScript::worldId()const</a></p>
     */
    @io.qt.QtPropertyReader(name="worldId")
    @io.qt.QtUninvokable
    public final io.qt.webengine.QQuickWebEngineScript.ScriptWorldId worldId(){
        return io.qt.webengine.QQuickWebEngineScript.ScriptWorldId.resolve(worldId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int worldId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qobject.html#timerEvent">QObject::timerEvent(QTimerEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void timerEvent(io.qt.core.QTimerEvent e){
        timerEvent_native_QTimerEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(e));
    }
    
    @io.qt.QtUninvokable
    private native void timerEvent_native_QTimerEvent_ptr(long __this__nativeId, long e);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuickWebEngineScript(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQuickWebEngineScript(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQuickWebEngineScript instance, QDeclarativeConstructor constructor);
    
}
