package io.qt.keyboard;


/**
 * <p>List model for selection lists</p>
 * <p>Java wrapper for Qt class <a href="https://doc.qt.io/qt/qvirtualkeyboardselectionlistmodel.html">QVirtualKeyboardSelectionListModel</a></p>
 */
public final class QVirtualKeyboardSelectionListModel extends io.qt.core.QAbstractListModel
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcDataSource = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QVirtualKeyboardSelectionListModel.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qvirtualkeyboardselectionlistmodel.html#DictionaryType-enum">QVirtualKeyboardSelectionListModel::DictionaryType</a></p>
     */
    public enum DictionaryType implements io.qt.QtEnumerator {
        Default(0),
        User(1);

        private DictionaryType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DictionaryType resolve(int value) {
            switch (value) {
            case 0: return Default;
            case 1: return User;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qvirtualkeyboardselectionlistmodel.html#Role-enum">QVirtualKeyboardSelectionListModel::Role</a></p>
     */
    @io.qt.QtRejectedEntries({"DisplayRole", "WordCompletionLengthRole"})
    public enum Role implements io.qt.QtEnumerator {
        Display(0),
        DisplayRole(0),
        WordCompletionLength(257),
        WordCompletionLengthRole(257),
        Dictionary(258),
        CanRemoveSuggestion(259);

        private Role(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Role resolve(int value) {
            switch (value) {
            case 0: return Display;
            case 257: return WordCompletionLength;
            case 258: return Dictionary;
            case 259: return CanRemoveSuggestion;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="https://doc.qt.io/qt/qvirtualkeyboardselectionlistmodel.html#Type-enum">QVirtualKeyboardSelectionListModel::Type</a></p>
     */
    public enum Type implements io.qt.QtEnumerator {
        WordCandidateList(0);

        private Type(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Type resolve(int value) {
            switch (value) {
            case 0: return WordCandidateList;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="https://doc.qt.io/qt/qvirtualkeyboardselectionlistmodel.html#activeItemChanged">QVirtualKeyboardSelectionListModel::activeItemChanged(int)</a></p>
     */
    public final Signal1<@io.qt.QtPrimitiveType Integer> activeItemChanged = new Signal1<>();

    @io.qt.QtPropertyNotify(name="count")
    public final Signal0 countChanged = new Signal0();

    /**
     * <p>See <a href="https://doc.qt.io/qt/qvirtualkeyboardselectionlistmodel.html#itemSelected">QVirtualKeyboardSelectionListModel::itemSelected(int)</a></p>
     */
    public final Signal1<@io.qt.QtPrimitiveType Integer> itemSelected = new Signal1<>();
    
    @io.qt.QtPropertyReader(name="count")
    @io.qt.QtUninvokable
    public final int count(){
        return count_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int count_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #dataAt(int, io.qt.keyboard.QVirtualKeyboardSelectionListModel.Role)}
     *  with <code>role = io.qt.keyboard.QVirtualKeyboardSelectionListModel.Role.Display</code>.</p>
     */
    public final java.lang.Object dataAt(int index) {
        return dataAt(index, io.qt.keyboard.QVirtualKeyboardSelectionListModel.Role.Display);
    }
    
    public final java.lang.Object dataAt(int index, io.qt.keyboard.QVirtualKeyboardSelectionListModel.Role role){
        return dataAt_native_int_QVirtualKeyboardSelectionListModel_Role_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index, role.value());
    }
    
    private native java.lang.Object dataAt_native_int_QVirtualKeyboardSelectionListModel_Role_constfct(long __this__nativeId, int index, int role);
    
    @io.qt.QtUninvokable
    public final io.qt.keyboard.QVirtualKeyboardAbstractInputMethod dataSource(){
        return dataSource_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.keyboard.QVirtualKeyboardAbstractInputMethod dataSource_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvirtualkeyboardselectionlistmodel.html#removeItem">QVirtualKeyboardSelectionListModel::removeItem(int)</a></p>
     */
    public final void removeItem(int index){
        removeItem_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    private native void removeItem_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qvirtualkeyboardselectionlistmodel.html#selectItem">QVirtualKeyboardSelectionListModel::selectItem(int)</a></p>
     */
    public final void selectItem(int index){
        selectItem_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    private native void selectItem_native_int(long __this__nativeId, int index);
    
    @io.qt.QtUninvokable
    public final void setDataSource(io.qt.keyboard.QVirtualKeyboardAbstractInputMethod dataSource, io.qt.keyboard.QVirtualKeyboardSelectionListModel.Type type){
        setDataSource_native_QVirtualKeyboardAbstractInputMethod_ptr_QVirtualKeyboardSelectionListModel_Type(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(dataSource), type.value());
        __rcDataSource = dataSource;
    }
    
    @io.qt.QtUninvokable
    private native void setDataSource_native_QVirtualKeyboardAbstractInputMethod_ptr_QVirtualKeyboardSelectionListModel_Type(long __this__nativeId, long dataSource, int type);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#data">QAbstractItemModel::data(QModelIndex,int)const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.Object data(io.qt.core.QModelIndex index, int role){
        return data_native_cref_QModelIndex_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), index, role);
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object data_native_cref_QModelIndex_int_constfct(long __this__nativeId, io.qt.core.QModelIndex index, int role);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#roleNames">QAbstractItemModel::roleNames()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.util.Map<java.lang.Integer, io.qt.core.QByteArray> roleNames(){
        return roleNames_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.util.Map<java.lang.Integer, io.qt.core.QByteArray> roleNames_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="https://doc.qt.io/qt/qabstractitemmodel.html#rowCount">QAbstractItemModel::rowCount(QModelIndex)const</a></p>
     */
    @io.qt.QtUninvokable
    public int rowCount(io.qt.core.QModelIndex parent){
        return rowCount_native_cref_QModelIndex_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), parent);
    }
    
    @io.qt.QtUninvokable
    private native int rowCount_native_cref_QModelIndex_constfct(long __this__nativeId, io.qt.core.QModelIndex parent);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QVirtualKeyboardSelectionListModel(QPrivateConstructor p) { super(p); } 
    
}
