package io.qt.keyboard;


/**
 * <p>Trace is a data model for touch input data</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html">QVirtualKeyboardTrace</a></p>
 */
public class QVirtualKeyboardTrace extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QVirtualKeyboardTrace.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#canceled-prop">QVirtualKeyboardTrace::canceledChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="canceled")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> canceledChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#channels-prop">QVirtualKeyboardTrace::channelsChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="channels")
    public final Signal0 channelsChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#final-prop">QVirtualKeyboardTrace::finalChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="final")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> finalChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#length-prop">QVirtualKeyboardTrace::lengthChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="length")
    public final Signal1<@io.qt.QtPrimitiveType Integer> lengthChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#opacity-prop">QVirtualKeyboardTrace::opacityChanged(qreal)</a></p>
     */
    @io.qt.QtPropertyNotify(name="opacity")
    public final Signal1<@io.qt.QtPrimitiveType Double> opacityChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#traceId-prop">QVirtualKeyboardTrace::traceIdChanged(int)</a></p>
     */
    @io.qt.QtPropertyNotify(name="traceId")
    public final Signal1<@io.qt.QtPrimitiveType Integer> traceIdChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QVirtualKeyboardTrace(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QVirtualKeyboardTrace() {
        this((io.qt.core.QObject)null);
    }
    
    public QVirtualKeyboardTrace(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QVirtualKeyboardTrace instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#addPoint">QVirtualKeyboardTrace::addPoint(QPointF)</a></p>
     */
    public final int addPoint(io.qt.core.QPointF point){
        return addPoint_native_cref_QPointF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    private native int addPoint_native_cref_QPointF(long __this__nativeId, long point);
    
    /**
     * <p>Overloaded function for {@link #channelData(java.lang.String, int, int)}
     *  with <code>count = -1</code>.</p>
     */
    public final io.qt.core.QList<java.lang.Object> channelData(java.lang.String channel, int pos) {
        return channelData(channel, pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #channelData(java.lang.String, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = 0</code></li>
     * <li><code>count = -1</code></li>
     * </ul>
     */
    public final io.qt.core.QList<java.lang.Object> channelData(java.lang.String channel) {
        return channelData(channel, (int)0, (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#channelData">QVirtualKeyboardTrace::channelData(QString,int,int)const</a></p>
     */
    public final io.qt.core.QList<java.lang.Object> channelData(java.lang.String channel, int pos, int count){
        return channelData_native_cref_QString_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), channel, pos, count);
    }
    
    private native io.qt.core.QList<java.lang.Object> channelData_native_cref_QString_int_int_constfct(long __this__nativeId, java.lang.String channel, int pos, int count);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#channels-prop">QVirtualKeyboardTrace::channels()const</a></p>
     */
    @io.qt.QtPropertyReader(name="channels")
    @io.qt.QtUninvokable
    public final io.qt.core.QStringList channels(){
        return channels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QStringList channels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#canceled-prop">QVirtualKeyboardTrace::isCanceled()const</a></p>
     */
    @io.qt.QtPropertyReader(name="canceled")
    @io.qt.QtUninvokable
    public final boolean isCanceled(){
        return isCanceled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isCanceled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#final-prop">QVirtualKeyboardTrace::isFinal()const</a></p>
     */
    @io.qt.QtPropertyReader(name="final")
    @io.qt.QtUninvokable
    public final boolean isFinal(){
        return isFinal_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isFinal_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#length-prop">QVirtualKeyboardTrace::length()const</a></p>
     */
    @io.qt.QtPropertyReader(name="length")
    @io.qt.QtUninvokable
    public final int length(){
        return length_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int length_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#opacity-prop">QVirtualKeyboardTrace::opacity()const</a></p>
     */
    @io.qt.QtPropertyReader(name="opacity")
    @io.qt.QtUninvokable
    public final double opacity(){
        return opacity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double opacity_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #points(int, int)}
     *  with <code>count = -1</code>.</p>
     */
    public final io.qt.core.QList<java.lang.Object> points(int pos) {
        return points(pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #points(int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = 0</code></li>
     * <li><code>count = -1</code></li>
     * </ul>
     */
    public final io.qt.core.QList<java.lang.Object> points() {
        return points((int)0, (int)-1);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#points">QVirtualKeyboardTrace::points(int,int)const</a></p>
     */
    public final io.qt.core.QList<java.lang.Object> points(int pos, int count){
        return points_native_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), pos, count);
    }
    
    private native io.qt.core.QList<java.lang.Object> points_native_int_int_constfct(long __this__nativeId, int pos, int count);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#canceled-prop">QVirtualKeyboardTrace::setCanceled(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="canceled")
    @io.qt.QtUninvokable
    public final void setCanceled(boolean canceled){
        setCanceled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), canceled);
    }
    
    @io.qt.QtUninvokable
    private native void setCanceled_native_bool(long __this__nativeId, boolean canceled);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#setChannelData">QVirtualKeyboardTrace::setChannelData(QString,int,QVariant)</a></p>
     */
    public final void setChannelData(java.lang.String channel, int index, java.lang.Object data){
        setChannelData_native_cref_QString_int_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), channel, index, data);
    }
    
    private native void setChannelData_native_cref_QString_int_cref_QVariant(long __this__nativeId, java.lang.String channel, int index, java.lang.Object data);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#channels-prop">QVirtualKeyboardTrace::setChannels(QStringList)</a></p>
     */
    @io.qt.QtPropertyWriter(name="channels")
    @io.qt.QtUninvokable
    public final void setChannels(java.util.Collection<java.lang.String> channels){
        setChannels_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), channels);
    }
    
    @io.qt.QtUninvokable
    private native void setChannels_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> channels);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#final-prop">QVirtualKeyboardTrace::setFinal(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="final")
    @io.qt.QtUninvokable
    public final void setFinal(boolean arg__final){
        setFinal_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__final);
    }
    
    @io.qt.QtUninvokable
    private native void setFinal_native_bool(long __this__nativeId, boolean arg__final);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#opacity-prop">QVirtualKeyboardTrace::setOpacity(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="opacity")
    @io.qt.QtUninvokable
    public final void setOpacity(double opacity){
        setOpacity_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), opacity);
    }
    
    @io.qt.QtUninvokable
    private native void setOpacity_native_qtjambireal(long __this__nativeId, double opacity);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#traceId-prop">QVirtualKeyboardTrace::setTraceId(int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="traceId")
    @io.qt.QtUninvokable
    public final void setTraceId(int id){
        setTraceId_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), id);
    }
    
    @io.qt.QtUninvokable
    private native void setTraceId_native_int(long __this__nativeId, int id);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardtrace.html#traceId-prop">QVirtualKeyboardTrace::traceId()const</a></p>
     */
    @io.qt.QtPropertyReader(name="traceId")
    @io.qt.QtUninvokable
    public final int traceId(){
        return traceId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int traceId_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QVirtualKeyboardTrace(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QVirtualKeyboardTrace(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QVirtualKeyboardTrace instance, QDeclarativeConstructor constructor);
    
}
