package io.qt.keyboard;


/**
 * <p>InputEngine class provides an input engine that supports C++ and QML integration</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html">QVirtualKeyboardInputEngine</a></p>
 */
public final class QVirtualKeyboardInputEngine extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcInputMethod = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QVirtualKeyboardInputEngine.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#InputMode-enum">QVirtualKeyboardInputEngine::InputMode</a></p>
     */
    public enum InputMode implements io.qt.QtEnumerator {
        Latin(0),
        Numeric(1),
        Dialable(2),
        Pinyin(3),
        Cangjie(4),
        Zhuyin(5),
        Hangul(6),
        Hiragana(7),
        Katakana(8),
        FullwidthLatin(9),
        Greek(10),
        Cyrillic(11),
        Arabic(12),
        Hebrew(13),
        ChineseHandwriting(14),
        JapaneseHandwriting(15),
        KoreanHandwriting(16),
        Thai(17);

        private InputMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static InputMode resolve(int value) {
            switch (value) {
            case 0: return Latin;
            case 1: return Numeric;
            case 2: return Dialable;
            case 3: return Pinyin;
            case 4: return Cangjie;
            case 5: return Zhuyin;
            case 6: return Hangul;
            case 7: return Hiragana;
            case 8: return Katakana;
            case 9: return FullwidthLatin;
            case 10: return Greek;
            case 11: return Cyrillic;
            case 12: return Arabic;
            case 13: return Hebrew;
            case 14: return ChineseHandwriting;
            case 15: return JapaneseHandwriting;
            case 16: return KoreanHandwriting;
            case 17: return Thai;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#PatternRecognitionMode-enum">QVirtualKeyboardInputEngine::PatternRecognitionMode</a></p>
     */
    @io.qt.QtRejectedEntries({"PatternRecognitionDisabled", "HandwritingRecoginition"})
    public enum PatternRecognitionMode implements io.qt.QtEnumerator {
        None(0),
        PatternRecognitionDisabled(0),
        Handwriting(1),
        HandwritingRecoginition(1);

        private PatternRecognitionMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static PatternRecognitionMode resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return Handwriting;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#ReselectFlag-enum">QVirtualKeyboardInputEngine::ReselectFlag</a></p>
     * 
     * @see ReselectFlags
     */
    public enum ReselectFlag implements io.qt.QtFlagEnumerator {
        WordBeforeCursor(1),
        WordAfterCursor(2),
        WordAtCursor(3);

        private ReselectFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public ReselectFlags asFlags() {
            return new ReselectFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public ReselectFlags combined(ReselectFlag e) {
            return new ReselectFlags(this, e);
        }

        /**
         * Creates a new {@link ReselectFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static ReselectFlags flags(ReselectFlag ... values) {
            return new ReselectFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ReselectFlag resolve(int value) {
            switch (value) {
            case 1: return WordBeforeCursor;
            case 2: return WordAfterCursor;
            case 3: return WordAtCursor;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link ReselectFlag}
     */
    public static final class ReselectFlags extends io.qt.QFlags<ReselectFlag> implements Comparable<ReselectFlags> {
        private static final long serialVersionUID = 0x23c29d375f26d8ebL;

        /**
         * Creates a new ReselectFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ReselectFlags(ReselectFlag ... args){
            super(args);
        }

        /**
         * Creates a new ReselectFlags with given <code>value</code>.
         * @param value
         */
        public ReselectFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ReselectFlags
         */
        @Override
        public final ReselectFlags combined(ReselectFlag e){
            return new ReselectFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final ReselectFlags setFlag(ReselectFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final ReselectFlags setFlag(ReselectFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ReselectFlags.
         * @return array of enum entries
         */
        @Override
        public final ReselectFlag[] flags(){
            return super.flags(ReselectFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final ReselectFlags clone(){
            return new ReselectFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(ReselectFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#TextCase-enum">QVirtualKeyboardInputEngine::TextCase</a></p>
     */
    public enum TextCase implements io.qt.QtEnumerator {
        Lower(0),
        Upper(1);

        private TextCase(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static TextCase resolve(int value) {
            switch (value) {
            case 0: return Lower;
            case 1: return Upper;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#activeKeyChanged">QVirtualKeyboardInputEngine::activeKeyChanged(Qt::Key)</a></p>
     */
    @io.qt.QtPropertyNotify(name="activeKey")
    public final Signal1<io.qt.core.Qt.Key> activeKeyChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#inputMethodChanged">QVirtualKeyboardInputEngine::inputMethodChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="inputMethod")
    public final Signal0 inputMethodChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#inputMethodReset">QVirtualKeyboardInputEngine::inputMethodReset()</a></p>
     */
    public final Signal0 inputMethodReset = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#inputMethodUpdate">QVirtualKeyboardInputEngine::inputMethodUpdate()</a></p>
     */
    public final Signal0 inputMethodUpdate = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#inputModeChanged">QVirtualKeyboardInputEngine::inputModeChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="inputMode")
    public final Signal0 inputModeChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#inputModesChanged">QVirtualKeyboardInputEngine::inputModesChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="inputModes")
    public final Signal0 inputModesChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#patternRecognitionModesChanged">QVirtualKeyboardInputEngine::patternRecognitionModesChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="patternRecognitionModes")
    public final Signal0 patternRecognitionModesChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#previousKeyChanged">QVirtualKeyboardInputEngine::previousKeyChanged(Qt::Key)</a></p>
     */
    @io.qt.QtPropertyNotify(name="previousKey")
    public final Signal1<io.qt.core.Qt.Key> previousKeyChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#virtualKeyClicked">QVirtualKeyboardInputEngine::virtualKeyClicked(Qt::Key,QString,Qt::KeyboardModifiers,bool)</a></p>
     */
    public final Signal4<io.qt.core.Qt.Key, java.lang.String, io.qt.core.Qt.KeyboardModifiers, @io.qt.QtPrimitiveType Boolean> virtualKeyClicked = new Signal4<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#wordCandidateListModel-prop">QVirtualKeyboardInputEngine::wordCandidateListModelChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="wordCandidateListModel")
    public final Signal0 wordCandidateListModelChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#wordCandidateListVisibleHint-prop">QVirtualKeyboardInputEngine::wordCandidateListVisibleHintChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="wordCandidateListVisibleHint")
    public final Signal0 wordCandidateListVisibleHintChanged = new Signal0();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#activeKey">QVirtualKeyboardInputEngine::activeKey()const</a></p>
     */
    @io.qt.QtPropertyReader(name="activeKey")
    @io.qt.QtUninvokable
    public final io.qt.core.Qt.Key activeKey(){
        return io.qt.core.Qt.Key.resolve(activeKey_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int activeKey_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final boolean clickPreeditText(int cursorPosition){
        return clickPreeditText_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), cursorPosition);
    }
    
    @io.qt.QtUninvokable
    private native boolean clickPreeditText_native_int(long __this__nativeId, int cursorPosition);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#inputContext">QVirtualKeyboardInputEngine::inputContext()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.keyboard.QVirtualKeyboardInputContext inputContext(){
        return inputContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.keyboard.QVirtualKeyboardInputContext inputContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#inputMethod">QVirtualKeyboardInputEngine::inputMethod()const</a></p>
     */
    @io.qt.QtPropertyReader(name="inputMethod")
    @io.qt.QtUninvokable
    public final io.qt.keyboard.QVirtualKeyboardAbstractInputMethod inputMethod(){
        return inputMethod_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.keyboard.QVirtualKeyboardAbstractInputMethod inputMethod_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#inputMode-prop">QVirtualKeyboardInputEngine::inputMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="inputMode")
    @io.qt.QtUninvokable
    public final io.qt.keyboard.QVirtualKeyboardInputEngine.InputMode inputMode(){
        return io.qt.keyboard.QVirtualKeyboardInputEngine.InputMode.resolve(inputMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int inputMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#inputModes">QVirtualKeyboardInputEngine::inputModes()const</a></p>
     */
    @io.qt.QtPropertyReader(name="inputModes")
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.lang.Integer> inputModes(){
        return inputModes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Integer> inputModes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#patternRecognitionModes">QVirtualKeyboardInputEngine::patternRecognitionModes()const</a></p>
     */
    @io.qt.QtPropertyReader(name="patternRecognitionModes")
    @io.qt.QtUninvokable
    public final io.qt.core.QList<java.lang.Integer> patternRecognitionModes(){
        return patternRecognitionModes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.lang.Integer> patternRecognitionModes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#previousKey">QVirtualKeyboardInputEngine::previousKey()const</a></p>
     */
    @io.qt.QtPropertyReader(name="previousKey")
    @io.qt.QtUninvokable
    public final io.qt.core.Qt.Key previousKey(){
        return io.qt.core.Qt.Key.resolve(previousKey_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int previousKey_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #reselect(int, io.qt.keyboard.QVirtualKeyboardInputEngine.ReselectFlags)}.</p>
     */
    public final boolean reselect(int cursorPosition, io.qt.keyboard.QVirtualKeyboardInputEngine.ReselectFlag ... reselectFlags){
        return reselect(cursorPosition, new io.qt.keyboard.QVirtualKeyboardInputEngine.ReselectFlags(reselectFlags));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#reselect">QVirtualKeyboardInputEngine::reselect(int,ReselectFlags)</a></p>
     */
    public final boolean reselect(int cursorPosition, io.qt.keyboard.QVirtualKeyboardInputEngine.ReselectFlags reselectFlags){
        return reselect_native_int_cref_QFlags_QVirtualKeyboardInputEngine_ReselectFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), cursorPosition, reselectFlags.value());
    }
    
    private native boolean reselect_native_int_cref_QFlags_QVirtualKeyboardInputEngine_ReselectFlag_(long __this__nativeId, int cursorPosition, int reselectFlags);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#setInputMethod">QVirtualKeyboardInputEngine::setInputMethod(QVirtualKeyboardAbstractInputMethod*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="inputMethod")
    @io.qt.QtUninvokable
    public final void setInputMethod(io.qt.keyboard.QVirtualKeyboardAbstractInputMethod inputMethod){
        setInputMethod_native_QVirtualKeyboardAbstractInputMethod_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(inputMethod));
        __rcInputMethod = inputMethod;
    }
    
    @io.qt.QtUninvokable
    private native void setInputMethod_native_QVirtualKeyboardAbstractInputMethod_ptr(long __this__nativeId, long inputMethod);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#inputMode-prop">QVirtualKeyboardInputEngine::setInputMode(QVirtualKeyboardInputEngine::InputMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="inputMode")
    @io.qt.QtUninvokable
    public final void setInputMode(io.qt.keyboard.QVirtualKeyboardInputEngine.InputMode inputMode){
        setInputMode_native_QVirtualKeyboardInputEngine_InputMode(QtJambi_LibraryUtilities.internal.nativeId(this), inputMode.value());
    }
    
    @io.qt.QtUninvokable
    private native void setInputMode_native_QVirtualKeyboardInputEngine_InputMode(long __this__nativeId, int inputMode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#traceBegin">QVirtualKeyboardInputEngine::traceBegin(int,QVirtualKeyboardInputEngine::PatternRecognitionMode,QVariantMap,QVariantMap)</a></p>
     */
    public final io.qt.keyboard.QVirtualKeyboardTrace traceBegin(int traceId, io.qt.keyboard.QVirtualKeyboardInputEngine.PatternRecognitionMode patternRecognitionMode, java.util.Map<java.lang.String, java.lang.Object> traceCaptureDeviceInfo, java.util.Map<java.lang.String, java.lang.Object> traceScreenInfo){
        return traceBegin_native_int_QVirtualKeyboardInputEngine_PatternRecognitionMode_cref_QMap_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), traceId, patternRecognitionMode.value(), traceCaptureDeviceInfo, traceScreenInfo);
    }
    
    private native io.qt.keyboard.QVirtualKeyboardTrace traceBegin_native_int_QVirtualKeyboardInputEngine_PatternRecognitionMode_cref_QMap_cref_QMap(long __this__nativeId, int traceId, int patternRecognitionMode, java.util.Map<java.lang.String, java.lang.Object> traceCaptureDeviceInfo, java.util.Map<java.lang.String, java.lang.Object> traceScreenInfo);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#traceEnd">QVirtualKeyboardInputEngine::traceEnd(QVirtualKeyboardTrace*)</a></p>
     */
    public final boolean traceEnd(io.qt.keyboard.QVirtualKeyboardTrace trace){
        return traceEnd_native_QVirtualKeyboardTrace_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(trace));
    }
    
    private native boolean traceEnd_native_QVirtualKeyboardTrace_ptr(long __this__nativeId, long trace);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#virtualKeyCancel">QVirtualKeyboardInputEngine::virtualKeyCancel()</a></p>
     */
    public final void virtualKeyCancel(){
        virtualKeyCancel_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void virtualKeyCancel_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #virtualKeyClick(io.qt.core.Qt.Key, java.lang.String, io.qt.core.Qt.KeyboardModifiers)}.</p>
     */
    public final boolean virtualKeyClick(io.qt.core.Qt.Key key, java.lang.String text, io.qt.core.Qt.KeyboardModifier ... modifiers){
        return virtualKeyClick(key, text, new io.qt.core.Qt.KeyboardModifiers(modifiers));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#virtualKeyClick">QVirtualKeyboardInputEngine::virtualKeyClick(Qt::Key,QString,Qt::KeyboardModifiers)</a></p>
     */
    public final boolean virtualKeyClick(io.qt.core.Qt.Key key, java.lang.String text, io.qt.core.Qt.KeyboardModifiers modifiers){
        return virtualKeyClick_native_Qt_Key_cref_QString_QFlags_Qt_KeyboardModifier_(QtJambi_LibraryUtilities.internal.nativeId(this), key.value(), text, modifiers.value());
    }
    
    private native boolean virtualKeyClick_native_Qt_Key_cref_QString_QFlags_Qt_KeyboardModifier_(long __this__nativeId, int key, java.lang.String text, int modifiers);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#virtualKeyPress">QVirtualKeyboardInputEngine::virtualKeyPress(Qt::Key,QString,Qt::KeyboardModifiers,bool)</a></p>
     */
    public final boolean virtualKeyPress(io.qt.core.Qt.Key key, java.lang.String text, io.qt.core.Qt.KeyboardModifiers modifiers, boolean repeat){
        return virtualKeyPress_native_Qt_Key_cref_QString_QFlags_Qt_KeyboardModifier__bool(QtJambi_LibraryUtilities.internal.nativeId(this), key.value(), text, modifiers.value(), repeat);
    }
    
    private native boolean virtualKeyPress_native_Qt_Key_cref_QString_QFlags_Qt_KeyboardModifier__bool(long __this__nativeId, int key, java.lang.String text, int modifiers, boolean repeat);
    
    /**
     * <p>Overloaded function for {@link #virtualKeyRelease(io.qt.core.Qt.Key, java.lang.String, io.qt.core.Qt.KeyboardModifiers)}.</p>
     */
    public final boolean virtualKeyRelease(io.qt.core.Qt.Key key, java.lang.String text, io.qt.core.Qt.KeyboardModifier ... modifiers){
        return virtualKeyRelease(key, text, new io.qt.core.Qt.KeyboardModifiers(modifiers));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#virtualKeyRelease">QVirtualKeyboardInputEngine::virtualKeyRelease(Qt::Key,QString,Qt::KeyboardModifiers)</a></p>
     */
    public final boolean virtualKeyRelease(io.qt.core.Qt.Key key, java.lang.String text, io.qt.core.Qt.KeyboardModifiers modifiers){
        return virtualKeyRelease_native_Qt_Key_cref_QString_QFlags_Qt_KeyboardModifier_(QtJambi_LibraryUtilities.internal.nativeId(this), key.value(), text, modifiers.value());
    }
    
    private native boolean virtualKeyRelease_native_Qt_Key_cref_QString_QFlags_Qt_KeyboardModifier_(long __this__nativeId, int key, java.lang.String text, int modifiers);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#wordCandidateListModel-prop">QVirtualKeyboardInputEngine::wordCandidateListModel()const</a></p>
     */
    @io.qt.QtPropertyReader(name="wordCandidateListModel")
    @io.qt.QtUninvokable
    public final io.qt.keyboard.QVirtualKeyboardSelectionListModel wordCandidateListModel(){
        return wordCandidateListModel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.keyboard.QVirtualKeyboardSelectionListModel wordCandidateListModel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputengine.html#wordCandidateListVisibleHint-prop">QVirtualKeyboardInputEngine::wordCandidateListVisibleHint()const</a></p>
     */
    @io.qt.QtPropertyReader(name="wordCandidateListVisibleHint")
    @io.qt.QtUninvokable
    public final boolean wordCandidateListVisibleHint(){
        return wordCandidateListVisibleHint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean wordCandidateListVisibleHint_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QVirtualKeyboardInputEngine(QPrivateConstructor p) { super(p); } 
    
}
