package io.qt.keyboard;


/**
 * <p>Provides access to an input context</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html">QVirtualKeyboardInputContext</a></p>
 */
public class QVirtualKeyboardInputContext extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QVirtualKeyboardInputContext.class);
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#anchorPosition-prop">QVirtualKeyboardInputContext::anchorPositionChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="anchorPosition")
    public final Signal0 anchorPositionChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#anchorRectIntersectsClipRect-prop">QVirtualKeyboardInputContext::anchorRectIntersectsClipRectChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="anchorRectIntersectsClipRect")
    public final Signal0 anchorRectIntersectsClipRectChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#anchorRectangle-prop">QVirtualKeyboardInputContext::anchorRectangleChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="anchorRectangle")
    public final Signal0 anchorRectangleChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#animating-prop">QVirtualKeyboardInputContext::animatingChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="animating")
    public final Signal0 animatingChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#capsLockActiveChanged">QVirtualKeyboardInputContext::capsLockActiveChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="capsLock")
    public final Signal0 capsLockActiveChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#cursorPosition-prop">QVirtualKeyboardInputContext::cursorPositionChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="cursorPosition")
    public final Signal0 cursorPositionChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#cursorRectIntersectsClipRect-prop">QVirtualKeyboardInputContext::cursorRectIntersectsClipRectChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="cursorRectIntersectsClipRect")
    public final Signal0 cursorRectIntersectsClipRectChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#cursorRectangle-prop">QVirtualKeyboardInputContext::cursorRectangleChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="cursorRectangle")
    public final Signal0 cursorRectangleChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext-obsolete.html#inputItem-prop">QVirtualKeyboardInputContext::inputItemChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="inputItem")
    public final Signal0 inputItemChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#inputMethodHints-prop">QVirtualKeyboardInputContext::inputMethodHintsChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="inputMethodHints")
    public final Signal0 inputMethodHintsChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#locale-prop">QVirtualKeyboardInputContext::localeChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="locale")
    public final Signal0 localeChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#preeditText-prop">QVirtualKeyboardInputContext::preeditTextChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="preeditText")
    public final Signal0 preeditTextChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#selectedText-prop">QVirtualKeyboardInputContext::selectedTextChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="selectedText")
    public final Signal0 selectedTextChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#selectionControlVisible-prop">QVirtualKeyboardInputContext::selectionControlVisibleChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="selectionControlVisible")
    public final Signal0 selectionControlVisibleChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#shiftActiveChanged">QVirtualKeyboardInputContext::shiftActiveChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="shift")
    public final Signal0 shiftActiveChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#surroundingText-prop">QVirtualKeyboardInputContext::surroundingTextChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="surroundingText")
    public final Signal0 surroundingTextChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#uppercase-prop">QVirtualKeyboardInputContext::uppercaseChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="uppercase")
    public final Signal0 uppercaseChanged = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QVirtualKeyboardInputContext(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QVirtualKeyboardInputContext() {
        this((io.qt.core.QObject)null);
    }
    
    public QVirtualKeyboardInputContext(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QVirtualKeyboardInputContext instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#anchorPosition-prop">QVirtualKeyboardInputContext::anchorPosition()const</a></p>
     */
    @io.qt.QtPropertyReader(name="anchorPosition")
    @io.qt.QtUninvokable
    public final int anchorPosition(){
        return anchorPosition_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int anchorPosition_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#anchorRectIntersectsClipRect-prop">QVirtualKeyboardInputContext::anchorRectIntersectsClipRect()const</a></p>
     */
    @io.qt.QtPropertyReader(name="anchorRectIntersectsClipRect")
    @io.qt.QtUninvokable
    public final boolean anchorRectIntersectsClipRect(){
        return anchorRectIntersectsClipRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean anchorRectIntersectsClipRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#anchorRectangle-prop">QVirtualKeyboardInputContext::anchorRectangle()const</a></p>
     */
    @io.qt.QtPropertyReader(name="anchorRectangle")
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF anchorRectangle(){
        return anchorRectangle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF anchorRectangle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#clear">QVirtualKeyboardInputContext::clear()</a></p>
     */
    public final void clear(){
        clear_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void clear_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#commit">QVirtualKeyboardInputContext::commit()</a></p>
     */
    public final void commit(){
        commit_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void commit_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #commit(java.lang.String, int, int)}
     *  with <code>replaceLength = 0</code>.</p>
     */
    public final void commit(java.lang.String text, int replaceFrom) {
        commit(text, replaceFrom, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #commit(java.lang.String, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>replaceFrom = 0</code></li>
     * <li><code>replaceLength = 0</code></li>
     * </ul>
     */
    public final void commit(java.lang.String text) {
        commit(text, (int)0, (int)0);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#commit-1">QVirtualKeyboardInputContext::commit(QString,int,int)</a></p>
     */
    public final void commit(java.lang.String text, int replaceFrom, int replaceLength){
        commit_native_cref_QString_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), text, replaceFrom, replaceLength);
    }
    
    private native void commit_native_cref_QString_int_int(long __this__nativeId, java.lang.String text, int replaceFrom, int replaceLength);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#cursorPosition-prop">QVirtualKeyboardInputContext::cursorPosition()const</a></p>
     */
    @io.qt.QtPropertyReader(name="cursorPosition")
    @io.qt.QtUninvokable
    public final int cursorPosition(){
        return cursorPosition_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int cursorPosition_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#cursorRectIntersectsClipRect-prop">QVirtualKeyboardInputContext::cursorRectIntersectsClipRect()const</a></p>
     */
    @io.qt.QtPropertyReader(name="cursorRectIntersectsClipRect")
    @io.qt.QtUninvokable
    public final boolean cursorRectIntersectsClipRect(){
        return cursorRectIntersectsClipRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean cursorRectIntersectsClipRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#cursorRectangle-prop">QVirtualKeyboardInputContext::cursorRectangle()const</a></p>
     */
    @io.qt.QtPropertyReader(name="cursorRectangle")
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF cursorRectangle(){
        return cursorRectangle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF cursorRectangle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#inputEngine-prop">QVirtualKeyboardInputContext::inputEngine()const</a></p>
     */
    @io.qt.QtPropertyReader(name="inputEngine")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.keyboard.QVirtualKeyboardInputEngine inputEngine(){
        return inputEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.keyboard.QVirtualKeyboardInputEngine inputEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext-obsolete.html#inputItem-prop">QVirtualKeyboardInputContext::inputItem()const</a></p>
     */
    @io.qt.QtPropertyReader(name="inputItem")
    @io.qt.QtUninvokable
    public final io.qt.core.QObject inputItem(){
        return inputItem_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject inputItem_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#inputMethodHints-prop">QVirtualKeyboardInputContext::inputMethodHints()const</a></p>
     */
    @io.qt.QtPropertyReader(name="inputMethodHints")
    @io.qt.QtUninvokable
    public final io.qt.core.Qt.InputMethodHints inputMethodHints(){
        return new io.qt.core.Qt.InputMethodHints(inputMethodHints_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int inputMethodHints_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#animating-prop">QVirtualKeyboardInputContext::isAnimating()const</a></p>
     */
    @io.qt.QtPropertyReader(name="animating")
    @io.qt.QtUninvokable
    public final boolean isAnimating(){
        return isAnimating_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAnimating_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#isCapsLockActive">QVirtualKeyboardInputContext::isCapsLockActive()const</a></p>
     */
    @io.qt.QtPropertyReader(name="capsLock")
    @io.qt.QtUninvokable
    public final boolean isCapsLockActive(){
        return isCapsLockActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isCapsLockActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#selectionControlVisible-prop">QVirtualKeyboardInputContext::isSelectionControlVisible()const</a></p>
     */
    @io.qt.QtPropertyReader(name="selectionControlVisible")
    @io.qt.QtUninvokable
    public final boolean isSelectionControlVisible(){
        return isSelectionControlVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSelectionControlVisible_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#isShiftActive">QVirtualKeyboardInputContext::isShiftActive()const</a></p>
     */
    @io.qt.QtPropertyReader(name="shift")
    @io.qt.QtUninvokable
    public final boolean isShiftActive(){
        return isShiftActive_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isShiftActive_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#uppercase-prop">QVirtualKeyboardInputContext::isUppercase()const</a></p>
     */
    @io.qt.QtPropertyReader(name="uppercase")
    @io.qt.QtUninvokable
    public final boolean isUppercase(){
        return isUppercase_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isUppercase_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#locale-prop">QVirtualKeyboardInputContext::locale()const</a></p>
     */
    @io.qt.QtPropertyReader(name="locale")
    @io.qt.QtUninvokable
    public final java.lang.String locale(){
        return locale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String locale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#preeditText-prop">QVirtualKeyboardInputContext::preeditText()const</a></p>
     */
    @io.qt.QtPropertyReader(name="preeditText")
    @io.qt.QtUninvokable
    public final java.lang.String preeditText(){
        return preeditText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String preeditText_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.gui.QInputMethodEvent.Attribute> preeditTextAttributes(){
        return preeditTextAttributes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.gui.QInputMethodEvent.Attribute> preeditTextAttributes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#selectedText-prop">QVirtualKeyboardInputContext::selectedText()const</a></p>
     */
    @io.qt.QtPropertyReader(name="selectedText")
    @io.qt.QtUninvokable
    public final java.lang.String selectedText(){
        return selectedText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String selectedText_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #sendKeyClick(int, java.lang.String, int)}
     *  with <code>modifiers = 0</code>.</p>
     */
    public final void sendKeyClick(int key, java.lang.String text) {
        sendKeyClick(key, text, (int)0);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#sendKeyClick">QVirtualKeyboardInputContext::sendKeyClick(int,QString,int)</a></p>
     */
    public final void sendKeyClick(int key, java.lang.String text, int modifiers){
        sendKeyClick_native_int_cref_QString_int(QtJambi_LibraryUtilities.internal.nativeId(this), key, text, modifiers);
    }
    
    private native void sendKeyClick_native_int_cref_QString_int(long __this__nativeId, int key, java.lang.String text, int modifiers);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#animating-prop">QVirtualKeyboardInputContext::setAnimating(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="animating")
    @io.qt.QtUninvokable
    public final void setAnimating(boolean isAnimating){
        setAnimating_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isAnimating);
    }
    
    @io.qt.QtUninvokable
    private native void setAnimating_native_bool(long __this__nativeId, boolean isAnimating);
    
    /**
     * <p>Overloaded function for {@link #setPreeditText(java.lang.String, java.util.Collection, int, int)}
     *  with <code>replaceLength = 0</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setPreeditText(java.lang.String text, java.util.Collection<io.qt.gui.QInputMethodEvent.Attribute> attributes, int replaceFrom) {
        setPreeditText(text, attributes, replaceFrom, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #setPreeditText(java.lang.String, java.util.Collection, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>replaceFrom = 0</code></li>
     * <li><code>replaceLength = 0</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void setPreeditText(java.lang.String text, java.util.Collection<io.qt.gui.QInputMethodEvent.Attribute> attributes) {
        setPreeditText(text, attributes, (int)0, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #setPreeditText(java.lang.String, java.util.Collection, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>attributes = java.util.Collections.emptyList()</code></li>
     * <li><code>replaceFrom = 0</code></li>
     * <li><code>replaceLength = 0</code></li>
     * </ul>
     */
    @io.qt.QtUninvokable
    public final void setPreeditText(java.lang.String text) {
        setPreeditText(text, java.util.Collections.emptyList(), (int)0, (int)0);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#preeditText-prop">QVirtualKeyboardInputContext::setPreeditText(QString,QList&lt;QInputMethodEvent::Attribute&gt;,int,int)</a></p>
     */
    @io.qt.QtPropertyWriter(name="preeditText")
    @io.qt.QtUninvokable
    public final void setPreeditText(java.lang.String text, java.util.Collection<io.qt.gui.QInputMethodEvent.Attribute> attributes, int replaceFrom, int replaceLength){
        setPreeditText_native_cref_QString_QList_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), text, attributes, replaceFrom, replaceLength);
    }
    
    @io.qt.QtUninvokable
    private native void setPreeditText_native_cref_QString_QList_int_int(long __this__nativeId, java.lang.String text, java.util.Collection<io.qt.gui.QInputMethodEvent.Attribute> attributes, int replaceFrom, int replaceLength);
    
    public final void setSelectionOnFocusObject(io.qt.core.QPointF anchorPos, io.qt.core.QPointF cursorPos){
        setSelectionOnFocusObject_native_cref_QPointF_cref_QPointF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(anchorPos), QtJambi_LibraryUtilities.internal.checkedNativeId(cursorPos));
    }
    
    private native void setSelectionOnFocusObject_native_cref_QPointF_cref_QPointF(long __this__nativeId, long anchorPos, long cursorPos);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardinputcontext.html#surroundingText-prop">QVirtualKeyboardInputContext::surroundingText()const</a></p>
     */
    @io.qt.QtPropertyReader(name="surroundingText")
    @io.qt.QtUninvokable
    public final java.lang.String surroundingText(){
        return surroundingText_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String surroundingText_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QVirtualKeyboardInputContext(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QVirtualKeyboardInputContext(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QVirtualKeyboardInputContext instance, QDeclarativeConstructor constructor);
    
}
