package io.qt.keyboard;


/**
 * <p>Base class for input methods</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html">QVirtualKeyboardAbstractInputMethod</a></p>
 */
public abstract class QVirtualKeyboardAbstractInputMethod extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QVirtualKeyboardAbstractInputMethod.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QVirtualKeyboardAbstractInputMethod {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public java.util.List<io.qt.keyboard.QVirtualKeyboardInputEngine.InputMode> inputModes(java.lang.String locale){
            return inputModes_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), locale);
        }
        @io.qt.QtUninvokable
        private native java.util.List<io.qt.keyboard.QVirtualKeyboardInputEngine.InputMode> inputModes_native_cref_QString(long __this__nativeId, java.lang.String locale);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean keyEvent(io.qt.core.Qt.Key key, java.lang.String text, io.qt.core.Qt.KeyboardModifiers modifiers){
            return keyEvent_native_Qt_Key_cref_QString_QFlags_Qt_KeyboardModifier_(QtJambi_LibraryUtilities.internal.nativeId(this), key.value(), text, modifiers.value());
        }
        @io.qt.QtUninvokable
        private native boolean keyEvent_native_Qt_Key_cref_QString_QFlags_Qt_KeyboardModifier_(long __this__nativeId, int key, java.lang.String text, int modifiers);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean setInputMode(java.lang.String locale, io.qt.keyboard.QVirtualKeyboardInputEngine.InputMode inputMode){
            return setInputMode_native_cref_QString_QVirtualKeyboardInputEngine_InputMode(QtJambi_LibraryUtilities.internal.nativeId(this), locale, inputMode.value());
        }
        @io.qt.QtUninvokable
        private native boolean setInputMode_native_cref_QString_QVirtualKeyboardInputEngine_InputMode(long __this__nativeId, java.lang.String locale, int inputMode);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean setTextCase(io.qt.keyboard.QVirtualKeyboardInputEngine.TextCase textCase){
            return setTextCase_native_QVirtualKeyboardInputEngine_TextCase(QtJambi_LibraryUtilities.internal.nativeId(this), textCase.value());
        }
        @io.qt.QtUninvokable
        private native boolean setTextCase_native_QVirtualKeyboardInputEngine_TextCase(long __this__nativeId, int textCase);
        
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#selectionListActiveItemChanged">QVirtualKeyboardAbstractInputMethod::selectionListActiveItemChanged(QVirtualKeyboardSelectionListModel::Type,int)</a></p>
     */
    public final Signal2<io.qt.keyboard.QVirtualKeyboardSelectionListModel.Type, @io.qt.QtPrimitiveType Integer> selectionListActiveItemChanged = new Signal2<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#selectionListChanged">QVirtualKeyboardAbstractInputMethod::selectionListChanged(QVirtualKeyboardSelectionListModel::Type)</a></p>
     */
    public final Signal1<io.qt.keyboard.QVirtualKeyboardSelectionListModel.Type> selectionListChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#selectionListsChanged">QVirtualKeyboardAbstractInputMethod::selectionListsChanged()</a></p>
     */
    public final Signal0 selectionListsChanged = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QVirtualKeyboardAbstractInputMethod(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QVirtualKeyboardAbstractInputMethod() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#QVirtualKeyboardAbstractInputMethod">QVirtualKeyboardAbstractInputMethod::QVirtualKeyboardAbstractInputMethod(QObject*)</a></p>
     */
    public QVirtualKeyboardAbstractInputMethod(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QVirtualKeyboardAbstractInputMethod instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#inputContext">QVirtualKeyboardAbstractInputMethod::inputContext()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.keyboard.QVirtualKeyboardInputContext inputContext(){
        return inputContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.keyboard.QVirtualKeyboardInputContext inputContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#inputEngine">QVirtualKeyboardAbstractInputMethod::inputEngine()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.keyboard.QVirtualKeyboardInputEngine inputEngine(){
        return inputEngine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.keyboard.QVirtualKeyboardInputEngine inputEngine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#clickPreeditText">QVirtualKeyboardAbstractInputMethod::clickPreeditText(int)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean clickPreeditText(int cursorPosition){
        return clickPreeditText_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), cursorPosition);
    }
    
    @io.qt.QtUninvokable
    private native boolean clickPreeditText_native_int(long __this__nativeId, int cursorPosition);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#inputModes">QVirtualKeyboardAbstractInputMethod::inputModes(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.util.List<io.qt.keyboard.QVirtualKeyboardInputEngine.InputMode> inputModes(java.lang.String locale);
    
    @io.qt.QtUninvokable
    private native java.util.List<io.qt.keyboard.QVirtualKeyboardInputEngine.InputMode> inputModes_native_cref_QString(long __this__nativeId, java.lang.String locale);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#keyEvent">QVirtualKeyboardAbstractInputMethod::keyEvent(Qt::Key,QString,Qt::KeyboardModifiers)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean keyEvent(io.qt.core.Qt.Key key, java.lang.String text, io.qt.core.Qt.KeyboardModifiers modifiers);
    
    @io.qt.QtUninvokable
    private native boolean keyEvent_native_Qt_Key_cref_QString_QFlags_Qt_KeyboardModifier_(long __this__nativeId, int key, java.lang.String text, int modifiers);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#patternRecognitionModes">QVirtualKeyboardAbstractInputMethod::patternRecognitionModes()const</a></p>
     */
    @io.qt.QtUninvokable
    public java.util.List<io.qt.keyboard.QVirtualKeyboardInputEngine.PatternRecognitionMode> patternRecognitionModes(){
        return patternRecognitionModes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.util.List<io.qt.keyboard.QVirtualKeyboardInputEngine.PatternRecognitionMode> patternRecognitionModes_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #reselect(int, io.qt.keyboard.QVirtualKeyboardInputEngine.ReselectFlags)}.</p>
     */
    @io.qt.QtUninvokable
    public final boolean reselect(int cursorPosition, io.qt.keyboard.QVirtualKeyboardInputEngine.ReselectFlag ... reselectFlags){
        return reselect(cursorPosition, new io.qt.keyboard.QVirtualKeyboardInputEngine.ReselectFlags(reselectFlags));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#reselect">QVirtualKeyboardAbstractInputMethod::reselect(int,QVirtualKeyboardInputEngine::ReselectFlags)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean reselect(int cursorPosition, io.qt.keyboard.QVirtualKeyboardInputEngine.ReselectFlags reselectFlags){
        return reselect_native_int_cref_QFlags_QVirtualKeyboardInputEngine_ReselectFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), cursorPosition, reselectFlags.value());
    }
    
    @io.qt.QtUninvokable
    private native boolean reselect_native_int_cref_QFlags_QVirtualKeyboardInputEngine_ReselectFlag_(long __this__nativeId, int cursorPosition, int reselectFlags);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#reset">QVirtualKeyboardAbstractInputMethod::reset()</a></p>
     */
    public void reset(){
        reset_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void reset_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#selectionListData">QVirtualKeyboardAbstractInputMethod::selectionListData(QVirtualKeyboardSelectionListModel::Type,int,QVirtualKeyboardSelectionListModel::Role)</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.Object selectionListData(io.qt.keyboard.QVirtualKeyboardSelectionListModel.Type type, int index, io.qt.keyboard.QVirtualKeyboardSelectionListModel.Role role){
        return selectionListData_native_QVirtualKeyboardSelectionListModel_Type_int_QVirtualKeyboardSelectionListModel_Role(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), index, role.value());
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object selectionListData_native_QVirtualKeyboardSelectionListModel_Type_int_QVirtualKeyboardSelectionListModel_Role(long __this__nativeId, int type, int index, int role);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#selectionListItemCount">QVirtualKeyboardAbstractInputMethod::selectionListItemCount(QVirtualKeyboardSelectionListModel::Type)</a></p>
     */
    @io.qt.QtUninvokable
    public int selectionListItemCount(io.qt.keyboard.QVirtualKeyboardSelectionListModel.Type type){
        return selectionListItemCount_native_QVirtualKeyboardSelectionListModel_Type(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @io.qt.QtUninvokable
    private native int selectionListItemCount_native_QVirtualKeyboardSelectionListModel_Type(long __this__nativeId, int type);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#selectionListItemSelected">QVirtualKeyboardAbstractInputMethod::selectionListItemSelected(QVirtualKeyboardSelectionListModel::Type,int)</a></p>
     */
    @io.qt.QtUninvokable
    public void selectionListItemSelected(io.qt.keyboard.QVirtualKeyboardSelectionListModel.Type type, int index){
        selectionListItemSelected_native_QVirtualKeyboardSelectionListModel_Type_int(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), index);
    }
    
    @io.qt.QtUninvokable
    private native void selectionListItemSelected_native_QVirtualKeyboardSelectionListModel_Type_int(long __this__nativeId, int type, int index);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#selectionListRemoveItem">QVirtualKeyboardAbstractInputMethod::selectionListRemoveItem(QVirtualKeyboardSelectionListModel::Type,int)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean selectionListRemoveItem(io.qt.keyboard.QVirtualKeyboardSelectionListModel.Type type, int index){
        return selectionListRemoveItem_native_QVirtualKeyboardSelectionListModel_Type_int(QtJambi_LibraryUtilities.internal.nativeId(this), type.value(), index);
    }
    
    @io.qt.QtUninvokable
    private native boolean selectionListRemoveItem_native_QVirtualKeyboardSelectionListModel_Type_int(long __this__nativeId, int type, int index);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#selectionLists">QVirtualKeyboardAbstractInputMethod::selectionLists()</a></p>
     */
    @io.qt.QtUninvokable
    public java.util.List<io.qt.keyboard.QVirtualKeyboardSelectionListModel.Type> selectionLists(){
        return selectionLists_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.util.List<io.qt.keyboard.QVirtualKeyboardSelectionListModel.Type> selectionLists_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#setInputMode">QVirtualKeyboardAbstractInputMethod::setInputMode(QString,QVirtualKeyboardInputEngine::InputMode)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean setInputMode(java.lang.String locale, io.qt.keyboard.QVirtualKeyboardInputEngine.InputMode inputMode);
    
    @io.qt.QtUninvokable
    private native boolean setInputMode_native_cref_QString_QVirtualKeyboardInputEngine_InputMode(long __this__nativeId, java.lang.String locale, int inputMode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#setTextCase">QVirtualKeyboardAbstractInputMethod::setTextCase(QVirtualKeyboardInputEngine::TextCase)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean setTextCase(io.qt.keyboard.QVirtualKeyboardInputEngine.TextCase textCase);
    
    @io.qt.QtUninvokable
    private native boolean setTextCase_native_QVirtualKeyboardInputEngine_TextCase(long __this__nativeId, int textCase);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#traceBegin">QVirtualKeyboardAbstractInputMethod::traceBegin(int,QVirtualKeyboardInputEngine::PatternRecognitionMode,QVariantMap,QVariantMap)</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.keyboard.QVirtualKeyboardTrace traceBegin(int traceId, io.qt.keyboard.QVirtualKeyboardInputEngine.PatternRecognitionMode patternRecognitionMode, java.util.Map<java.lang.String, java.lang.Object> traceCaptureDeviceInfo, java.util.Map<java.lang.String, java.lang.Object> traceScreenInfo){
        return traceBegin_native_int_QVirtualKeyboardInputEngine_PatternRecognitionMode_cref_QMap_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), traceId, patternRecognitionMode.value(), traceCaptureDeviceInfo, traceScreenInfo);
    }
    
    @io.qt.QtUninvokable
    private native io.qt.keyboard.QVirtualKeyboardTrace traceBegin_native_int_QVirtualKeyboardInputEngine_PatternRecognitionMode_cref_QMap_cref_QMap(long __this__nativeId, int traceId, int patternRecognitionMode, java.util.Map<java.lang.String, java.lang.Object> traceCaptureDeviceInfo, java.util.Map<java.lang.String, java.lang.Object> traceScreenInfo);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#traceEnd">QVirtualKeyboardAbstractInputMethod::traceEnd(QVirtualKeyboardTrace*)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean traceEnd(io.qt.keyboard.QVirtualKeyboardTrace trace){
        return traceEnd_native_QVirtualKeyboardTrace_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(trace));
    }
    
    @io.qt.QtUninvokable
    private native boolean traceEnd_native_QVirtualKeyboardTrace_ptr(long __this__nativeId, long trace);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qvirtualkeyboardabstractinputmethod.html#update">QVirtualKeyboardAbstractInputMethod::update()</a></p>
     */
    public void update(){
        update_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void update_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QVirtualKeyboardAbstractInputMethod(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QVirtualKeyboardAbstractInputMethod(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QVirtualKeyboardAbstractInputMethod instance, QDeclarativeConstructor constructor);
    
}
