package io.qt.uic.ui4;

import io.qt.*;


/**
 * <p>Java wrapper for Qt class <code>DomLayoutItem</code></p>
 * @hidden
 */
public class DomLayoutItem extends QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * <p>Java wrapper for Qt enum <code>DomLayoutItem::Kind</code></p>
     * @hidden
     */
    public enum Kind implements QtEnumerator {
        /**
         * <p>Representing <code>DomLayoutItem::<wbr/>Unknown</code></p>
         */
        Unknown(0),
        /**
         * <p>Representing <code>DomLayoutItem::<wbr/>Widget</code></p>
         */
        Widget(1),
        /**
         * <p>Representing <code>DomLayoutItem::<wbr/>Layout</code></p>
         */
        Layout(2),
        /**
         * <p>Representing <code>DomLayoutItem::<wbr/>Spacer</code></p>
         */
        Spacer(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Kind(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Kind resolve(int value) {
            switch (value) {
            case 0: return Unknown;
            case 1: return Widget;
            case 2: return Layout;
            case 3: return Spacer;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>DomLayoutItem()</code></p>
     */
    public DomLayoutItem(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(DomLayoutItem instance);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>attributeAlignment()const</code></p>
     */
    @QtUninvokable
    public final java.lang.@NonNull String attributeAlignment(){
        return attributeAlignment_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String attributeAlignment_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>attributeColSpan()const</code></p>
     */
    @QtUninvokable
    public final int attributeColSpan(){
        return attributeColSpan_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int attributeColSpan_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>attributeColumn()const</code></p>
     */
    @QtUninvokable
    public final int attributeColumn(){
        return attributeColumn_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int attributeColumn_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>attributeRow()const</code></p>
     */
    @QtUninvokable
    public final int attributeRow(){
        return attributeRow_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int attributeRow_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>attributeRowSpan()const</code></p>
     */
    @QtUninvokable
    public final int attributeRowSpan(){
        return attributeRowSpan_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int attributeRowSpan_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>clearAttributeAlignment()</code></p>
     */
    @QtUninvokable
    public final void clearAttributeAlignment(){
        clearAttributeAlignment_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clearAttributeAlignment_native(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>clearAttributeColSpan()</code></p>
     */
    @QtUninvokable
    public final void clearAttributeColSpan(){
        clearAttributeColSpan_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clearAttributeColSpan_native(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>clearAttributeColumn()</code></p>
     */
    @QtUninvokable
    public final void clearAttributeColumn(){
        clearAttributeColumn_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clearAttributeColumn_native(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>clearAttributeRow()</code></p>
     */
    @QtUninvokable
    public final void clearAttributeRow(){
        clearAttributeRow_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clearAttributeRow_native(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>clearAttributeRowSpan()</code></p>
     */
    @QtUninvokable
    public final void clearAttributeRowSpan(){
        clearAttributeRowSpan_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void clearAttributeRowSpan_native(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>elementLayout()const</code></p>
     */
    @QtUninvokable
    public final io.qt.uic.ui4.@Nullable DomLayout elementLayout(){
        return elementLayout_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.uic.ui4.DomLayout elementLayout_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>elementSpacer()const</code></p>
     */
    @QtUninvokable
    public final io.qt.uic.ui4.@Nullable DomSpacer elementSpacer(){
        return elementSpacer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.uic.ui4.DomSpacer elementSpacer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>elementWidget()const</code></p>
     */
    @QtUninvokable
    public final io.qt.uic.ui4.@Nullable DomWidget elementWidget(){
        return elementWidget_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.uic.ui4.DomWidget elementWidget_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>hasAttributeAlignment()const</code></p>
     */
    @QtUninvokable
    public final boolean hasAttributeAlignment(){
        return hasAttributeAlignment_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasAttributeAlignment_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>hasAttributeColSpan()const</code></p>
     */
    @QtUninvokable
    public final boolean hasAttributeColSpan(){
        return hasAttributeColSpan_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasAttributeColSpan_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>hasAttributeColumn()const</code></p>
     */
    @QtUninvokable
    public final boolean hasAttributeColumn(){
        return hasAttributeColumn_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasAttributeColumn_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>hasAttributeRow()const</code></p>
     */
    @QtUninvokable
    public final boolean hasAttributeRow(){
        return hasAttributeRow_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasAttributeRow_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>hasAttributeRowSpan()const</code></p>
     */
    @QtUninvokable
    public final boolean hasAttributeRowSpan(){
        return hasAttributeRowSpan_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean hasAttributeRowSpan_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>kind()const</code></p>
     */
    @QtUninvokable
    public final io.qt.uic.ui4.DomLayoutItem.@NonNull Kind kind(){
        return io.qt.uic.ui4.DomLayoutItem.Kind.resolve(kind_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int kind_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>read(QXmlStreamReader&amp;)</code></p>
     */
    @QtUninvokable
    public final void read(io.qt.core.@StrictNonNull QXmlStreamReader reader){
        java.util.Objects.requireNonNull(reader, "Argument 'reader': null not expected.");
        read_native_ref_QXmlStreamReader(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(reader));
    }
    
    @QtUninvokable
    private native void read_native_ref_QXmlStreamReader(long __this__nativeId, long reader);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>setAttributeAlignment(QString)</code></p>
     */
    @QtUninvokable
    public final void setAttributeAlignment(java.lang.@NonNull String a){
        setAttributeAlignment_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), a);
    }
    
    @QtUninvokable
    private native void setAttributeAlignment_native_cref_QString(long __this__nativeId, java.lang.String a);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>setAttributeColSpan(int)</code></p>
     */
    @QtUninvokable
    public final void setAttributeColSpan(int a){
        setAttributeColSpan_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), a);
    }
    
    @QtUninvokable
    private native void setAttributeColSpan_native_int(long __this__nativeId, int a);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>setAttributeColumn(int)</code></p>
     */
    @QtUninvokable
    public final void setAttributeColumn(int a){
        setAttributeColumn_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), a);
    }
    
    @QtUninvokable
    private native void setAttributeColumn_native_int(long __this__nativeId, int a);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>setAttributeRow(int)</code></p>
     */
    @QtUninvokable
    public final void setAttributeRow(int a){
        setAttributeRow_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), a);
    }
    
    @QtUninvokable
    private native void setAttributeRow_native_int(long __this__nativeId, int a);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>setAttributeRowSpan(int)</code></p>
     */
    @QtUninvokable
    public final void setAttributeRowSpan(int a){
        setAttributeRowSpan_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), a);
    }
    
    @QtUninvokable
    private native void setAttributeRowSpan_native_int(long __this__nativeId, int a);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>setElementLayout(DomLayout*)</code></p>
     */
    @QtUninvokable
    public final void setElementLayout(io.qt.uic.ui4.@Nullable DomLayout a){
        setElementLayout_native_DomLayout_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(a));
    }
    
    @QtUninvokable
    private native void setElementLayout_native_DomLayout_ptr(long __this__nativeId, long a);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>setElementSpacer(DomSpacer*)</code></p>
     */
    @QtUninvokable
    public final void setElementSpacer(io.qt.uic.ui4.@Nullable DomSpacer a){
        setElementSpacer_native_DomSpacer_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(a));
    }
    
    @QtUninvokable
    private native void setElementSpacer_native_DomSpacer_ptr(long __this__nativeId, long a);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>setElementWidget(DomWidget*)</code></p>
     */
    @QtUninvokable
    public final void setElementWidget(io.qt.uic.ui4.@Nullable DomWidget a){
        setElementWidget_native_DomWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(a));
    }
    
    @QtUninvokable
    private native void setElementWidget_native_DomWidget_ptr(long __this__nativeId, long a);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>takeElementLayout()</code></p>
     */
    @QtUninvokable
    public final io.qt.uic.ui4.@Nullable DomLayout takeElementLayout(){
        return takeElementLayout_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.uic.ui4.DomLayout takeElementLayout_native(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>takeElementSpacer()</code></p>
     */
    @QtUninvokable
    public final io.qt.uic.ui4.@Nullable DomSpacer takeElementSpacer(){
        return takeElementSpacer_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.uic.ui4.DomSpacer takeElementSpacer_native(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>takeElementWidget()</code></p>
     */
    @QtUninvokable
    public final io.qt.uic.ui4.@Nullable DomWidget takeElementWidget(){
        return takeElementWidget_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.uic.ui4.DomWidget takeElementWidget_native(long __this__nativeId);
    
    /**
     * <p>See <code>DomLayoutItem::<wbr/>write(QXmlStreamWriter&amp;,<wbr/>QString)const</code></p>
     */
    @QtUninvokable
    public final void write(io.qt.core.@StrictNonNull QXmlStreamWriter writer, java.lang.@NonNull String tagName){
        java.util.Objects.requireNonNull(writer, "Argument 'writer': null not expected.");
        write_native_ref_QXmlStreamWriter_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(writer), tagName);
    }
    
    @QtUninvokable
    private native void write_native_ref_QXmlStreamWriter_cref_QString_constfct(long __this__nativeId, long writer, java.lang.String tagName);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected DomLayoutItem(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Overloaded function for {@link #write(io.qt.core.QXmlStreamWriter, java.lang.String)}
     *  with <code>tagName = (String)null</code>.</p>
     */
    @QtUninvokable
    public final void write(io.qt.core.@StrictNonNull QXmlStreamWriter writer) {
        write(writer, (String)null);
    }
}
