/*
 * Decompiled with CFR 0.152.
 */
package io.qt.uic;

import io.qt.core.QFile;
import io.qt.core.QFileInfo;
import io.qt.core.QIODevice;
import io.qt.core.QIODeviceBase;
import io.qt.core.QTextStream;
import io.qt.core.QXmlStreamAttributes;
import io.qt.core.QXmlStreamReader;
import io.qt.uic.CustomWidgetsInfo;
import io.qt.uic.DatabaseInfo;
import io.qt.uic.Driver;
import io.qt.uic.Option;
import io.qt.uic.Validator;
import io.qt.uic.java.WriteClass;
import io.qt.uic.java.WriteDeclaration;
import io.qt.uic.kotlin.WriteImports;
import io.qt.uic.ui4.DomCustomWidget;
import io.qt.uic.ui4.DomCustomWidgets;
import io.qt.uic.ui4.DomHeader;
import io.qt.uic.ui4.DomInclude;
import io.qt.uic.ui4.DomIncludes;
import io.qt.uic.ui4.DomUI;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class Uic {
    private final Driver drv;
    final QTextStream m_stdout;
    private QTextStream m_output;
    private final Option opt;
    private final DatabaseInfo info;
    private final CustomWidgetsInfo cWidgetsInfo;
    private String pixFunction;

    public Uic(Driver driver) {
        QIODevice qiodevice = QIODevice.fromOutputStream((OutputStream)System.out);
        qiodevice.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly});
        this.m_output = this.m_stdout = new QTextStream(qiodevice);
        this.info = new DatabaseInfo();
        this.cWidgetsInfo = new CustomWidgetsInfo();
        this.drv = driver;
        this.opt = driver.option();
    }

    public boolean printDependencies() {
        DomCustomWidgets customWidgets;
        QIODevice f;
        String fileName = this.opt.inputFile;
        if (fileName.isEmpty()) {
            f = QIODevice.fromInputStream((InputStream)System.in);
        } else {
            f = new QFile(fileName);
            if (!f.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.ReadOnly})) {
                return false;
            }
        }
        DomUI ui = null;
        QXmlStreamReader reader = new QXmlStreamReader(f);
        ui = this.parseUiFile(reader);
        if (ui == null) {
            return false;
        }
        DomIncludes includes = ui.elementIncludes();
        if (includes != null) {
            for (DomInclude incl : includes.elementInclude()) {
                String file = incl.text();
                if (file == null || file.isEmpty()) continue;
                System.out.println(file);
            }
        }
        if ((customWidgets = ui.elementCustomWidgets()) != null) {
            for (DomCustomWidget customWidget : customWidgets.elementCustomWidget()) {
                String file;
                DomHeader header = customWidget.elementHeader();
                if (header == null || (file = header.text()) == null || file.isEmpty()) continue;
                System.out.println(file);
            }
        }
        ui.dispose();
        return true;
    }

    public Driver driver() {
        return this.drv;
    }

    public QTextStream output() {
        return this.m_output;
    }

    public Option option() {
        return this.opt;
    }

    public String pixmapFunction() {
        return this.pixFunction;
    }

    public void setPixmapFunction(String f) {
        this.pixFunction = f;
    }

    public DatabaseInfo databaseInfo() {
        return this.info;
    }

    public CustomWidgetsInfo customWidgetsInfo() {
        return this.cWidgetsInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean write(QIODevice in, String outputDir, String language) {
        QIODevice iodevice;
        String className;
        DomUI ui = null;
        QXmlStreamReader reader = new QXmlStreamReader();
        reader.setDevice(in);
        ui = this.parseUiFile(reader);
        if (ui == null) {
            return false;
        }
        double version = Double.parseDouble(ui.attributeVersion());
        if (version < 4.0) {
            System.err.println("uic: File generated with too old version of Qt Designer");
            return false;
        }
        this.driver().setUseIdBasedTranslations(ui.attributeIdbasedtr());
        if (ui == null || ui.elementWidget() == null) {
            return false;
        }
        String qualifiedClassName = ui.elementClass();
        String[] namespaceList = qualifiedClassName.split("::");
        if (namespaceList.length > 1) {
            className = namespaceList[namespaceList.length - 1];
            this.drv.option().targetPackage = String.join((CharSequence)".", Arrays.copyOf(namespaceList, namespaceList.length - 1));
        } else {
            className = qualifiedClassName;
        }
        String fileSuffix = "kotlin".equals(language) ? ".kt" : ".java";
        QTextStream oldOutput = this.m_output;
        QFile outputFile = null;
        if (outputDir == null || outputDir.isEmpty()) {
            iodevice = QIODevice.fromOutputStream((OutputStream)System.out);
        } else {
            QFileInfo targetFile = new QFileInfo(outputDir + "/" + this.drv.option().targetPackage.replace('.', '/') + "/" + this.drv.option().prefix + className + this.drv.option().postfix + fileSuffix);
            targetFile.absoluteDir().mkpath(".");
            outputFile = new QFile(targetFile.absoluteFilePath());
            iodevice = outputFile;
        }
        if (iodevice.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly})) {
            this.m_output = new QTextStream(iodevice);
        } else {
            if (outputFile == null) return false;
            outputFile.remove();
            if (!outputFile.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly})) return false;
            this.m_output = new QTextStream(iodevice);
        }
        this.pixFunction = ui.elementPixmapFunction();
        if ("QPixmap::fromMimeSource".equals(this.pixFunction) || "qPixmapFromMimeSource".equals(this.pixFunction)) {
            System.err.println(this.opt.messagePrefix() + "Warning: Obsolete pixmap function '" + this.pixFunction + "' specified in the UI file.");
            this.pixFunction = null;
        }
        this.info.acceptUI(ui);
        this.cWidgetsInfo.acceptUI(ui);
        if ("kotlin".equals(language)) {
            new WriteImports(this).acceptUI(ui);
        } else {
            new io.qt.uic.java.WriteImports(this).acceptUI(ui);
        }
        new Validator(this).acceptUI(ui);
        if ("kotlin".equals(language)) {
            new io.qt.uic.kotlin.WriteDeclaration(this).acceptUI(ui);
        } else {
            new WriteDeclaration(this).acceptUI(ui);
        }
        this.m_output.dispose();
        iodevice.close();
        this.m_output = oldOutput;
        if (outputDir == null || (this.drv.option().prefix == null || this.drv.option().prefix.isEmpty()) && (this.drv.option().postfix == null || this.drv.option().postfix.isEmpty())) return true;
        outputFile = new QFile(outputDir + "/" + this.drv.option().targetPackage.replace('.', '/') + "/" + className + fileSuffix);
        iodevice = outputFile;
        if (!outputFile.exists() || this.drv.option().forceOutput) {
            if (!iodevice.open(new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly})) {
                return false;
            }
            this.m_output = new QTextStream(iodevice);
            if ("kotlin".equals(language)) {
                new io.qt.uic.kotlin.WriteClass(this, className).acceptUI(ui);
            } else {
                new WriteClass(this, className).acceptUI(ui);
            }
            this.m_output.dispose();
            outputFile.close();
            this.m_output = oldOutput;
        }
        outputFile.dispose();
        return true;
    }

    public boolean isButton(String className) {
        return this.customWidgetsInfo().extendsOneOf(className, Arrays.asList("QRadioButton", "QToolButton", "QCheckBox", "QPushButton", "QCommandLinkButton"));
    }

    public boolean isContainer(String className) {
        return this.customWidgetsInfo().extendsOneOf(className, Arrays.asList("QStackedWidget", "QToolBox", "QTabWidget", "QScrollArea", "QMdiArea", "QWizard", "QDockWidget"));
    }

    public boolean isMenu(String className) {
        return this.customWidgetsInfo().extendsOneOf(className, Arrays.asList("QMenu", "QPopupMenu"));
    }

    private static double versionFromUiAttribute(QXmlStreamReader reader) {
        String versionAttribute;
        QXmlStreamAttributes attributes = reader.attributes();
        if (!attributes.hasAttribute(versionAttribute = "version")) {
            return 4.0;
        }
        String version = attributes.value(versionAttribute);
        try {
            return Double.parseDouble(version);
        }
        catch (NumberFormatException e) {
            return 4.0;
        }
    }

    private DomUI parseUiFile(QXmlStreamReader reader) {
        DomUI ui = null;
        while (!reader.atEnd()) {
            if (reader.readNext() != QXmlStreamReader.TokenType.StartElement) continue;
            if (reader.name().equalsIgnoreCase("ui") && ui == null) {
                double version = Uic.versionFromUiAttribute(reader);
                if (version < 4.0) {
                    System.err.println(String.format("QtJambi UIC: File generated with too old version of Qt Designer (%1$s)", version));
                    return null;
                }
                ui = new DomUI();
                ui.read(reader);
                continue;
            }
            reader.raiseError("Unexpected element " + reader.name().toString());
        }
        if (reader.hasError()) {
            if (ui != null) {
                ui.dispose();
            }
            ui = null;
            System.err.println(String.format("QtJambi UIC: Error in line %1$s, column %2$s : %3$s", reader.lineNumber(), reader.columnNumber(), reader.errorString()));
        }
        return ui;
    }
}

