/*
 * Decompiled with CFR 0.152.
 */
package io.qt.uic.kotlin;

import io.qt.QtEnumerator;
import io.qt.core.QHash;
import io.qt.core.QIODeviceBase;
import io.qt.core.QList;
import io.qt.core.QLogging;
import io.qt.core.QMultiMap;
import io.qt.core.QPair;
import io.qt.core.QSet;
import io.qt.core.QStack;
import io.qt.core.QStringList;
import io.qt.core.QTextStream;
import io.qt.core.QVersionNumber;
import io.qt.core.Qt;
import io.qt.gui.QPalette;
import io.qt.uic.ClassInfoEntries;
import io.qt.uic.Comparators;
import io.qt.uic.ConnectionSyntax;
import io.qt.uic.CustomWidgetsInfo;
import io.qt.uic.Driver;
import io.qt.uic.Option;
import io.qt.uic.SignalSlot;
import io.qt.uic.TreeWalker;
import io.qt.uic.Uic;
import io.qt.uic.Utils;
import io.qt.uic.ui4.DomAction;
import io.qt.uic.ui4.DomActionGroup;
import io.qt.uic.ui4.DomActionRef;
import io.qt.uic.ui4.DomBrush;
import io.qt.uic.ui4.DomButtonGroup;
import io.qt.uic.ui4.DomColor;
import io.qt.uic.ui4.DomColorGroup;
import io.qt.uic.ui4.DomColorRole;
import io.qt.uic.ui4.DomColumn;
import io.qt.uic.ui4.DomConnection;
import io.qt.uic.ui4.DomCustomWidget;
import io.qt.uic.ui4.DomCustomWidgets;
import io.qt.uic.ui4.DomFont;
import io.qt.uic.ui4.DomGradient;
import io.qt.uic.ui4.DomGradientStop;
import io.qt.uic.ui4.DomItem;
import io.qt.uic.ui4.DomLayout;
import io.qt.uic.ui4.DomLayoutDefault;
import io.qt.uic.ui4.DomLayoutFunction;
import io.qt.uic.ui4.DomLayoutItem;
import io.qt.uic.ui4.DomProperty;
import io.qt.uic.ui4.DomResourceIcon;
import io.qt.uic.ui4.DomResourcePixmap;
import io.qt.uic.ui4.DomRow;
import io.qt.uic.ui4.DomSize;
import io.qt.uic.ui4.DomSizePolicy;
import io.qt.uic.ui4.DomSlots;
import io.qt.uic.ui4.DomSpacer;
import io.qt.uic.ui4.DomString;
import io.qt.uic.ui4.DomStringList;
import io.qt.uic.ui4.DomTabStops;
import io.qt.uic.ui4.DomUI;
import io.qt.uic.ui4.DomWidget;
import io.qt.widgets.QSizePolicy;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class WriteInitialization
extends TreeWalker {
    private static final String[] realPropertyNames = new String[]{"visible", "cascadingSectionResizes", "minimumSectionSize", "defaultSectionSize", "highlightSections", "showSortIndicator", "stretchLastSection"};
    private static final String[] headerPrefixes = new String[]{"horizontalHeader", "verticalHeader"};
    private static final QStringList currentIndexWidgets = new QStringList(new String[]{"QComboBox", "QStackedWidget", "QTabWidget", "QToolBox"});
    private final Uic m_uic;
    private final Driver m_driver;
    private final QTextStream m_output;
    private final Option m_option;
    private String m_indent;
    private boolean m_stdsetdef = true;
    private final QStack<DomWidget> m_widgetChain = new QStack(DomWidget.class);
    private final QStack<DomLayout> m_layoutChain = new QStack(DomLayout.class);
    private final QStack<DomActionGroup> m_actionGroupChain = new QStack(DomActionGroup.class);
    private final List<Buddy> m_buddies = new ArrayList<Buddy>();
    private final Set<String> m_buttonGroups = new TreeSet<String>();
    private final Map<Integer, String> m_colorBrushHash = new TreeMap<Integer, String>();
    private final Map<DomFont, String> m_fontPropertiesNameMap = new TreeMap<DomFont, String>(new Comparators.DomFontComparator());
    private final Map<DomResourceIcon, String> m_iconPropertiesNameMap = new TreeMap<DomResourceIcon, String>(new Comparators.DomResourceIconComparator());
    private final Map<DomSizePolicy, String> m_sizePolicyNameMap = new TreeMap<DomSizePolicy, String>(new Comparators.DomSizePolicyComparator());
    private final LayoutDefaultHandler m_LayoutDefaultHandler = new LayoutDefaultHandler();
    private Enum m_layoutMarginType = Enum.TopLevelMargin;
    private String m_generatedClass;
    private String m_mainFormVarName;
    private List<String> m_customSlots = Collections.emptyList();
    private List<String> m_customSignals = Collections.emptyList();
    private final StringBuilder m_delayedInitialization = new StringBuilder();
    private final QTextStream m_delayedOut = new QTextStream((Object)this.m_delayedInitialization, new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly});
    private final StringBuilder m_refreshInitialization = new StringBuilder();
    private final QTextStream m_refreshOut = new QTextStream((Object)this.m_refreshInitialization, new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly});
    private final StringBuilder m_delayedActionInitialization = new StringBuilder();
    private final QTextStream m_actionOut = new QTextStream((Object)this.m_delayedActionInitialization, new QIODeviceBase.OpenModeFlag[]{QIODeviceBase.OpenModeFlag.WriteOnly});
    private boolean m_layoutWidget = false;
    private boolean m_firstThemeIcon = true;
    private boolean m_connectSlotsByName = true;

    public static void formatMemberFnPtrConnection(QTextStream str, SignalSlot signal, SignalSlot slot) {
        String functionName;
        int parenPos;
        str.append(signal.name).append("?.");
        if (signal.metaMethod != null) {
            str.append(signal.metaMethod.name());
        } else {
            parenPos = signal.signature.indexOf(40);
            functionName = signal.signature.substring(0, parenPos);
            str.append(functionName);
        }
        str.append("?.connect(");
        if (slot.metaMethod != null) {
            if (slot.isAmbiguous) {
                str.append("QMetaObject.Slot").append(slot.metaMethod.parameterCount());
                List parameterClassTypes = slot.metaMethod.parameterClassTypes();
                if (!parameterClassTypes.isEmpty()) {
                    str.append('<');
                    for (int i = 0; i < parameterClassTypes.size(); ++i) {
                        if (i > 0) {
                            str.append(", ");
                        }
                        str.append(((Class)parameterClassTypes.get(i)).getTypeName().replace('$', '.'));
                    }
                    str.append('>');
                }
                str.append('(');
            }
            str.append(slot.name).append("::").append(slot.metaMethod.name());
            if (slot.isAmbiguous) {
                str.append(')');
            }
        } else if (slot.method != null) {
            if (slot.isAmbiguous) {
                str.append("QMetaObject.Slot").append(slot.method.getParameterCount());
                Class<?>[] parameterClassTypes = slot.method.getParameterTypes();
                if (parameterClassTypes.length > 0) {
                    str.append('<');
                    for (int i = 0; i < parameterClassTypes.length; ++i) {
                        if (i > 0) {
                            str.append(", ");
                        }
                        str.append(parameterClassTypes[i].getTypeName().replace('$', '.'));
                    }
                    str.append('>');
                }
                str.append('(');
            }
            str.append(slot.name).append("::").append(slot.metaMethod.name());
            if (slot.isAmbiguous) {
                str.append(')');
            }
        } else {
            parenPos = slot.signature.indexOf(40);
            functionName = slot.signature.substring(0, parenPos);
            str.append(slot.name).append("::").append(functionName);
        }
        str.append(')');
    }

    public static void formatStringBasedConnection(QTextStream str, SignalSlot sender, SignalSlot receiver) {
        str.append("QObject.connect(").append(sender.name).append(", \"");
        if (sender.metaMethod != null) {
            str.append(sender.metaMethod.methodSignature());
        } else {
            str.append(sender.signature);
        }
        str.append("\", ").append(receiver.name).append(", \"");
        if (receiver.metaMethod != null) {
            str.append(receiver.metaMethod.methodSignature());
        } else if (receiver.method != null) {
            str.append(receiver.method.getName()).append('(');
            Class<?>[] params = receiver.method.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    str.append(", ");
                }
                str.append(params[i].getTypeName().replace('$', '.'));
            }
            str.append(')');
        } else {
            str.append(receiver.signature);
        }
        str.append("\")");
    }

    public void formatConnection(QTextStream str, SignalSlot theSignal, SignalSlot theSlot) {
        ConnectionSyntax connectionSyntax = this.connectionSyntax(theSignal, theSlot);
        switch (connectionSyntax) {
            case MemberFunctionPtr: {
                WriteInitialization.formatMemberFnPtrConnection(str, theSignal, theSlot);
                break;
            }
            case StringBased: {
                WriteInitialization.formatStringBasedConnection(str, theSignal, theSlot);
                break;
            }
        }
    }

    public static String formatString(String text) {
        StringBuilder textBuilder = new StringBuilder();
        textBuilder.append('\"');
        int length = Character.codePointCount(text, 0, text.length());
        for (int i = 0; i < length; ++i) {
            int codePoint = Character.codePointAt(text, i);
            if (Character.UnicodeBlock.of(codePoint) == Character.UnicodeBlock.BASIC_LATIN) {
                switch (new String(Character.toChars(codePoint))) {
                    case "\n": {
                        textBuilder.append("\\n");
                        break;
                    }
                    case "\r": {
                        textBuilder.append("\\r");
                        break;
                    }
                    case "\\": {
                        textBuilder.append("\\\\");
                        break;
                    }
                    case "\b": {
                        textBuilder.append("\\b");
                        break;
                    }
                    case "\t": {
                        textBuilder.append("\\t");
                        break;
                    }
                    case "\f": {
                        textBuilder.append("\\f");
                        break;
                    }
                    case "\"": {
                        textBuilder.append("\\\"");
                        break;
                    }
                    case "'": {
                        textBuilder.append("\\'");
                        break;
                    }
                    default: {
                        textBuilder.appendCodePoint(codePoint);
                        break;
                    }
                }
                continue;
            }
            String hex = Integer.toHexString(codePoint).toUpperCase();
            textBuilder.append("\\u");
            for (int j = hex.length(); j < 4; ++j) {
                textBuilder.append('0');
            }
            textBuilder.append(hex);
        }
        textBuilder.append('\"');
        return textBuilder.toString();
    }

    public WriteInitialization(Uic uic) {
        this.m_uic = uic;
        this.m_driver = uic.driver();
        this.m_output = uic.output();
        this.m_option = uic.option();
        this.m_indent = this.m_option.indent + this.m_option.indent;
    }

    @Override
    public void acceptUI(DomUI node) {
        String varName;
        String className;
        DomSlots customSlots;
        this.m_actionGroupChain.push(null);
        this.m_widgetChain.push(null);
        this.m_layoutChain.push(null);
        if (node.hasAttributeConnectslotsbyname()) {
            this.m_connectSlotsByName = node.attributeConnectslotsbyname();
        }
        if ((customSlots = node.elementSlots()) != null) {
            this.m_customSlots = customSlots.elementSlot();
            this.m_customSignals = customSlots.elementSignal();
        }
        this.acceptLayoutDefault(node.elementLayoutDefault());
        this.acceptLayoutFunction(node.elementLayoutFunction());
        if (node.elementCustomWidgets() != null) {
            super.acceptCustomWidgets(node.elementCustomWidgets());
        }
        this.m_generatedClass = className = node.elementClass() + this.m_option.postfix;
        this.m_mainFormVarName = varName = this.m_driver.findOrInsertWidget(node.elementWidget());
        String widgetClassName = node.elementWidget().attributeClass();
        this.m_output.append(this.m_option.indent).append("fun setupUi(").append(varName).append(": ").append(widgetClassName).append(")").append("{").endl().append(this.m_option.indent).endl();
        for (String connection : this.m_uic.databaseInfo().connections()) {
            if ("(default)".equals(connection)) continue;
            this.m_output.append(this.m_indent).append(Driver.normalizedName(connection)).append("Connection = io.qt.sql.QSqlDatabase.database(").append(WriteInitialization.formatString(connection)).append(")").endl();
        }
        this.acceptWidget(node.elementWidget());
        for (Buddy b : this.m_buddies) {
            String buddyVarName = this.m_driver.widgetVariableName(b.buddyAttributeName);
            if (buddyVarName.isEmpty()) {
                System.err.println(String.format("%1$s: Warning: Buddy assignment: '%2$s' is not a valid widget.", this.m_option.messagePrefix(), b.buddyAttributeName));
                continue;
            }
            this.m_output.append(this.m_indent).append(b.labelVarName).append(".setBuddy(").append(buddyVarName).append(")").endl();
        }
        if (node.elementTabStops() != null) {
            this.acceptTabStops(node.elementTabStops());
        }
        if (this.m_delayedActionInitialization.length() > 0) {
            this.m_output.endl().append(this.m_delayedActionInitialization.toString());
        }
        this.m_output.endl().append(this.m_indent).append("this.retranslateUi(").append(varName).append(")").endl();
        if (node.elementConnections() != null) {
            this.acceptConnections(node.elementConnections());
        }
        this.m_delayedOut.flush();
        if (this.m_delayedInitialization.length() > 0) {
            this.m_output.endl().append(this.m_delayedInitialization.toString()).endl();
        }
        if (this.m_option.autoConnection && this.m_connectSlotsByName) {
            this.m_output.endl().append(this.m_indent).append("QMetaObject.connectSlotsByName(").append(varName).append(")").endl();
        }
        this.m_output.append(this.m_option.indent).append("}").endl().endl();
        this.m_refreshOut.flush();
        this.m_output.append(this.m_option.indent).append("fun retranslateUi(").append(varName).append(": ").append(widgetClassName).append(")").endl().append(this.m_option.indent).append("{").endl().append(this.m_refreshInitialization.toString()).append(this.m_option.indent).append("}").endl();
        this.m_layoutChain.pop();
        this.m_widgetChain.pop();
        this.m_actionGroupChain.pop();
    }

    private void addWizardPage(String pageVarName, DomWidget page, String parentWidget) {
        String id = "";
        QList<DomProperty> attributes = page.elementAttribute();
        if (!attributes.isEmpty()) {
            for (DomProperty p : attributes) {
                if (!"pageId".equals(p.attributeName())) continue;
                DomString ds = p.elementString();
                if (ds == null) break;
                id = ds.text();
                break;
            }
        }
        if (id.isEmpty()) {
            this.m_output.append(this.m_indent).append(parentWidget).append(".addPage(").append(pageVarName).append(")").endl();
        } else {
            this.m_output.append(this.m_indent).append(parentWidget).append(".setPage(").append(id).append(", ").append(pageVarName).append(")").endl();
        }
    }

    @Override
    public void acceptWidget(DomWidget node) {
        DomProperty ptoolTip;
        DomProperty picon;
        String icon;
        String addPageMethod;
        String _parentClass;
        DomWidget _parentWidget;
        this.m_layoutMarginType = this.m_widgetChain.count() == 1 ? Enum.TopLevelMargin : Enum.ChildMargin;
        String className = node.attributeClass();
        String varName = this.m_driver.findOrInsertWidget(node);
        String objectName = node.attributeName();
        String parentWidget = "";
        String parentClass = "";
        if (this.m_widgetChain.top() != null) {
            parentWidget = this.m_driver.findOrInsertWidget((DomWidget)this.m_widgetChain.top());
            parentClass = ((DomWidget)this.m_widgetChain.top()).attributeClass();
        }
        String savedParentWidget = parentWidget;
        if (this.m_uic.isContainer(parentClass)) {
            parentWidget = "";
        }
        CustomWidgetsInfo cwi = this.m_uic.customWidgetsInfo();
        if (this.m_widgetChain.size() != 1) {
            this.m_output.append(this.m_indent).append(varName).append(" = ").append(cwi.realClassName(className)).append('(').append(parentWidget).append(")").endl();
        }
        parentWidget = savedParentWidget;
        if (cwi._extends(className, "QComboBox")) {
            this.initializeComboBox(node);
        } else if (cwi._extends(className, "QListWidget")) {
            this.initializeListWidget(node);
        } else if (cwi._extends(className, "QTreeWidget")) {
            this.initializeTreeWidget(node);
        } else if (cwi._extends(className, "QTableWidget")) {
            this.initializeTableWidget(node);
        }
        if (this.m_uic.isButton(className)) {
            this.addButtonGroup(node, varName);
        }
        this.writeProperties(varName, objectName, className, (List<DomProperty>)node.elementProperty());
        if (parentWidget != null && !parentWidget.isEmpty() && cwi._extends(className, "QMenu")) {
            this.initializeMenu(node, parentWidget);
        }
        if (node.elementLayout().isEmpty()) {
            this.m_layoutChain.push(null);
        }
        this.m_layoutWidget = false;
        if (!(!"QWidget".equals(className) || node.hasAttributeNative() || (_parentWidget = (DomWidget)this.m_widgetChain.top()) == null || "QMainWindow".equals(_parentClass = _parentWidget.attributeClass()) || this.m_uic.customWidgetsInfo().isCustomWidgetContainer(_parentClass) || this.m_uic.isContainer(_parentClass))) {
            this.m_layoutWidget = true;
        }
        this.m_widgetChain.push((Object)node);
        this.m_layoutChain.push(null);
        super.acceptWidget(node);
        this.m_layoutChain.pop();
        this.m_widgetChain.pop();
        this.m_layoutWidget = false;
        Map<String, DomProperty> attributes = Utils.propertyMap(node.elementAttribute());
        String pageDefaultString = "Page";
        if (cwi._extends(parentClass, "QMainWindow")) {
            if (cwi._extends(className, "QMenuBar")) {
                this.m_output.append(this.m_indent).append(parentWidget).append("?.setMenuBar(").append(varName).append(")").endl();
            } else if (cwi._extends(className, "QToolBar")) {
                this.m_output.append(this.m_indent).append(parentWidget).append("?.addToolBar(").append(this.toolBarAreaStringFromDOMAttributes(attributes).replace("::", ".")).append(varName).append(")").endl();
                DomProperty pbreak = attributes.get("toolBarBreak");
                if (pbreak != null && Boolean.parseBoolean(pbreak.elementBool())) {
                    this.m_output.append(this.m_indent).append(parentWidget).append("?.insertToolBarBreak(").append(varName).append(")").endl();
                }
            } else if (cwi._extends(className, "QDockWidget")) {
                this.m_output.append(this.m_indent).append(parentWidget).append("?.addDockWidget(");
                DomProperty pstyle = attributes.get("dockWidgetArea");
                if (pstyle != null) {
                    this.m_output.append("Qt.DockWidgetArea.").append(Qt.DockWidgetArea.resolve((int)pstyle.elementNumber()).name()).append(", ");
                }
                this.m_output.append(varName).append(")").endl();
            } else if (this.m_uic.customWidgetsInfo()._extends(className, "QStatusBar")) {
                this.m_output.append(this.m_indent).append(parentWidget).append("?.setStatusBar(").append(varName).append(")").endl();
            } else {
                this.m_output.append(this.m_indent).append(parentWidget).append("?.setCentralWidget(").append(varName).append(")").endl();
            }
        }
        if ((addPageMethod = cwi.customWidgetAddPageMethod(parentClass)).isEmpty()) {
            addPageMethod = cwi.simpleContainerAddPageMethod(parentClass);
        }
        if (!addPageMethod.isEmpty()) {
            this.m_output.append(this.m_indent).append(parentWidget).append('.').append(addPageMethod).append('(').append(varName).append(")").endl();
        } else if (this.m_uic.customWidgetsInfo()._extends(parentClass, "QWizard")) {
            this.addWizardPage(varName, node, parentWidget);
        } else if (this.m_uic.customWidgetsInfo()._extends(parentClass, "QToolBox")) {
            DomProperty plabel = attributes.get("label");
            DomString plabelString = plabel != null ? plabel.elementString() : null;
            icon = "";
            picon = attributes.get("icon");
            if (picon != null) {
                icon = ", " + this.iconCall(picon);
            }
            this.m_output.append(this.m_indent).append(parentWidget).append("?.addItem(").append(varName).append(icon).append(", ").append(this.noTrCall(plabelString, pageDefaultString)).append(")").endl();
            this.autoTrOutput(plabelString, pageDefaultString).append(this.m_indent).append(parentWidget).append("?.setItemText(").append(parentWidget).append("?.indexOf(").append(varName).append("), ").append(this.autoTrCall(plabelString, pageDefaultString)).append(")").flush();
            ptoolTip = attributes.get("toolTip");
            if (ptoolTip != null) {
                this.autoTrOutput(ptoolTip.elementString()).append(this.m_indent).append(parentWidget).append("?.setItemToolTip(").append(parentWidget).append("?.indexOf(").append(varName).append("), ").append(this.autoTrCall(ptoolTip.elementString())).append(")").flush();
            }
        } else if (this.m_uic.customWidgetsInfo()._extends(parentClass, "QTabWidget")) {
            DomProperty pwhatsThis;
            DomProperty ptitle = attributes.get("title");
            DomString ptitleString = ptitle != null ? ptitle.elementString() : null;
            icon = "";
            picon = attributes.get("icon");
            if (picon != null) {
                icon = ", " + this.iconCall(picon);
            }
            this.m_output.append(this.m_indent).append(parentWidget).append("?.addTab(").append(varName).append(icon).append(", \"\")").endl();
            this.autoTrOutput(ptitleString, pageDefaultString).append(this.m_indent).append(parentWidget).append("?.setTabText(").append(parentWidget).append("?.indexOf(").append(varName).append("), ").append(this.autoTrCall(ptitleString, pageDefaultString)).append(")").flush();
            ptoolTip = attributes.get("toolTip");
            if (ptoolTip != null) {
                this.autoTrOutput(ptoolTip.elementString()).append(this.m_indent).append(parentWidget).append("?.setTabToolTip(").append(parentWidget).append("?.indexOf(").append(varName).append("), ").append(this.autoTrCall(ptoolTip.elementString())).append(")").flush();
            }
            if ((pwhatsThis = attributes.get("whatsThis")) != null) {
                this.autoTrOutput(pwhatsThis.elementString()).append(this.m_indent).append(parentWidget).append("?.setTabWhatsThis(").append(parentWidget).append("?.indexOf(").append(varName).append("), ").append(this.autoTrCall(pwhatsThis.elementString())).append(")").flush();
            }
        }
        if (cwi.extendsOneOf(className, Arrays.asList("QTreeView", "QTreeWidget"))) {
            String[] headerProperties = new ArrayList();
            for (String realPropertyName : realPropertyNames) {
                String[] fakePropertyName = "header" + Character.toUpperCase(realPropertyName.charAt(0)) + realPropertyName.substring(1);
                DomProperty fakeProperty = attributes.get(fakePropertyName);
                if (fakeProperty == null) continue;
                fakeProperty.setAttributeName(realPropertyName);
                headerProperties.add(fakeProperty);
            }
            this.writeProperties(varName + "?.header()", objectName + "_headerView", "QHeaderView", (List<DomProperty>)headerProperties, Flag.WritePropertyIgnoreObjectName.value());
        } else if (cwi.extendsOneOf(className, Arrays.asList("QTableView", "QTableWidget"))) {
            for (String headerPrefix : headerPrefixes) {
                ArrayList<DomProperty> headerProperties = new ArrayList<DomProperty>();
                for (String realPropertyName : realPropertyNames) {
                    String fakePropertyName = headerPrefix + Character.toLowerCase(realPropertyName.charAt(0)) + realPropertyName.substring(1);
                    DomProperty fakeProperty = attributes.get(fakePropertyName);
                    if (fakeProperty == null) continue;
                    fakeProperty.setAttributeName(realPropertyName);
                    headerProperties.add(fakeProperty);
                }
                String headerVar = varName + "?." + headerPrefix + "()";
                this.writeProperties(headerVar, objectName + "_" + headerPrefix, "QHeaderView", headerProperties, Flag.WritePropertyIgnoreObjectName.value());
            }
        }
        if (node.elementLayout().isEmpty()) {
            this.m_layoutChain.pop();
        }
        QStringList zOrder = node.elementZOrder();
        for (String name : zOrder) {
            String _varName = this.m_driver.widgetVariableName(name);
            if (_varName.isEmpty()) {
                System.err.println(String.format("%1$s: Warning: Z-order assignment: '%2$s' is not a valid widget.", this.m_option.messagePrefix(), name));
                continue;
            }
            this.m_output.append(this.m_indent).append(_varName).append("?.raise_()").endl();
        }
    }

    @Override
    public void acceptLayout(DomLayout node) {
        String className = node.attributeClass();
        String varName = this.m_driver.findOrInsertLayout(node);
        String objectName = node.attributeName();
        Map<String, DomProperty> properties = Utils.propertyMap(node.elementProperty());
        boolean oldLayoutProperties = properties.get("margin") != null;
        boolean isGroupBox = false;
        this.m_output.append(this.m_indent).append(varName).append(" = ").append(className).append('(');
        if (this.m_layoutChain.top() == null && !isGroupBox) {
            this.m_output.append(this.m_driver.findOrInsertWidget((DomWidget)this.m_widgetChain.top()));
        }
        this.m_output.append(")").endl();
        boolean suppressMarginDefault = this.m_layoutChain.top() != null;
        int marginType = Enum.Use43UiFile.value();
        if (oldLayoutProperties) {
            marginType = this.m_layoutMarginType.value();
        }
        this.m_LayoutDefaultHandler.writeProperties(this.m_indent, varName, properties, marginType, suppressMarginDefault, this.m_output);
        this.m_layoutMarginType = Enum.SubLayoutMargin;
        QList<DomProperty> propList = node.elementProperty();
        ArrayList<DomProperty> newPropList = new ArrayList<DomProperty>();
        if (this.m_layoutWidget) {
            DomProperty p;
            boolean bottom = false;
            boolean right = false;
            boolean top = false;
            boolean left = false;
            for (DomProperty p2 : propList) {
                String propertyName = p2.attributeName();
                if ("leftMargin".equals(propertyName) && p2.kind() == DomProperty.Kind.Number) {
                    left = true;
                    continue;
                }
                if ("topMargin".equals(propertyName) && p2.kind() == DomProperty.Kind.Number) {
                    top = true;
                    continue;
                }
                if ("rightMargin".equals(propertyName) && p2.kind() == DomProperty.Kind.Number) {
                    right = true;
                    continue;
                }
                if (!"bottomMargin".equals(propertyName) || p2.kind() != DomProperty.Kind.Number) continue;
                bottom = true;
            }
            if (!left) {
                p = new DomProperty();
                p.setAttributeName("leftMargin");
                p.setElementNumber(0);
                newPropList.add(p);
            }
            if (!top) {
                p = new DomProperty();
                p.setAttributeName("topMargin");
                p.setElementNumber(0);
                newPropList.add(p);
            }
            if (!right) {
                p = new DomProperty();
                p.setAttributeName("rightMargin");
                p.setElementNumber(0);
                newPropList.add(p);
            }
            if (!bottom) {
                p = new DomProperty();
                p.setAttributeName("bottomMargin");
                p.setElementNumber(0);
                newPropList.add(p);
            }
            this.m_layoutWidget = false;
        }
        propList.addAll(newPropList);
        this.writeProperties(varName, objectName, className, (List<DomProperty>)propList, Flag.WritePropertyIgnoreMargin.value() | Flag.WritePropertyIgnoreSpacing.value());
        propList.clear();
        newPropList.clear();
        this.m_layoutChain.push((Object)node);
        super.acceptLayout(node);
        this.m_layoutChain.pop();
        String numberNull = "0";
        this.writePropertyList(varName, "setStretch", node.attributeStretch(), numberNull);
        this.writePropertyList(varName, "setRowStretch", node.attributeRowStretch(), numberNull);
        this.writePropertyList(varName, "setColumnStretch", node.attributeColumnStretch(), numberNull);
        this.writePropertyList(varName, "setColumnMinimumWidth", node.attributeColumnMinimumWidth(), numberNull);
        this.writePropertyList(varName, "setRowMinimumHeight", node.attributeRowMinimumHeight(), numberNull);
    }

    private static String formLayoutRole(int column, int colspan) {
        if (colspan > 1) {
            return "QFormLayout.ItemRole.SpanningRole";
        }
        return column == 0 ? "QFormLayout.ItemRole.LabelRole" : "QFormLayout.ItemRole.FieldRole";
    }

    private static String layoutAddMethod(DomLayoutItem.Kind kind, String layoutClass) {
        String methodPrefix = "QFormLayout".equals(layoutClass) ? "set" : "add";
        switch (kind) {
            case Widget: {
                return methodPrefix + "Widget";
            }
            case Layout: {
                return methodPrefix + "Layout";
            }
            case Spacer: {
                return methodPrefix + "Item";
            }
        }
        return "";
    }

    static String toolbarArea(int v) {
        switch (v) {
            case 0: {
                return "NoToolBarArea";
            }
            case 1: {
                return "LeftToolBarArea";
            }
            case 2: {
                return "RightToolBarArea";
            }
            case 4: {
                return "TopToolBarArea";
            }
            case 8: {
                return "BottomToolBarArea";
            }
            case 15: {
                return "AllToolBarAreas";
            }
        }
        return "NoToolBarArea";
    }

    String toolBarAreaStringFromDOMAttributes(Map<String, DomProperty> attributes) {
        DomProperty pstyle = attributes.get("toolBarArea");
        String result = "";
        if (pstyle == null) {
            return "";
        }
        switch (pstyle.kind()) {
            case Number: {
                result = WriteInitialization.toolbarArea(pstyle.elementNumber());
                break;
            }
            case Enum: {
                result = pstyle.elementEnum();
                break;
            }
        }
        result = !result.startsWith("Qt::") ? "Qt.ToolBarArea." + result : "Qt.ToolBarArea." + result.substring(4);
        return result + ", ";
    }

    void writeSpacerItem(DomSpacer node, QTextStream output) {
        String orientation;
        String value;
        DomSize sizeHint;
        Map<String, DomProperty> properties = Utils.propertyMap(node.elementProperty());
        output.append("QSpacerItem(");
        int w = 0;
        int h = 0;
        DomProperty sh = properties.get("sizeHint");
        if (sh != null && (sizeHint = sh.elementSize()) != null) {
            w = sizeHint.elementWidth();
            h = sizeHint.elementHeight();
        }
        output.append(w).append(", ").append(h).append(", ");
        DomProperty st = properties.get("sizeType");
        String sizeType = st != null ? ((value = st.elementEnum()).startsWith("QSizePolicy::") ? value.replace("QSizePolicy::", "QSizePolicy.Policy.") : "QSizePolicy.Policy." + value) : "QSizePolicy.Policy.Expanding";
        boolean isVspacer = false;
        DomProperty o = properties.get("orientation");
        if (o != null && ("Qt::Vertical".equals(orientation = o.elementEnum()) || "Vertical".equals(orientation))) {
            isVspacer = true;
        }
        String horizType = isVspacer ? "QSizePolicy.Policy.Minimum" : sizeType;
        String vertType = isVspacer ? sizeType : "QSizePolicy.Policy.Minimum";
        output.append(horizType).append(", ").append(vertType).append(')');
    }

    @Override
    public void acceptSpacer(DomSpacer node) {
        this.m_output.append(this.m_indent).append(this.m_driver.findOrInsertSpacer(node)).append(" = ");
        this.writeSpacerItem(node, this.m_output);
        this.m_output.append(';').endl();
    }

    @Override
    public void acceptLayoutItem(DomLayoutItem node) {
        super.acceptLayoutItem(node);
        DomLayout layout = (DomLayout)this.m_layoutChain.top();
        if (layout == null) {
            return;
        }
        String layoutName = this.m_driver.findOrInsertLayout(layout);
        String itemName = this.m_driver.findOrInsertLayoutItem(node);
        this.m_output.endl().append(this.m_indent).append(layoutName).append("?.").append(WriteInitialization.layoutAddMethod(node.kind(), layout.attributeClass())).append('(');
        if ("QGridLayout".equals(layout.attributeClass())) {
            int row = node.attributeRow();
            int col = node.attributeColumn();
            int rowSpan = node.hasAttributeRowSpan() ? node.attributeRowSpan() : 1;
            int colSpan = node.hasAttributeColSpan() ? node.attributeColSpan() : 1;
            this.m_output.append(itemName).append(", ").append(row).append(", ").append(col).append(", ").append(rowSpan).append(", ").append(colSpan);
            if (!node.attributeAlignment().isEmpty()) {
                this.m_output.append(", ").append(node.attributeAlignment().replace("::", "."));
            }
        } else if ("QFormLayout".equals(layout.attributeClass())) {
            int row = node.attributeRow();
            int colSpan = node.hasAttributeColSpan() ? node.attributeColSpan() : 1;
            String role = WriteInitialization.formLayoutRole(node.attributeColumn(), colSpan);
            this.m_output.append(row).append(", ").append(role.replace("::", ".")).append(", ").append(itemName);
        } else {
            this.m_output.append(itemName);
            if (layout.attributeClass().contains("Box") && !node.attributeAlignment().isEmpty()) {
                this.m_output.append(", 0, ").append(node.attributeAlignment().replace("::", "."));
            }
        }
        this.m_output.append(")").endl();
    }

    @Override
    public void acceptActionGroup(DomActionGroup node) {
        String varName = this.m_driver.findOrInsertActionGroup(node);
        String objectName = node.attributeName();
        String parentName = this.m_driver.findOrInsertWidget((DomWidget)this.m_widgetChain.top());
        if (this.m_actionGroupChain.top() != null) {
            parentName = this.m_driver.findOrInsertActionGroup((DomActionGroup)this.m_actionGroupChain.top());
        }
        this.m_output.append(this.m_indent).append(varName).append(" = QActionGroup(").append(parentName).append(")").endl();
        this.writeProperties(varName, objectName, "QActionGroup", (List<DomProperty>)node.elementProperty());
        this.m_actionGroupChain.push((Object)node);
        super.acceptActionGroup(node);
        this.m_actionGroupChain.pop();
    }

    @Override
    public void acceptAction(DomAction node) {
        if (node.hasAttributeMenu()) {
            return;
        }
        String varName = this.m_driver.findOrInsertAction(node);
        String objectName = node.attributeName();
        String parentName = this.m_driver.findOrInsertWidget((DomWidget)this.m_widgetChain.top());
        if (this.m_actionGroupChain.top() != null) {
            parentName = this.m_driver.findOrInsertActionGroup((DomActionGroup)this.m_actionGroupChain.top());
        }
        this.m_output.append(this.m_indent).append(varName).append(" = QAction(").append(parentName).append(")").endl();
        this.writeProperties(varName, objectName, "QAction", (List<DomProperty>)node.elementProperty());
    }

    @Override
    public void acceptActionRef(DomActionRef node) {
        String actionName = node.attributeName();
        if (actionName.isEmpty() || this.m_widgetChain.top() == null || this.m_driver.actionGroupByName(actionName) != null) {
            return;
        }
        String varName = this.m_driver.findOrInsertWidget((DomWidget)this.m_widgetChain.top());
        if (this.m_widgetChain.top() != null && "separator".equals(actionName)) {
            this.m_actionOut.append(this.m_indent).append(varName).append("?.addSeparator()").endl();
            return;
        }
        DomWidget domWidget = this.m_driver.widgetByName(actionName);
        if (domWidget != null && this.m_uic.isMenu(domWidget.attributeClass())) {
            this.m_actionOut.append(this.m_indent).append(varName).append("?.addAction(").append(this.m_driver.findOrInsertWidget(domWidget)).append("?.menuAction())").endl();
            return;
        }
        DomAction domAction = this.m_driver.actionByName(actionName);
        if (domAction == null) {
            System.err.println(this.m_option.messagePrefix() + ": Warning: action `" + actionName + "' not declared");
            return;
        }
        this.m_actionOut.append(this.m_indent).append(varName).append("?.addAction(").append(this.m_driver.findOrInsertAction(domAction)).append(")").endl();
    }

    @Override
    public void acceptTabStops(DomTabStops tabStops) {
        String lastName = "";
        QStringList l = tabStops.elementTabStop();
        for (int i = 0; i < l.size(); ++i) {
            String name = this.m_driver.widgetVariableName((String)l.at(i));
            if (name.isEmpty()) {
                System.err.println(this.m_option.messagePrefix() + ": Warning: Tab-stop assignment: `" + (String)l.at(i) + "' is not a valid widget.");
                continue;
            }
            if (i == 0) {
                lastName = name;
                continue;
            }
            if (name.isEmpty() || lastName.isEmpty()) continue;
            this.m_output.append(this.m_indent).append("QWidget.setTabOrder(").append(lastName).append(", ").append(name).append(")").endl();
            lastName = name;
        }
    }

    @Override
    public void acceptCustomWidgets(DomCustomWidgets node) {
    }

    @Override
    public void acceptCustomWidget(DomCustomWidget node) {
    }

    @Override
    public void acceptLayoutDefault(DomLayoutDefault node) {
        this.m_LayoutDefaultHandler.acceptLayoutDefault(node);
    }

    @Override
    public void acceptLayoutFunction(DomLayoutFunction node) {
        this.m_LayoutDefaultHandler.acceptLayoutFunction(node);
    }

    @Override
    public void acceptConnection(DomConnection connection) {
        String senderName = connection.elementSender();
        String receiverName = connection.elementReceiver();
        Declaration senderDecl = this.findDeclaration(senderName);
        Declaration receiverDecl = this.findDeclaration(receiverName);
        if (senderDecl.name.isEmpty() || receiverDecl.name.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append(this.m_option.messagePrefix()).append(": Warning: Invalid signal/slot connection: \"").append(senderName).append("\" . \"").append(receiverName).append("\".");
            System.err.println(message);
            return;
        }
        String senderSignature = connection.elementSignal();
        CustomWidgetsInfo.MethodInfo methodInfo = this.m_uic.customWidgetsInfo().methodInfo(senderDecl.className, senderSignature, true);
        SignalSlot theSignal = new SignalSlot(senderDecl.name, senderSignature, senderDecl.className, methodInfo.metaMethod, methodInfo.method, methodInfo.isAmbiguous);
        methodInfo = this.m_uic.customWidgetsInfo().methodInfo(receiverDecl.className, connection.elementSlot(), false);
        SignalSlot theSlot = new SignalSlot(receiverDecl.name, connection.elementSlot(), receiverDecl.className, methodInfo.metaMethod, methodInfo.method, methodInfo.isAmbiguous);
        this.m_output.append(this.m_indent);
        this.formatConnection(this.m_output, theSignal, theSlot);
        this.m_output.append(';').endl();
    }

    private static String domColor2QString(DomColor c) {
        if (c.hasAttributeAlpha()) {
            return String.format("QColor(%1$s, %2$s, %3$s, %4$s)", c.elementRed(), c.elementGreen(), c.elementBlue(), c.attributeAlpha());
        }
        return String.format("QColor(%1$s, %2$s, %3$s)", c.elementRed(), c.elementGreen(), c.elementBlue());
    }

    public static QVersionNumber colorRoleVersionAdded(String roleName) {
        if ("PlaceholderText".equals(roleName)) {
            return new QVersionNumber(5, 12, 0);
        }
        return new QVersionNumber();
    }

    private String iconCall(DomProperty icon) {
        if (icon.kind() == DomProperty.Kind.IconSet) {
            return this.writeIconProperties(icon.elementIconSet());
        }
        return this.pixCall(icon);
    }

    private String pixCall(DomProperty p) {
        String s;
        String type;
        switch (p.kind()) {
            case IconSet: {
                type = "QIcon";
                s = p.elementIconSet().text();
                break;
            }
            case Pixmap: {
                type = "QPixmap";
                s = p.elementPixmap().text();
                break;
            }
            default: {
                QLogging.qWarning((String)"%s: Warning: Unknown icon format encountered. The ui-file was generated with a too-recent version of Designer.", (Object[])new Object[]{this.m_option.messagePrefix()});
                return "QIcon()";
            }
        }
        return this.pixCall(type, s);
    }

    private String pixCall(String t, String text) {
        if (text.isEmpty()) {
            return "" + t + "()";
        }
        StringBuilder str = new StringBuilder();
        str.append("");
        str.append(t);
        str.append("(");
        String pixFunc = this.m_uic.pixmapFunction();
        if (pixFunc.isEmpty()) {
            str.append(WriteInitialization.formatString(text));
        } else {
            str.append(pixFunc).append('(').append(WriteInitialization.formatString(text)).append(')');
        }
        str.append(')');
        return str.toString();
    }

    private String trCall(String str, String comment) {
        return this.trCall(str, comment, "");
    }

    private String trCall(String str, String commentHint, String id) {
        if (str.isEmpty()) {
            return "\"\"";
        }
        StringBuilder result = new StringBuilder();
        boolean idBasedTranslations = this.m_driver.useIdBasedTranslations();
        if (this.m_option.translateFunction.isEmpty()) {
            result.append("io.qt.core.QCoreApplication.translate(").append('\"').append(this.m_generatedClass.replace("::", ".")).append("\", ");
        } else {
            result.append(this.m_option.translateFunction).append('(');
        }
        result.append(WriteInitialization.formatString(idBasedTranslations ? id : str));
        if (!idBasedTranslations && !this.m_option.idBased) {
            result.append(", ");
            if (commentHint.isEmpty()) {
                result.append("null");
            } else {
                result.append(WriteInitialization.formatString(commentHint));
            }
        }
        result.append(')');
        return result.toString();
    }

    private String trCall(DomString str) {
        return this.trCall(str, "");
    }

    private String trCall(DomString str, String defaultString) {
        String value = defaultString;
        String comment = "";
        String id = "";
        if (str != null) {
            value = Utils.toString(str);
            comment = str.attributeComment();
            id = str.attributeId();
        }
        return this.trCall(value, comment, id);
    }

    private String noTrCall(DomString str) {
        return this.noTrCall(str, "");
    }

    private String noTrCall(DomString str, String defaultString) {
        String value = defaultString;
        if (str == null && defaultString.isEmpty()) {
            return "";
        }
        if (str != null) {
            value = str.text();
        }
        StringBuilder ret = new StringBuilder();
        ret.append(WriteInitialization.formatString(value));
        return ret.toString();
    }

    private String autoTrCall(DomString str) {
        return this.autoTrCall(str, "");
    }

    private String autoTrCall(DomString str, String defaultString) {
        if (str != null && !defaultString.isEmpty() || WriteInitialization.needsTranslation(str)) {
            return this.trCall(str, defaultString);
        }
        return this.noTrCall(str, defaultString);
    }

    private static boolean needsTranslation(DomStringList element) {
        if (element == null) {
            return false;
        }
        return !element.hasAttributeNotr() || !Boolean.parseBoolean(element.attributeNotr());
    }

    private static boolean needsTranslation(DomString element) {
        if (element == null) {
            return false;
        }
        return !element.hasAttributeNotr() || !Boolean.parseBoolean(element.attributeNotr());
    }

    private QTextStream autoTrOutput(DomProperty property) {
        DomString str = property.elementString();
        if (str != null) {
            return this.autoTrOutput(str);
        }
        DomStringList list = property.elementStringList();
        if (list != null && WriteInitialization.needsTranslation(list)) {
            return this.m_refreshOut;
        }
        return this.m_output;
    }

    private QTextStream autoTrOutput(DomString str) {
        return this.autoTrOutput(str, "");
    }

    private QTextStream autoTrOutput(DomString str, String defaultString) {
        if (str != null && !defaultString.isEmpty() || WriteInitialization.needsTranslation(str)) {
            return this.m_refreshOut;
        }
        return this.m_output;
    }

    private void writePropertyList(String varName, String setFunction, String value, String defaultValue) {
        if (value.isEmpty()) {
            return;
        }
        String[] list = value.split(",");
        int count = list.length;
        for (int i = 0; i < count; ++i) {
            if (list[i].equals(defaultValue)) continue;
            this.m_output.append(this.m_indent).append(varName).append('.').append(setFunction).append('(').append(i).append(", ").append(list[i]).append(")").endl();
        }
    }

    private String writeStringListProperty(DomStringList list) {
        StringBuilder propertyValue = new StringBuilder();
        propertyValue.append("QStringList(");
        QStringList values = list.elementString();
        if (values.isEmpty()) {
            return propertyValue.toString();
        }
        if (WriteInitialization.needsTranslation(list)) {
            String comment = list.attributeComment();
            for (int i = 0; i < values.size(); ++i) {
                if (i != 0) {
                    propertyValue.append(", ");
                }
                propertyValue.append('\n').append(this.m_indent).append("   ").append(this.trCall((String)values.at(i), comment));
            }
        } else {
            for (int i = 0; i < values.size(); ++i) {
                if (i != 0) {
                    propertyValue.append(", ");
                }
                propertyValue.append(WriteInitialization.formatString((String)values.at(i)));
            }
        }
        return propertyValue.toString();
    }

    private void writeProperties(String varName, String objectName, String className, List<DomProperty> lst) {
        this.writeProperties(varName, objectName, className, lst, 0);
    }

    private static boolean checkProperty(CustomWidgetsInfo customWidgetsInfo, String fileName, String className, DomProperty p) {
        switch (p.kind()) {
            case Set: {
                if (!"features".equals(p.attributeName()) || !customWidgetsInfo._extends(className, "QDockWidget") || !"QDockWidget::AllDockWidgetFeatures".equals(p.elementSet())) break;
                String msg = fileName + ": Warning: Deprecated enum value QDockWidget::AllDockWidgetFeatures was encountered.";
                QLogging.qWarning((String)"%s", (Object[])new Object[]{msg});
                return false;
            }
            case Enum: {
                if (!"sizeAdjustPolicy".equals(p.attributeName()) || !customWidgetsInfo._extends(className, "QComboBox") || !"QComboBox::AdjustToMinimumContentsLength".equals(p.elementEnum())) break;
                String msg = fileName + ": Warning: Deprecated enum value QComboBox::AdjustToMinimumContentsLength was encountered.";
                QLogging.qWarning((String)"%s", (Object[])new Object[]{msg});
                return false;
            }
            case IconSet: {
                DomResourceIcon dri = p.elementIconSet();
                if (dri == null || WriteInitialization.isIconFormat44(dri) || !dri.text().isEmpty()) break;
                String msg = String.format("%1$s: Warning: An invalid icon property '%2$s' was encountered.", fileName, p.attributeName());
                QLogging.qWarning((String)"%s", (Object[])new Object[]{msg});
                return false;
            }
            case Pixmap: {
                DomResourcePixmap drp = p.elementPixmap();
                if (drp == null || !drp.text().isEmpty()) break;
                String msg = String.format("%1: Warning: An invalid pixmap property '%2' was encountered.", fileName, p.attributeName());
                QLogging.qWarning((String)"%s", (Object[])new Object[]{msg});
                return false;
            }
        }
        return true;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void writeProperties(String varName, String objectName, String className, List<DomProperty> lst, int flags) {
        v0 = isTopLevel = this.m_widgetChain.count() == 1;
        if (this.m_uic.customWidgetsInfo()._extends(className, "QAxWidget") && (p = (properties = Utils.propertyMap(lst)).get("control")) != null) {
            this.m_output.append(this.m_indent).append(varName).append("?.setControl(").append(WriteInitialization.formatString(Utils.toString(p.elementString()))).append(")").endl();
        }
        indent = "";
        if (this.m_widgetChain.top() == null) {
            indent = this.m_option.indent;
            this.m_output.append(this.m_indent).append("if (").append(varName).append("?.objectName().isEmpty())\n");
        }
        if (0 == (flags & Flag.WritePropertyIgnoreObjectName.value())) {
            if (objectName.startsWith("this.")) {
                objectName = objectName.substring(5);
            }
            this.m_output.append(this.m_indent).append(indent).append(varName).append("?.setObjectName(").append(WriteInitialization.formatString(objectName)).append(")").endl();
        }
        bottomMargin = -1;
        rightMargin = -1;
        topMargin = -1;
        leftMargin = -1;
        frameShadowEncountered = false;
        for (DomProperty p : lst) {
            if (!WriteInitialization.checkProperty(this.m_uic.customWidgetsInfo(), this.m_option.inputFile, className, p)) continue;
            propertyName = p.attributeName();
            propertyValue = "";
            delayProperty = false;
            if (isTopLevel && "geometry".equals(propertyName) && p.elementRect() != null) {
                r = p.elementRect();
                this.m_output.append(this.m_indent).append(varName).append("?.resize(").append(r.elementWidth()).append(", ").append(r.elementHeight()).append(")").endl();
                continue;
            }
            if (propertyName.equals("currentRow") && this.m_uic.customWidgetsInfo()._extends(className, "QListWidget")) {
                this.m_delayedOut.append(this.m_indent).append(varName).append("?.setCurrentRow(").append(p.elementNumber()).append(")").endl();
                continue;
            }
            if (propertyName.equals("currentIndex") && this.m_uic.customWidgetsInfo().extendsOneOf(className, (List<String>)WriteInitialization.currentIndexWidgets)) {
                this.m_delayedOut.append(this.m_indent).append(varName).append("?.setCurrentIndex(").append(p.elementNumber()).append(")").endl();
                continue;
            }
            if (propertyName.equals("tabSpacing") && this.m_uic.customWidgetsInfo()._extends(className, "QToolBox")) {
                this.m_delayedOut.append(this.m_indent).append(varName).append("?.layout().setSpacing(").append(p.elementNumber()).append(")").endl();
                continue;
            }
            if (propertyName.equals("control") && this.m_uic.customWidgetsInfo()._extends(className, "QAxWidget")) continue;
            if (propertyName.equals("default") && this.m_uic.customWidgetsInfo()._extends(className, "QPushButton")) {
                delayProperty = true;
            } else {
                if (propertyName.equals("database") && p.elementStringList() != null || propertyName.equals("frameworkCode") && p.kind() == DomProperty.Kind.Bool) continue;
                if (propertyName.equals("orientation") && this.m_uic.customWidgetsInfo()._extends(className, "Line")) {
                    shape = "QFrame.Shape.HLine";
                    if (p.elementEnum().equals("Qt.Orientation.Vertical")) {
                        shape = "QFrame.Shape.VLine";
                    }
                    this.m_output.append(this.m_indent).append(varName).append("?.setFrameShape(").append(shape).append(")").endl();
                    if (frameShadowEncountered) continue;
                    this.m_output.append(this.m_indent).append(varName).append("?.setFrameShadow(QFrame.Shadow.Sunken)").endl();
                    continue;
                }
                if ((flags & Flag.WritePropertyIgnoreMargin.value()) != 0 && propertyName.equals("margin") || (flags & Flag.WritePropertyIgnoreSpacing.value()) != 0 && propertyName.equals("spacing")) continue;
                if (propertyName.equals("leftMargin") && p.kind() == DomProperty.Kind.Number) {
                    leftMargin = p.elementNumber();
                    continue;
                }
                if (propertyName.equals("topMargin") && p.kind() == DomProperty.Kind.Number) {
                    topMargin = p.elementNumber();
                    continue;
                }
                if (propertyName.equals("rightMargin") && p.kind() == DomProperty.Kind.Number) {
                    rightMargin = p.elementNumber();
                    continue;
                }
                if (propertyName.equals("bottomMargin") && p.kind() == DomProperty.Kind.Number) {
                    bottomMargin = p.elementNumber();
                    continue;
                }
                if (propertyName.equals("numDigits") && this.m_uic.customWidgetsInfo()._extends(className, "QLCDNumber")) {
                    QLogging.qWarning((String)"Widget '%s': Deprecated property QLCDNumber::numDigits encountered. It has been replaced by QLCDNumber::digitCount.", (Object[])new Object[]{varName});
                    propertyName = "digitCount";
                } else if (propertyName.equals("frameShadow")) {
                    frameShadowEncountered = true;
                }
            }
            stdset = this.m_stdsetdef;
            if (p.hasAttributeStdset()) {
                stdset = p.attributeStdset() != 0;
            }
            setFunction = new StringBuilder();
            if (stdset) {
                setFunction.append("?.set").append(Character.toUpperCase(propertyName.charAt(0))).append(propertyName.substring(1)).append('(');
            } else {
                setFunction.append("?.setProperty(\"").append(propertyName).append("\", ");
            }
            varNewName = varName;
            switch (1.$SwitchMap$io$qt$uic$ui4$DomProperty$Kind[p.kind().ordinal()]) {
                case 6: {
                    propertyValue = "" + Boolean.parseBoolean(p.elementBool());
                    break;
                }
                case 7: {
                    propertyValue = WriteInitialization.domColor2QString(p.elementColor());
                    break;
                }
                case 8: {
                    if (propertyName.equals("buddy") && this.m_uic.customWidgetsInfo()._extends(className, "QLabel")) {
                        buddy = new Buddy(varName, p.elementCstring());
                        this.m_buddies.add(buddy);
                        break;
                    }
                    str = new StringBuilder();
                    if (!stdset) {
                        str.append("QByteArray(");
                    }
                    str.append(WriteInitialization.formatString(p.elementCstring()));
                    if (!stdset) {
                        str.append(')');
                    }
                    propertyName = str.toString();
                    break;
                }
                case 9: {
                    propertyValue = String.format("QCursor(Qt.CursorShape.%1$s)", new Object[]{Qt.CursorShape.resolve((int)p.elementCursor()).name()});
                    break;
                }
                case 10: {
                    if (p.hasAttributeStdset() && p.attributeStdset() == 0) {
                        varNewName = varNewName + "?.viewport()";
                    }
                    propertyValue = String.format("QCursor(Qt.CursorShape.%1$s)", new Object[]{p.elementCursorShape()});
                    break;
                }
                case 2: {
                    propertyValue = p.elementEnum();
                    idx = propertyValue.lastIndexOf("::");
                    if (idx <= 0) ** GOTO lbl149
                    ns = propertyValue.substring(0, idx);
                    enm /* !! */  = propertyValue.substring(idx + 2);
                    qual = ClassInfoEntries.classToJavaQualifier(ns);
                    propertyValue = null;
                    if (qual != null) {
                        try {
                            cls = Class.forName(qual);
                            for (Class<?> ecl : cls.getDeclaredClasses()) {
                                if (!ecl.isEnum()) continue;
                                e = null;
                                try {
                                    e = (java.lang.Enum)java.lang.Enum.valueOf(ecl, (String)enm /* !! */ );
                                }
                                catch (IllegalArgumentException var31_60) {
                                    // empty catch block
                                }
                                if (e == null) continue;
                                propertyValue = ecl.getName().replace('$', '.') + '.' + e.name();
                                if (cls.getPackage() != null && !cls.getPackage().getName().isEmpty()) {
                                    propertyValue = propertyValue.substring(cls.getPackage().getName().length() + 1);
                                }
                                break;
                            }
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                    if (propertyValue != null) break;
                    propertyValue = ns.replace("::", ".") + "." + (String)enm /* !! */ ;
                    break;
lbl149:
                    // 1 sources

                    propertyValue = propertyValue.replace("::", ".");
                    break;
                }
                case 5: {
                    flagList = new ArrayList<String>();
                    enumClass = null;
                    for (String _flg : p.elementSet().split("\\|")) {
                        idx = _flg.lastIndexOf("::");
                        if (idx <= 0) ** GOTO lbl198
                        ns = _flg.substring(0, idx);
                        enm = _flg.substring(idx + 2);
                        qual = ClassInfoEntries.classToJavaQualifier(ns);
                        _flg = null;
                        if (qual == null) continue;
                        try {
                            if (enumClass != null) ** GOTO lbl180
                            cls = Class.forName(qual);
                            for (Class<?> ecl : cls.getDeclaredClasses()) {
                                if (!ecl.isEnum()) continue;
                                e = null;
                                try {
                                    e = (java.lang.Enum)java.lang.Enum.valueOf(ecl, enm);
                                }
                                catch (IllegalArgumentException var37_68) {
                                    // empty catch block
                                }
                                if (e == null) continue;
                                _flg = ecl.getName().replace('$', '.') + '.' + e.name();
                                enumClass = ecl;
                                if (cls.getPackage() != null && !cls.getPackage().getName().isEmpty()) {
                                    _flg = _flg.substring(cls.getPackage().getName().length() + 1);
                                }
                                ** GOTO lbl193
                            }
                            ** GOTO lbl193
lbl180:
                            // 1 sources

                            e = null;
                            try {
                                e = (java.lang.Enum)java.lang.Enum.valueOf(enumClass, enm);
                            }
                            catch (IllegalArgumentException var32_63) {
                                // empty catch block
                            }
                            if (e != null) {
                                _flg = enumClass.getName().replace('$', '.') + '.' + e.name();
                                if (enumClass.getDeclaringClass().getPackage() != null && !enumClass.getDeclaringClass().getPackage().getName().isEmpty()) {
                                    _flg = _flg.substring(enumClass.getDeclaringClass().getPackage().getName().length() + 1);
                                }
                            }
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
lbl193:
                        // 4 sources

                        if (_flg == null) {
                            _flg = ns.replace("::", ".") + "." + enm;
                        }
                        flagList.add(_flg);
                        continue;
lbl198:
                        // 1 sources

                        flagList.add(_flg.replace("::", "."));
                    }
                    propertyValue = String.join((CharSequence)", ", flagList);
                    if (enumClass == null) break;
                    try {
                        if (!Modifier.isStatic(enumClass.getMethod("flags", new Class[]{Array.newInstance(enumClass, 0).getClass()}).getModifiers())) break;
                        propertyValue = enumClass.getName().replace('$', '.') + ".flags(" + propertyValue + ")";
                        if (enumClass.getDeclaringClass().getPackage() == null || enumClass.getDeclaringClass().getPackage().getName().isEmpty()) break;
                        propertyValue = propertyValue.substring(enumClass.getDeclaringClass().getPackage().getName().length() + 1);
                    }
                    catch (Exception enm) {}
                    break;
                }
                case 11: {
                    propertyValue = this.writeFontProperties(p.elementFont());
                    break;
                }
                case 3: {
                    propertyValue = this.writeIconProperties(p.elementIconSet());
                    break;
                }
                case 4: {
                    propertyValue = this.pixCall(p);
                    break;
                }
                case 12: {
                    pal = p.elementPalette();
                    paletteName = this.m_driver.unique("palette");
                    this.m_output.append(this.m_indent).append("var ").append(paletteName).append(" = QPalette()").endl();
                    this.writeColorGroup(pal.elementActive(), "QPalette.ColorGroup.Active", paletteName);
                    this.writeColorGroup(pal.elementInactive(), "QPalette.ColorGroup.Inactive", paletteName);
                    this.writeColorGroup(pal.elementDisabled(), "QPalette.ColorGroup.Disabled", paletteName);
                    propertyValue = paletteName;
                    break;
                }
                case 13: {
                    po = p.elementPoint();
                    propertyValue = String.format("QPoint(%1$s, %2$s)", new Object[]{po.elementX(), po.elementY()});
                    break;
                }
                case 14: {
                    pof = p.elementPointF();
                    propertyValue = String.format("QPointF(%1$s, %2$s)", new Object[]{pof.elementX(), pof.elementY()});
                    break;
                }
                case 15: {
                    r = p.elementRect();
                    propertyValue = String.format("QRect(%1$s, %2$s, %3$s, %4$s)", new Object[]{r.elementX(), r.elementY(), r.elementWidth(), r.elementHeight()});
                    break;
                }
                case 16: {
                    rf = p.elementRectF();
                    propertyValue = String.format("QRectF(%1$s, %2$s, %3$s, %4$s)", new Object[]{rf.elementX(), rf.elementY(), rf.elementWidth(), rf.elementHeight()});
                    break;
                }
                case 17: {
                    locale = p.elementLocale();
                    str = new StringBuilder();
                    str.append("QLocale(QLocale.Language.").append(locale.attributeLanguage()).append(", QLocale.Country.").append(locale.attributeCountry()).append(')');
                    propertyValue = str.toString();
                    break;
                }
                case 18: {
                    spName = this.writeSizePolicy(p.elementSizePolicy());
                    this.m_output.append(this.m_indent).append(spName).append("?.setHeightForWidth(").append(varName).append("?.sizePolicy().hasHeightForWidth())").endl();
                    propertyValue = spName;
                    break;
                }
                case 19: {
                    s = p.elementSize();
                    propertyValue = String.format("QSize(%1$s, %2$s)", new Object[]{s.elementWidth(), s.elementHeight()});
                    break;
                }
                case 20: {
                    sf = p.elementSizeF();
                    propertyValue = String.format("QSizeF(%1$s, %2$s)", new Object[]{sf.elementWidth(), sf.elementHeight()});
                    break;
                }
                case 21: {
                    if (propertyName.equals("objectName") && (v = p.elementString().text()).equals(varName)) break;
                    propertyValue = this.autoTrCall(p.elementString());
                    break;
                }
                case 1: {
                    propertyValue = "" + p.elementNumber();
                    break;
                }
                case 22: {
                    propertyValue = "" + p.elementUInt();
                    break;
                }
                case 23: {
                    propertyValue = p.elementLongLong() + "L";
                    break;
                }
                case 24: {
                    propertyValue = p.elementULongLong() + "L";
                    break;
                }
                case 25: {
                    propertyValue = Float.toString(p.elementFloat());
                    break;
                }
                case 26: {
                    propertyValue = Double.toString(p.elementDouble());
                    break;
                }
                case 27: {
                    c = p.elementChar();
                    textBuilder = new StringBuilder();
                    textBuilder.append('\'');
                    if (Character.UnicodeBlock.of(c.elementUnicode()) == Character.UnicodeBlock.BASIC_LATIN) {
                        textBuilder.appendCodePoint(c.elementUnicode());
                    } else {
                        hex = Integer.toHexString(c.elementUnicode()).toUpperCase();
                        textBuilder.append("\\u");
                        for (j = hex.length(); j < 4; ++j) {
                            textBuilder.append('0');
                        }
                        textBuilder.append(hex);
                    }
                    textBuilder.append('\'');
                    propertyValue = textBuilder.toString();
                    break;
                }
                case 28: {
                    d = p.elementDate();
                    propertyValue = String.format("QDate(%1$s, %2$s, %3$s)", new Object[]{d.elementYear(), d.elementMonth(), d.elementDay()});
                    break;
                }
                case 29: {
                    t = p.elementTime();
                    propertyValue = String.format("QTime(%1$s, %2$s, %3$s)", new Object[]{t.elementHour(), t.elementMinute(), t.elementSecond()});
                    break;
                }
                case 30: {
                    dt = p.elementDateTime();
                    propertyValue = String.format("QDateTime(new QDate(%1$s, %2$s, %3$s), new QTime(%4$s, %5$s, %6$s))", new Object[]{dt.elementYear(), dt.elementMonth(), dt.elementDay(), dt.elementHour(), dt.elementMinute(), dt.elementSecond()});
                    break;
                }
                case 31: {
                    propertyValue = this.writeStringListProperty(p.elementStringList());
                    break;
                }
                case 32: {
                    u = p.elementUrl();
                    _propertyValue = new StringBuilder();
                    _propertyValue.append("QUrl(").append(WriteInitialization.formatString(u.elementString().text())).append(")");
                    propertyValue = "" + propertyValue;
                    break;
                }
                case 33: {
                    propertyValue = this.writeBrushInitialization(p.elementBrush());
                    break;
                }
            }
            if (propertyValue.isEmpty()) continue;
            o = delayProperty != false ? this.m_delayedOut : this.autoTrOutput(p);
            o.append(this.m_indent).append(varNewName).append(setFunction.toString()).append(propertyValue).append(")").endl().flush();
        }
        if (leftMargin != -1 || topMargin != -1 || rightMargin != -1 || bottomMargin != -1) {
            this.m_output.append(this.m_indent).append(varName).append("?.setContentsMargins(").append(leftMargin).append(", ").append(topMargin).append(", ").append(rightMargin).append(", ").append(bottomMargin).append(")").endl();
        }
    }

    private void writeColorGroup(DomColorGroup colorGroup, String group, String paletteName) {
        if (colorGroup == null) {
            return;
        }
        QList<DomColor> colors = colorGroup.elementColor();
        for (int i = 0; i < colors.size(); ++i) {
            DomColor color = (DomColor)((Object)colors.get(i));
            this.m_output.append(this.m_indent).append(paletteName).append(".setColor(").append(group).append(", ").append("QPalette.ColorRole.").append(QPalette.ColorRole.resolve((int)i).name()).append(", ").append(WriteInitialization.domColor2QString(color)).append(")").endl();
        }
        QList<DomColorRole> colorRoles = colorGroup.elementColorRole();
        for (DomColorRole colorRole : colorRoles) {
            if (!colorRole.hasAttributeRole()) continue;
            String roleName = colorRole.attributeRole();
            String brushName = this.writeBrushInitialization(colorRole.elementBrush());
            this.m_output.append(this.m_indent).append(paletteName).append(".setBrush(").append(group).append(", QPalette.ColorRole.").append(roleName).append(", ").append(brushName).append(")").endl();
        }
    }

    private void writeBrush(DomBrush brush, String brushName) {
        String style = "SolidPattern";
        if (brush.hasAttributeBrushStyle()) {
            style = brush.attributeBrushStyle();
        }
        if (style.equals("LinearGradientPattern") || style.equals("RadialGradientPattern") || style.equals("ConicalGradientPattern")) {
            DomGradient gradient = brush.elementGradient();
            String gradientType = gradient.attributeType();
            String gradientName = this.m_driver.unique("gradient");
            if (gradientType.equals("LinearGradient")) {
                this.m_output.append(this.m_indent).append("var ").append(gradientName).append(" = QLinearGradient(").append(gradient.attributeStartX()).append(", ").append(gradient.attributeStartY()).append(", ").append(gradient.attributeEndX()).append(", ").append(gradient.attributeEndY()).append(")").endl();
            } else if (gradientType.equals("RadialGradient")) {
                this.m_output.append(this.m_indent).append("var ").append(gradientName).append(" = QRadialGradient(").append(gradient.attributeCentralX()).append(", ").append(gradient.attributeCentralY()).append(", ").append(gradient.attributeRadius()).append(", ").append(gradient.attributeFocalX()).append(", ").append(gradient.attributeFocalY()).append(")").endl();
            } else if (gradientType.equals("ConicalGradient")) {
                this.m_output.append(this.m_indent).append("var ").append(gradientName).append(" = QConicalGradient(").append(gradient.attributeCentralX()).append(", ").append(gradient.attributeCentralY()).append(", ").append(gradient.attributeAngle()).append(")").endl();
            }
            this.m_output.append(this.m_indent).append(gradientName).append(".setSpread(QGradient.").append(gradient.attributeSpread()).append(")").endl();
            if (gradient.hasAttributeCoordinateMode()) {
                this.m_output.append(this.m_indent).append(gradientName).append(".setCoordinateMode(QGradient.").append(gradient.attributeCoordinateMode()).append(")").endl();
            }
            QList<DomGradientStop> stops = gradient.elementGradientStop();
            for (DomGradientStop stop : stops) {
                DomColor color = stop.elementColor();
                this.m_output.append(this.m_indent).append(gradientName).append(".setColorAt(").append(stop.attributePosition()).append(", ").append(WriteInitialization.domColor2QString(color)).append(")").endl();
            }
            this.m_output.append(this.m_indent).append("var ").append(brushName).append(" = QBrush(").append(gradientName).append(")").endl();
        } else if (style.equals("TexturePattern")) {
            DomProperty property = brush.elementTexture();
            String iconValue = this.iconCall(property);
            this.m_output.append(this.m_indent).append("var ").append(brushName).append(" = QBrush(").append(iconValue).append(")").endl();
        } else {
            DomColor color = brush.elementColor();
            this.m_output.append(this.m_indent).append("var ").append(brushName).append(" = QBrush(").append(WriteInitialization.domColor2QString(color)).append(")").endl();
            this.m_output.append(this.m_indent).append(brushName).append(".setStyle(Qt.BrushStyle.SolidPattern").append(")").endl();
        }
    }

    private void addInitializer(Item item, String name, int column, String value) {
        this.addInitializer(item, name, column, value, "", false);
    }

    private void addInitializer(Item item, String name, int column, String value, String directive, boolean translatable) {
        if (!value.isEmpty()) {
            StringBuilder setter = new StringBuilder();
            setter.append("?.set").append(Character.toUpperCase(name.charAt(0))).append(name.substring(1)).append('(');
            if (column >= 0) {
                setter.append(column).append(", ");
            }
            setter.append(value).append(")");
            item.addSetter(setter.toString(), directive, translatable);
        }
    }

    private void addQtFlagsInitializer(Item item, Map<String, DomProperty> properties, String name) {
        this.addQtFlagsInitializer(item, properties, name, -1);
    }

    private void addQtFlagsInitializer(Item item, Map<String, DomProperty> properties, String name, int column) {
        DomProperty p = properties.get(name);
        if (p != null) {
            String orOperator = "|Qt.";
            String v = p.elementSet();
            if (!v.isEmpty()) {
                v = v.replace("|", orOperator);
                this.addInitializer(item, name, column, "Qt." + v);
            }
        }
    }

    private void addQtEnumInitializer(Item item, Map<String, DomProperty> properties, String name, int column) {
        String v;
        DomProperty p = properties.get(name);
        if (p != null && !(v = p.elementEnum()).isEmpty()) {
            this.addInitializer(item, name, column, "Qt." + v);
        }
    }

    private void addBrushInitializer(Item item, Map<String, DomProperty> properties, String name, int column) {
        DomProperty p = properties.get(name);
        if (p != null) {
            if (p.elementBrush() != null) {
                this.addInitializer(item, name, column, this.writeBrushInitialization(p.elementBrush()));
            } else if (p.elementColor() != null) {
                this.addInitializer(item, name, column, WriteInitialization.domColor2QString(p.elementColor()));
            }
        }
    }

    private void addStringInitializer(Item item, Map<String, DomProperty> properties, String name, int column) {
        this.addStringInitializer(item, properties, name, column, "");
    }

    private void addStringInitializer(Item item, Map<String, DomProperty> properties, String name, int column, String directive) {
        DomString str;
        String text;
        DomProperty p = properties.get(name);
        if (p != null && !(text = Utils.toString(str = p.elementString())).isEmpty()) {
            boolean translatable = WriteInitialization.needsTranslation(str);
            String value = this.autoTrCall(str);
            this.addInitializer(item, name, column, value, directive, translatable);
        }
    }

    private void addCommonInitializers(Item item, Map<String, DomProperty> properties) {
        this.addCommonInitializers(item, properties, -1);
    }

    private void addCommonInitializers(Item item, Map<String, DomProperty> properties, int column) {
        DomProperty icon = properties.get("icon");
        if (icon != null) {
            this.addInitializer(item, "icon", column, this.iconCall(icon));
        }
        this.addBrushInitializer(item, properties, "foreground", column);
        this.addBrushInitializer(item, properties, "background", column);
        DomProperty font = properties.get("font");
        if (font != null) {
            this.addInitializer(item, "font", column, this.writeFontProperties(font.elementFont()));
        }
        this.addQtFlagsInitializer(item, properties, "textAlignment", column);
        this.addQtEnumInitializer(item, properties, "checkState", column);
        this.addStringInitializer(item, properties, "text", column);
        this.addStringInitializer(item, properties, "toolTip", column, "tooltip");
        this.addStringInitializer(item, properties, "whatsThis", column, "whatsthis");
        this.addStringInitializer(item, properties, "statusTip", column, "statustip");
    }

    private void initializeMenu(DomWidget w, String parentWidget) {
        String menuName = this.m_driver.findOrInsertWidget(w);
        String menuAction = menuName + "Action";
        DomAction action = this.m_driver.actionByName(menuAction);
        if (action != null && action.hasAttributeMenu()) {
            this.m_output.append(this.m_indent).append(menuAction).append(" = ").append(menuName).append("?.menuAction()").endl();
        }
    }

    private void initializeComboBox(DomWidget w) {
        String varName = this.m_driver.findOrInsertWidget(w);
        QList<DomItem> items = w.elementItem();
        if (items.isEmpty()) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            DomItem item = (DomItem)((Object)items.get(i));
            Map<String, DomProperty> properties = Utils.propertyMap(item.elementProperty());
            DomProperty text = properties.get("text");
            DomProperty icon = properties.get("icon");
            String iconValue = "";
            if (icon != null) {
                iconValue = this.iconCall(icon);
            }
            this.m_output.append(this.m_indent).append(varName).append("?.addItem(");
            if (icon != null) {
                this.m_output.append(iconValue).append(", ");
            }
            if (WriteInitialization.needsTranslation(text.elementString())) {
                this.m_output.append("\"\")").endl();
                this.m_refreshOut.append(this.m_indent).append(varName).append("?.setItemText(").append(i).append(", ").append(this.trCall(text.elementString())).append(")").endl();
                continue;
            }
            this.m_output.append(this.noTrCall(text.elementString())).append(")").endl();
        }
        this.m_refreshOut.endl();
    }

    private void initializeListWidget(DomWidget w) {
        String varName = this.m_driver.findOrInsertWidget(w);
        QList<DomItem> items = w.elementItem();
        if (items.isEmpty()) {
            return;
        }
        String tempName = this.disableSorting(w, varName);
        for (int i = 0; i < items.size(); ++i) {
            DomItem domItem = (DomItem)((Object)items.get(i));
            Map<String, DomProperty> properties = Utils.propertyMap(domItem.elementProperty());
            Item item = new Item("QListWidgetItem", this.m_indent, this.m_output, this.m_refreshOut, this.m_driver);
            this.addQtFlagsInitializer(item, properties, "flags");
            this.addCommonInitializers(item, properties);
            item.writeSetupUi(varName);
            StringBuilder parentPath = new StringBuilder();
            parentPath.append(varName).append("?.item(").append(i).append(')');
            item.writeRetranslateUi(parentPath.toString());
        }
        this.enableSorting(w, varName, tempName);
    }

    private void initializeTreeWidget(DomWidget w) {
        String varName = this.m_driver.findOrInsertWidget(w);
        Item item = new Item("QTreeWidgetItem", this.m_indent, this.m_output, this.m_refreshOut, this.m_driver);
        QList<DomColumn> columns = w.elementColumn();
        for (int i = 0; i < columns.size(); ++i) {
            DomString str;
            DomColumn column = (DomColumn)((Object)columns.get(i));
            Map<String, DomProperty> properties = Utils.propertyMap(column.elementProperty());
            this.addCommonInitializers(item, properties, i);
            DomProperty p = properties.get("text");
            if (p == null || (str = p.elementString()) == null || !str.text().isEmpty()) continue;
            this.m_output.append(this.m_indent).append(varName).append("?.headerItem().setText(").append(i).append(", \"\")").endl();
        }
        String itemName = item.writeSetupUi("", Item.EmptyItemPolicy.DontConstruct);
        item.writeRetranslateUi(varName + "?.headerItem()");
        if (itemName != null && !itemName.isEmpty()) {
            this.m_output.append(this.m_indent).append(varName).append("?.setHeaderItem(").append(itemName).append(")").endl();
        }
        if (w.elementItem().isEmpty()) {
            return;
        }
        String tempName = this.disableSorting(w, varName);
        List<Item> items = this.initializeTreeWidgetItems((List<DomItem>)w.elementItem());
        for (int i = 0; i < items.size(); ++i) {
            Item itm = items.get(i);
            itm.writeSetupUi(varName);
            StringBuilder parentPath = new StringBuilder();
            parentPath.append(varName).append("?.topLevelItem(").append(i).append(')');
            itm.writeRetranslateUi(parentPath.toString());
        }
        this.enableSorting(w, varName, tempName);
    }

    private List<Item> initializeTreeWidgetItems(List<DomItem> domItems) {
        ArrayList<Item> items = new ArrayList<Item>();
        int numDomItems = domItems.size();
        for (int i = 0; i < numDomItems; ++i) {
            DomItem domItem = domItems.get(i);
            Item item = new Item("QTreeWidgetItem", this.m_indent, this.m_output, this.m_refreshOut, this.m_driver);
            items.add(item);
            QHash map = new QHash(String.class, DomProperty.class);
            int col = -1;
            QList<DomProperty> properties = domItem.elementProperty();
            for (DomProperty p : properties) {
                if (p.attributeName().equals("text")) {
                    if (!map.isEmpty()) {
                        this.addCommonInitializers(item, (Map<String, DomProperty>)map, col);
                        map.clear();
                    }
                    ++col;
                }
                map.insert((Object)p.attributeName(), (Object)p);
            }
            this.addCommonInitializers(item, (Map<String, DomProperty>)map, col);
            this.addQtFlagsInitializer(item, (Map<String, DomProperty>)map, "flags");
            List<Item> subItems = this.initializeTreeWidgetItems((List<DomItem>)domItem.elementItem());
            for (Item subItem : subItems) {
                item.addChild(subItem);
            }
        }
        return items;
    }

    private void initializeTableWidget(DomWidget w) {
        String varName = this.m_driver.findOrInsertWidget(w);
        QList<DomColumn> columns = w.elementColumn();
        if (!columns.isEmpty()) {
            this.m_output.append(this.m_indent).append("if (").append(varName).append("?.columnCount() < ").append(columns.size()).append(')');
            this.m_output.endl().append(this.m_indent).append(this.m_option.indent).append(varName).append("?.setColumnCount(").append(columns.size()).append(")").endl();
        }
        for (int i = 0; i < columns.size(); ++i) {
            DomColumn column = (DomColumn)((Object)columns.get(i));
            if (column.elementProperty().isEmpty()) continue;
            Map<String, DomProperty> properties = Utils.propertyMap(column.elementProperty());
            Item item = new Item("QTableWidgetItem", this.m_indent, this.m_output, this.m_refreshOut, this.m_driver);
            this.addCommonInitializers(item, properties);
            String itemName = item.writeSetupUi("", Item.EmptyItemPolicy.ConstructItemAndVariable);
            StringBuilder parentPath = new StringBuilder();
            parentPath.append(varName).append("?.horizontalHeaderItem(").append(i).append(')');
            item.writeRetranslateUi(parentPath.toString());
            this.m_output.append(this.m_indent).append(varName).append("?.setHorizontalHeaderItem(").append(i).append(", ").append(itemName).append(")").endl();
        }
        QList<DomRow> rows = w.elementRow();
        if (!rows.isEmpty()) {
            this.m_output.append(this.m_indent).append("if (").append(varName).append("?.rowCount() < ").append(rows.size()).append(')').endl().append(this.m_indent).append(this.m_option.indent).append(varName).append("?.setRowCount(").append(rows.size()).append(")").endl();
        }
        for (int i = 0; i < rows.size(); ++i) {
            DomRow row = (DomRow)((Object)rows.get(i));
            if (row.elementProperty().isEmpty()) continue;
            Map<String, DomProperty> properties = Utils.propertyMap(row.elementProperty());
            Item item = new Item("QTableWidgetItem", this.m_indent, this.m_output, this.m_refreshOut, this.m_driver);
            this.addCommonInitializers(item, properties);
            String itemName = item.writeSetupUi("", Item.EmptyItemPolicy.ConstructItemAndVariable);
            StringBuilder parentPath = new StringBuilder();
            parentPath.append(varName).append("?.verticalHeaderItem(").append(i).append(')');
            item.writeRetranslateUi(parentPath.toString());
            this.m_output.append(this.m_indent).append(varName).append("?.setVerticalHeaderItem(").append(i).append(", ").append(itemName).append(")").endl();
        }
        String tempName = this.disableSorting(w, varName);
        QList<DomItem> items = w.elementItem();
        for (DomItem cell : items) {
            if (!cell.hasAttributeRow() || !cell.hasAttributeColumn() || cell.elementProperty().isEmpty()) continue;
            int r = cell.attributeRow();
            int c = cell.attributeColumn();
            Map<String, DomProperty> properties = Utils.propertyMap(cell.elementProperty());
            Item item = new Item("QTableWidgetItem", this.m_indent, this.m_output, this.m_refreshOut, this.m_driver);
            this.addQtFlagsInitializer(item, properties, "flags");
            this.addCommonInitializers(item, properties);
            String itemName = item.writeSetupUi("", Item.EmptyItemPolicy.ConstructItemAndVariable);
            StringBuilder parentPath = new StringBuilder();
            parentPath.append(varName).append("?.item(").append(r).append(", ").append(c).append(')');
            item.writeRetranslateUi(parentPath.toString());
            this.m_output.append(this.m_indent).append(varName).append("?.setItem(").append(r).append(", ").append(c).append(", ").append(itemName).append(")").endl();
        }
        this.enableSorting(w, varName, tempName);
    }

    private String disableSorting(DomWidget w, String varName) {
        String tempName = "";
        if (!w.elementItem().isEmpty()) {
            tempName = this.m_driver.unique("__sortingEnabled");
            this.m_refreshOut.endl();
            this.m_refreshOut.append(this.m_indent);
            this.m_refreshOut.append("boolean ");
            this.m_refreshOut.append(tempName).append(" = ").append(varName).append("?.isSortingEnabled()").endl().append(this.m_indent).append(varName).append("?.setSortingEnabled(false)").endl();
        }
        return tempName;
    }

    private void enableSorting(DomWidget w, String varName, String tempName) {
        if (!w.elementItem().isEmpty()) {
            this.m_refreshOut.append(this.m_indent).append(varName).append("?.setSortingEnabled(").append(tempName).append(")").append('\n');
        }
    }

    private Declaration findDeclaration(String name) {
        DomWidget widget = this.m_driver.widgetByName(name);
        if (widget != null) {
            return new Declaration(this.m_driver.findOrInsertWidget(widget), widget.attributeClass());
        }
        DomAction action = this.m_driver.actionByName(name);
        if (action != null) {
            return new Declaration(this.m_driver.findOrInsertAction(action), "QAction");
        }
        DomButtonGroup group = this.m_driver.findButtonGroup(name);
        if (group != null) {
            return new Declaration(this.m_driver.findOrInsertButtonGroup(group), "QButtonGroup");
        }
        return new Declaration("", "");
    }

    private String writeFontProperties(DomFont f) {
        if (this.m_fontPropertiesNameMap.containsKey((Object)f)) {
            return this.m_fontPropertiesNameMap.get((Object)f);
        }
        String fontName = this.m_driver.unique("font");
        this.m_fontPropertiesNameMap.put(f, fontName);
        this.m_output.append(this.m_indent).append("var ").append(fontName).append(" = QFont()").endl();
        if (f.hasElementFamily() && !f.elementFamily().isEmpty()) {
            this.m_output.append(this.m_indent).append(fontName).append("?.setFamilies(").append("java.util.Arrays.asList(").append(WriteInitialization.formatString(f.elementFamily())).append("))").endl();
        }
        if (f.hasElementPointSize() && f.elementPointSize() > 0) {
            this.m_output.append(this.m_indent).append(fontName).append("?.setPointSize(").append(f.elementPointSize()).append(")").endl();
        }
        if (f.hasElementBold()) {
            this.m_output.append(this.m_indent).append(fontName).append("?.setBold(").append(Boolean.toString(f.elementBold())).append(")").endl();
        }
        if (f.hasElementItalic()) {
            this.m_output.append(this.m_indent).append(fontName).append("?.setItalic(").append(Boolean.toString(f.elementItalic())).append(")").endl();
        }
        if (f.hasElementUnderline()) {
            this.m_output.append(this.m_indent).append(fontName).append("?.setUnderline(").append(Boolean.toString(f.elementUnderline())).append(")").endl();
        }
        if (f.hasElementStrikeOut()) {
            this.m_output.append(this.m_indent).append(fontName).append("?.setStrikeOut(").append(Boolean.toString(f.elementStrikeOut())).append(")").endl();
        }
        if (f.hasElementKerning()) {
            this.m_output.append(this.m_indent).append(fontName).append("?.setKerning(").append(Boolean.toString(f.elementKerning())).append(")").endl();
        }
        if (f.hasElementAntialiasing()) {
            this.m_output.append(this.m_indent).append(fontName).append("?.setStyleStrategy(QFont.StyleStrategy.").append(f.elementAntialiasing() ? "PreferDefault" : "NoAntialias").append(")").endl();
        }
        if (f.hasElementStyleStrategy()) {
            this.m_output.append(this.m_indent).append(fontName).append("?.setStyleStrategy(QFont.StyleStrategy.").append(f.elementStyleStrategy()).append(")").endl();
        }
        return fontName;
    }

    private static void writeIconAddFile(QTextStream output, String indent, String iconName, String fileName, String mode, String state) {
        output.append(indent).append(iconName).append("?.addFile(").append(WriteInitialization.formatString(fileName)).append(", QSize(), QIcon.Mode.").append(mode).append(", QIcon.State.").append(state).append(")").endl();
    }

    private static void writeResourceIcon(QTextStream output, String iconName, String indent, DomResourceIcon i) {
        if (i.hasElementNormalOff()) {
            WriteInitialization.writeIconAddFile(output, indent, iconName, i.elementNormalOff().text(), "Normal", "Off");
        }
        if (i.hasElementNormalOn()) {
            WriteInitialization.writeIconAddFile(output, indent, iconName, i.elementNormalOn().text(), "Normal", "On");
        }
        if (i.hasElementDisabledOff()) {
            WriteInitialization.writeIconAddFile(output, indent, iconName, i.elementDisabledOff().text(), "Disabled", "Off");
        }
        if (i.hasElementDisabledOn()) {
            WriteInitialization.writeIconAddFile(output, indent, iconName, i.elementDisabledOn().text(), "Disabled", "On");
        }
        if (i.hasElementActiveOff()) {
            WriteInitialization.writeIconAddFile(output, indent, iconName, i.elementActiveOff().text(), "Active", "Off");
        }
        if (i.hasElementActiveOn()) {
            WriteInitialization.writeIconAddFile(output, indent, iconName, i.elementActiveOn().text(), "Active", "On");
        }
        if (i.hasElementSelectedOff()) {
            WriteInitialization.writeIconAddFile(output, indent, iconName, i.elementSelectedOff().text(), "Selected", "Off");
        }
        if (i.hasElementSelectedOn()) {
            WriteInitialization.writeIconAddFile(output, indent, iconName, i.elementSelectedOn().text(), "Selected", "On");
        }
    }

    private static void writeIconAddPixmap(QTextStream output, String indent, String iconName, String call, String mode, String state) {
        output.append(indent).append(iconName).append("?.addPixmap(").append(call).append(", QIcon.Mode.").append(mode).append(", QIcon.State.").append(state).append(")").endl();
    }

    private static boolean iconHasStatePixmaps(DomResourceIcon i) {
        return i.hasElementNormalOff() || i.hasElementNormalOn() || i.hasElementDisabledOff() || i.hasElementDisabledOn() || i.hasElementActiveOff() || i.hasElementActiveOn() || i.hasElementSelectedOff() || i.hasElementSelectedOn();
    }

    private static boolean isIconFormat44(DomResourceIcon i) {
        return WriteInitialization.iconHasStatePixmaps(i) || !i.attributeTheme().isEmpty();
    }

    private String writeIconProperties(DomResourceIcon i) {
        if (this.m_iconPropertiesNameMap.containsKey((Object)i)) {
            return this.m_iconPropertiesNameMap.get((Object)i);
        }
        String iconName = this.m_driver.unique("icon");
        this.m_iconPropertiesNameMap.put(i, iconName);
        if (!WriteInitialization.isIconFormat44(i)) {
            this.m_output.append(this.m_indent);
            this.m_output.append("var ");
            this.m_output.append(iconName).append(" = ").append(this.pixCall("QIcon", i.text())).append(';').endl();
            return iconName;
        }
        if (i.attributeTheme().isEmpty()) {
            this.m_output.append(this.m_indent).append("var ").append(iconName).append(" = QIcon()").endl();
            if (this.m_uic.pixmapFunction().isEmpty()) {
                WriteInitialization.writeResourceIcon(this.m_output, iconName, this.m_indent, i);
            } else {
                this.writePixmapFunctionIcon(this.m_output, iconName, this.m_indent, i);
            }
            return iconName;
        }
        if (i.attributeTheme().startsWith(":") || i.attributeTheme().startsWith("classpath:") || i.attributeTheme().startsWith("/:classpath:")) {
            this.m_output.append(this.m_indent).append("var ").append(iconName).append(" = QIcon(").append(WriteInitialization.formatString(i.attributeTheme())).append(")").endl();
            return iconName;
        }
        if (i.attributeResource().startsWith(":") || i.attributeResource().startsWith("classpath:") || i.attributeResource().startsWith("/:classpath:")) {
            this.m_output.append(this.m_indent).append("var ").append(iconName).append(" = QIcon(").append(WriteInitialization.formatString(i.attributeResource())).append(")").endl();
            return iconName;
        }
        if (WriteInitialization.iconHasStatePixmaps(i)) {
            this.m_output.append(this.m_indent).append("var ").append(iconName).append(" = QIcon()").endl();
            String themeNameStringVariableC = "iconThemeName";
            this.m_output.append(this.m_indent);
            if (this.m_firstThemeIcon) {
                this.m_output.append("String ");
                this.m_firstThemeIcon = false;
            }
            this.m_output.append(themeNameStringVariableC).append(" = ").append(WriteInitialization.formatString(i.attributeTheme())).append(';').endl();
            this.m_output.append(this.m_indent).append("if(");
            this.m_output.append("QIcon.hasThemeIcon(").append(themeNameStringVariableC).append(')').append(") {").endl().append(this.m_indent).append(this.m_option.indent).append(iconName).append(" = QIcon.fromTheme(").append(themeNameStringVariableC).append(")").append(this.m_indent).append("} else {").endl();
            if (this.m_uic.pixmapFunction().isEmpty()) {
                WriteInitialization.writeResourceIcon(this.m_output, iconName, this.m_indent + this.m_option.indent, i);
            } else {
                this.writePixmapFunctionIcon(this.m_output, iconName, this.m_indent + this.m_option.indent, i);
            }
            this.m_output.append(this.m_indent);
            this.m_output.append('}').endl();
            return iconName;
        }
        this.m_output.append(this.m_indent).append("var ").append(iconName).append(" = QIcon(QIcon.fromTheme(").append(WriteInitialization.formatString(i.attributeTheme())).append("))").endl();
        return iconName;
    }

    private void writePixmapFunctionIcon(QTextStream output, String iconName, String indent, DomResourceIcon i) {
        if (i.hasElementNormalOff()) {
            WriteInitialization.writeIconAddPixmap(output, indent, iconName, this.pixCall("QPixmap", i.elementNormalOff().text()), "Normal", "Off");
        }
        if (i.hasElementNormalOn()) {
            WriteInitialization.writeIconAddPixmap(output, indent, iconName, this.pixCall("QPixmap", i.elementNormalOn().text()), "Normal", "On");
        }
        if (i.hasElementDisabledOff()) {
            WriteInitialization.writeIconAddPixmap(output, indent, iconName, this.pixCall("QPixmap", i.elementDisabledOff().text()), "Disabled", "Off");
        }
        if (i.hasElementDisabledOn()) {
            WriteInitialization.writeIconAddPixmap(output, indent, iconName, this.pixCall("QPixmap", i.elementDisabledOn().text()), "Disabled", "On");
        }
        if (i.hasElementActiveOff()) {
            WriteInitialization.writeIconAddPixmap(output, indent, iconName, this.pixCall("QPixmap", i.elementActiveOff().text()), "Active", "Off");
        }
        if (i.hasElementActiveOn()) {
            WriteInitialization.writeIconAddPixmap(output, indent, iconName, this.pixCall("QPixmap", i.elementActiveOn().text()), "Active", "On");
        }
        if (i.hasElementSelectedOff()) {
            WriteInitialization.writeIconAddPixmap(output, indent, iconName, this.pixCall("QPixmap", i.elementSelectedOff().text()), "Selected", "Off");
        }
        if (i.hasElementSelectedOn()) {
            WriteInitialization.writeIconAddPixmap(output, indent, iconName, this.pixCall("QPixmap", i.elementSelectedOn().text()), "Selected", "On");
        }
    }

    private String writeSizePolicy(DomSizePolicy sp) {
        if (this.m_sizePolicyNameMap.containsKey((Object)sp)) {
            return this.m_sizePolicyNameMap.get((Object)sp);
        }
        String spName = this.m_driver.unique("sizePolicy");
        this.m_sizePolicyNameMap.put(sp, spName);
        this.m_output.append(this.m_indent).append("var ").append(spName).append(" = QSizePolicy(");
        if (sp.hasElementHSizeType() && sp.hasElementVSizeType()) {
            this.m_output.append("QSizePolicy.Policy.").append(QSizePolicy.Policy.resolve((int)sp.elementHSizeType()).name()).append(", QSizePolicy.Policy.").append(QSizePolicy.Policy.resolve((int)sp.elementVSizeType()).name());
        } else if (sp.hasAttributeHSizeType() && sp.hasAttributeVSizeType()) {
            this.m_output.append("QSizePolicy.Policy.").append(sp.attributeHSizeType()).append(", QSizePolicy.Policy.").append(sp.attributeVSizeType());
        }
        this.m_output.append(")").endl();
        this.m_output.append(this.m_indent).append(spName).append("?.setHorizontalStretch(").append(sp.elementHorStretch()).append(")").endl();
        this.m_output.append(this.m_indent).append(spName).append("?.setVerticalStretch(").append(sp.elementVerStretch()).append(")").endl();
        return spName;
    }

    private String writeBrushInitialization(DomBrush brush) {
        DomColor color;
        boolean solidColoredBrush = !brush.hasAttributeBrushStyle() || brush.attributeBrushStyle().equals("SolidPattern");
        Integer rgb = 0;
        if (solidColoredBrush && (color = brush.elementColor()) != null && this.m_colorBrushHash.containsKey(rgb = Integer.valueOf((color.elementRed() & 0xFF) << 24 | (color.elementGreen() & 0xFF) << 16 | (color.elementBlue() & 0xFF) << 8 | color.attributeAlpha() & 0xFF))) {
            return this.m_colorBrushHash.get(rgb);
        }
        String brushName = this.m_driver.unique("brush");
        this.writeBrush(brush, brushName);
        if (solidColoredBrush) {
            this.m_colorBrushHash.put(rgb, brushName);
        }
        return brushName;
    }

    private void addButtonGroup(DomWidget buttonNode, String varName) {
        boolean createGroupOnTheFly;
        Map<String, DomProperty> attributes = Utils.propertyMap(buttonNode.elementAttribute());
        DomProperty prop = attributes.get("buttonGroup");
        if (prop == null) {
            return;
        }
        String attributeName = Utils.toString(prop.elementString());
        DomButtonGroup group = this.m_driver.findButtonGroup(attributeName);
        boolean bl = createGroupOnTheFly = group == null;
        if (createGroupOnTheFly) {
            DomButtonGroup newGroup = new DomButtonGroup();
            newGroup.setAttributeName(attributeName);
            group = newGroup;
            System.err.println(this.m_option.messagePrefix() + ": Warning: Creating button group `" + attributeName + "'");
        }
        String groupName = this.m_driver.findOrInsertButtonGroup(group);
        String objectName = group.attributeName();
        if (!this.m_buttonGroups.contains(groupName)) {
            String className = "QButtonGroup";
            this.m_output.append(this.m_indent);
            if (createGroupOnTheFly) {
                this.m_output.append("var ");
            }
            this.m_output.append(groupName).append(" = ").append(className).append('(').append(this.m_mainFormVarName).append(")").endl();
            this.m_buttonGroups.add(groupName);
            this.writeProperties(groupName, objectName, className, (List<DomProperty>)group.elementProperty());
        }
        this.m_output.append(this.m_indent).append(groupName).append("?.addButton(").append(varName).append(")").endl();
    }

    private boolean isCustomWidget(String className) {
        return this.m_uic.customWidgetsInfo().customWidget(className) != null;
    }

    private ConnectionSyntax connectionSyntax(SignalSlot sender, SignalSlot receiver) {
        if (this.m_option.forceMemberFnPtrConnectionSyntax) {
            return ConnectionSyntax.MemberFunctionPtr;
        }
        if (this.m_option.forceStringConnectionSyntax) {
            return ConnectionSyntax.StringBased;
        }
        if (this.m_mainFormVarName.equals(sender.name) && this.m_customSignals.contains(sender.signature) || this.m_mainFormVarName.equals(receiver.name) && this.m_customSlots.contains(receiver.signature)) {
            return ConnectionSyntax.StringBased;
        }
        return ConnectionSyntax.MemberFunctionPtr;
    }

    private static class LayoutDefaultHandler {
        private final int[] m_state = new int[Properties.NumProperties.value()];
        private int[] m_defaultValues = new int[Properties.NumProperties.value()];
        private String[] m_functions = new String[Properties.NumProperties.value()];

        LayoutDefaultHandler() {
            Arrays.fill(this.m_functions, "");
        }

        void acceptLayoutDefault(DomLayoutDefault node) {
            if (node == null) {
                return;
            }
            if (node.hasAttributeMargin()) {
                int n = Properties.Margin.value();
                this.m_state[n] = this.m_state[n] | StateFlags.HasDefaultValue.value();
                this.m_defaultValues[Properties.Margin.value()] = node.attributeMargin();
            }
            if (node.hasAttributeSpacing()) {
                int n = Properties.Spacing.value();
                this.m_state[n] = this.m_state[n] | StateFlags.HasDefaultValue.value();
                this.m_defaultValues[Properties.Spacing.value()] = node.attributeSpacing();
            }
        }

        void acceptLayoutFunction(DomLayoutFunction node) {
            if (node == null) {
                return;
            }
            if (node.hasAttributeMargin()) {
                int n = Properties.Margin.value();
                this.m_state[n] = this.m_state[n] | StateFlags.HasDefaultFunction.value();
                this.m_functions[Properties.Margin.value()] = node.attributeMargin();
                int n2 = Properties.Margin.value();
                this.m_functions[n2] = this.m_functions[n2] + "()";
            }
            if (node.hasAttributeSpacing()) {
                int n = Properties.Spacing.value();
                this.m_state[n] = this.m_state[n] | StateFlags.HasDefaultFunction.value();
                this.m_functions[Properties.Spacing.value()] = node.attributeSpacing();
                int n3 = Properties.Spacing.value();
                this.m_functions[n3] = this.m_functions[n3] + "()";
            }
        }

        private static void writeSetter(String indent, String varName, String setter, String v, QTextStream str) {
            str.append(indent).append(varName).append('.').append(setter).append('(').append(v).append(")").endl();
        }

        private static void writeContentsMargins(String indent, String objectName, int value, QTextStream str) {
            LayoutDefaultHandler.writeSetter(indent, objectName, "setContentsMargins", value + ", " + value + ", " + value + ", " + value, str);
        }

        public void writeProperties(String indent, String varName, Map<String, DomProperty> properties, int marginType, boolean suppressMarginDefault, QTextStream str) {
            int defaultSpacing = marginType == Enum.Use43UiFile.value() ? -1 : 6;
            this.writeProperty(Properties.Spacing.value(), indent, varName, properties, "spacing", "setSpacing", defaultSpacing, false, str);
            int[] layoutmargins = new int[]{-1, 9, 9, 0};
            this.writeProperty(Properties.Margin.value(), indent, varName, properties, "margin", "setMargin", layoutmargins[marginType], suppressMarginDefault, str);
        }

        private void writeProperty(int p, String indent, String objectName, Map<String, DomProperty> properties, String propertyName, String setter, int defaultStyleValue, boolean suppressDefault, QTextStream str) {
            DomProperty prop = properties.get(propertyName);
            if (prop != null) {
                boolean useLayoutFunctionPre43;
                int value = prop.elementNumber();
                boolean bl = useLayoutFunctionPre43 = !suppressDefault && this.m_state[p] == (StateFlags.HasDefaultFunction.value() | StateFlags.HasDefaultValue.value()) && value == this.m_defaultValues[p];
                if (!useLayoutFunctionPre43) {
                    boolean ifndefMac;
                    boolean bl2 = ifndefMac = 0 == (this.m_state[p] & (StateFlags.HasDefaultFunction.value() | StateFlags.HasDefaultValue.value())) && value == defaultStyleValue;
                    if (ifndefMac) {
                        str.append("#ifndef Q_OS_MAC\n");
                    }
                    if (p == Properties.Margin.value()) {
                        LayoutDefaultHandler.writeContentsMargins(indent, objectName, value, str);
                    } else {
                        LayoutDefaultHandler.writeSetter(indent, objectName, setter, "" + value, str);
                    }
                    if (ifndefMac) {
                        str.append("#endif\n");
                    }
                    return;
                }
            }
            if (suppressDefault) {
                return;
            }
            if ((this.m_state[p] & StateFlags.HasDefaultFunction.value()) != 0) {
                LayoutDefaultHandler.writeSetter(indent, objectName, setter, this.m_functions[p], str);
                return;
            }
            if ((this.m_state[p] & StateFlags.HasDefaultValue.value()) != 0) {
                if (p == Properties.Margin.value()) {
                    LayoutDefaultHandler.writeContentsMargins(indent, objectName, this.m_defaultValues[p], str);
                } else {
                    LayoutDefaultHandler.writeSetter(indent, objectName, setter, "" + this.m_defaultValues[p], str);
                }
            }
        }

        private static enum Properties implements QtEnumerator
        {
            Margin,
            Spacing,
            NumProperties;

        }

        private static enum StateFlags implements QtEnumerator
        {
            HasDefaultValue(1),
            HasDefaultFunction(2);

            private final int value;

            private StateFlags(int value) {
                this.value = value;
            }

            public int value() {
                return this.value;
            }
        }
    }

    static enum Enum implements QtEnumerator
    {
        Use43UiFile,
        TopLevelMargin,
        ChildMargin,
        SubLayoutMargin;

    }

    private static class Buddy {
        public final String labelVarName;
        public final String buddyAttributeName;

        Buddy(String labelVarName, String buddyAttributeName) {
            this.labelVarName = labelVarName;
            this.buddyAttributeName = buddyAttributeName;
        }
    }

    static enum Flag implements QtEnumerator
    {
        WritePropertyIgnoreMargin(1),
        WritePropertyIgnoreSpacing(2),
        WritePropertyIgnoreObjectName(4);

        private final int value;

        private Flag(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    private static class Declaration {
        public final String name;
        public final String className;

        Declaration(String name, String className) {
            this.name = name;
            this.className = className;
        }
    }

    private static class Item {
        private ItemData m_setupUiData = new ItemData();
        private ItemData m_retranslateUiData = new ItemData();
        private final List<Item> m_children = new ArrayList<Item>();
        private Item m_parent = null;
        private String m_itemClassName = "";
        private String m_indent = "";
        private QTextStream m_setupUiStream;
        private QTextStream m_retranslateUiStream;
        private Driver m_driver;

        public Item(String itemClassName, String indent, QTextStream setupUiStream, QTextStream retranslateUiStream, Driver driver) {
            this.m_itemClassName = itemClassName;
            this.m_indent = indent;
            this.m_setupUiStream = setupUiStream;
            this.m_retranslateUiStream = retranslateUiStream;
            this.m_driver = driver;
        }

        public String writeSetupUi(String parent) {
            return this.writeSetupUi(parent, EmptyItemPolicy.ConstructItemOnly);
        }

        public String writeSetupUi(String parent, EmptyItemPolicy emptyItemPolicy) {
            if (emptyItemPolicy == EmptyItemPolicy.DontConstruct && this.m_setupUiData.policy == ItemData.TemporaryVariableGeneratorPolicy.DontGenerate) {
                return "";
            }
            if (emptyItemPolicy == EmptyItemPolicy.ConstructItemOnly && this.m_children.isEmpty() && this.m_setupUiData.policy == ItemData.TemporaryVariableGeneratorPolicy.DontGenerate) {
                this.m_setupUiStream.append(this.m_indent);
                this.m_setupUiStream.append(this.m_itemClassName);
                this.m_setupUiStream.append("(");
                this.m_setupUiStream.append(parent);
                this.m_setupUiStream.append(")").endl();
                return "";
            }
            String uniqueName = this.m_driver.unique("__" + this.m_itemClassName.toLowerCase());
            this.m_setupUiStream.append(this.m_indent);
            this.m_setupUiStream.append("var ");
            this.m_setupUiStream.append(uniqueName);
            this.m_setupUiStream.append(" = ");
            this.m_setupUiStream.append(this.m_itemClassName);
            this.m_setupUiStream.append("(");
            this.m_setupUiStream.append(parent);
            this.m_setupUiStream.append(")").endl();
            for (QPair pair : this.m_setupUiData.setters) {
                this.m_setupUiStream.append(this.m_indent);
                this.m_setupUiStream.append(uniqueName);
                this.m_setupUiStream.append((String)pair.second);
                this.m_setupUiStream.endl();
            }
            for (QPair pair : this.m_setupUiData.setters) {
                this.m_setupUiStream.append(this.m_indent).append(uniqueName).append((String)pair.second).endl();
            }
            for (Item child : this.m_children) {
                child.writeSetupUi(uniqueName);
            }
            return uniqueName;
        }

        public void writeRetranslateUi(String parentPath) {
            if (this.m_retranslateUiData.policy == ItemData.TemporaryVariableGeneratorPolicy.DontGenerate) {
                return;
            }
            String uniqueName = this.m_driver.unique("___" + this.m_itemClassName.toLowerCase());
            this.m_retranslateUiStream.append(this.m_indent);
            this.m_retranslateUiStream.append(this.m_itemClassName).append(" ");
            this.m_retranslateUiStream.append(uniqueName).append(" = ").append(parentPath).endl();
            for (QPair pair : this.m_retranslateUiData.setters) {
                this.m_retranslateUiStream.append(this.m_indent).append(uniqueName).append((String)pair.second).endl();
            }
            for (int i = 0; i < this.m_children.size(); ++i) {
                StringBuilder method = new StringBuilder();
                method.append(uniqueName).append(".child(").append(i).append(')');
                this.m_children.get(i).writeRetranslateUi(method.toString());
            }
        }

        public void addSetter(String setter, String directive, boolean translatable) {
            ItemData.TemporaryVariableGeneratorPolicy newPolicy;
            ItemData.TemporaryVariableGeneratorPolicy temporaryVariableGeneratorPolicy = newPolicy = directive == null || directive.isEmpty() ? ItemData.TemporaryVariableGeneratorPolicy.Generate : ItemData.TemporaryVariableGeneratorPolicy.GenerateWithMultiDirective;
            if (translatable) {
                this.m_retranslateUiData.setters.insert((Object)directive, (Object)setter);
                if (ItemData.TemporaryVariableGeneratorPolicy.GenerateWithMultiDirective == newPolicy) {
                    this.m_retranslateUiData.directives.insert((Object)directive);
                }
                if (this.m_retranslateUiData.policy.value() < newPolicy.value()) {
                    this.m_retranslateUiData.policy = newPolicy;
                }
            } else {
                this.m_setupUiData.setters.insert((Object)directive, (Object)setter);
                if (ItemData.TemporaryVariableGeneratorPolicy.GenerateWithMultiDirective == newPolicy) {
                    this.m_setupUiData.directives.insert((Object)directive);
                }
                if (this.m_setupUiData.policy.value() < newPolicy.value()) {
                    this.m_setupUiData.policy = newPolicy;
                }
            }
        }

        public void addChild(Item child) {
            this.m_children.add(child);
            child.m_parent = this;
            Item c = child;
            Item p = this;
            while (p != null) {
                p.m_setupUiData.directives.unite(c.m_setupUiData.directives);
                p.m_retranslateUiData.directives.unite(c.m_retranslateUiData.directives);
                if (p.m_setupUiData.policy.value() < c.m_setupUiData.policy.value()) {
                    p.m_setupUiData.policy = c.m_setupUiData.policy;
                }
                if (p.m_retranslateUiData.policy.value() < c.m_retranslateUiData.policy.value()) {
                    p.m_retranslateUiData.policy = c.m_retranslateUiData.policy;
                }
                c = p;
                p = p.m_parent;
            }
        }

        private static class ItemData {
            final QMultiMap<String, String> setters = new QMultiMap(String.class, String.class);
            final QSet<String> directives = new QSet(String.class);
            TemporaryVariableGeneratorPolicy policy = TemporaryVariableGeneratorPolicy.DontGenerate;

            ItemData() {
            }

            static enum TemporaryVariableGeneratorPolicy implements QtEnumerator
            {
                DontGenerate(1),
                GenerateWithMultiDirective(2),
                Generate(3);

                private final int value;

                private TemporaryVariableGeneratorPolicy(int value) {
                    this.value = value;
                }

                public int value() {
                    return this.value;
                }
            }
        }

        public static enum EmptyItemPolicy implements QtEnumerator
        {
            DontConstruct,
            ConstructItemOnly,
            ConstructItemAndVariable;

        }
    }
}

