/*
 * Decompiled with CFR 0.152.
 */
package io.qt.uic.kotlin;

import io.qt.core.QTextStream;
import io.qt.uic.CustomWidgetsInfo;
import io.qt.uic.Option;
import io.qt.uic.TreeWalker;
import io.qt.uic.Uic;
import io.qt.uic.kotlin.WriteImports;
import io.qt.uic.ui4.DomCustomWidget;
import io.qt.uic.ui4.DomSlots;
import io.qt.uic.ui4.DomUI;
import io.qt.uic.ui4.DomWidget;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WriteClass
extends TreeWalker {
    private final String m_className;
    private final QTextStream m_output;
    private final Option m_option;
    private final CustomWidgetsInfo cWidgetsInfo;
    private DomSlots m_elementSlots;

    public WriteClass(Uic uic, String className) {
        this.m_output = uic.output();
        this.m_option = uic.option();
        this.cWidgetsInfo = uic.customWidgetsInfo();
        this.m_className = className;
    }

    @Override
    public void acceptUI(DomUI node) {
        this.m_elementSlots = node.elementSlots();
        this.m_output.append("package ").append(this.m_option.targetPackage).endl().endl();
        super.acceptUI(node);
    }

    private String fromUnknownType(String argument) {
        DomCustomWidget customWidget;
        String rawArgument = argument;
        if (rawArgument.startsWith("const ")) {
            rawArgument = rawArgument.substring(6);
        }
        if (rawArgument.endsWith(" const*") || rawArgument.endsWith(" const&")) {
            rawArgument = rawArgument.substring(0, rawArgument.length() - 7);
        }
        if (rawArgument.endsWith("*") || rawArgument.endsWith("&")) {
            rawArgument = rawArgument.substring(0, rawArgument.length() - 1);
        }
        if ((customWidget = this.cWidgetsInfo.customWidget(rawArgument)) != null) {
            if (rawArgument.contains("::")) {
                rawArgument = rawArgument.replace("::", ".");
            } else if (customWidget.hasElementHeader() && !customWidget.elementHeader().text().toLowerCase().endsWith(".h")) {
                rawArgument = customWidget.elementHeader().text().replace("::", ".");
            }
            return rawArgument;
        }
        return argument;
    }

    private String typeArgs(String argument) {
        int parenPos = argument.indexOf(60);
        if (parenPos < 0) {
            String _argument = WriteClass.getExternalTypeName(argument).replace('$', '.').replace('/', '.');
            if (_argument.isEmpty()) {
                _argument = this.fromUnknownType(argument);
            }
            return _argument;
        }
        String container = argument.substring(0, parenPos);
        String arguments = argument.substring(parenPos);
        ArrayList<String> args = new ArrayList<String>();
        if (arguments.startsWith("<") && arguments.endsWith(">")) {
            String _container;
            arguments = arguments.substring(1, arguments.length() - 1);
            int nestedLevels = 0;
            int beginIndex = 0;
            int length = arguments.length();
            block5: for (int i = 0; i < length; ++i) {
                char c = arguments.charAt(i);
                switch (c) {
                    case ',': {
                        if (nestedLevels != 0) continue block5;
                        String arg = arguments.substring(beginIndex, i);
                        args.add(this.typeArgs(arg));
                        beginIndex = i + 1;
                        continue block5;
                    }
                    case '(': 
                    case '<': 
                    case '[': {
                        ++nestedLevels;
                        continue block5;
                    }
                    case ')': 
                    case '>': 
                    case ']': {
                        --nestedLevels;
                    }
                }
            }
            String arg = arguments.substring(beginIndex);
            if (!arg.trim().isEmpty()) {
                args.add(this.typeArgs(arg));
            }
            if ((_container = WriteClass.getExternalTypeName(container).replace('$', '.').replace('/', '.')).isEmpty()) {
                _container = this.fromUnknownType(container);
            }
            return String.format("%1$s<%2$s>", _container, String.join((CharSequence)", ", args));
        }
        String _argument = WriteClass.getExternalTypeName(argument).replace('$', '.').replace('/', '.');
        if (_argument.isEmpty()) {
            _argument = this.fromUnknownType(argument);
        }
        return _argument;
    }

    @Override
    public void acceptWidget(DomWidget widget) {
        String superClassName;
        if (WriteImports.m_classToPackage.containsKey(widget.attributeClass())) {
            superClassName = WriteImports.m_classToPackage.get(widget.attributeClass());
            if (superClassName == null || superClassName.isEmpty()) {
                superClassName = widget.attributeClass();
            } else if (superClassName.endsWith("*")) {
                superClassName = superClassName.replace("*", widget.attributeClass());
            }
        } else {
            superClassName = widget.attributeClass();
            DomCustomWidget customWidget = this.cWidgetsInfo.customWidget(superClassName);
            if (customWidget != null) {
                if (superClassName.contains("::")) {
                    superClassName = superClassName.replace("::", ".");
                } else if (customWidget.hasElementHeader() && !customWidget.elementHeader().text().toLowerCase().endsWith(".h")) {
                    superClassName = customWidget.elementHeader().text().replace("::", ".");
                }
            }
        }
        this.m_output.append("class ").append(this.m_className).append(" : ").append(superClassName).append(" {").endl().endl().append(this.m_option.indent).append("val ui = ").append(this.m_option.prefix).append(this.m_className).append(this.m_option.postfix).append("()").endl();
        boolean hasConstructor = false;
        try {
            Class<?> superClass = Class.forName(superClassName);
            TreeMap<Integer, Map> constructors = new TreeMap<Integer, Map>();
            for (Constructor<?> constructor : superClass.getConstructors()) {
                Map map = constructors.computeIfAbsent(constructor.getParameterCount(), i -> new TreeMap());
                map.put(constructor.toString(), constructor);
            }
            for (Map map : constructors.values()) {
                for (Constructor constructor : map.values()) {
                    if (!Modifier.isPublic(constructor.getModifiers())) continue;
                    hasConstructor = true;
                    this.m_output.endl().append(this.m_option.indent).append("constructor(");
                    Parameter[] parameters = constructor.getParameters();
                    for (int i2 = 0; i2 < parameters.length; ++i2) {
                        if (i2 > 0) {
                            this.m_output.append(", ");
                        }
                        String typeName = parameters[i2].getType().getTypeName().replace('$', '.');
                        if (i2 == parameters.length - 1 && parameters[i2].isVarArgs()) {
                            typeName = typeName.replaceFirst("\\[\\]$", "");
                            this.m_output.append("vararg ");
                        }
                        this.m_output.append(parameters[i2].getName());
                        this.m_output.append(": ");
                        this.m_output.append(typeName);
                    }
                    this.m_output.append(") : super(");
                    for (int i2 = 0; i2 < parameters.length; ++i2) {
                        if (i2 > 0) {
                            this.m_output.append(", ");
                        }
                        if (i2 == parameters.length - 1 && parameters[i2].isVarArgs()) {
                            this.m_output.append("*");
                        }
                        this.m_output.append(parameters[i2].getName());
                    }
                    this.m_output.append(") {").endl().append(this.m_option.indent).append(this.m_option.indent).append("ui.setupUi(this)").endl().append(this.m_option.indent).append("}").endl();
                }
            }
        }
        catch (ClassNotFoundException t) {
            Logger.getLogger("qtjambi.uic").log(Level.WARNING, "Unable to load class " + superClassName + ". Please make sure to add it to UIC's classpath.", t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!hasConstructor) {
            this.m_output.endl().append(this.m_option.indent).append("constructor() {").endl().append(this.m_option.indent).append(this.m_option.indent).append("ui.setupUi(this)").endl().append(this.m_option.indent).append("}").endl();
        }
        this.m_output.endl().append(this.m_option.indent).append("protected override fun changeEvent(e: io.qt.core.QEvent) {").endl().append(this.m_option.indent).append(this.m_option.indent).append("super.changeEvent(e)").endl().append(this.m_option.indent).append(this.m_option.indent).append("when (e.type()) {").endl().append(this.m_option.indent).append(this.m_option.indent).append("io.qt.core.QEvent.Type.LanguageChange -> ui.retranslateUi(this)").endl().append(this.m_option.indent).append(this.m_option.indent).append("else -> {}").endl().append(this.m_option.indent).append(this.m_option.indent).append("}").endl().append(this.m_option.indent).append("}").endl();
        if (this.m_elementSlots != null) {
            String arg;
            char c;
            int length;
            int beginIndex;
            for (String signal : this.m_elementSlots.elementSignal()) {
                int parenPos = signal.indexOf(40);
                String functionName = signal.substring(0, parenPos);
                String arguments = signal.substring(parenPos);
                ArrayList<String> arrayList = new ArrayList<String>();
                if (arguments.startsWith("(") && arguments.endsWith(")")) {
                    arguments = arguments.substring(1, arguments.length() - 1);
                    int nestedLevels = 0;
                    beginIndex = 0;
                    length = arguments.length();
                    block19: for (int i3 = 0; i3 < length; ++i3) {
                        c = arguments.charAt(i3);
                        switch (c) {
                            case ',': {
                                if (nestedLevels != 0) continue block19;
                                String arg2 = arguments.substring(beginIndex, i3);
                                arrayList.add(this.typeArgs(arg2));
                                beginIndex = i3 + 1;
                                continue block19;
                            }
                            case '(': 
                            case '<': 
                            case '[': {
                                ++nestedLevels;
                                continue block19;
                            }
                            case ')': 
                            case '>': 
                            case ']': {
                                --nestedLevels;
                            }
                        }
                    }
                    arg = arguments.substring(beginIndex);
                    if (!arg.trim().isEmpty()) {
                        arrayList.add(this.typeArgs(arg));
                    }
                }
                this.m_output.endl().append(this.m_option.indent).append("public final Signal").append(arrayList.size());
                if (!arrayList.isEmpty()) {
                    this.m_output.append("<").append(String.join((CharSequence)", ", arrayList)).append(">");
                }
                this.m_output.append(" ").append(functionName).append(" = new Signal").append(arrayList.size());
                if (!arrayList.isEmpty()) {
                    this.m_output.append("<>");
                }
                this.m_output.append("();").endl();
            }
            for (String slot : this.m_elementSlots.elementSlot()) {
                int parenPos = slot.indexOf(40);
                String functionName = slot.substring(0, parenPos);
                String arguments = slot.substring(parenPos);
                ArrayList<String> arrayList = new ArrayList<String>();
                if (arguments.startsWith("(") && arguments.endsWith(")")) {
                    arguments = arguments.substring(1, arguments.length() - 1);
                    int nestedLevels = 0;
                    beginIndex = 0;
                    length = arguments.length();
                    block21: for (int i4 = 0; i4 < length; ++i4) {
                        c = arguments.charAt(i4);
                        switch (c) {
                            case ',': {
                                if (nestedLevels != 0) continue block21;
                                String arg2 = arguments.substring(beginIndex, i4);
                                arrayList.add(this.typeArgs(arg2));
                                beginIndex = i4 + 1;
                                continue block21;
                            }
                            case '(': 
                            case '<': 
                            case '[': {
                                ++nestedLevels;
                                continue block21;
                            }
                            case ')': 
                            case '>': 
                            case ']': {
                                --nestedLevels;
                            }
                        }
                    }
                    arg = arguments.substring(beginIndex);
                    if (!arg.trim().isEmpty()) {
                        arrayList.add(this.typeArgs(arg));
                    }
                }
                this.m_output.endl().append(this.m_option.indent).append("public void ").append(functionName).append('(');
                for (int i5 = 0; i5 < arrayList.size(); ++i5) {
                    if (i5 > 0) {
                        this.m_output.append(", ");
                    }
                    this.m_output.append((String)arrayList.get(i5)).append(" arg").append(i5 + 1);
                }
                this.m_output.append("){").endl().append(this.m_option.indent).append("}").endl();
            }
        }
        this.m_output.append("}").endl();
    }

    public static native String getExternalTypeName(String var0);

    protected QTextStream output() {
        return this.m_output;
    }
}

