/*
 * Decompiled with CFR 0.152.
 */
package io.qt.uic.java;

import io.qt.core.QTextStream;
import io.qt.uic.Driver;
import io.qt.uic.Option;
import io.qt.uic.TreeWalker;
import io.qt.uic.Uic;
import io.qt.uic.java.WriteInitialization;
import io.qt.uic.ui4.DomAction;
import io.qt.uic.ui4.DomActionGroup;
import io.qt.uic.ui4.DomButtonGroup;
import io.qt.uic.ui4.DomButtonGroups;
import io.qt.uic.ui4.DomLayout;
import io.qt.uic.ui4.DomSpacer;
import io.qt.uic.ui4.DomUI;
import io.qt.uic.ui4.DomWidget;

public class WriteDeclaration
extends TreeWalker {
    private final Uic m_uic;
    private final Driver m_driver;
    private final QTextStream m_output;
    private final Option m_option;

    public WriteDeclaration(Uic uic) {
        this.m_uic = uic;
        this.m_driver = uic.driver();
        this.m_output = uic.output();
        this.m_option = uic.option();
    }

    @Override
    public void acceptUI(DomUI node) {
        String qualifiedClassName;
        String className = qualifiedClassName = node.elementClass() + this.m_option.postfix;
        this.m_driver.findOrInsertWidget(node.elementWidget());
        String[] namespaceList = qualifiedClassName.split("::");
        if (namespaceList.length != 0) {
            className = namespaceList[namespaceList.length - 1];
        }
        if (this.m_option.targetPackage != null && !this.m_option.targetPackage.isEmpty()) {
            this.m_output.endl();
        }
        this.m_output.append("public class ").append(this.m_option.prefix).append(className).append(" {").endl().endl();
        for (String connection : this.m_uic.databaseInfo().connections()) {
            if (connection.equals("(default)")) continue;
            this.m_output.append(this.m_option.indent).append("public QSqlDatabase ").append(Driver.normalizedName(connection)).append("Connection;").endl();
        }
        super.acceptWidget(node.elementWidget());
        DomButtonGroups domButtonGroups = node.elementButtonGroups();
        if (domButtonGroups != null) {
            this.acceptButtonGroups(domButtonGroups);
        }
        this.m_output.endl();
        new WriteInitialization(this.m_uic).acceptUI(node);
        this.m_output.append("}").endl().endl();
    }

    @Override
    public void acceptWidget(DomWidget node) {
        String className = "QWidget";
        if (node.hasAttributeClass()) {
            className = node.attributeClass();
        }
        this.m_output.append(this.m_option.indent).append("public ").append(this.m_uic.customWidgetsInfo().realClassName(className)).append(" ").append(this.unself(this.m_driver.findOrInsertWidget(node))).append(";").endl();
        super.acceptWidget(node);
    }

    @Override
    public void acceptSpacer(DomSpacer node) {
        this.m_output.append(this.m_option.indent).append("public QSpacerItem ").append(this.unself(this.m_driver.findOrInsertSpacer(node))).append(";").endl();
        super.acceptSpacer(node);
    }

    @Override
    public void acceptLayout(DomLayout node) {
        String className = "QLayout";
        if (node.hasAttributeClass()) {
            className = node.attributeClass();
        }
        this.m_output.append(this.m_option.indent).append("public ").append(className).append(" ").append(this.unself(this.m_driver.findOrInsertLayout(node))).append(";").endl();
        super.acceptLayout(node);
    }

    @Override
    public void acceptActionGroup(DomActionGroup node) {
        this.m_output.append(this.m_option.indent).append("public QActionGroup ").append(this.unself(this.m_driver.findOrInsertActionGroup(node))).append(";").endl();
        super.acceptActionGroup(node);
    }

    @Override
    public void acceptAction(DomAction node) {
        this.m_output.append(this.m_option.indent).append("public QAction ").append(this.unself(this.m_driver.findOrInsertAction(node))).append(";").endl();
        super.acceptAction(node);
    }

    @Override
    public void acceptButtonGroup(DomButtonGroup buttonGroup) {
        this.m_output.append(this.m_option.indent).append("public QButtonGroup ").append(this.unself(this.m_driver.findOrInsertButtonGroup(buttonGroup))).append(";").endl();
        super.acceptButtonGroup(buttonGroup);
    }

    private String unself(String referenceName) {
        if (referenceName.startsWith("this.")) {
            referenceName = referenceName.substring(5);
        }
        return referenceName;
    }
}

