/*
 * Decompiled with CFR 0.152.
 */
package io.qt.uic;

import io.qt.QtUtilities;
import io.qt.core.QCommandLineOption;
import io.qt.core.QCommandLineParser;
import io.qt.core.QCoreApplication;
import io.qt.core.QDir;
import io.qt.core.QList;
import io.qt.core.QScopeGuard;
import io.qt.core.Qt;
import io.qt.uic.Driver;
import java.util.Collection;

public class Main {
    public static void main(String[] args) {
        Qt.qSetGlobalQHashSeed((int)0);
        QCoreApplication.setApplicationName((String)"uic");
        QCoreApplication.setApplicationVersion((String)QtUtilities.qtjambiVersion().toString());
        QCoreApplication.initialize((String[])args);
        QCoreApplication.setApplicationName((String)"QtJambi UIC");
        try (QScopeGuard guard = new QScopeGuard(QCoreApplication::shutdown);){
            Driver driver = new Driver();
            QCommandLineParser parser = new QCommandLineParser();
            parser.setSingleDashWordOptionMode(QCommandLineParser.SingleDashWordOptionMode.ParseAsLongOptions);
            parser.setApplicationDescription(String.format("QtJambi User Interface Compiler version %1$s", QCoreApplication.applicationVersion()));
            parser.addHelpOption();
            parser.addVersionOption();
            QCommandLineOption dependenciesOption = new QCommandLineOption((Collection)QList.of((String)"d", (String[])new String[]{"dependencies"}), "dependencies");
            dependenciesOption.setDescription("Display the dependencies.");
            parser.addOption(dependenciesOption);
            QCommandLineOption forceOption = new QCommandLineOption((Collection)QList.of((String)"f", (String[])new String[]{"force"}), "force");
            forceOption.setDescription("Force all source files to be written.");
            parser.addOption(forceOption);
            QCommandLineOption outputOption = new QCommandLineOption((Collection)QList.of((String)"o", (String[])new String[]{"output"}), "output");
            outputOption.setDescription("Place the output into <dir>");
            outputOption.setValueName("dir");
            parser.addOption(outputOption);
            QCommandLineOption packageOption = new QCommandLineOption((Collection)QList.of((String)"p", (String[])new String[]{"package"}), "package");
            packageOption.setDescription("Place the output into <package>");
            packageOption.setValueName("package");
            parser.addOption(packageOption);
            QCommandLineOption noAutoConnectionOption = new QCommandLineOption((Collection)QList.of((String)"a", (String[])new String[]{"no-autoconnection"}));
            noAutoConnectionOption.setDescription("Do not generate a call to QMetaObject.connectSlotsByName().");
            parser.addOption(noAutoConnectionOption);
            QCommandLineOption postfixOption = new QCommandLineOption("postfix");
            postfixOption.setDescription("Postfix to add to all generated classnames.");
            postfixOption.setValueName("postfix");
            parser.addOption(postfixOption);
            QCommandLineOption translateOption = new QCommandLineOption((Collection)QList.of((String)"tr", (String[])new String[]{"translate"}));
            translateOption.setDescription("Use <function> for i18n.");
            translateOption.setValueName("function");
            parser.addOption(translateOption);
            QCommandLineOption importOption = new QCommandLineOption((Collection)QList.of((String)"i", (String[])new String[]{"imports"}));
            importOption.setDescription("Add imports to comma-separated packages and/or classes.");
            importOption.setValueName("imports");
            parser.addOption(importOption);
            QCommandLineOption generatorOption = new QCommandLineOption((Collection)QList.of((String)"g", (String[])new String[]{"generator"}));
            generatorOption.setDescription("Select generator.");
            generatorOption.setValueName("c++|python|java");
            generatorOption.setDefaultValue("java");
            generatorOption.setFlags(new QCommandLineOption.Flag[]{QCommandLineOption.Flag.HiddenFromHelp});
            parser.addOption(generatorOption);
            QCommandLineOption connectionsOption = new QCommandLineOption((Collection)QList.of((String)"c", (String[])new String[]{"connections"}));
            connectionsOption.setDescription("Connection syntax.");
            connectionsOption.setValueName("pmf|string");
            parser.addOption(connectionsOption);
            QCommandLineOption idBasedOption = new QCommandLineOption("idbased");
            idBasedOption.setDescription("Use id based function for i18n");
            parser.addOption(idBasedOption);
            parser.addPositionalArgument("[uifile]", "Input file (*.ui), otherwise stdin.");
            parser.process((Collection)QCoreApplication.arguments());
            driver.option().dependencies = parser.isSet(dependenciesOption);
            driver.option().outputDir = QDir.fromNativeSeparators((String)parser.value(outputOption));
            driver.option().targetPackage = parser.value(packageOption).replace('/', '.');
            driver.option().autoConnection = !parser.isSet(noAutoConnectionOption);
            driver.option().idBased = parser.isSet(idBasedOption);
            driver.option().postfix = parser.value(postfixOption);
            driver.option().translateFunction = parser.value(translateOption);
            driver.option().imports = QDir.fromNativeSeparators((String)parser.value(importOption));
            driver.option().forceOutput = parser.isSet(forceOption);
            if (parser.isSet(connectionsOption)) {
                String value = parser.value(connectionsOption);
                if (value.equals("pmf")) {
                    driver.option().forceMemberFnPtrConnectionSyntax = true;
                } else if (value.equals("string")) {
                    driver.option().forceStringConnectionSyntax = true;
                }
            }
            if (parser.isSet(generatorOption)) {
                if (parser.value(generatorOption).compareTo("python") == 0) {
                    System.err.println("QtJambi UIC could not generate python code. Use Qt's native UIC tool instead.");
                    System.exit(-1);
                }
                if (parser.value(generatorOption).compareTo("c++") == 0 || parser.value(generatorOption).compareTo("cpp") == 0 || parser.value(generatorOption).compareTo("cplusplus") == 0) {
                    System.err.println("QtJambi UIC could not generate c++ code. Use Qt's native UIC tool instead.");
                }
                System.exit(-1);
            }
            String inputFile = null;
            if (!parser.positionalArguments().isEmpty()) {
                inputFile = (String)parser.positionalArguments().at(0);
            }
            if (driver.option().dependencies) {
                driver.printDependencies(inputFile);
                return;
            }
            driver.uic(inputFile, driver.option().outputDir);
        }
    }
}

