/*
 * Decompiled with CFR 0.152.
 */
package io.qt.uic;

import io.qt.uic.CustomWidgetsInfo;
import io.qt.uic.TreeWalker;
import io.qt.uic.Uic;
import io.qt.uic.ui4.DomAction;
import io.qt.uic.ui4.DomActionGroup;
import io.qt.uic.ui4.DomActionRef;
import io.qt.uic.ui4.DomCustomWidget;
import io.qt.uic.ui4.DomLayout;
import io.qt.uic.ui4.DomProperty;
import io.qt.uic.ui4.DomSpacer;
import io.qt.uic.ui4.DomUI;
import io.qt.uic.ui4.DomWidget;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;

public abstract class WriteIncludesBase
extends TreeWalker {
    private final Set<String> m_knownClasses = new TreeSet<String>();
    private final Uic m_uic;
    private boolean m_laidOut = false;

    public WriteIncludesBase(Uic uic) {
        this.m_uic = uic;
    }

    @Override
    public void acceptUI(DomUI node) {
        this.m_knownClasses.clear();
        this.m_laidOut = false;
        if (node.elementIncludes() != null) {
            this.acceptIncludes(node.elementIncludes());
        }
        if (node.elementCustomWidgets() != null) {
            super.acceptCustomWidgets(node.elementCustomWidgets());
        }
        if (node.elementButtonGroups() != null) {
            this.add("QButtonGroup");
        }
        super.acceptUI(node);
    }

    @Override
    public void acceptWidget(DomWidget node) {
        this.add(node.attributeClass());
        super.acceptWidget(node);
    }

    @Override
    public void acceptLayout(DomLayout node) {
        this.add(node.attributeClass());
        this.m_laidOut = true;
        super.acceptLayout(node);
    }

    @Override
    public void acceptSpacer(DomSpacer node) {
        this.add("QSpacerItem");
        super.acceptSpacer(node);
    }

    @Override
    public void acceptProperty(DomProperty node) {
        switch (node.kind()) {
            case Brush: {
                this.add("QBrush");
                break;
            }
            case Color: {
                this.add("QColor");
                break;
            }
            case Cursor: 
            case CursorShape: {
                this.add("QCursor");
                this.add("Qt");
                break;
            }
            case Enum: {
                this.add("Qt");
                break;
            }
            case Font: {
                this.add("QFont");
                break;
            }
            case Palette: {
                this.add("QPalette");
                this.add("QBrush");
                this.add("QColor");
                this.add("Qt");
                break;
            }
            case Pixmap: {
                this.add("QPixmap");
                break;
            }
            case Point: {
                this.add("QPoint");
                break;
            }
            case PointF: {
                this.add("QPointF");
                break;
            }
            case Date: {
                this.add("QDate");
                break;
            }
            case DateTime: {
                this.add("QDateTime");
                break;
            }
            case Locale: {
                this.add("QLocale");
                break;
            }
            case IconSet: {
                this.add("QIcon");
                break;
            }
            case Url: {
                this.add("QUrl");
                break;
            }
            case Time: {
                this.add("QTime");
                break;
            }
            case StringList: {
                this.add("QStringList");
                break;
            }
            case SizePolicy: {
                this.add("QSizePolicy");
                break;
            }
            case Size: {
                this.add("QSize");
                break;
            }
            case SizeF: {
                this.add("QSizeF");
                break;
            }
            case Rect: {
                this.add("QRect");
                break;
            }
            case RectF: {
                this.add("QRectF");
                break;
            }
        }
        super.acceptProperty(node);
    }

    protected void add(String className, DomCustomWidget dcw) {
        if (className == null || className.isEmpty() || this.m_knownClasses.contains(className)) {
            return;
        }
        this.m_knownClasses.add(className);
        CustomWidgetsInfo cwi = this.m_uic.customWidgetsInfo();
        if (cwi.extendsOneOf(className, Arrays.asList("QTreeView", "QTreeWidget", "QTableView", "QTableWidget"))) {
            this.add("QHeaderView");
        }
        if (!this.m_laidOut && cwi._extends(className, "QToolBox")) {
            this.add("QLayout");
        }
        if (className.equals("Line")) {
            this.add("QFrame");
            return;
        }
        if (cwi._extends(className, "QDialogButtonBox")) {
            this.add("QAbstractButton");
        }
        this.doAdd(className, dcw);
    }

    @Override
    public void acceptCustomWidget(DomCustomWidget node) {
        String className = node.elementClass();
        if (className != null && !className.isEmpty()) {
            this.add(className, node);
        }
    }

    @Override
    public void acceptActionGroup(DomActionGroup node) {
        this.add("QActionGroup");
        super.acceptActionGroup(node);
    }

    @Override
    public void acceptAction(DomAction node) {
        this.add("QAction");
        super.acceptAction(node);
    }

    @Override
    public void acceptActionRef(DomActionRef node) {
        this.add("QAction");
        super.acceptActionRef(node);
    }

    protected void add(String className) {
        this.add(className, null);
    }

    protected void doAdd(String className) {
        this.doAdd(className, null);
    }

    protected abstract void doAdd(String var1, DomCustomWidget var2);

    protected Uic uic() {
        return this.m_uic;
    }
}

