/*
 * Decompiled with CFR 0.152.
 */
package io.qt.uic;

import io.qt.core.QStringList;
import io.qt.uic.TreeWalker;
import io.qt.uic.Utils;
import io.qt.uic.ui4.DomProperty;
import io.qt.uic.ui4.DomUI;
import io.qt.uic.ui4.DomWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DatabaseInfo
extends TreeWalker {
    private final List<String> m_connections = new ArrayList<String>();
    private final Map<String, List<String>> m_cursors = new TreeMap<String, List<String>>();
    private final Map<String, List<String>> m_fields = new TreeMap<String, List<String>>();

    @Override
    public void acceptUI(DomUI node) {
        this.m_connections.clear();
        this.m_cursors.clear();
        this.m_fields.clear();
        super.acceptUI(node);
    }

    public List<String> connections() {
        return Collections.unmodifiableList(this.m_connections);
    }

    @Override
    public void acceptWidget(DomWidget node) {
        Map<String, DomProperty> properties = Utils.propertyMap(node.elementProperty());
        DomProperty frameworkCode = properties.get("frameworkCode");
        if (frameworkCode != null && !Boolean.parseBoolean(frameworkCode.elementBool())) {
            return;
        }
        DomProperty db = properties.get("database");
        if (db != null && db.elementStringList() != null) {
            String field;
            String table;
            QStringList info = db.elementStringList().elementString();
            if (info.isEmpty() || ((String)info.get(0)).isEmpty()) {
                return;
            }
            String connection = (String)info.get(0);
            if (!this.m_connections.contains(connection)) {
                this.m_connections.add(connection);
            }
            String string = table = info.size() > 1 ? (String)info.get(1) : "";
            if (table.isEmpty()) {
                return;
            }
            List<String> val = this.m_cursors.get(connection);
            val.add(table);
            this.m_cursors.put(connection, val);
            String string2 = field = info.size() > 2 ? (String)info.get(2) : "";
            if (field.isEmpty()) {
                return;
            }
            val = this.m_fields.get(connection);
            val.add(field);
            this.m_fields.put(connection, val);
        }
        super.acceptWidget(node);
    }
}

