/*
 * Decompiled with CFR 0.152.
 */
package io.qt.uic;

import io.qt.core.QMetaMethod;
import io.qt.core.QMetaObject;
import io.qt.core.QPair;
import io.qt.uic.TreeWalker;
import io.qt.uic.java.WriteImports;
import io.qt.uic.ui4.DomCustomWidget;
import io.qt.uic.ui4.DomCustomWidgets;
import io.qt.uic.ui4.DomUI;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomWidgetsInfo
extends TreeWalker {
    private static QPair<String, String>[] addPageMethods = new QPair[]{new QPair((Object)"QStackedWidget", (Object)"addWidget"), new QPair((Object)"QToolBar", (Object)"addWidget"), new QPair((Object)"QDockWidget", (Object)"setWidget"), new QPair((Object)"QScrollArea", (Object)"setWidget"), new QPair((Object)"QSplitter", (Object)"addWidget"), new QPair((Object)"QMdiArea", (Object)"addSubWindow")};
    private final Map<String, DomCustomWidget> m_customWidgets = new TreeMap<String, DomCustomWidget>();

    public DomCustomWidget customWidget(String name) {
        return this.m_customWidgets.get(name);
    }

    @Override
    public void acceptUI(DomUI node) {
        this.m_customWidgets.clear();
        if (node.elementCustomWidgets() != null) {
            this.acceptCustomWidgets(node.elementCustomWidgets());
        }
    }

    @Override
    public void acceptCustomWidgets(DomCustomWidgets node) {
        super.acceptCustomWidgets(node);
    }

    @Override
    public void acceptCustomWidget(DomCustomWidget node) {
        if (node.elementClass().isEmpty()) {
            return;
        }
        this.m_customWidgets.put(node.elementClass(), node);
    }

    public final boolean _extends(String classNameIn, String baseClassName) {
        if (Objects.equals(classNameIn, baseClassName)) {
            return true;
        }
        String className = classNameIn;
        DomCustomWidget c = this.customWidget(className);
        while (c != null) {
            String _extends = c.elementExtends();
            if (Objects.equals(className, _extends)) {
                return false;
            }
            if (Objects.equals(_extends, baseClassName)) {
                return true;
            }
            className = _extends;
            c = this.customWidget(className);
        }
        return false;
    }

    public final boolean extendsOneOf(String classNameIn, List<String> baseClassNames) {
        if (baseClassNames.contains(classNameIn)) {
            return true;
        }
        String className = classNameIn;
        DomCustomWidget c = this.customWidget(className);
        while (c != null) {
            String _extends = c.elementExtends();
            if (Objects.equals(className, _extends)) {
                return false;
            }
            if (baseClassNames.contains(_extends)) {
                return true;
            }
            className = _extends;
            c = this.customWidget(className);
        }
        return false;
    }

    public final boolean isCustomWidgetContainer(String className) {
        DomCustomWidget dcw = this.m_customWidgets.getOrDefault(className, null);
        if (dcw != null && dcw.hasElementContainer()) {
            return dcw.elementContainer() != 0;
        }
        return false;
    }

    public final MethodInfo methodInfo(String className, String signature, boolean isSignal) {
        String javaCassName;
        if (WriteImports.m_classToPackage.containsKey(className)) {
            javaCassName = WriteImports.m_classToPackage.get(className);
            if (javaCassName == null || javaCassName.isEmpty()) {
                javaCassName = className;
            } else if (javaCassName.endsWith("*")) {
                javaCassName = javaCassName.replace("*", className);
            }
        } else {
            javaCassName = className;
            DomCustomWidget customWidget = this.customWidget(javaCassName);
            if (customWidget != null) {
                if (javaCassName.contains("::")) {
                    javaCassName = javaCassName.replace("::", ".");
                } else if (customWidget.hasElementHeader() && !customWidget.elementHeader().text().toLowerCase().endsWith(".h")) {
                    javaCassName = customWidget.elementHeader().text().replace("::", ".");
                }
            }
        }
        try {
            Class<?> javaClass = Class.forName(javaCassName);
            QMetaObject mo = QMetaObject.forType(javaClass);
            QMetaMethod matchingMetaMethod = null;
            HashSet<Method> reflectedMethods = new HashSet<Method>();
            ArrayList<QMetaMethod> metaMethods = new ArrayList<QMetaMethod>();
            int parenPos = signature.indexOf(40);
            String functionName = signature.substring(0, parenPos);
            for (QMetaMethod mtd : mo.methods()) {
                if (isSignal && mtd.methodType() != QMetaMethod.MethodType.Signal || !mtd.name().toString().equals(functionName)) continue;
                metaMethods.add(mtd);
                try {
                    reflectedMethods.add(mtd.toReflectedMethod());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!mtd.cppMethodSignature().toString().equals(signature)) continue;
                matchingMetaMethod = mtd;
            }
            ArrayList<Method> methods = new ArrayList<Method>();
            if (!isSignal) {
                for (Method method : javaClass.getMethods()) {
                    if (reflectedMethods.contains(method) || !method.getName().equals(functionName)) continue;
                    methods.add(method);
                }
            }
            if (metaMethods.size() + methods.size() == 1) {
                if (metaMethods.size() == 1) {
                    return new MethodInfo((QMetaMethod)metaMethods.get(0), null, false);
                }
                return new MethodInfo(null, (Method)methods.get(0), false);
            }
            return new MethodInfo(matchingMetaMethod, null, true);
        }
        catch (ClassNotFoundException t) {
            Logger.getLogger("qtjambi.uic").log(Level.WARNING, "Unable to load class " + javaCassName + ". Please make sure to add it to UIC's classpath.", t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new MethodInfo(null, null, false);
    }

    public final String realClassName(String className) {
        String[] namespaces;
        if ("Line".equals(className)) {
            return "QFrame";
        }
        DomCustomWidget dcw = this.m_customWidgets.getOrDefault(className, null);
        if (dcw != null && (namespaces = (className = dcw.elementClass()).split("::")).length > 0) {
            className = namespaces[namespaces.length - 1];
        }
        return className;
    }

    public final String customWidgetAddPageMethod(String name) {
        DomCustomWidget dcw = this.m_customWidgets.getOrDefault(name, null);
        if (dcw != null) {
            return dcw.elementAddPageMethod();
        }
        return "";
    }

    public final String simpleContainerAddPageMethod(String name) {
        for (QPair<String, String> m : addPageMethods) {
            if (!this._extends(name, (String)m.first)) continue;
            return (String)m.second;
        }
        return "";
    }

    public static class MethodInfo {
        public final QMetaMethod metaMethod;
        public final Method method;
        public final boolean isAmbiguous;

        private MethodInfo(QMetaMethod metaMethod, Method method, boolean isAmbiguous) {
            this.metaMethod = metaMethod;
            this.method = method;
            this.isAmbiguous = isAmbiguous;
        }
    }
}

