/****************************************************************************
**
** Copyright (C) 2009-2023 Dr. Peter Droste, Omix Visualization GmbH & Co. KG. All rights reserved.
**
** This file is part of Qt Jambi.
**
** $BEGIN_LICENSE$
** GNU Lesser General Public License Usage
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
** 
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
** $END_LICENSE$

**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
package io.qt.uic;

import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;

public class ClassInfoEntries {
	
	private static final TreeMap<String, String> m_classToJavaQualifier = new TreeMap<>();
	
	static {
		for (ClassInfoEntry e : ClassInfoEntries.classInfoEntries()) {
	    	m_classToJavaQualifier.put(e.klass, e.packge + "." + e.klass);
	    }
	}
	
	public static String classToJavaQualifier(String cls) {
		return m_classToJavaQualifier.get(cls);
	}
	
	public static List<ClassInfoEntry> classInfoEntries(){
		return Arrays.asList(
				new ClassInfoEntry("QAbstractAnimation", "io.qt.core"),
				new ClassInfoEntry("QAnimationDriver", "io.qt.core"),
				new ClassInfoEntry("QAnimationGroup", "io.qt.core"),
				new ClassInfoEntry("QChartView", "io.qt.chats"),
				new ClassInfoEntry("QParallelAnimationGroup", "io.qt.core"),
				new ClassInfoEntry("QPauseAnimation", "io.qt.core"),
				new ClassInfoEntry("QPropertyAnimation", "io.qt.core"),
				new ClassInfoEntry("QSequentialAnimationGroup", "io.qt.core"),
				new ClassInfoEntry("QVariantAnimation", "io.qt.core"),
				new ClassInfoEntry("QFuture", "io.qt.core"),
				new ClassInfoEntry("QFutureInterfaceBase", "io.qt.core"),
				new ClassInfoEntry("QFutureInterface", "io.qt.core"),
				new ClassInfoEntry("QFutureSynchronizer", "io.qt.core"),
				new ClassInfoEntry("QFutureWatcherBase", "io.qt.core"),
				new ClassInfoEntry("QFutureWatcher", "io.qt.core"),
				new ClassInfoEntry("QRunnable", "io.qt.core"),
				new ClassInfoEntry("QThreadPool", "io.qt.core"),
				new ClassInfoEntry("QSysInfo", "io.qt.core"),
				new ClassInfoEntry("QFlags", "io.qt.core"),
				new ClassInfoEntry("QLibraryInfo", "io.qt.core"),
				new ClassInfoEntry("Qt", "io.qt.core"),
				new ClassInfoEntry("QBuffer", "io.qt.core"),
				new ClassInfoEntry("QDataStream", "io.qt.core"),
				new ClassInfoEntry("QDebug", "io.qt.core"),
				new ClassInfoEntry("QDir", "io.qt.core"),
				new ClassInfoEntry("QDirIterator", "io.qt.core"),
				new ClassInfoEntry("QFile", "io.qt.core"),
				new ClassInfoEntry("QFileInfo", "io.qt.core"),
				new ClassInfoEntry("QFileInfoList", "io.qt.core"),
				new ClassInfoEntry("QFileInfoListIterator", "io.qt.core"),
				new ClassInfoEntry("QFileSystemWatcher", "io.qt.core"),
				new ClassInfoEntry("QIODevice", "io.qt.core"),
				new ClassInfoEntry("QProcessEnvironment", "io.qt.core"),
				new ClassInfoEntry("QProcess", "io.qt.core"),
				new ClassInfoEntry("QResource", "io.qt.core"),
				new ClassInfoEntry("QSettings", "io.qt.core"),
				new ClassInfoEntry("QTemporaryFile", "io.qt.core"),
				new ClassInfoEntry("QTextStream", "io.qt.core"),
				new ClassInfoEntry("QTextStreamFunction", "io.qt.core"),
				new ClassInfoEntry("QTextStreamManipulator", "io.qt.core"),
				new ClassInfoEntry("QTS", "io.qt.core"),
				new ClassInfoEntry("QUrl", "io.qt.core"),
				new ClassInfoEntry("QAbstractEventDispatcher", "io.qt.core"),
				new ClassInfoEntry("QModelIndex", "io.qt.core"),
				new ClassInfoEntry("QPersistentModelIndex", "io.qt.core"),
				new ClassInfoEntry("QModelIndexList", "io.qt.core"),
				new ClassInfoEntry("QAbstractItemModel", "io.qt.core"),
				new ClassInfoEntry("QAbstractTableModel", "io.qt.core"),
				new ClassInfoEntry("QAbstractListModel", "io.qt.core"),
				new ClassInfoEntry("QBasicTimer", "io.qt.core"),
				new ClassInfoEntry("QCoreApplication", "io.qt.core"),
				new ClassInfoEntry("QtCleanUpFunction", "io.qt.core"),
				new ClassInfoEntry("QEvent", "io.qt.core"),
				new ClassInfoEntry("QTimerEvent", "io.qt.core"),
				new ClassInfoEntry("QChildEvent", "io.qt.core"),
				new ClassInfoEntry("QCustomEvent", "io.qt.core"),
				new ClassInfoEntry("QDynamicPropertyChangeEvent", "io.qt.core"),
				new ClassInfoEntry("QEventLoop", "io.qt.core"),
				new ClassInfoEntry("QMetaMethod", "io.qt.core"),
				new ClassInfoEntry("QMetaEnum", "io.qt.core"),
				new ClassInfoEntry("QMetaProperty", "io.qt.core"),
				new ClassInfoEntry("QMetaClassInfo", "io.qt.core"),
				new ClassInfoEntry("QMetaType", "io.qt.core"),
				new ClassInfoEntry("QMimeData", "io.qt.core"),
				new ClassInfoEntry("QObjectList", "io.qt.core"),
				new ClassInfoEntry("QObjectData", "io.qt.core"),
				new ClassInfoEntry("QObject", "io.qt.core"),
				new ClassInfoEntry("QObjectUserData", "io.qt.core"),
				new ClassInfoEntry("QObjectCleanupHandler", "io.qt.core"),
				new ClassInfoEntry("QGenericArgument", "io.qt.core"),
				new ClassInfoEntry("QGenericReturnArgument", "io.qt.core"),
				new ClassInfoEntry("QArgument", "io.qt.core"),
				new ClassInfoEntry("QReturnArgument", "io.qt.core"),
				new ClassInfoEntry("QMetaObject", "io.qt.core"),
				new ClassInfoEntry("QPointer", "io.qt.core"),
				new ClassInfoEntry("QSharedMemory", "io.qt.core"),
				new ClassInfoEntry("QSignalMapper", "io.qt.core"),
				new ClassInfoEntry("QSocketNotifier", "io.qt.core"),
				new ClassInfoEntry("QSystemSemaphore", "io.qt.core"),
				new ClassInfoEntry("QTimer", "io.qt.core"),
				new ClassInfoEntry("QTranslator", "io.qt.core"),
				new ClassInfoEntry("QVariant", "io.qt.core"),
				new ClassInfoEntry("QVariantList", "io.qt.core"),
				new ClassInfoEntry("QVariantMap", "io.qt.core"),
				new ClassInfoEntry("QVariantHash", "io.qt.core"),
				new ClassInfoEntry("QVariantComparisonHelper", "io.qt.core"),
				new ClassInfoEntry("QFactoryInterface", "io.qt.core"),
				new ClassInfoEntry("QLibrary", "io.qt.core"),
				new ClassInfoEntry("QtPlugin", "io.qt.core"),
				new ClassInfoEntry("QtPluginInstanceFunction", "io.qt.core"),
				new ClassInfoEntry("QPluginLoader", "io.qt.core"),
				new ClassInfoEntry("QUuid", "io.qt.core"),
				new ClassInfoEntry("QAtomicInt", "io.qt.core"),
				new ClassInfoEntry("QAtomicPointer", "io.qt.core"),
				new ClassInfoEntry("QBasicAtomicInt", "io.qt.core"),
				new ClassInfoEntry("QBasicAtomicPointer", "io.qt.core"),
				new ClassInfoEntry("QMutex", "io.qt.core"),
				new ClassInfoEntry("QMutexLocker", "io.qt.core"),
				new ClassInfoEntry("QMutexPrivate", "io.qt.core"),
				new ClassInfoEntry("QMutex", "io.qt.core"),
				new ClassInfoEntry("QMutexLocker", "io.qt.core"),
				new ClassInfoEntry("QReadWriteLock", "io.qt.core"),
				new ClassInfoEntry("QReadLocker", "io.qt.core"),
				new ClassInfoEntry("QWriteLocker", "io.qt.core"),
				new ClassInfoEntry("QReadWriteLock", "io.qt.core"),
				new ClassInfoEntry("QReadLocker", "io.qt.core"),
				new ClassInfoEntry("QWriteLocker", "io.qt.core"),
				new ClassInfoEntry("QSemaphore", "io.qt.core"),
				new ClassInfoEntry("QThread", "io.qt.core"),
				new ClassInfoEntry("QThread", "io.qt.core"),
				new ClassInfoEntry("QThreadStorageData", "io.qt.core"),
				new ClassInfoEntry("QThreadStorage", "io.qt.core"),
				new ClassInfoEntry("QWaitCondition", "io.qt.core"),
				new ClassInfoEntry("QWaitCondition", "io.qt.core"),
				new ClassInfoEntry("QtAlgorithms", "io.qt.core"),
				new ClassInfoEntry("QBitArray", "io.qt.core"),
				new ClassInfoEntry("QBitRef", "io.qt.core"),
				new ClassInfoEntry("QByteArray", "io.qt.core"),
				new ClassInfoEntry("QByteRef", "io.qt.core"),
				new ClassInfoEntry("QByteArrayMatcher", "io.qt.core"),
				new ClassInfoEntry("QCache", "io.qt.core"),
				new ClassInfoEntry("QLatin1Char", "io.qt.core"),
				new ClassInfoEntry("QChar", "io.qt.core"),
				new ClassInfoEntry("QtContainerFwd", "io.qt.core"),
				new ClassInfoEntry("QContiguousCacheData", "io.qt.core"),
				new ClassInfoEntry("QContiguousCacheTypedData", "io.qt.core"),
				new ClassInfoEntry("QContiguousCache", "io.qt.core"),
				new ClassInfoEntry("QCryptographicHash", "io.qt.core"),
				new ClassInfoEntry("QDate", "io.qt.core"),
				new ClassInfoEntry("QTime", "io.qt.core"),
				new ClassInfoEntry("QDateTime", "io.qt.core"),
				new ClassInfoEntry("QEasingCurve", "io.qt.core"),
				new ClassInfoEntry("QElapsedTimer", "io.qt.core"),
				new ClassInfoEntry("QHashData", "io.qt.core"),
				new ClassInfoEntry("QHashDummyValue", "io.qt.core"),
				new ClassInfoEntry("QHashDummyNode", "io.qt.core"),
				new ClassInfoEntry("QHashNode", "io.qt.core"),
				new ClassInfoEntry("QHash", "io.qt.core"),
				new ClassInfoEntry("QMultiHash", "io.qt.core"),
				new ClassInfoEntry("QHashIterator", "io.qt.core"),
				new ClassInfoEntry("QMutableHashIterator", "io.qt.core"),
				new ClassInfoEntry("QHashIterator", "io.qt.core"),
				new ClassInfoEntry("QMutableHashIterator", "io.qt.core"),
				new ClassInfoEntry("QLine", "io.qt.core"),
				new ClassInfoEntry("QLineF", "io.qt.core"),
				new ClassInfoEntry("QListData", "io.qt.core"),
				new ClassInfoEntry("QList", "io.qt.core"),
				new ClassInfoEntry("QListIterator", "io.qt.core"),
				new ClassInfoEntry("QMutableListIterator", "io.qt.core"),
				new ClassInfoEntry("QListIterator", "io.qt.core"),
				new ClassInfoEntry("QMutableListIterator", "io.qt.core"),
				new ClassInfoEntry("QSystemLocale", "io.qt.core"),
				new ClassInfoEntry("QLocale", "io.qt.core"),
				new ClassInfoEntry("QMapData", "io.qt.core"),
				new ClassInfoEntry("QMapNode", "io.qt.core"),
				new ClassInfoEntry("QMapPayloadNode", "io.qt.core"),
				new ClassInfoEntry("QMap", "io.qt.core"),
				new ClassInfoEntry("QMultiMap", "io.qt.core"),
				new ClassInfoEntry("QMapIterator", "io.qt.core"),
				new ClassInfoEntry("QMutableMapIterator", "io.qt.core"),
				new ClassInfoEntry("QMapIterator", "io.qt.core"),
				new ClassInfoEntry("QMutableMapIterator", "io.qt.core"),
				new ClassInfoEntry("QMargins", "io.qt.core"),
				new ClassInfoEntry("QPair", "io.qt.core"),
				new ClassInfoEntry("QPoint", "io.qt.core"),
				new ClassInfoEntry("QPointF", "io.qt.core"),
				new ClassInfoEntry("QQueue", "io.qt.core"),
				new ClassInfoEntry("QRect", "io.qt.core"),
				new ClassInfoEntry("QRectF", "io.qt.core"),
				new ClassInfoEntry("QScopedPointerDeleter", "io.qt.core"),
				new ClassInfoEntry("QScopedPointerArrayDeleter", "io.qt.core"),
				new ClassInfoEntry("QScopedPointerPodDeleter", "io.qt.core"),
				new ClassInfoEntry("QScopedPointer", "io.qt.core"),
				new ClassInfoEntry("QScopedArrayPointer", "io.qt.core"),
				new ClassInfoEntry("QSet", "io.qt.core"),
				new ClassInfoEntry("QSetIterator", "io.qt.core"),
				new ClassInfoEntry("QMutableSetIterator", "io.qt.core"),
				new ClassInfoEntry("QMutableSetIterator", "io.qt.core"),
				new ClassInfoEntry("QSharedData", "io.qt.core"),
				new ClassInfoEntry("QSharedDataPointer", "io.qt.core"),
				new ClassInfoEntry("QExplicitlySharedDataPointer", "io.qt.core"),
				new ClassInfoEntry("QSharedPointer", "io.qt.core"),
				new ClassInfoEntry("QWeakPointer", "io.qt.core"),
				new ClassInfoEntry("QSize", "io.qt.core"),
				new ClassInfoEntry("QSizeF", "io.qt.core"),
				new ClassInfoEntry("QStack", "io.qt.core"),
				new ClassInfoEntry("QStdWString", "io.qt.core"),
				new ClassInfoEntry("QString", "io.qt.core"),
				new ClassInfoEntry("QLatin1String", "io.qt.core"),
				new ClassInfoEntry("QCharRef", "io.qt.core"),
				new ClassInfoEntry("QLatin1Literal", "io.qt.core"),
				new ClassInfoEntry("QAbstractConcatenable", "io.qt.core"),
				new ClassInfoEntry("QConcatenable", "io.qt.core"),
				new ClassInfoEntry("QStringBuilder", "io.qt.core"),
				new ClassInfoEntry("QStringBuilder", "io.qt.core"),
				new ClassInfoEntry("QConcatenable", "io.qt.core"),
				new ClassInfoEntry("QStringListIterator", "io.qt.core"),
				new ClassInfoEntry("QMutableStringListIterator", "io.qt.core"),
				new ClassInfoEntry("QStringList", "io.qt.core"),
				new ClassInfoEntry("QStringMatcher", "io.qt.core"),
				new ClassInfoEntry("QTextBoundaryFinder", "io.qt.core"),
				new ClassInfoEntry("QTimeLine", "io.qt.core"),
				new ClassInfoEntry("QVarLengthArray", "io.qt.core"),
				new ClassInfoEntry("QXmlStreamAttribute", "io.qt.core"),
				new ClassInfoEntry("QXmlStreamAttributes", "io.qt.core"),
				new ClassInfoEntry("QXmlStreamNamespaceDeclaration", "io.qt.core"),
				new ClassInfoEntry("QXmlStreamNamespaceDeclarations", "io.qt.core"),
				new ClassInfoEntry("QXmlStreamNotationDeclaration", "io.qt.core"),
				new ClassInfoEntry("QXmlStreamNotationDeclarations", "io.qt.core"),
				new ClassInfoEntry("QXmlStreamEntityDeclaration", "io.qt.core"),
				new ClassInfoEntry("QXmlStreamEntityDeclarations", "io.qt.core"),
				new ClassInfoEntry("QXmlStreamEntityResolver", "io.qt.core"),
				new ClassInfoEntry("QXmlStreamReader", "io.qt.core"),
				new ClassInfoEntry("QXmlStreamWriter", "io.qt.core"),
				new ClassInfoEntry("QDomImplementation", "io.qt.xml"),
				new ClassInfoEntry("QDomNode", "io.qt.xml"),
				new ClassInfoEntry("QDomNodeList", "io.qt.xml"),
				new ClassInfoEntry("QDomDocumentType", "io.qt.xml"),
				new ClassInfoEntry("QDomDocument", "io.qt.xml"),
				new ClassInfoEntry("QDomNamedNodeMap", "io.qt.xml"),
				new ClassInfoEntry("QDomDocumentFragment", "io.qt.xml"),
				new ClassInfoEntry("QDomCharacterData", "io.qt.xml"),
				new ClassInfoEntry("QDomAttr", "io.qt.xml"),
				new ClassInfoEntry("QDomElement", "io.qt.xml"),
				new ClassInfoEntry("QDomText", "io.qt.xml"),
				new ClassInfoEntry("QDomComment", "io.qt.xml"),
				new ClassInfoEntry("QDomCDATASection", "io.qt.xml"),
				new ClassInfoEntry("QDomNotation", "io.qt.xml"),
				new ClassInfoEntry("QDomEntity", "io.qt.xml"),
				new ClassInfoEntry("QDomEntityReference", "io.qt.xml"),
				new ClassInfoEntry("QDomProcessingInstruction", "io.qt.xml"),
				new ClassInfoEntry("QXmlStreamAttribute", "io.qt.xml"),
				new ClassInfoEntry("QXmlStreamAttributes", "io.qt.xml"),
				new ClassInfoEntry("QXmlStreamEntityDeclaration", "io.qt.xml"),
				new ClassInfoEntry("QXmlStreamEntityDeclarations", "io.qt.xml"),
				new ClassInfoEntry("QXmlStreamEntityResolver", "io.qt.xml"),
				new ClassInfoEntry("QXmlStreamNamespaceDeclaration", "io.qt.xml"),
				new ClassInfoEntry("QXmlStreamNamespaceDeclarations", "io.qt.xml"),
				new ClassInfoEntry("QXmlStreamNotationDeclaration", "io.qt.xml"),
				new ClassInfoEntry("QXmlStreamNotationDeclarations", "io.qt.xml"),
				new ClassInfoEntry("QXmlStreamReader", "io.qt.xml"),
				new ClassInfoEntry("QXmlStreamWriter", "io.qt.xml"),
				new ClassInfoEntry("QNetworkCacheMetaData", "io.qt.network"),
				new ClassInfoEntry("QAbstractNetworkCache", "io.qt.network"),
				new ClassInfoEntry("QNetworkAccessManager", "io.qt.network"),
				new ClassInfoEntry("QNetworkCookie", "io.qt.network"),
				new ClassInfoEntry("QNetworkCookieJar", "io.qt.network"),
				new ClassInfoEntry("QNetworkDiskCache", "io.qt.network"),
				new ClassInfoEntry("QNetworkReply", "io.qt.network"),
				new ClassInfoEntry("QNetworkRequest", "io.qt.network"),
				new ClassInfoEntry("QAuthenticator", "io.qt.network"),
				new ClassInfoEntry("QIPv6Address", "io.qt.network"),
				new ClassInfoEntry("QHostAddress", "io.qt.network"),
				new ClassInfoEntry("QHostInfo", "io.qt.network"),
				new ClassInfoEntry("QNetworkAddressEntry", "io.qt.network"),
				new ClassInfoEntry("QNetworkInterface", "io.qt.network"),
				new ClassInfoEntry("QNetworkProxyQuery", "io.qt.network"),
				new ClassInfoEntry("QNetworkProxy", "io.qt.network"),
				new ClassInfoEntry("QNetworkProxyFactory", "io.qt.network"),
				new ClassInfoEntry("QAbstractSocket", "io.qt.network"),
				new ClassInfoEntry("QLocalServer", "io.qt.network"),
				new ClassInfoEntry("QLocalSocket", "io.qt.network"),
				new ClassInfoEntry("QTcpServer", "io.qt.network"),
				new ClassInfoEntry("QTcpSocket", "io.qt.network"),
				new ClassInfoEntry("QUdpSocket", "io.qt.network"),
				new ClassInfoEntry("QSsl", "io.qt.network"),
				new ClassInfoEntry("QSslCertificate", "io.qt.network"),
				new ClassInfoEntry("QSslCipher", "io.qt.network"),
				new ClassInfoEntry("QSslConfiguration", "io.qt.network"),
				new ClassInfoEntry("QSslError", "io.qt.network"),
				new ClassInfoEntry("QSslKey", "io.qt.network"),
				new ClassInfoEntry("QSslSocket", "io.qt.network"),
				new ClassInfoEntry("QHelpGlobal", "io.qt.help"),
				new ClassInfoEntry("QHelpContentItem", "io.qt.help"),
				new ClassInfoEntry("QHelpContentModel", "io.qt.help"),
				new ClassInfoEntry("QHelpContentWidget", "io.qt.help"),
				new ClassInfoEntry("QHelpEngine", "io.qt.help"),
				new ClassInfoEntry("QHelpEngineCore", "io.qt.help"),
				new ClassInfoEntry("QHelpIndexModel", "io.qt.help"),
				new ClassInfoEntry("QHelpIndexWidget", "io.qt.help"),
				new ClassInfoEntry("QHelpSearchQuery", "io.qt.help"),
				new ClassInfoEntry("QHelpSearchEngine", "io.qt.help"),
				new ClassInfoEntry("QHelpSearchQueryWidget", "io.qt.help"),
				new ClassInfoEntry("QHelpSearchResultWidget", "io.qt.help"),
				new ClassInfoEntry("QAudio", "io.qt.multimedia"),
				new ClassInfoEntry("QAudioDeviceInfo", "io.qt.multimedia"),
				new ClassInfoEntry("QAbstractAudioDeviceInfo", "io.qt.multimedia"),
				new ClassInfoEntry("QAbstractAudioOutput", "io.qt.multimedia"),
				new ClassInfoEntry("QAbstractAudioInput", "io.qt.multimedia"),
				new ClassInfoEntry("QAudioEngineFactoryInterface", "io.qt.multimedia"),
				new ClassInfoEntry("QAudioEnginePlugin", "io.qt.multimedia"),
				new ClassInfoEntry("QAudioFormat", "io.qt.multimedia"),
				new ClassInfoEntry("QAudioInput", "io.qt.multimedia"),
				new ClassInfoEntry("QAudioOutput", "io.qt.multimedia"),
				new ClassInfoEntry("QAbstractVideoBuffer", "io.qt.multimedia"),
				new ClassInfoEntry("QAbstractVideoSurface", "io.qt.multimedia"),
				new ClassInfoEntry("QVideoFrame", "io.qt.multimedia"),
				new ClassInfoEntry("QVideoSurfaceFormat", "io.qt.multimedia"),
				new ClassInfoEntry("QSignalSpy", "io.qt.test"),
				new ClassInfoEntry("QTest", "io.qt.test"),
				new ClassInfoEntry("QTestAccessibilityEvent", "io.qt.test"),
				new ClassInfoEntry("QTestAccessibility", "io.qt.test"),
				new ClassInfoEntry("QTestData", "io.qt.test"),
				new ClassInfoEntry("QTestEvent", "io.qt.test"),
				new ClassInfoEntry("QTestKeyEvent", "io.qt.test"),
				new ClassInfoEntry("QTestKeyClicksEvent", "io.qt.test"),
				new ClassInfoEntry("QTestMouseEvent", "io.qt.test"),
				new ClassInfoEntry("QTestDelayEvent", "io.qt.test"),
				new ClassInfoEntry("QTestEventList", "io.qt.test"),
				new ClassInfoEntry("QTestEventLoop", "io.qt.test"),
				new ClassInfoEntry("QEventSizeOfChecker", "io.qt.test"),
				new ClassInfoEntry("QEventSizeOfChecker", "io.qt.test"),
				new ClassInfoEntry("QSpontaneKeyEvent", "io.qt.test"),
				new ClassInfoEntry("QDBusAbstractAdaptor", "io.qt.dbus"),
				new ClassInfoEntry("QDBusAbstractInterfaceBase", "io.qt.dbus"),
				new ClassInfoEntry("QDBusAbstractInterface", "io.qt.dbus"),
				new ClassInfoEntry("QDBusArgument", "io.qt.dbus"),
				new ClassInfoEntry("QDBusConnection", "io.qt.dbus"),
				new ClassInfoEntry("QDBusConnectionInterface", "io.qt.dbus"),
				new ClassInfoEntry("QDBusContext", "io.qt.dbus"),
				new ClassInfoEntry("QDBusError", "io.qt.dbus"),
				new ClassInfoEntry("QDBusObjectPath", "io.qt.dbus"),
				new ClassInfoEntry("QDBusSignature", "io.qt.dbus"),
				new ClassInfoEntry("QDBusVariant", "io.qt.dbus"),
				new ClassInfoEntry("QDBusInterface", "io.qt.dbus"),
				new ClassInfoEntry("QDBusMessage", "io.qt.dbus"),
				new ClassInfoEntry("QDBusMetaType", "io.qt.dbus"),
				new ClassInfoEntry("QDBusPendingCall", "io.qt.dbus"),
				new ClassInfoEntry("QDBusPendingCallWatcher", "io.qt.dbus"),
				new ClassInfoEntry("QDBusPendingReplyData", "io.qt.dbus"),
				new ClassInfoEntry("QDBusPendingReply", "io.qt.dbus"),
				new ClassInfoEntry("QDBusReply", "io.qt.dbus"),
				new ClassInfoEntry("QDBusReply", "io.qt.dbus"),
				new ClassInfoEntry("QDBusServer", "io.qt.dbus"),
				new ClassInfoEntry("QDBusServiceWatcher", "io.qt.dbus"),
				new ClassInfoEntry("QSqlDriverCreatorBase", "io.qt.sql"),
				new ClassInfoEntry("QSqlDriverCreator", "io.qt.sql"),
				new ClassInfoEntry("QSqlDatabase", "io.qt.sql"),
				new ClassInfoEntry("QSqlDriver", "io.qt.sql"),
				new ClassInfoEntry("QSqlDriverFactoryInterface", "io.qt.sql"),
				new ClassInfoEntry("QSqlDriverPlugin", "io.qt.sql"),
				new ClassInfoEntry("QSqlError", "io.qt.sql"),
				new ClassInfoEntry("QSqlField", "io.qt.sql"),
				new ClassInfoEntry("QSqlIndex", "io.qt.sql"),
				new ClassInfoEntry("QSqlQuery", "io.qt.sql"),
				new ClassInfoEntry("QSqlRecord", "io.qt.sql"),
				new ClassInfoEntry("QSqlResult", "io.qt.sql"),
				new ClassInfoEntry("QSqlQueryModel", "io.qt.sql"),
				new ClassInfoEntry("QSqlRelationalDelegate", "io.qt.sql"),
				new ClassInfoEntry("QSqlRelation", "io.qt.sql"),
				new ClassInfoEntry("QSqlRelationalTableModel", "io.qt.sql"),
				new ClassInfoEntry("QSqlTableModel", "io.qt.sql"),
				new ClassInfoEntry("QAccessible", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleInterface", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleInterfaceEx", "io.qt.widgets"),
				new ClassInfoEntry("QAccessible2Interface", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleTextInterface", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleEditableTextInterface", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleSimpleEditableTextInterface", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleValueInterface", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleTableInterface", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleActionInterface", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleImageInterface", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleBridge", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleBridgeFactoryInterface", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleBridgePlugin", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleObject", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleObjectEx", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleApplication", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleFactoryInterface", "io.qt.widgets"),
				new ClassInfoEntry("QAccessiblePlugin", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleWidget", "io.qt.widgets"),
				new ClassInfoEntry("QAccessibleWidgetEx", "io.qt.widgets"),
				new ClassInfoEntry("QAbstractPrintDialog", "io.qt.printsupport"),
				new ClassInfoEntry("QColorDialog", "io.qt.widgets"),
				new ClassInfoEntry("QDialog", "io.qt.widgets"),
				new ClassInfoEntry("QErrorMessage", "io.qt.widgets"),
				new ClassInfoEntry("QFileDialog", "io.qt.widgets"),
				new ClassInfoEntry("QFileSystemModel", "io.qt.gui"),
				new ClassInfoEntry("QFontDialog", "io.qt.widgets"),
				new ClassInfoEntry("QInputDialog", "io.qt.widgets"),
				new ClassInfoEntry("QMessageBox", "io.qt.widgets"),
				new ClassInfoEntry("QPageSetupDialog", "io.qt.printsupport"),
				new ClassInfoEntry("QOpenGLWidget", "io.qt.opengl.widgets"),
				new ClassInfoEntry("QPrintDialog", "io.qt.printsupport"),
				new ClassInfoEntry("QPrintPreviewDialog", "io.qt.printsupport"),
				new ClassInfoEntry("QProgressDialog", "io.qt.widgets"),
				new ClassInfoEntry("QWizard", "io.qt.widgets"),
				new ClassInfoEntry("QWizardPage", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsEffect", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsColorizeEffect", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsBlurEffect", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsDropShadowEffect", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsOpacityEffect", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsAnchor", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsAnchorLayout", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsGridLayout", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsItem", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsObject", "io.qt.widgets"),
				new ClassInfoEntry("QAbstractGraphicsShapeItem", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsPathItem", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsRectItem", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsEllipseItem", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsPolygonItem", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsLineItem", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsPixmapItem", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsTextItem", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsSimpleTextItem", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsItemGroup", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsItemAnimation", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsLayout", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsLayoutItem", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsLinearLayout", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsProxyWidget", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsScene", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsSceneEvent", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsSceneMouseEvent", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsSceneWheelEvent", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsSceneContextMenuEvent", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsSceneHoverEvent", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsSceneHelpEvent", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsSceneDragDropEvent", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsSceneResizeEvent", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsSceneMoveEvent", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsTransform", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsScale", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsRotation", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsView", "io.qt.widgets"),
				new ClassInfoEntry("QGraphicsWidget", "io.qt.widgets"),
				new ClassInfoEntry("QBitmap", "io.qt.gui"),
				new ClassInfoEntry("QIcon", "io.qt.gui"),
				new ClassInfoEntry("QIconEngine", "io.qt.gui"),
				new ClassInfoEntry("QIconEngineFactoryInterface", "io.qt.gui"),
				new ClassInfoEntry("QIconEnginePlugin", "io.qt.gui"),
				new ClassInfoEntry("QIconEngineFactoryInterfaceV2", "io.qt.gui"),
				new ClassInfoEntry("QImage", "io.qt.gui"),
				new ClassInfoEntry("QImageIOHandler", "io.qt.gui"),
				new ClassInfoEntry("QImageIOHandlerFactoryInterface", "io.qt.gui"),
				new ClassInfoEntry("QImageIOPlugin", "io.qt.gui"),
				new ClassInfoEntry("QImageReader", "io.qt.gui"),
				new ClassInfoEntry("QImageWriter", "io.qt.gui"),
				new ClassInfoEntry("QMovie", "io.qt.gui"),
				new ClassInfoEntry("QPicture", "io.qt.gui"),
				new ClassInfoEntry("QPixmap", "io.qt.gui"),
				new ClassInfoEntry("QPixmapCache", "io.qt.gui"),
				new ClassInfoEntry("QAbstractItemDelegate", "io.qt.widgets"),
				new ClassInfoEntry("QAbstractItemView", "io.qt.widgets"),
				new ClassInfoEntry("QAbstractProxyModel", "io.qt.core"),
				new ClassInfoEntry("QColumnView", "io.qt.widgets"),
				new ClassInfoEntry("QDataWidgetMapper", "io.qt.widgets"),
				new ClassInfoEntry("QFileIconProvider", "io.qt.widgets"),
				new ClassInfoEntry("QHeaderView", "io.qt.widgets"),
				new ClassInfoEntry("QItemDelegate", "io.qt.widgets"),
				new ClassInfoEntry("QItemEditorCreatorBase", "io.qt.widgets"),
				new ClassInfoEntry("QItemEditorCreator", "io.qt.widgets"),
				new ClassInfoEntry("QStandardItemEditorCreator", "io.qt.widgets"),
				new ClassInfoEntry("QItemEditorFactory", "io.qt.widgets"),
				new ClassInfoEntry("QItemSelectionRange", "io.qt.widgets"),
				new ClassInfoEntry("QItemSelectionModel", "io.qt.widgets"),
				new ClassInfoEntry("QItemSelection", "io.qt.widgets"),
				new ClassInfoEntry("QListView", "io.qt.widgets"),
				new ClassInfoEntry("QListWidgetItem", "io.qt.widgets"),
				new ClassInfoEntry("QListWidget", "io.qt.widgets"),
				new ClassInfoEntry("QSortFilterProxyModel", "io.qt.core"),
				new ClassInfoEntry("QStandardItem", "io.qt.gui"),
				new ClassInfoEntry("QStandardItemModel", "io.qt.gui"),
				new ClassInfoEntry("QStringListModel", "io.qt.core"),
				new ClassInfoEntry("QStyledItemDelegate", "io.qt.widgets"),
				new ClassInfoEntry("QTableView", "io.qt.widgets"),
				new ClassInfoEntry("QTableWidgetSelectionRange", "io.qt.widgets"),
				new ClassInfoEntry("QTableWidgetItem", "io.qt.widgets"),
				new ClassInfoEntry("QTableWidget", "io.qt.widgets"),
				new ClassInfoEntry("QTreeView", "io.qt.widgets"),
				new ClassInfoEntry("QTreeWidgetItem", "io.qt.widgets"),
				new ClassInfoEntry("QTreeWidget", "io.qt.widgets"),
				new ClassInfoEntry("QTreeWidgetItemIterator", "io.qt.widgets"),
				new ClassInfoEntry("QAction", "io.qt.gui"),
				new ClassInfoEntry("QActionGroup", "io.qt.gui"),
				new ClassInfoEntry("QApplication", "io.qt.widgets"),
				new ClassInfoEntry("QBoxLayout", "io.qt.widgets"),
				new ClassInfoEntry("QHBoxLayout", "io.qt.widgets"),
				new ClassInfoEntry("QVBoxLayout", "io.qt.widgets"),
				new ClassInfoEntry("QClipboard", "io.qt.gui"),
				new ClassInfoEntry("QCursor", "io.qt.gui"),
				new ClassInfoEntry("QCursor", "io.qt.gui"),
				new ClassInfoEntry("QCursorShape", "io.qt.widgets"),
				new ClassInfoEntry("QDrag", "io.qt.widgets"),
				new ClassInfoEntry("QtEvents", "io.qt.gui"),
				new ClassInfoEntry("QInputEvent", "io.qt.gui"),
				new ClassInfoEntry("QMouseEvent", "io.qt.gui"),
				new ClassInfoEntry("QHoverEvent", "io.qt.gui"),
				new ClassInfoEntry("QWheelEvent", "io.qt.gui"),
				new ClassInfoEntry("QTabletEvent", "io.qt.gui"),
				new ClassInfoEntry("QKeyEvent", "io.qt.gui"),
				new ClassInfoEntry("QFocusEvent", "io.qt.gui"),
				new ClassInfoEntry("QPaintEvent", "io.qt.gui"),
				new ClassInfoEntry("QUpdateLaterEvent", "io.qt.gui"),
				new ClassInfoEntry("QMoveEvent", "io.qt.gui"),
				new ClassInfoEntry("QResizeEvent", "io.qt.gui"),
				new ClassInfoEntry("QCloseEvent", "io.qt.gui"),
				new ClassInfoEntry("QIconDragEvent", "io.qt.gui"),
				new ClassInfoEntry("QShowEvent", "io.qt.gui"),
				new ClassInfoEntry("QHideEvent", "io.qt.gui"),
				new ClassInfoEntry("QContextMenuEvent", "io.qt.gui"),
				new ClassInfoEntry("QInputMethodEvent", "io.qt.gui"),
				new ClassInfoEntry("QDropEvent", "io.qt.gui"),
				new ClassInfoEntry("QDragMoveEvent", "io.qt.gui"),
				new ClassInfoEntry("QDragEnterEvent", "io.qt.gui"),
				new ClassInfoEntry("QDragLeaveEvent", "io.qt.gui"),
				new ClassInfoEntry("QHelpEvent", "io.qt.gui"),
				new ClassInfoEntry("QStatusTipEvent", "io.qt.gui"),
				new ClassInfoEntry("QWhatsThisClickedEvent", "io.qt.gui"),
				new ClassInfoEntry("QActionEvent", "io.qt.gui"),
				new ClassInfoEntry("QFileOpenEvent", "io.qt.gui"),
				new ClassInfoEntry("QToolBarChangeEvent", "io.qt.gui"),
				new ClassInfoEntry("QShortcutEvent", "io.qt.gui"),
				new ClassInfoEntry("QClipboardEvent", "io.qt.gui"),
				new ClassInfoEntry("QWindowStateChangeEvent", "io.qt.gui"),
				new ClassInfoEntry("QMenubarUpdatedEvent", "io.qt.gui"),
				new ClassInfoEntry("QTouchEvent", "io.qt.gui"),
				new ClassInfoEntry("QGestureEvent", "io.qt.gui"),
				new ClassInfoEntry("QScrollPrepareEvent", "io.qt.gui"),
				new ClassInfoEntry("QScrollEvent", "io.qt.gui"),
				new ClassInfoEntry("QFormLayout", "io.qt.widgets"),
				new ClassInfoEntry("QGenericPluginFactoryInterface", "io.qt.gui"),
				new ClassInfoEntry("QGenericPlugin", "io.qt.gui"),
				new ClassInfoEntry("QGenericPluginFactory", "io.qt.gui"),
				new ClassInfoEntry("QGesture", "io.qt.widgets"),
				new ClassInfoEntry("QPanGesture", "io.qt.widgets"),
				new ClassInfoEntry("QPinchGesture", "io.qt.widgets"),
				new ClassInfoEntry("QSwipeGesture", "io.qt.widgets"),
				new ClassInfoEntry("QTapGesture", "io.qt.widgets"),
				new ClassInfoEntry("QTapAndHoldGesture", "io.qt.widgets"),
				new ClassInfoEntry("QGestureRecognizer", "io.qt.widgets"),
				new ClassInfoEntry("QGridLayout", "io.qt.widgets"),
				new ClassInfoEntry("QKeySequence", "io.qt.gui"),
				new ClassInfoEntry("QKeySequence", "io.qt.gui"),
				new ClassInfoEntry("QLayoutIterator", "io.qt.widgets"),
				new ClassInfoEntry("QLayout", "io.qt.widgets"),
				new ClassInfoEntry("QLayoutItem", "io.qt.widgets"),
				new ClassInfoEntry("QSpacerItem", "io.qt.widgets"),
				new ClassInfoEntry("QWidgetItem", "io.qt.widgets"),
				new ClassInfoEntry("QWidgetItemV2", "io.qt.widgets"),
				new ClassInfoEntry("QPalette", "io.qt.gui"),
				new ClassInfoEntry("QColorGroup", "io.qt.widgets"),
				new ClassInfoEntry("QSessionManager", "io.qt.gui"),
				new ClassInfoEntry("QShortcut", "io.qt.gui"),
				new ClassInfoEntry("QSizePolicy", "io.qt.widgets"),
				new ClassInfoEntry("QStackedLayout", "io.qt.widgets"),
				new ClassInfoEntry("QToolTip", "io.qt.widgets"),
				new ClassInfoEntry("QWhatsThis", "io.qt.widgets"),
				new ClassInfoEntry("QWidgetData", "io.qt.widgets"),
				new ClassInfoEntry("QWidget", "io.qt.widgets"),
				new ClassInfoEntry("QWidgetAction", "io.qt.widgets"),
				new ClassInfoEntry("QWidgetList", "io.qt.widgets"),
				new ClassInfoEntry("QWidgetMapper", "io.qt.widgets"),
				new ClassInfoEntry("QWidgetSet", "io.qt.widgets"),
				new ClassInfoEntry("QWindowSystemInterface", "io.qt.widgets"),
				new ClassInfoEntry("QGenericMatrix", "io.qt.gui"),
				new ClassInfoEntry("QMatrix2x2", "io.qt.gui"),
				new ClassInfoEntry("QMatrix2x3", "io.qt.gui"),
				new ClassInfoEntry("QMatrix2x4", "io.qt.gui"),
				new ClassInfoEntry("QMatrix3x2", "io.qt.gui"),
				new ClassInfoEntry("QMatrix3x3", "io.qt.gui"),
				new ClassInfoEntry("QMatrix3x4", "io.qt.gui"),
				new ClassInfoEntry("QMatrix4x2", "io.qt.gui"),
				new ClassInfoEntry("QMatrix4x3", "io.qt.gui"),
				new ClassInfoEntry("QMatrix4x4", "io.qt.gui"),
				new ClassInfoEntry("QQuaternion", "io.qt.gui"),
				new ClassInfoEntry("QVector2D", "io.qt.gui"),
				new ClassInfoEntry("QVector3D", "io.qt.gui"),
				new ClassInfoEntry("QVector4D", "io.qt.gui"),
				new ClassInfoEntry("QBrush", "io.qt.gui"),
				new ClassInfoEntry("QBrushData", "io.qt.gui"),
				new ClassInfoEntry("QGradientStop", "io.qt.gui"),
				new ClassInfoEntry("QGradientStops", "io.qt.gui"),
				new ClassInfoEntry("QGradient", "io.qt.gui"),
				new ClassInfoEntry("QLinearGradient", "io.qt.gui"),
				new ClassInfoEntry("QRadialGradient", "io.qt.gui"),
				new ClassInfoEntry("QConicalGradient", "io.qt.gui"),
				new ClassInfoEntry("QColor", "io.qt.gui"),
				new ClassInfoEntry("QColormap", "io.qt.gui"),
				new ClassInfoEntry("QTileRules", "io.qt.gui"),
				new ClassInfoEntry("QMatrix", "io.qt.gui"),
				new ClassInfoEntry("QPaintDevice", "io.qt.gui"),
				new ClassInfoEntry("QTextItem", "io.qt.gui"),
				new ClassInfoEntry("QPaintEngine", "io.qt.gui"),
				new ClassInfoEntry("QPaintEngineState", "io.qt.gui"),
				new ClassInfoEntry("QPainter", "io.qt.gui"),
				new ClassInfoEntry("QPainterPath", "io.qt.gui"),
				new ClassInfoEntry("QPainterPathPrivate", "io.qt.gui"),
				new ClassInfoEntry("QPainterPathStroker", "io.qt.gui"),
				new ClassInfoEntry("QPen", "io.qt.gui"),
				new ClassInfoEntry("QPolygon", "io.qt.gui"),
				new ClassInfoEntry("QPolygonF", "io.qt.gui"),
				new ClassInfoEntry("QPrintEngine", "io.qt.gui"),
				new ClassInfoEntry("QPrinter", "io.qt.gui"),
				new ClassInfoEntry("QPrinterInfo", "io.qt.gui"),
				new ClassInfoEntry("QRegion", "io.qt.gui"),
				new ClassInfoEntry("QRgb", "io.qt.gui"),
				new ClassInfoEntry("QStylePainter", "io.qt.gui"),
				new ClassInfoEntry("QTransform", "io.qt.gui"),
				new ClassInfoEntry("QCommonStyle", "io.qt.widgets"),
				new ClassInfoEntry("QProxyStyle", "io.qt.widgets"),
				new ClassInfoEntry("QStyle", "io.qt.widgets"),
				new ClassInfoEntry("QStyleFactory", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOption", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionFocusRect", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionFrame", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionTabWidgetFrame", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionTabBarBase", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionHeader", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionButton", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionTab", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionToolBar", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionProgressBar", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionMenuItem", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionDockWidget", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionViewItem", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionToolBox", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionRubberBand", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionComplex", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionSlider", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionSpinBox", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionToolButton", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionComboBox", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionTitleBar", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionGroupBox", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionSizeGrip", "io.qt.widgets"),
				new ClassInfoEntry("QStyleOptionGraphicsItem", "io.qt.widgets"),
				new ClassInfoEntry("QStyleHintReturn", "io.qt.widgets"),
				new ClassInfoEntry("QStyleHintReturnMask", "io.qt.widgets"),
				new ClassInfoEntry("QStyleHintReturnVariant", "io.qt.widgets"),
				new ClassInfoEntry("QStyleFactoryInterface", "io.qt.widgets"),
				new ClassInfoEntry("QStylePlugin", "io.qt.widgets"),
				new ClassInfoEntry("QFontEngineInfo", "io.qt.gui"),
				new ClassInfoEntry("QFontEngineFactoryInterface", "io.qt.gui"),
				new ClassInfoEntry("QFontEnginePlugin", "io.qt.gui"),
				new ClassInfoEntry("QAbstractFontEngine", "io.qt.gui"),
				new ClassInfoEntry("QAbstractTextDocumentLayout", "io.qt.gui"),
				new ClassInfoEntry("QTextObjectInterface", "io.qt.gui"),
				new ClassInfoEntry("QFont", "io.qt.gui"),
				new ClassInfoEntry("QFontDatabase", "io.qt.gui"),
				new ClassInfoEntry("QFontInfo", "io.qt.gui"),
				new ClassInfoEntry("QFontMetrics", "io.qt.gui"),
				new ClassInfoEntry("QFontMetricsF", "io.qt.gui"),
				new ClassInfoEntry("QGlyphs", "io.qt.gui"),
				new ClassInfoEntry("QStaticText", "io.qt.gui"),
				new ClassInfoEntry("QSyntaxHighlighter", "io.qt.gui"),
				new ClassInfoEntry("QTextCursor", "io.qt.gui"),
				new ClassInfoEntry("QAbstractUndoItem", "io.qt.gui"),
				new ClassInfoEntry("QTextDocument", "io.qt.gui"),
				new ClassInfoEntry("QTextDocumentFragment", "io.qt.gui"),
				new ClassInfoEntry("QTextDocumentWriter", "io.qt.gui"),
				new ClassInfoEntry("QTextLength", "io.qt.gui"),
				new ClassInfoEntry("QTextFormat", "io.qt.gui"),
				new ClassInfoEntry("QTextCharFormat", "io.qt.gui"),
				new ClassInfoEntry("QTextBlockFormat", "io.qt.gui"),
				new ClassInfoEntry("QTextListFormat", "io.qt.gui"),
				new ClassInfoEntry("QTextImageFormat", "io.qt.gui"),
				new ClassInfoEntry("QTextFrameFormat", "io.qt.gui"),
				new ClassInfoEntry("QTextTableFormat", "io.qt.gui"),
				new ClassInfoEntry("QTextTableCellFormat", "io.qt.gui"),
				new ClassInfoEntry("QTextInlineObject", "io.qt.gui"),
				new ClassInfoEntry("QTextLayout", "io.qt.gui"),
				new ClassInfoEntry("QTextLine", "io.qt.gui"),
				new ClassInfoEntry("QTextList", "io.qt.gui"),
				new ClassInfoEntry("QTextObject", "io.qt.gui"),
				new ClassInfoEntry("QTextBlockGroup", "io.qt.gui"),
				new ClassInfoEntry("QTextFrameLayoutData", "io.qt.gui"),
				new ClassInfoEntry("QTextFrame", "io.qt.gui"),
				new ClassInfoEntry("QTextBlockUserData", "io.qt.gui"),
				new ClassInfoEntry("QTextBlock", "io.qt.gui"),
				new ClassInfoEntry("QTextFragment", "io.qt.gui"),
				new ClassInfoEntry("QTextOption", "io.qt.gui"),
				new ClassInfoEntry("QTextTableCell", "io.qt.gui"),
				new ClassInfoEntry("QTextTable", "io.qt.widgets"),
				new ClassInfoEntry("QCompleter", "io.qt.widgets"),
				new ClassInfoEntry("QDesktopServices", "io.qt.widgets"),
				new ClassInfoEntry("QScroller", "io.qt.widgets"),
				new ClassInfoEntry("QScrollerProperties", "io.qt.widgets"),
				new ClassInfoEntry("QSystemTrayIcon", "io.qt.gui"),
				new ClassInfoEntry("QUndoGroup", "io.qt.gui"),
				new ClassInfoEntry("QUndoCommand", "io.qt.gui"),
				new ClassInfoEntry("QUndoStack", "io.qt.gui"),
				new ClassInfoEntry("QUndoView", "io.qt.widgets"),
				new ClassInfoEntry("QAbstractButton", "io.qt.widgets"),
				new ClassInfoEntry("QAbstractScrollArea", "io.qt.widgets"),
				new ClassInfoEntry("QAbstractSlider", "io.qt.widgets"),
				new ClassInfoEntry("QAbstractSpinBox", "io.qt.widgets"),
				new ClassInfoEntry("QButtonGroup", "io.qt.widgets"),
				new ClassInfoEntry("QCalendarWidget", "io.qt.widgets"),
				new ClassInfoEntry("QCheckBox", "io.qt.widgets"),
				new ClassInfoEntry("QComboBox", "io.qt.widgets"),
				new ClassInfoEntry("QCommandLinkButton", "io.qt.widgets"),
				new ClassInfoEntry("QDateTimeEdit", "io.qt.widgets"),
				new ClassInfoEntry("QTimeEdit", "io.qt.widgets"),
				new ClassInfoEntry("QDateEdit", "io.qt.widgets"),
				new ClassInfoEntry("QDial", "io.qt.widgets"),
				new ClassInfoEntry("QDialogButtonBox", "io.qt.widgets"),
				new ClassInfoEntry("QDockWidget", "io.qt.widgets"),
				new ClassInfoEntry("QFocusFrame", "io.qt.widgets"),
				new ClassInfoEntry("QFontComboBox", "io.qt.widgets"),
				new ClassInfoEntry("QFrame", "io.qt.widgets"),
				new ClassInfoEntry("QGroupBox", "io.qt.widgets"),
				new ClassInfoEntry("QKeySequenceEdit", "io.qt.widgets"),
				new ClassInfoEntry("QLabel", "io.qt.widgets"),
				new ClassInfoEntry("QLCDNumber", "io.qt.widgets"),
				new ClassInfoEntry("QLineEdit", "io.qt.widgets"),
				new ClassInfoEntry("QMainWindow", "io.qt.widgets"),
				new ClassInfoEntry("QMdiArea", "io.qt.widgets"),
				new ClassInfoEntry("QMdiSubWindow", "io.qt.widgets"),
				new ClassInfoEntry("QMenu", "io.qt.widgets"),
				new ClassInfoEntry("QMenuBar", "io.qt.widgets"),
				new ClassInfoEntry("QMenuItem", "io.qt.widgets"),
				new ClassInfoEntry("QPlainTextEdit", "io.qt.widgets"),
				new ClassInfoEntry("QPlainTextDocumentLayout", "io.qt.widgets"),
				new ClassInfoEntry("QPrintPreviewWidget", "io.qt.printsupport"),
				new ClassInfoEntry("QProgressBar", "io.qt.widgets"),
				new ClassInfoEntry("QPushButton", "io.qt.widgets"),
				new ClassInfoEntry("QRadioButton", "io.qt.widgets"),
				new ClassInfoEntry("QRubberBand", "io.qt.widgets"),
				new ClassInfoEntry("QScrollArea", "io.qt.widgets"),
				new ClassInfoEntry("QScrollBar", "io.qt.widgets"),
				new ClassInfoEntry("QSizeGrip", "io.qt.widgets"),
				new ClassInfoEntry("QSlider", "io.qt.widgets"),
				new ClassInfoEntry("QSpinBox", "io.qt.widgets"),
				new ClassInfoEntry("QDoubleSpinBox", "io.qt.widgets"),
				new ClassInfoEntry("QSplashScreen", "io.qt.widgets"),
				new ClassInfoEntry("QSplitter", "io.qt.widgets"),
				new ClassInfoEntry("QSplitterHandle", "io.qt.widgets"),
				new ClassInfoEntry("QStackedWidget", "io.qt.widgets"),
				new ClassInfoEntry("QStatusBar", "io.qt.widgets"),
				new ClassInfoEntry("QTabBar", "io.qt.widgets"),
				new ClassInfoEntry("QTabWidget", "io.qt.widgets"),
				new ClassInfoEntry("QTextBrowser", "io.qt.widgets"),
				new ClassInfoEntry("QTextEdit", "io.qt.widgets"),
				new ClassInfoEntry("QToolBar", "io.qt.widgets"),
				new ClassInfoEntry("QToolBox", "io.qt.widgets"),
				new ClassInfoEntry("QToolButton", "io.qt.widgets"),
				new ClassInfoEntry("QValidator", "io.qt.gui"),
				new ClassInfoEntry("QIntValidator", "io.qt.gui"),
				new ClassInfoEntry("QDoubleValidator", "io.qt.gui"),
				new ClassInfoEntry("QRegularExpressionValidator", "io.qt.gui"),
				new ClassInfoEntry("QDesignerComponents", "io.qt.designer"),
				new ClassInfoEntry("QExtensionFactory", "io.qt.designer"),
				new ClassInfoEntry("QAbstractExtensionFactory", "io.qt.designer"),
				new ClassInfoEntry("QAbstractExtensionManager", "io.qt.designer"),
				new ClassInfoEntry("QExtensionManager", "io.qt.designer"),
				new ClassInfoEntry("QDesignerActionEditorInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerBrushManagerInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerDnDItemInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerFormEditorInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerFormEditorPluginInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerFormWindowInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerFormWindowCursorInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerFormWindowManagerInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerFormWindowToolInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerIconCacheInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerIntegrationInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerLanguageExtension", "io.qt.designer"),
				new ClassInfoEntry("QDesignerMetaDataBaseItemInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerMetaDataBaseInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerObjectInspectorInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerPromotionInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerPropertyEditorInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerResourceBrowserInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerWidgetBoxInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerWidgetDataBaseItemInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerWidgetDataBaseInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerWidgetFactoryInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerDynamicPropertySheetExtension", "io.qt.designer"),
				new ClassInfoEntry("QDesignerExtraInfoExtension", "io.qt.designer"),
				new ClassInfoEntry("QDesignerLayoutDecorationExtension", "io.qt.designer"),
				new ClassInfoEntry("QDesignerMemberSheetExtension", "io.qt.designer"),
				new ClassInfoEntry("QDesignerPropertySheetExtension", "io.qt.designer"),
				new ClassInfoEntry("QDesignerTaskMenuExtension", "io.qt.designer"),
				new ClassInfoEntry("QAbstractFormBuilder", "io.qt.designer"),
				new ClassInfoEntry("QDesignerContainerExtension", "io.qt.designer"),
				new ClassInfoEntry("QDesignerCustomWidgetInterface", "io.qt.designer"),
				new ClassInfoEntry("QDesignerCustomWidgetCollectionInterface", "io.qt.designer"),
				new ClassInfoEntry("QFormBuilder", "io.qt.designer"),
				new ClassInfoEntry("QDesignerExportWidget", "io.qt.designer"),
				new ClassInfoEntry("QGraphicsSvgItem", "io.qt.svg.widgets"),
				new ClassInfoEntry("QSvgWidget", "io.qt.svg.widgets"),
				new ClassInfoEntry("QSvgGenerator", "io.qt.svg"),
				new ClassInfoEntry("QSvgRenderer", "io.qt.svg"),
				new ClassInfoEntry("QQuickWidget", "io.qt.quick.widgets"),
				new ClassInfoEntry("QVideoWidget", "io.qt.multimedia.widgets"),
				new ClassInfoEntry("QWebEngineView", "io.qt.webengine.widgets"),
				new ClassInfoEntry("QAxObject", "io.qt.activex"),
				new ClassInfoEntry("QAxWidget", "io.qt.activex"),
				new ClassInfoEntry("QAxBase", "io.qt.activex"),
				new ClassInfoEntry("QAxBaseObject", "io.qt.activex"),
				new ClassInfoEntry("QAxBaseWidget", "io.qt.activex"),
				new ClassInfoEntry("QAxScript", "io.qt.activex"),
				new ClassInfoEntry("QAxScriptEngine", "io.qt.activex"),
				new ClassInfoEntry("QAxScriptManager", "io.qt.activex"),
				new ClassInfoEntry("QAxSelect", "io.qt.activex")
			);
	}
}
