/*
 * Decompiled with CFR 0.152.
 */
package io.qt.uic;

import io.qt.core.QFile;
import io.qt.core.QHash;
import io.qt.core.QIODevice;
import io.qt.core.QPair;
import io.qt.uic.Option;
import io.qt.uic.Uic;
import io.qt.uic.ui4.DomAction;
import io.qt.uic.ui4.DomActionGroup;
import io.qt.uic.ui4.DomAttributeInterface;
import io.qt.uic.ui4.DomButtonGroup;
import io.qt.uic.ui4.DomLayout;
import io.qt.uic.ui4.DomLayoutItem;
import io.qt.uic.ui4.DomSpacer;
import io.qt.uic.ui4.DomWidget;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Objects;

public class Driver {
    private boolean isFirst = true;
    final Option m_option = new Option();
    final QHash<DomWidget, String> m_widgets = new QHash(DomWidget.class, String.class);
    final QHash<DomSpacer, String> m_spacers = new QHash(DomSpacer.class, String.class);
    final QHash<DomLayout, String> m_layouts = new QHash(DomLayout.class, String.class);
    final QHash<DomActionGroup, String> m_actionGroups = new QHash(DomActionGroup.class, String.class);
    final QHash<DomButtonGroup, String> m_buttonGroups = new QHash(DomButtonGroup.class, String.class);
    final QHash<DomAction, String> m_actions = new QHash(DomAction.class, String.class);
    final QHash<String, Boolean> m_nameRepository = new QHash(String.class, Boolean.TYPE);
    boolean m_idBasedTranslations = false;

    private <DomClass extends DomAttributeInterface> String findOrInsert(QHash<DomClass, String> domHash, DomClass dom, String className) {
        Iterator it = domHash.find(dom).iterator();
        if (!it.hasNext()) {
            String name;
            String value = name = this.unique(dom.attributeName(), className);
            if (!this.isFirst) {
                value = "this." + name;
            } else {
                this.isFirst = false;
            }
            domHash.insert(dom, (Object)value);
            return value;
        }
        return (String)((QPair)it.next()).second;
    }

    private <DomClass extends DomAttributeInterface> DomClass findByAttributeName(QHash<DomClass, String> domHash, String name) {
        QPair<DomClass, String> pair = this.findByAttributeNameIt(domHash, name);
        return (DomClass)(pair != null ? (DomAttributeInterface)pair.first : null);
    }

    private <DomClass extends DomAttributeInterface> QPair<DomClass, String> findByAttributeNameIt(QHash<DomClass, String> domHash, String name) {
        for (QPair pair : domHash) {
            if (!Objects.equals(name, ((DomAttributeInterface)pair.first).attributeName())) continue;
            return pair;
        }
        return null;
    }

    public boolean printDependencies(String fileName) {
        assert (this.m_option.dependencies);
        this.m_option.inputFile = fileName;
        Uic tool = new Uic(this);
        return tool.printDependencies();
    }

    public boolean uic(String fileName) {
        return this.uic(fileName, null, "java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uic(String fileName, String outputDir, String language) {
        Object input = fileName == null || fileName.isEmpty() ? QIODevice.fromInputStream((InputStream)System.in) : new QFile(fileName);
        if (!input.isOpen() && !input.open(new QIODevice.OpenModeFlag[]{QIODevice.OpenModeFlag.ReadOnly})) {
            System.err.println("QtJambi UIC: Unable to read input: " + input.errorString());
            return false;
        }
        this.m_option.inputFile = fileName;
        Uic tool = new Uic(this);
        try {
            boolean bl = tool.write((QIODevice)input, outputDir, language);
            return bl;
        }
        finally {
            input.close();
            input.dispose();
        }
    }

    public Option option() {
        return this.m_option;
    }

    public static String normalizedName(String name) {
        String[] elements = name.split("::");
        name = elements[elements.length - 1];
        char[] result = name.toCharArray();
        for (int i = 0; i < result.length; ++i) {
            if (Character.isJavaIdentifierPart(result[i])) continue;
            result[i] = 95;
        }
        if (result.length > 0 && !Character.isJavaIdentifierStart(result[0])) {
            return "_" + new String(result);
        }
        return new String(result);
    }

    public static String qtify(String name) {
        if (name.charAt(0) == 'Q' || name.charAt(0) == 'K') {
            name = name.substring(1);
        }
        char[] chars = name.toCharArray();
        int size = chars.length;
        for (int i = 0; i < size && Character.isUpperCase(chars[i]); ++i) {
            chars[i] = Character.toLowerCase(chars[i]);
        }
        return new String(chars);
    }

    public String unique() {
        return this.unique("");
    }

    public String unique(String instanceName) {
        return this.unique(instanceName, "");
    }

    public String unique(String instanceName, String className) {
        String name;
        boolean alreadyUsed = false;
        if (instanceName != null && !instanceName.isEmpty()) {
            String base = name = Driver.qtify(Driver.normalizedName(instanceName));
            int id = 1;
            while (this.m_nameRepository.contains((Object)name)) {
                alreadyUsed = true;
                name = base + id;
                ++id;
            }
        } else {
            name = !className.isEmpty() ? this.unique(Driver.qtify(className)) : this.unique("var");
        }
        if (alreadyUsed && !className.isEmpty()) {
            System.err.println(String.format("%1$s: Warning: The name '%2$s' (%3$s) is already in use, defaulting to '%4$s'.", this.m_option.messagePrefix(), instanceName, className, name));
        }
        this.m_nameRepository.insert((Object)name, (Object)true);
        return name;
    }

    public String findOrInsertWidget(DomWidget ui_widget) {
        return this.findOrInsert(this.m_widgets, ui_widget, ui_widget.attributeClass());
    }

    public String findOrInsertSpacer(DomSpacer ui_spacer) {
        return this.findOrInsert(this.m_spacers, ui_spacer, "QSpacerItem");
    }

    public String findOrInsertLayout(DomLayout ui_layout) {
        return this.findOrInsert(this.m_layouts, ui_layout, ui_layout.attributeClass());
    }

    public String findOrInsertLayoutItem(DomLayoutItem ui_layoutItem) {
        switch (ui_layoutItem.kind()) {
            case Widget: {
                return this.findOrInsertWidget(ui_layoutItem.elementWidget());
            }
            case Spacer: {
                return this.findOrInsertSpacer(ui_layoutItem.elementSpacer());
            }
            case Layout: {
                return this.findOrInsertLayout(ui_layoutItem.elementLayout());
            }
        }
        return "";
    }

    public String findOrInsertName(String name) {
        return this.unique(name);
    }

    public String findOrInsertActionGroup(DomActionGroup ui_group) {
        return this.findOrInsert(this.m_actionGroups, ui_group, "QActionGroup");
    }

    public String findOrInsertAction(DomAction ui_action) {
        return this.findOrInsert(this.m_actions, ui_action, "QAction");
    }

    public String findOrInsertButtonGroup(DomButtonGroup ui_group) {
        return this.findOrInsert(this.m_buttonGroups, ui_group, "QButtonGroup");
    }

    public DomButtonGroup findButtonGroup(String attributeName) {
        return this.findByAttributeName(this.m_buttonGroups, attributeName);
    }

    public DomWidget widgetByName(String attributeName) {
        return this.findByAttributeName(this.m_widgets, attributeName);
    }

    public String widgetVariableName(String attributeName) {
        QPair<DomWidget, String> pair = this.findByAttributeNameIt(this.m_widgets, attributeName);
        return pair != null ? (String)pair.second : "";
    }

    public DomActionGroup actionGroupByName(String attributeName) {
        return this.findByAttributeName(this.m_actionGroups, attributeName);
    }

    public DomAction actionByName(String attributeName) {
        return this.findByAttributeName(this.m_actions, attributeName);
    }

    public boolean useIdBasedTranslations() {
        return this.m_idBasedTranslations;
    }

    public void setUseIdBasedTranslations(boolean u) {
        this.m_idBasedTranslations = u;
    }
}

