package io.qt.uic.ui4;

import io.qt.*;
import static io.qt.QtUtilities.*;

/**
 * @hidden
 */
final class QtJambi_LibraryUtilities {

    final static int qtMajorVersion = 5;

    final static int qtMinorVersion = 15;

    final static int qtJambiPatch = 18;

    final static InternalAccess internal;

    static{
        try {
            initializePackage("io.qt.core");
            loadQtLibrary("DBus", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("EglFSDeviceIntegration", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("Network", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("OpenGL", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("Positioning", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("PrintSupport", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("Qml", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("QmlModels", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("Quick", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("QuickWidgets", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("Svg", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("WaylandClient", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("WebChannel", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("WebEngineCore", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("WebEngineWidgets", LibraryRequirementMode.ProvideOnly);
            loadQtLibrary("Widgets", LibraryRequirementMode.ProvideOnly, "linux", "macos");
            loadQtLibrary("WlShellIntegration", LibraryRequirementMode.ProvideOnly, "linux");
            loadQtLibrary("XcbQpa", LibraryRequirementMode.ProvideOnly, "linux");
            loadUtilityLibrary("libGLESv2", LibraryRequirementMode.Optional, "windows");
            loadUtilityLibrary("libEGL", LibraryRequirementMode.Optional, "windows");
            loadQtLibrary("Gui", LibraryRequirementMode.Mandatory);
            loadQtLibrary("Widgets", LibraryRequirementMode.Mandatory);
            loadQtLibrary("Xml", LibraryRequirementMode.Mandatory);
            loadQtLibrary("Designer", LibraryRequirementMode.Mandatory);
            loadQtJambiLibrary("UIC");
        } catch(Error t) {
            throw t;
        } catch(Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
        internal = internalAccess();
    }
    private static native InternalAccess internalAccess();

    static void initialize() { };

    private QtJambi_LibraryUtilities() throws InstantiationError { throw new InstantiationError("Cannot instantiate QtJambi_LibraryUtilities."); }
}

