/*
 * Decompiled with CFR 0.152.
 */
package io.qt.uic.java;

import io.qt.core.QCoreApplication;
import io.qt.core.QFileInfo;
import io.qt.core.QTextStream;
import io.qt.uic.ClassInfoEntries;
import io.qt.uic.ClassInfoEntry;
import io.qt.uic.Option;
import io.qt.uic.Uic;
import io.qt.uic.WriteIncludesBase;
import io.qt.uic.ui4.DomCustomWidget;
import io.qt.uic.ui4.DomInclude;
import io.qt.uic.ui4.DomUI;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class WriteImports
extends WriteIncludesBase {
    private final QTextStream m_output;
    private final Option m_option;
    private final TreeSet<String> m_imports = new TreeSet();
    private final Set<String> m_includeBaseNames = new TreeSet<String>();
    public static final Map<String, String> m_classToPackage = new TreeMap<String, String>();

    public WriteImports(Uic uic) {
        super(uic);
        this.m_output = uic.output();
        this.m_option = uic.option();
    }

    @Override
    public void acceptUI(DomUI node) {
        this.m_imports.clear();
        this.m_includeBaseNames.clear();
        if (this.m_option.copyrightHeader) {
            this.m_output.writeString("/********************************************************************************\n");
            if (this.m_option.inputFile == null || this.m_option.inputFile.isEmpty()) {
                this.m_output.writeString(" * Form generated from reading UI file\n");
            } else {
                this.m_output.writeString(" * Form generated from reading UI file '" + new QFileInfo(this.m_option.inputFile).fileName() + "'\n");
            }
            this.m_output.writeString(" *\n");
            this.m_output.writeString(" * Created by: QtJambi User Interface Compiler version " + QCoreApplication.applicationVersion() + "\n");
            this.m_output.writeString(" *\n");
            this.m_output.writeString(" * WARNING! All changes made in this file will be lost when recompiling UI file!\n");
            this.m_output.writeString(" *******************************************************************************/\n\n");
            String comment = node.elementComment();
            if (comment != null && !comment.isEmpty()) {
                this.m_output.writeString("/**\n");
                this.m_output.writeString(" *" + comment);
                this.m_output.writeString("\n */\n\n");
            }
        }
        this.m_output.append("package ").append(this.m_option.targetPackage).append(';').endl().endl();
        super.acceptUI(node);
        boolean connectSlotsByName = true;
        if (node.hasAttributeConnectslotsbyname()) {
            connectSlotsByName = node.attributeConnectslotsbyname();
        }
        if (this.m_option.autoConnection && connectSlotsByName) {
            this.m_imports.add("io.qt.core.*");
        }
        String includeFile = this.uic().option().imports;
        for (String incl : includeFile.split(",")) {
            this.m_imports.add(incl);
        }
        TreeSet<String> packages = new TreeSet<String>();
        packages.add(this.m_option.targetPackage);
        for (String imprt : this.m_imports) {
            if ((imprt = imprt.trim()).isEmpty()) continue;
            String[] inamespaceList = imprt.split("\\.");
            if (inamespaceList.length > 0) {
                String last = inamespaceList[inamespaceList.length - 1];
                String currentPackage = String.join((CharSequence)".", Arrays.copyOf(inamespaceList, inamespaceList.length - 1));
                if ("*".equals(last)) {
                    packages.add(currentPackage);
                } else if (packages.contains(currentPackage)) continue;
            }
            this.m_output.append("import ").append(imprt).append(';').endl();
        }
        this.m_output.endl();
    }

    private void insertIncludeForClass(String className, String header) {
        if (header.isEmpty()) {
            if (m_classToPackage.containsKey(className)) {
                header = m_classToPackage.get(className);
            } else {
                String namespaceSeparator;
                String lowerClassName = className.toLowerCase();
                int namespaceIndex = lowerClassName.lastIndexOf(namespaceSeparator = "::");
                if (namespaceIndex != -1) {
                    lowerClassName = lowerClassName.substring(0, namespaceIndex + namespaceSeparator.length());
                }
                if (this.m_includeBaseNames.contains(lowerClassName)) {
                    header = "";
                }
            }
        }
        if (!header.isEmpty()) {
            this.insertInclude(header);
        }
    }

    @Override
    public void doAdd(String className, DomCustomWidget dcw) {
        if (dcw != null) {
            if (className.contains("::")) {
                this.insertInclude(className.replace("::", "."));
            } else if (dcw.hasElementHeader()) {
                if (dcw.elementHeader().text().toLowerCase().endsWith(".h")) {
                    this.insertIncludeForClass(className, "");
                } else {
                    this.insertInclude(dcw.elementHeader().text().replace("::", "."));
                }
            }
        } else {
            this.insertIncludeForClass(className, "");
        }
    }

    @Override
    public void acceptInclude(DomInclude node) {
        if (m_classToPackage.containsKey(node.text())) {
            this.insertInclude(m_classToPackage.get(node.text()));
        } else {
            this.insertInclude(node.text());
        }
    }

    private void insertInclude(String incl) {
        CharSequence[] namespaceList = incl.split("\\.");
        if (namespaceList.length > 0) {
            namespaceList[namespaceList.length - 1] = "*";
            incl = String.join((CharSequence)".", namespaceList);
        }
        this.m_imports.add(incl);
    }

    protected QTextStream output() {
        return this.m_output;
    }

    static {
        for (ClassInfoEntry e : ClassInfoEntries.classInfoEntries()) {
            m_classToPackage.put(e.klass, e.packge + "." + e.klass);
        }
        m_classToPackage.put("QtCore", "io.qt.core.*");
        m_classToPackage.put("QtGui", "io.qt.gui.*");
        m_classToPackage.put("QtWidgets", "io.qt.widgets.*");
        m_classToPackage.put("QtSvgWidgets", "io.qt.svg.widgets.*");
        m_classToPackage.put("QtSvg", "io.qt.svg.*");
        m_classToPackage.put("QtSql", "io.qt.sql.*");
        m_classToPackage.put("QtNetwork", "io.qt.network.*");
        m_classToPackage.put("ActiveQt", "io.qt.activex.*");
        m_classToPackage.put("QtQuickWidgets", "io.qt.quick.widgets.*");
        m_classToPackage.put("QtQuick", "io.qt.quick.*");
        m_classToPackage.put("QtQml", "io.qt.qml.*");
    }
}

