package io.qt.texttospeech;


/**
 * <p>The base for text-to-speech engine integrations</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html">QTextToSpeechEngine</a></p>
 */
public abstract class QTextToSpeechEngine extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QTextToSpeechEngine.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QTextToSpeechEngine {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public java.util.List<io.qt.core.QLocale> availableLocales(){
            return availableLocales_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.util.List<io.qt.core.QLocale> availableLocales_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public java.util.List<io.qt.texttospeech.QVoice> availableVoices(){
            return availableVoices_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native java.util.List<io.qt.texttospeech.QVoice> availableVoices_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.core.QLocale locale(){
            return locale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.core.QLocale locale_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void pause(){
            pause_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void pause_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public double pitch(){
            return pitch_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native double pitch_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public double rate(){
            return rate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native double rate_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void resume(){
            resume_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void resume_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void say(java.lang.String text){
            say_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), text);
        }
        @io.qt.QtUninvokable
        private native void say_native_cref_QString(long __this__nativeId, java.lang.String text);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean setLocale(io.qt.core.QLocale locale){
            return setLocale_native_cref_QLocale(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(locale));
        }
        @io.qt.QtUninvokable
        private native boolean setLocale_native_cref_QLocale(long __this__nativeId, long locale);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean setPitch(double pitch){
            return setPitch_native_double(QtJambi_LibraryUtilities.internal.nativeId(this), pitch);
        }
        @io.qt.QtUninvokable
        private native boolean setPitch_native_double(long __this__nativeId, double pitch);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean setRate(double rate){
            return setRate_native_double(QtJambi_LibraryUtilities.internal.nativeId(this), rate);
        }
        @io.qt.QtUninvokable
        private native boolean setRate_native_double(long __this__nativeId, double rate);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean setVoice(io.qt.texttospeech.QVoice voice){
            return setVoice_native_cref_QVoice(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(voice));
        }
        @io.qt.QtUninvokable
        private native boolean setVoice_native_cref_QVoice(long __this__nativeId, long voice);
        
        
        @Override
        @io.qt.QtUninvokable
        public boolean setVolume(double volume){
            return setVolume_native_double(QtJambi_LibraryUtilities.internal.nativeId(this), volume);
        }
        @io.qt.QtUninvokable
        private native boolean setVolume_native_double(long __this__nativeId, double volume);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.texttospeech.QTextToSpeech.State state(){
            return io.qt.texttospeech.QTextToSpeech.State.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        @io.qt.QtUninvokable
        private native int state_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public void stop(){
            stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native void stop_native(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.texttospeech.QVoice voice(){
            return voice_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.texttospeech.QVoice voice_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public double volume(){
            return volume_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native double volume_native_constfct(long __this__nativeId);
        
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#stateChanged">QTextToSpeechEngine::stateChanged(QTextToSpeech::State)</a></p>
     */
    public final Signal1<io.qt.texttospeech.QTextToSpeech.State> stateChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QTextToSpeechEngine(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QTextToSpeechEngine() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#QTextToSpeechEngine">QTextToSpeechEngine::QTextToSpeechEngine(QObject*)</a></p>
     */
    public QTextToSpeechEngine(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QTextToSpeechEngine instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#availableLocales">QTextToSpeechEngine::availableLocales()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.util.List<io.qt.core.QLocale> availableLocales();
    
    @io.qt.QtUninvokable
    private native java.util.List<io.qt.core.QLocale> availableLocales_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#availableVoices">QTextToSpeechEngine::availableVoices()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract java.util.List<io.qt.texttospeech.QVoice> availableVoices();
    
    @io.qt.QtUninvokable
    private native java.util.List<io.qt.texttospeech.QVoice> availableVoices_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#locale">QTextToSpeechEngine::locale()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.core.QLocale locale();
    
    @io.qt.QtUninvokable
    private native io.qt.core.QLocale locale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#pause">QTextToSpeechEngine::pause()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void pause();
    
    @io.qt.QtUninvokable
    private native void pause_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#pitch">QTextToSpeechEngine::pitch()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract double pitch();
    
    @io.qt.QtUninvokable
    private native double pitch_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#rate">QTextToSpeechEngine::rate()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract double rate();
    
    @io.qt.QtUninvokable
    private native double rate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#resume">QTextToSpeechEngine::resume()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void resume();
    
    @io.qt.QtUninvokable
    private native void resume_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#say">QTextToSpeechEngine::say(QString)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void say(java.lang.String text);
    
    @io.qt.QtUninvokable
    private native void say_native_cref_QString(long __this__nativeId, java.lang.String text);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#setLocale">QTextToSpeechEngine::setLocale(QLocale)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean setLocale(io.qt.core.QLocale locale);
    
    @io.qt.QtUninvokable
    private native boolean setLocale_native_cref_QLocale(long __this__nativeId, long locale);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#setPitch">QTextToSpeechEngine::setPitch(double)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean setPitch(double pitch);
    
    @io.qt.QtUninvokable
    private native boolean setPitch_native_double(long __this__nativeId, double pitch);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#setRate">QTextToSpeechEngine::setRate(double)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean setRate(double rate);
    
    @io.qt.QtUninvokable
    private native boolean setRate_native_double(long __this__nativeId, double rate);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#setVoice">QTextToSpeechEngine::setVoice(QVoice)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean setVoice(io.qt.texttospeech.QVoice voice);
    
    @io.qt.QtUninvokable
    private native boolean setVoice_native_cref_QVoice(long __this__nativeId, long voice);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#setVolume">QTextToSpeechEngine::setVolume(double)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract boolean setVolume(double volume);
    
    @io.qt.QtUninvokable
    private native boolean setVolume_native_double(long __this__nativeId, double volume);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#state">QTextToSpeechEngine::state()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.texttospeech.QTextToSpeech.State state();
    
    @io.qt.QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#stop">QTextToSpeechEngine::stop()</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void stop();
    
    @io.qt.QtUninvokable
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#voice">QTextToSpeechEngine::voice()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.texttospeech.QVoice voice();
    
    @io.qt.QtUninvokable
    private native io.qt.texttospeech.QVoice voice_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#volume">QTextToSpeechEngine::volume()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract double volume();
    
    @io.qt.QtUninvokable
    private native double volume_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#createVoice">QTextToSpeechEngine::createVoice(QString,QVoice::Gender,QVoice::Age,QVariant)</a></p>
     */
    protected static io.qt.texttospeech.QVoice createVoice(java.lang.String name, io.qt.texttospeech.QVoice.Gender gender, io.qt.texttospeech.QVoice.Age age, java.lang.Object data){
        return createVoice_native_cref_QString_QVoice_Gender_QVoice_Age_cref_QVariant(name, gender.value(), age.value(), data);
    }
    
    private native static io.qt.texttospeech.QVoice createVoice_native_cref_QString_QVoice_Gender_QVoice_Age_cref_QVariant(java.lang.String name, int gender, int age, java.lang.Object data);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeechengine.html#voiceData">QTextToSpeechEngine::voiceData(QVoice)</a></p>
     */
    protected static java.lang.Object voiceData(io.qt.texttospeech.QVoice voice){
        return voiceData_native_cref_QVoice(QtJambi_LibraryUtilities.internal.checkedNativeId(voice));
    }
    
    private native static java.lang.Object voiceData_native_cref_QVoice(long voice);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QTextToSpeechEngine(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QTextToSpeechEngine(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QTextToSpeechEngine instance, QDeclarativeConstructor constructor);
    
}
