package io.qt.texttospeech;


/**
 * <p>Convenient access to text-to-speech engines</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qtexttospeech.html">QTextToSpeech</a></p>
 */
public class QTextToSpeech extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QTextToSpeech.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qtexttospeech.html#State-enum">QTextToSpeech::State</a></p>
     */
    public enum State implements io.qt.QtEnumerator {
        Ready(0),
        Speaking(1),
        Paused(2),
        BackendError(3);

        private State(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static State resolve(int value) {
            switch (value) {
            case 0: return Ready;
            case 1: return Speaking;
            case 2: return Paused;
            case 3: return BackendError;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#locale-prop">QTextToSpeech::localeChanged(QLocale)</a></p>
     */
    @io.qt.QtPropertyNotify(name="locale")
    public final Signal1<io.qt.core.QLocale> localeChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#pitch-prop">QTextToSpeech::pitchChanged(double)</a></p>
     */
    @io.qt.QtPropertyNotify(name="pitch")
    public final Signal1<@io.qt.QtPrimitiveType Double> pitchChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#rate-prop">QTextToSpeech::rateChanged(double)</a></p>
     */
    @io.qt.QtPropertyNotify(name="rate")
    public final Signal1<@io.qt.QtPrimitiveType Double> rateChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#state-prop">QTextToSpeech::stateChanged(QTextToSpeech::State)</a></p>
     */
    @io.qt.QtPropertyNotify(name="state")
    public final Signal1<io.qt.texttospeech.QTextToSpeech.State> stateChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#voice-prop">QTextToSpeech::voiceChanged(QVoice)</a></p>
     */
    @io.qt.QtPropertyNotify(name="voice")
    public final Signal1<io.qt.texttospeech.QVoice> voiceChanged = new Signal1<>();

    /**
     * <p>Wrapper class for overloaded signals:</p>
     * <ul>
     * <li><code>volumeChanged(double volume)</code></li>
     * <li><code>volumeChanged(int volume)</code></li>
     * </ul>
     */
    public final class MultiSignal_volumeChanged extends MultiSignal{
        private MultiSignal_volumeChanged(){
            super();
        }

        /**
         * <p>Provides an overloaded signal by parameter type.</p>
         * <p>The only valid calls are:</p><ul>
         * <li><code>volumeChanged.overload(double.class)</code></li>
         * <li><code>volumeChanged.overload(int.class)</code></li>
         * </ul>
         * <p>{@link io.qt.QNoSuchSignalException} is thrown otherwise.</p>

         * @param <A> signal parameter type
         * @param type1 value of type A
         * @return overloaded signal
         * @throws io.qt.QNoSuchSignalException if signal is not available
         */
        @io.qt.QtAllowedTypeSet({double.class})
        @io.qt.QtAllowedTypeSet({int.class})
        public final <A> Signal1<A> overload(Class<A> type1) throws io.qt.QNoSuchSignalException{
            return (Signal1<A>)super.overload(type1);
        }

        /**
         * Initializes a connection to the <i>slot</i>.
         * 
         * @param slot the slot to be connected
         * @param connectionType type of connection
         * @return connection if successful or <code>null</code> otherwise
         * @throws io.qt.QMisfittingSignatureException Raised if their signatures are incompatible.
         * @throws io.qt.QUninvokableSlotException Raised if slot is annotated <code>&commat;QtUninvokable</code>.
         */
        public final <A> io.qt.core.QMetaObject.Connection connect(io.qt.core.QMetaObject.Slot1<A> slot, io.qt.core.Qt.ConnectionType... connectionType) throws io.qt.QNoSuchSignalException{
            return super.connect(slot, connectionType);
        }

        /**
         * Removes the connection to the given <i>slot</i>.
         * 
         * @param slot the slot to be disconnected
         * @return <code>true</code> if successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A> boolean disconnect(io.qt.core.QMetaObject.Slot1<A> slot) {
            return super.disconnect(slot);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws io.qt.QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A> io.qt.core.QMetaObject.Connection connect(io.qt.core.QMetaObject.Connectable1<A> signal, io.qt.core.Qt.ConnectionType... connectionType) throws io.qt.QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A> boolean disconnect(io.qt.core.QMetaObject.Connectable1<A> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * Creates a connection from this signal to another. Whenever this signal is emitted, it will cause the second
         * signal to be emitted as well.
         * 
         * @param signal The second signal. This will be emitted whenever this signal is emitted.
         * @param connectionType One of the connection types defined in the Qt interface.
         * @return connection if successful or <code>null</code> otherwise
         * @throws io.qt.QMisfittingSignatureException Raised if their signatures are incompatible.
         */
        public final <A> io.qt.core.QMetaObject.Connection connect(io.qt.core.QMetaObject.AbstractPublicSignal1<A> signal, io.qt.core.Qt.ConnectionType... connectionType) throws io.qt.QNoSuchSignalException{
            return super.connect((io.qt.core.QMetaObject.AbstractSignal)signal, connectionType);
        }

        /**
         * Disconnects a signal from another signal if the two were previously connected by a call to connect.
         * A call to this function will assure that the emission of the first signal will not cause the emission of the second.
         * 
         * @param signal The second signal.
         * @return <code>true</code> if the two signals were successfully disconnected, or <code>false</code> otherwise.
         */
        public final <A> boolean disconnect(io.qt.core.QMetaObject.AbstractPublicSignal1<A> signal) {
            return super.disconnect((io.qt.core.QMetaObject.AbstractSignal)signal);
        }

        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#volume-prop">QTextToSpeech::volumeChanged(double)</a></p>
         * 
         */
    @io.qt.QtPropertyNotify(name="volume")
        public final void emit(double volume) {
            ((Signal1<java.lang.Double>)overload(double.class)).emit(volume);
        }

        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#volume-prop">QTextToSpeech::volumeChanged(int)</a></p>
         * 
         */
    @io.qt.QtPropertyNotify(name="volume")
        public final void emit(int volume) {
            ((Signal1<java.lang.Integer>)overload(int.class)).emit(volume);
        }

    };


    /**
     * <p>Overloaded signals:</p>
     * <ul>
     * <li><code>volumeChanged(double volume)</code></li>
     * <li><code>volumeChanged(int volume)</code></li>
     * </ul>
     */
    public final MultiSignal_volumeChanged volumeChanged = new MultiSignal_volumeChanged();

    
    /**
     * <p>Overloaded constructor for {@link #QTextToSpeech(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QTextToSpeech() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#QTextToSpeech">QTextToSpeech::QTextToSpeech(QObject*)</a></p>
     */
    public QTextToSpeech(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QTextToSpeech instance, io.qt.core.QObject parent);
    
    /**
     * <p>Overloaded constructor for {@link #QTextToSpeech(java.lang.String, io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QTextToSpeech(java.lang.String engine) {
        this(engine, (io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#QTextToSpeech-1">QTextToSpeech::QTextToSpeech(QString,QObject*)</a></p>
     */
    public QTextToSpeech(java.lang.String engine, io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, engine, parent);
    }
    
    private native static void initialize_native(QTextToSpeech instance, java.lang.String engine, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#availableLocales">QTextToSpeech::availableLocales()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QVector<io.qt.core.QLocale> availableLocales(){
        return availableLocales_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QVector<io.qt.core.QLocale> availableLocales_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#availableVoices">QTextToSpeech::availableVoices()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QVector<io.qt.texttospeech.QVoice> availableVoices(){
        return availableVoices_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QVector<io.qt.texttospeech.QVoice> availableVoices_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#locale-prop">QTextToSpeech::locale()const</a></p>
     */
    @io.qt.QtPropertyReader(name="locale")
    @io.qt.QtUninvokable
    public final io.qt.core.QLocale locale(){
        return locale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QLocale locale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#pause">QTextToSpeech::pause()</a></p>
     */
    public final void pause(){
        pause_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void pause_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#pitch-prop">QTextToSpeech::pitch()const</a></p>
     */
    @io.qt.QtPropertyReader(name="pitch")
    @io.qt.QtUninvokable
    public final double pitch(){
        return pitch_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double pitch_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#rate-prop">QTextToSpeech::rate()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rate")
    @io.qt.QtUninvokable
    public final double rate(){
        return rate_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double rate_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#resume">QTextToSpeech::resume()</a></p>
     */
    public final void resume(){
        resume_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void resume_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#say">QTextToSpeech::say(QString)</a></p>
     */
    public final void say(java.lang.String text){
        say_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), text);
    }
    
    private native void say_native_cref_QString(long __this__nativeId, java.lang.String text);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#setLocale">QTextToSpeech::setLocale(QLocale)</a></p>
     */
    @io.qt.QtPropertyWriter(name="locale")
    public final void setLocale(io.qt.core.QLocale locale){
        setLocale_native_cref_QLocale(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(locale));
    }
    
    private native void setLocale_native_cref_QLocale(long __this__nativeId, long locale);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#pitch-prop">QTextToSpeech::setPitch(double)</a></p>
     */
    @io.qt.QtPropertyWriter(name="pitch")
    public final void setPitch(double pitch){
        setPitch_native_double(QtJambi_LibraryUtilities.internal.nativeId(this), pitch);
    }
    
    private native void setPitch_native_double(long __this__nativeId, double pitch);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#rate-prop">QTextToSpeech::setRate(double)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rate")
    public final void setRate(double rate){
        setRate_native_double(QtJambi_LibraryUtilities.internal.nativeId(this), rate);
    }
    
    private native void setRate_native_double(long __this__nativeId, double rate);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#setVoice">QTextToSpeech::setVoice(QVoice)</a></p>
     */
    @io.qt.QtPropertyWriter(name="voice")
    public final void setVoice(io.qt.texttospeech.QVoice voice){
        setVoice_native_cref_QVoice(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(voice));
    }
    
    private native void setVoice_native_cref_QVoice(long __this__nativeId, long voice);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#volume-prop">QTextToSpeech::setVolume(double)</a></p>
     */
    @io.qt.QtPropertyWriter(name="volume")
    public final void setVolume(double volume){
        setVolume_native_double(QtJambi_LibraryUtilities.internal.nativeId(this), volume);
    }
    
    private native void setVolume_native_double(long __this__nativeId, double volume);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#state-prop">QTextToSpeech::state()const</a></p>
     */
    @io.qt.QtPropertyReader(name="state")
    @io.qt.QtUninvokable
    public final io.qt.texttospeech.QTextToSpeech.State state(){
        return io.qt.texttospeech.QTextToSpeech.State.resolve(state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int state_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#stop">QTextToSpeech::stop()</a></p>
     */
    public final void stop(){
        stop_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void stop_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#voice-prop">QTextToSpeech::voice()const</a></p>
     */
    @io.qt.QtPropertyReader(name="voice")
    @io.qt.QtUninvokable
    public final io.qt.texttospeech.QVoice voice(){
        return voice_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.texttospeech.QVoice voice_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#volume-prop">QTextToSpeech::volume()const</a></p>
     */
    @io.qt.QtPropertyReader(name="volume")
    @io.qt.QtUninvokable
    public final double volume(){
        return volume_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double volume_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qtexttospeech.html#availableEngines">QTextToSpeech::availableEngines()</a></p>
     */
    public native static io.qt.core.QStringList availableEngines();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QTextToSpeech(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QTextToSpeech(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QTextToSpeech instance, QDeclarativeConstructor constructor);
    
}
