package io.qt.test;


/**
 * <p>Contains all the functions and declarations that are related to Qt Test</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qtest.html">QTest</a></p>
 */
public final class QTest
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private QTest() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace QTest."); }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qtest.html#KeyAction-enum">QTest::KeyAction</a></p>
     */
    public enum KeyAction implements io.qt.QtEnumerator {
        Press(0),
        Release(1),
        Click(2),
        Shortcut(3);

        private KeyAction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static KeyAction resolve(int value) {
            switch (value) {
            case 0: return Press;
            case 1: return Release;
            case 2: return Click;
            case 3: return Shortcut;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qtest.html#MouseAction-enum">QTest::MouseAction</a></p>
     */
    public enum MouseAction implements io.qt.QtEnumerator {
        MousePress(0),
        MouseRelease(1),
        MouseClick(2),
        MouseDClick(3),
        MouseMove(4);

        private MouseAction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static MouseAction resolve(int value) {
            switch (value) {
            case 0: return MousePress;
            case 1: return MouseRelease;
            case 2: return MouseClick;
            case 3: return MouseDClick;
            case 4: return MouseMove;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qtest.html#QBenchmarkMetric-enum">QTest::QBenchmarkMetric</a></p>
     */
    public enum QBenchmarkMetric implements io.qt.QtEnumerator {
        FramesPerSecond(0),
        BitsPerSecond(1),
        BytesPerSecond(2),
        WalltimeMilliseconds(3),
        CPUTicks(4),
        InstructionReads(5),
        Events(6),
        WalltimeNanoseconds(7),
        BytesAllocated(8),
        CPUMigrations(9),
        CPUCycles(10),
        BusCycles(11),
        StalledCycles(12),
        Instructions(13),
        BranchInstructions(14),
        BranchMisses(15),
        CacheReferences(16),
        CacheReads(17),
        CacheWrites(18),
        CachePrefetches(19),
        CacheMisses(20),
        CacheReadMisses(21),
        CacheWriteMisses(22),
        CachePrefetchMisses(23),
        ContextSwitches(24),
        PageFaults(25),
        MinorPageFaults(26),
        MajorPageFaults(27),
        AlignmentFaults(28),
        EmulationFaults(29),
        RefCPUCycles(30);

        private QBenchmarkMetric(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static QBenchmarkMetric resolve(int value) {
            switch (value) {
            case 0: return FramesPerSecond;
            case 1: return BitsPerSecond;
            case 2: return BytesPerSecond;
            case 3: return WalltimeMilliseconds;
            case 4: return CPUTicks;
            case 5: return InstructionReads;
            case 6: return Events;
            case 7: return WalltimeNanoseconds;
            case 8: return BytesAllocated;
            case 9: return CPUMigrations;
            case 10: return CPUCycles;
            case 11: return BusCycles;
            case 12: return StalledCycles;
            case 13: return Instructions;
            case 14: return BranchInstructions;
            case 15: return BranchMisses;
            case 16: return CacheReferences;
            case 17: return CacheReads;
            case 18: return CacheWrites;
            case 19: return CachePrefetches;
            case 20: return CacheMisses;
            case 21: return CacheReadMisses;
            case 22: return CacheWriteMisses;
            case 23: return CachePrefetchMisses;
            case 24: return ContextSwitches;
            case 25: return PageFaults;
            case 26: return MinorPageFaults;
            case 27: return MajorPageFaults;
            case 28: return AlignmentFaults;
            case 29: return EmulationFaults;
            case 30: return RefCPUCycles;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qtest.html#TestFailMode-enum">QTest::TestFailMode</a></p>
     */
    public enum TestFailMode implements io.qt.QtEnumerator {
        Abort(1),
        Continue(2);

        private TestFailMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static TestFailMode resolve(int value) {
            switch (value) {
            case 1: return Abort;
            case 2: return Continue;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Java wrapper for Qt class QTest::QBenchmarkIterationController</p>
     */
    public static class QBenchmarkIterationController extends io.qt.QtObject
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        /**
         * <p>Java wrapper for Qt enum QTest::QBenchmarkIterationController::RunMode</p>
         */
        public enum RunMode implements io.qt.QtEnumerator {
            RepeatUntilValidMeasurement(0),
            RunOnce(1);

            private RunMode(int value) {
                this.value = value;
            }

            /**
             * {@inheritDoc}
             */
            public int value() {
                return value;
            }

            /**
             * Returns the corresponding enum entry for the given value.
             * @param value
             * @return enum entry
             */
            public static RunMode resolve(int value) {
                switch (value) {
                case 0: return RepeatUntilValidMeasurement;
                case 1: return RunOnce;
                default: throw new io.qt.QNoSuchEnumValueException(value);
                }
            }


            private final int value;
        }
        
        
        public QBenchmarkIterationController(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(QBenchmarkIterationController instance);
        
        public QBenchmarkIterationController(io.qt.test.QTest.QBenchmarkIterationController.RunMode runMode){
            super((QPrivateConstructor)null);
            initialize_native(this, runMode);
        }
        
        private native static void initialize_native(QBenchmarkIterationController instance, io.qt.test.QTest.QBenchmarkIterationController.RunMode runMode);
        
        @io.qt.QtUninvokable
        public final boolean isDone(){
            return isDone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean isDone_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void next(){
            next_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native void next_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setI(int i){
            setI_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), i);
        }
        
        @io.qt.QtUninvokable
        private native void setI_native_int(long __this__nativeId, int i);
        
        @io.qt.QtUninvokable
        public final int i(){
            return i_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int i_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected QBenchmarkIterationController(QPrivateConstructor p) { super(p); } 
        
    }
    /**
     * <p>Used to simulate a sequence of touch events</p>
     * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qtest-qtoucheventsequence.html">QTest::QTouchEventSequence</a></p>
     */
    public static final class QTouchEventSequence extends io.qt.QtObject
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>Overloaded function for {@link #commit(boolean)}
         *  with <code>processEvents = true</code>.</p>
         */
        @io.qt.QtUninvokable
        public final void commit() {
            commit((boolean)true);
        }
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qtest-qtoucheventsequence.html#commit">QTest::QTouchEventSequence::commit(bool)</a></p>
         */
        @io.qt.QtUninvokable
        public final void commit(boolean processEvents){
            commit_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), processEvents);
        }
        
        @io.qt.QtUninvokable
        private native void commit_native_bool(long __this__nativeId, boolean processEvents);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qtest-qtoucheventsequence.html#move-1">QTest::QTouchEventSequence::move(int,QPoint,QWidget*)</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.test.QTest.QTouchEventSequence move(int touchId, io.qt.core.QPoint pt, io.qt.widgets.QWidget widget){
            move_native_int_cref_QPoint_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), touchId, QtJambi_LibraryUtilities.internal.checkedNativeId(pt), QtJambi_LibraryUtilities.internal.checkedNativeId(widget));
            return this;
        }
        
        @io.qt.QtUninvokable
        private native io.qt.test.QTest.QTouchEventSequence move_native_int_cref_QPoint_QWidget_ptr(long __this__nativeId, int touchId, long pt, long widget);
        
        /**
         * <p>Overloaded function for {@link #move(int, io.qt.core.QPoint, io.qt.gui.QWindow)}
         *  with <code>window = null</code>.</p>
         */
        @io.qt.QtUninvokable
        public final io.qt.test.QTest.QTouchEventSequence move(int touchId, io.qt.core.QPoint pt) {
            return move(touchId, pt, (io.qt.gui.QWindow)null);
        }
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qtest-qtoucheventsequence.html#move">QTest::QTouchEventSequence::move(int,QPoint,QWindow*)</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.test.QTest.QTouchEventSequence move(int touchId, io.qt.core.QPoint pt, io.qt.gui.QWindow window){
            move_native_int_cref_QPoint_QWindow_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), touchId, QtJambi_LibraryUtilities.internal.checkedNativeId(pt), QtJambi_LibraryUtilities.internal.checkedNativeId(window));
            return this;
        }
        
        @io.qt.QtUninvokable
        private native io.qt.test.QTest.QTouchEventSequence move_native_int_cref_QPoint_QWindow_ptr(long __this__nativeId, int touchId, long pt, long window);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qtest-qtoucheventsequence.html#press-1">QTest::QTouchEventSequence::press(int,QPoint,QWidget*)</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.test.QTest.QTouchEventSequence press(int touchId, io.qt.core.QPoint pt, io.qt.widgets.QWidget widget){
            press_native_int_cref_QPoint_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), touchId, QtJambi_LibraryUtilities.internal.checkedNativeId(pt), QtJambi_LibraryUtilities.internal.checkedNativeId(widget));
            return this;
        }
        
        @io.qt.QtUninvokable
        private native io.qt.test.QTest.QTouchEventSequence press_native_int_cref_QPoint_QWidget_ptr(long __this__nativeId, int touchId, long pt, long widget);
        
        /**
         * <p>Overloaded function for {@link #press(int, io.qt.core.QPoint, io.qt.gui.QWindow)}
         *  with <code>window = null</code>.</p>
         */
        @io.qt.QtUninvokable
        public final io.qt.test.QTest.QTouchEventSequence press(int touchId, io.qt.core.QPoint pt) {
            return press(touchId, pt, (io.qt.gui.QWindow)null);
        }
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qtest-qtoucheventsequence.html#press">QTest::QTouchEventSequence::press(int,QPoint,QWindow*)</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.test.QTest.QTouchEventSequence press(int touchId, io.qt.core.QPoint pt, io.qt.gui.QWindow window){
            press_native_int_cref_QPoint_QWindow_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), touchId, QtJambi_LibraryUtilities.internal.checkedNativeId(pt), QtJambi_LibraryUtilities.internal.checkedNativeId(window));
            return this;
        }
        
        @io.qt.QtUninvokable
        private native io.qt.test.QTest.QTouchEventSequence press_native_int_cref_QPoint_QWindow_ptr(long __this__nativeId, int touchId, long pt, long window);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qtest-qtoucheventsequence.html#release-1">QTest::QTouchEventSequence::release(int,QPoint,QWidget*)</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.test.QTest.QTouchEventSequence release(int touchId, io.qt.core.QPoint pt, io.qt.widgets.QWidget widget){
            release_native_int_cref_QPoint_QWidget_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), touchId, QtJambi_LibraryUtilities.internal.checkedNativeId(pt), QtJambi_LibraryUtilities.internal.checkedNativeId(widget));
            return this;
        }
        
        @io.qt.QtUninvokable
        private native io.qt.test.QTest.QTouchEventSequence release_native_int_cref_QPoint_QWidget_ptr(long __this__nativeId, int touchId, long pt, long widget);
        
        /**
         * <p>Overloaded function for {@link #release(int, io.qt.core.QPoint, io.qt.gui.QWindow)}
         *  with <code>window = null</code>.</p>
         */
        @io.qt.QtUninvokable
        public final io.qt.test.QTest.QTouchEventSequence release(int touchId, io.qt.core.QPoint pt) {
            return release(touchId, pt, (io.qt.gui.QWindow)null);
        }
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qtest-qtoucheventsequence.html#release">QTest::QTouchEventSequence::release(int,QPoint,QWindow*)</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.test.QTest.QTouchEventSequence release(int touchId, io.qt.core.QPoint pt, io.qt.gui.QWindow window){
            release_native_int_cref_QPoint_QWindow_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), touchId, QtJambi_LibraryUtilities.internal.checkedNativeId(pt), QtJambi_LibraryUtilities.internal.checkedNativeId(window));
            return this;
        }
        
        @io.qt.QtUninvokable
        private native io.qt.test.QTest.QTouchEventSequence release_native_int_cref_QPoint_QWindow_ptr(long __this__nativeId, int touchId, long pt, long window);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qtest-qtoucheventsequence.html#stationary">QTest::QTouchEventSequence::stationary(int)</a></p>
         */
        @io.qt.QtUninvokable
        public final io.qt.test.QTest.QTouchEventSequence stationary(int touchId){
            stationary_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), touchId);
            return this;
        }
        
        @io.qt.QtUninvokable
        private native io.qt.test.QTest.QTouchEventSequence stationary_native_int(long __this__nativeId, int touchId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected QTouchEventSequence(QPrivateConstructor p) { super(p); } 
        
    }

    
    public native static void addColumnInternal(int id, java.lang.String name);
    
    public static io.qt.core.Qt.Key asciiToKey(char ascii){
        return io.qt.core.Qt.Key.resolve(asciiToKey_native_char(ascii));
    }
    
    private native static int asciiToKey_native_char(char ascii);
    
    public native static boolean compare_helper(boolean success, java.lang.String failureMsg, java.lang.String val1, java.lang.String val2, java.lang.String actual, java.lang.String expected, java.lang.String file, int line);
    
    /**
     * <p>Overloaded function for {@link #createTouchDevice(io.qt.gui.QTouchDevice.DeviceType)}
     *  with <code>devType = io.qt.gui.QTouchDevice.DeviceType.TouchScreen</code>.</p>
     */
    public static io.qt.gui.QTouchDevice createTouchDevice() {
        return createTouchDevice(io.qt.gui.QTouchDevice.DeviceType.TouchScreen);
    }
    
    public static io.qt.gui.QTouchDevice createTouchDevice(io.qt.gui.QTouchDevice.DeviceType devType){
        return createTouchDevice_native_QTouchDevice_DeviceType(devType.value());
    }
    
    private native static io.qt.gui.QTouchDevice createTouchDevice_native_QTouchDevice_DeviceType(int devType);
    
    public native static java.lang.String currentAppName();
    
    public native static java.lang.String currentDataTag();
    
    public native static boolean currentTestFailed();
    
    public native static java.lang.String currentTestFunction();
    
    public static void ignoreMessage(io.qt.core.QtMsgType type, io.qt.core.QRegularExpression messagePattern){
        ignoreMessage_native_QtMsgType_cref_QRegularExpression(type.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(messagePattern));
    }
    
    private native static void ignoreMessage_native_QtMsgType_cref_QRegularExpression(int type, long messagePattern);
    
    public static void ignoreMessage(io.qt.core.QtMsgType type, java.lang.String message){
        ignoreMessage_native_QtMsgType_const_char_ptr(type.value(), message);
    }
    
    private native static void ignoreMessage_native_QtMsgType_const_char_ptr(int type, java.lang.String message);
    
    /**
     * <p>Overloaded function for {@link #keyClick(io.qt.widgets.QWidget, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyClick(io.qt.widgets.QWidget widget, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyClick(widget, key, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyClick(io.qt.widgets.QWidget, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyClick(io.qt.widgets.QWidget widget, io.qt.core.Qt.Key key) {
        keyClick(widget, key, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyClick(io.qt.widgets.QWidget widget, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyClick_native_QWidget_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), key.value(), modifier.value(), delay);
    }
    
    private native static void keyClick_native_QWidget_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(long widget, int key, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyClick(io.qt.widgets.QWidget, char, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyClick(io.qt.widgets.QWidget widget, char key, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyClick(widget, key, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyClick(io.qt.widgets.QWidget, char, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyClick(io.qt.widgets.QWidget widget, char key) {
        keyClick(widget, key, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyClick(io.qt.widgets.QWidget widget, char key, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyClick_native_QWidget_ptr_char_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), key, modifier.value(), delay);
    }
    
    private native static void keyClick_native_QWidget_ptr_char_QFlags_Qt_KeyboardModifier__int(long widget, char key, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyClick(io.qt.gui.QWindow, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyClick(io.qt.gui.QWindow window, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyClick(window, key, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyClick(io.qt.gui.QWindow, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyClick(io.qt.gui.QWindow window, io.qt.core.Qt.Key key) {
        keyClick(window, key, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyClick(io.qt.gui.QWindow window, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyClick_native_QWindow_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.checkedNativeId(window), key.value(), modifier.value(), delay);
    }
    
    private native static void keyClick_native_QWindow_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(long window, int key, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyClick(io.qt.gui.QWindow, char, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyClick(io.qt.gui.QWindow window, char key, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyClick(window, key, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyClick(io.qt.gui.QWindow, char, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyClick(io.qt.gui.QWindow window, char key) {
        keyClick(window, key, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyClick(io.qt.gui.QWindow window, char key, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyClick_native_QWindow_ptr_char_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.checkedNativeId(window), key, modifier.value(), delay);
    }
    
    private native static void keyClick_native_QWindow_ptr_char_QFlags_Qt_KeyboardModifier__int(long window, char key, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyClicks(io.qt.widgets.QWidget, java.lang.String, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyClicks(io.qt.widgets.QWidget widget, java.lang.String sequence, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyClicks(widget, sequence, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyClicks(io.qt.widgets.QWidget, java.lang.String, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyClicks(io.qt.widgets.QWidget widget, java.lang.String sequence) {
        keyClicks(widget, sequence, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyClicks(io.qt.widgets.QWidget widget, java.lang.String sequence, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyClicks_native_QWidget_ptr_cref_QString_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), sequence, modifier.value(), delay);
    }
    
    private native static void keyClicks_native_QWidget_ptr_cref_QString_QFlags_Qt_KeyboardModifier__int(long widget, java.lang.String sequence, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyEvent(io.qt.test.QTest.KeyAction, io.qt.widgets.QWidget, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyEvent(io.qt.test.QTest.KeyAction action, io.qt.widgets.QWidget widget, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyEvent(action, widget, key, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyEvent(io.qt.test.QTest.KeyAction, io.qt.widgets.QWidget, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyEvent(io.qt.test.QTest.KeyAction action, io.qt.widgets.QWidget widget, io.qt.core.Qt.Key key) {
        keyEvent(action, widget, key, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyEvent(io.qt.test.QTest.KeyAction action, io.qt.widgets.QWidget widget, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyEvent_native_QTest_KeyAction_QWidget_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(action.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(widget), key.value(), modifier.value(), delay);
    }
    
    private native static void keyEvent_native_QTest_KeyAction_QWidget_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(int action, long widget, int key, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyEvent(io.qt.test.QTest.KeyAction, io.qt.widgets.QWidget, char, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyEvent(io.qt.test.QTest.KeyAction action, io.qt.widgets.QWidget widget, char ascii, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyEvent(action, widget, ascii, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyEvent(io.qt.test.QTest.KeyAction, io.qt.widgets.QWidget, char, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyEvent(io.qt.test.QTest.KeyAction action, io.qt.widgets.QWidget widget, char ascii) {
        keyEvent(action, widget, ascii, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyEvent(io.qt.test.QTest.KeyAction action, io.qt.widgets.QWidget widget, char ascii, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyEvent_native_QTest_KeyAction_QWidget_ptr_char_QFlags_Qt_KeyboardModifier__int(action.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(widget), ascii, modifier.value(), delay);
    }
    
    private native static void keyEvent_native_QTest_KeyAction_QWidget_ptr_char_QFlags_Qt_KeyboardModifier__int(int action, long widget, char ascii, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyEvent(io.qt.test.QTest.KeyAction, io.qt.gui.QWindow, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyEvent(io.qt.test.QTest.KeyAction action, io.qt.gui.QWindow window, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyEvent(action, window, key, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyEvent(io.qt.test.QTest.KeyAction, io.qt.gui.QWindow, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyEvent(io.qt.test.QTest.KeyAction action, io.qt.gui.QWindow window, io.qt.core.Qt.Key key) {
        keyEvent(action, window, key, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyEvent(io.qt.test.QTest.KeyAction action, io.qt.gui.QWindow window, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyEvent_native_QTest_KeyAction_QWindow_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(action.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(window), key.value(), modifier.value(), delay);
    }
    
    private native static void keyEvent_native_QTest_KeyAction_QWindow_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(int action, long window, int key, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyEvent(io.qt.test.QTest.KeyAction, io.qt.gui.QWindow, char, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyEvent(io.qt.test.QTest.KeyAction action, io.qt.gui.QWindow window, char ascii, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyEvent(action, window, ascii, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyEvent(io.qt.test.QTest.KeyAction, io.qt.gui.QWindow, char, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyEvent(io.qt.test.QTest.KeyAction action, io.qt.gui.QWindow window, char ascii) {
        keyEvent(action, window, ascii, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyEvent(io.qt.test.QTest.KeyAction action, io.qt.gui.QWindow window, char ascii, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyEvent_native_QTest_KeyAction_QWindow_ptr_char_QFlags_Qt_KeyboardModifier__int(action.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(window), ascii, modifier.value(), delay);
    }
    
    private native static void keyEvent_native_QTest_KeyAction_QWindow_ptr_char_QFlags_Qt_KeyboardModifier__int(int action, long window, char ascii, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyPress(io.qt.widgets.QWidget, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyPress(io.qt.widgets.QWidget widget, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyPress(widget, key, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyPress(io.qt.widgets.QWidget, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyPress(io.qt.widgets.QWidget widget, io.qt.core.Qt.Key key) {
        keyPress(widget, key, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyPress(io.qt.widgets.QWidget widget, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyPress_native_QWidget_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), key.value(), modifier.value(), delay);
    }
    
    private native static void keyPress_native_QWidget_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(long widget, int key, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyPress(io.qt.widgets.QWidget, char, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyPress(io.qt.widgets.QWidget widget, char key, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyPress(widget, key, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyPress(io.qt.widgets.QWidget, char, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyPress(io.qt.widgets.QWidget widget, char key) {
        keyPress(widget, key, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyPress(io.qt.widgets.QWidget widget, char key, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyPress_native_QWidget_ptr_char_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), key, modifier.value(), delay);
    }
    
    private native static void keyPress_native_QWidget_ptr_char_QFlags_Qt_KeyboardModifier__int(long widget, char key, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyPress(io.qt.gui.QWindow, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyPress(io.qt.gui.QWindow window, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyPress(window, key, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyPress(io.qt.gui.QWindow, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyPress(io.qt.gui.QWindow window, io.qt.core.Qt.Key key) {
        keyPress(window, key, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyPress(io.qt.gui.QWindow window, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyPress_native_QWindow_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.checkedNativeId(window), key.value(), modifier.value(), delay);
    }
    
    private native static void keyPress_native_QWindow_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(long window, int key, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyPress(io.qt.gui.QWindow, char, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyPress(io.qt.gui.QWindow window, char key, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyPress(window, key, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyPress(io.qt.gui.QWindow, char, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyPress(io.qt.gui.QWindow window, char key) {
        keyPress(window, key, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyPress(io.qt.gui.QWindow window, char key, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyPress_native_QWindow_ptr_char_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.checkedNativeId(window), key, modifier.value(), delay);
    }
    
    private native static void keyPress_native_QWindow_ptr_char_QFlags_Qt_KeyboardModifier__int(long window, char key, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyRelease(io.qt.widgets.QWidget, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyRelease(io.qt.widgets.QWidget widget, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyRelease(widget, key, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyRelease(io.qt.widgets.QWidget, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyRelease(io.qt.widgets.QWidget widget, io.qt.core.Qt.Key key) {
        keyRelease(widget, key, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyRelease(io.qt.widgets.QWidget widget, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyRelease_native_QWidget_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), key.value(), modifier.value(), delay);
    }
    
    private native static void keyRelease_native_QWidget_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(long widget, int key, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyRelease(io.qt.widgets.QWidget, char, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyRelease(io.qt.widgets.QWidget widget, char key, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyRelease(widget, key, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyRelease(io.qt.widgets.QWidget, char, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyRelease(io.qt.widgets.QWidget widget, char key) {
        keyRelease(widget, key, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyRelease(io.qt.widgets.QWidget widget, char key, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyRelease_native_QWidget_ptr_char_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), key, modifier.value(), delay);
    }
    
    private native static void keyRelease_native_QWidget_ptr_char_QFlags_Qt_KeyboardModifier__int(long widget, char key, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyRelease(io.qt.gui.QWindow, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyRelease(io.qt.gui.QWindow window, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyRelease(window, key, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyRelease(io.qt.gui.QWindow, io.qt.core.Qt.Key, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyRelease(io.qt.gui.QWindow window, io.qt.core.Qt.Key key) {
        keyRelease(window, key, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyRelease(io.qt.gui.QWindow window, io.qt.core.Qt.Key key, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyRelease_native_QWindow_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.checkedNativeId(window), key.value(), modifier.value(), delay);
    }
    
    private native static void keyRelease_native_QWindow_ptr_Qt_Key_QFlags_Qt_KeyboardModifier__int(long window, int key, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #keyRelease(io.qt.gui.QWindow, char, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void keyRelease(io.qt.gui.QWindow window, char key, io.qt.core.Qt.KeyboardModifiers modifier) {
        keyRelease(window, key, modifier, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #keyRelease(io.qt.gui.QWindow, char, io.qt.core.Qt.KeyboardModifiers, int)}</p>
     * <p>with: </p><ul>
     * <li><code>modifier = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void keyRelease(io.qt.gui.QWindow window, char key) {
        keyRelease(window, key, new io.qt.core.Qt.KeyboardModifiers(0), (int)-1);
    }
    
    public static void keyRelease(io.qt.gui.QWindow window, char key, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        keyRelease_native_QWindow_ptr_char_QFlags_Qt_KeyboardModifier__int(QtJambi_LibraryUtilities.internal.checkedNativeId(window), key, modifier.value(), delay);
    }
    
    private native static void keyRelease_native_QWindow_ptr_char_QFlags_Qt_KeyboardModifier__int(long window, char key, int modifier, int delay);
    
    public static void keySequence(io.qt.widgets.QWidget widget, io.qt.gui.QKeySequence keySequence){
        keySequence_native_QWidget_ptr_cref_QKeySequence(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), QtJambi_LibraryUtilities.internal.checkedNativeId(keySequence));
    }
    
    private native static void keySequence_native_QWidget_ptr_cref_QKeySequence(long widget, long keySequence);
    
    public static void keySequence(io.qt.gui.QWindow window, io.qt.gui.QKeySequence keySequence){
        keySequence_native_QWindow_ptr_cref_QKeySequence(QtJambi_LibraryUtilities.internal.checkedNativeId(window), QtJambi_LibraryUtilities.internal.checkedNativeId(keySequence));
    }
    
    private native static void keySequence_native_QWindow_ptr_cref_QKeySequence(long window, long keySequence);
    
    public static byte keyToAscii(io.qt.core.Qt.Key key){
        return keyToAscii_native_Qt_Key(key.value());
    }
    
    private native static byte keyToAscii_native_Qt_Key(int key);
    
    /**
     * <p>Overloaded function for {@link #mouseClick(io.qt.widgets.QWidget, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void mouseClick(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos) {
        mouseClick(widget, button, stateKey, pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mouseClick(io.qt.widgets.QWidget, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mouseClick(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey) {
        mouseClick(widget, button, stateKey, new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mouseClick(io.qt.widgets.QWidget, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>stateKey = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mouseClick(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button) {
        mouseClick(widget, button, new io.qt.core.Qt.KeyboardModifiers(0), new io.qt.core.QPoint(), (int)-1);
    }
    
    public static void mouseClick(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos, int delay){
        mouseClick_native_QWidget_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), button.value(), stateKey.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    private native static void mouseClick_native_QWidget_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(long widget, int button, int stateKey, long pos, int delay);
    
    /**
     * <p>Overloaded function for {@link #mouseClick(io.qt.gui.QWindow, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void mouseClick(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos) {
        mouseClick(window, button, stateKey, pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mouseClick(io.qt.gui.QWindow, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mouseClick(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey) {
        mouseClick(window, button, stateKey, new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mouseClick(io.qt.gui.QWindow, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>stateKey = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mouseClick(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button) {
        mouseClick(window, button, new io.qt.core.Qt.KeyboardModifiers(0), new io.qt.core.QPoint(), (int)-1);
    }
    
    public static void mouseClick(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos, int delay){
        mouseClick_native_QWindow_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(QtJambi_LibraryUtilities.internal.checkedNativeId(window), button.value(), stateKey.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    private native static void mouseClick_native_QWindow_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(long window, int button, int stateKey, long pos, int delay);
    
    /**
     * <p>Overloaded function for {@link #mouseDClick(io.qt.widgets.QWidget, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void mouseDClick(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos) {
        mouseDClick(widget, button, stateKey, pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mouseDClick(io.qt.widgets.QWidget, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mouseDClick(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey) {
        mouseDClick(widget, button, stateKey, new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mouseDClick(io.qt.widgets.QWidget, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>stateKey = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mouseDClick(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button) {
        mouseDClick(widget, button, new io.qt.core.Qt.KeyboardModifiers(0), new io.qt.core.QPoint(), (int)-1);
    }
    
    public static void mouseDClick(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos, int delay){
        mouseDClick_native_QWidget_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), button.value(), stateKey.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    private native static void mouseDClick_native_QWidget_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(long widget, int button, int stateKey, long pos, int delay);
    
    /**
     * <p>Overloaded function for {@link #mouseDClick(io.qt.gui.QWindow, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void mouseDClick(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos) {
        mouseDClick(window, button, stateKey, pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mouseDClick(io.qt.gui.QWindow, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mouseDClick(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey) {
        mouseDClick(window, button, stateKey, new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mouseDClick(io.qt.gui.QWindow, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>stateKey = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mouseDClick(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button) {
        mouseDClick(window, button, new io.qt.core.Qt.KeyboardModifiers(0), new io.qt.core.QPoint(), (int)-1);
    }
    
    public static void mouseDClick(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos, int delay){
        mouseDClick_native_QWindow_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(QtJambi_LibraryUtilities.internal.checkedNativeId(window), button.value(), stateKey.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    private native static void mouseDClick_native_QWindow_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(long window, int button, int stateKey, long pos, int delay);
    
    /**
     * <p>Overloaded function for {@link #mouseEvent(io.qt.test.QTest.MouseAction, io.qt.widgets.QWidget, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void mouseEvent(io.qt.test.QTest.MouseAction action, io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos) {
        mouseEvent(action, widget, button, stateKey, pos, (int)-1);
    }
    
    public static void mouseEvent(io.qt.test.QTest.MouseAction action, io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos, int delay){
        mouseEvent_native_QTest_MouseAction_QWidget_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(action.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(widget), button.value(), stateKey.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    private native static void mouseEvent_native_QTest_MouseAction_QWidget_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(int action, long widget, int button, int stateKey, long pos, int delay);
    
    /**
     * <p>Overloaded function for {@link #mouseEvent(io.qt.test.QTest.MouseAction, io.qt.gui.QWindow, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void mouseEvent(io.qt.test.QTest.MouseAction action, io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos) {
        mouseEvent(action, window, button, stateKey, pos, (int)-1);
    }
    
    public static void mouseEvent(io.qt.test.QTest.MouseAction action, io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos, int delay){
        mouseEvent_native_QTest_MouseAction_QWindow_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(action.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(window), button.value(), stateKey.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    private native static void mouseEvent_native_QTest_MouseAction_QWindow_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(int action, long window, int button, int stateKey, long pos, int delay);
    
    /**
     * <p>Overloaded function for {@link #mouseMove(io.qt.widgets.QWidget, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void mouseMove(io.qt.widgets.QWidget widget, io.qt.core.QPoint pos) {
        mouseMove(widget, pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mouseMove(io.qt.widgets.QWidget, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mouseMove(io.qt.widgets.QWidget widget) {
        mouseMove(widget, new io.qt.core.QPoint(), (int)-1);
    }
    
    public static void mouseMove(io.qt.widgets.QWidget widget, io.qt.core.QPoint pos, int delay){
        mouseMove_native_QWidget_ptr_QPoint_int(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    private native static void mouseMove_native_QWidget_ptr_QPoint_int(long widget, long pos, int delay);
    
    /**
     * <p>Overloaded function for {@link #mouseMove(io.qt.gui.QWindow, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void mouseMove(io.qt.gui.QWindow window, io.qt.core.QPoint pos) {
        mouseMove(window, pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mouseMove(io.qt.gui.QWindow, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mouseMove(io.qt.gui.QWindow window) {
        mouseMove(window, new io.qt.core.QPoint(), (int)-1);
    }
    
    public static void mouseMove(io.qt.gui.QWindow window, io.qt.core.QPoint pos, int delay){
        mouseMove_native_QWindow_ptr_QPoint_int(QtJambi_LibraryUtilities.internal.checkedNativeId(window), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    private native static void mouseMove_native_QWindow_ptr_QPoint_int(long window, long pos, int delay);
    
    /**
     * <p>Overloaded function for {@link #mousePress(io.qt.widgets.QWidget, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void mousePress(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos) {
        mousePress(widget, button, stateKey, pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mousePress(io.qt.widgets.QWidget, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mousePress(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey) {
        mousePress(widget, button, stateKey, new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mousePress(io.qt.widgets.QWidget, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>stateKey = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mousePress(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button) {
        mousePress(widget, button, new io.qt.core.Qt.KeyboardModifiers(0), new io.qt.core.QPoint(), (int)-1);
    }
    
    public static void mousePress(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos, int delay){
        mousePress_native_QWidget_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), button.value(), stateKey.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    private native static void mousePress_native_QWidget_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(long widget, int button, int stateKey, long pos, int delay);
    
    /**
     * <p>Overloaded function for {@link #mousePress(io.qt.gui.QWindow, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void mousePress(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos) {
        mousePress(window, button, stateKey, pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mousePress(io.qt.gui.QWindow, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mousePress(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey) {
        mousePress(window, button, stateKey, new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mousePress(io.qt.gui.QWindow, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>stateKey = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mousePress(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button) {
        mousePress(window, button, new io.qt.core.Qt.KeyboardModifiers(0), new io.qt.core.QPoint(), (int)-1);
    }
    
    public static void mousePress(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos, int delay){
        mousePress_native_QWindow_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(QtJambi_LibraryUtilities.internal.checkedNativeId(window), button.value(), stateKey.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    private native static void mousePress_native_QWindow_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(long window, int button, int stateKey, long pos, int delay);
    
    /**
     * <p>Overloaded function for {@link #mouseRelease(io.qt.widgets.QWidget, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void mouseRelease(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos) {
        mouseRelease(widget, button, stateKey, pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mouseRelease(io.qt.widgets.QWidget, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mouseRelease(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey) {
        mouseRelease(widget, button, stateKey, new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mouseRelease(io.qt.widgets.QWidget, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>stateKey = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mouseRelease(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button) {
        mouseRelease(widget, button, new io.qt.core.Qt.KeyboardModifiers(0), new io.qt.core.QPoint(), (int)-1);
    }
    
    public static void mouseRelease(io.qt.widgets.QWidget widget, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos, int delay){
        mouseRelease_native_QWidget_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), button.value(), stateKey.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    private native static void mouseRelease_native_QWidget_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(long widget, int button, int stateKey, long pos, int delay);
    
    /**
     * <p>Overloaded function for {@link #mouseRelease(io.qt.gui.QWindow, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void mouseRelease(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos) {
        mouseRelease(window, button, stateKey, pos, (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mouseRelease(io.qt.gui.QWindow, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mouseRelease(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey) {
        mouseRelease(window, button, stateKey, new io.qt.core.QPoint(), (int)-1);
    }
    
    /**
     * <p>Overloaded function for {@link #mouseRelease(io.qt.gui.QWindow, io.qt.core.Qt.MouseButton, io.qt.core.Qt.KeyboardModifiers, io.qt.core.QPoint, int)}</p>
     * <p>with: </p><ul>
     * <li><code>stateKey = new io.qt.core.Qt.KeyboardModifiers(0)</code></li>
     * <li><code>pos = new io.qt.core.QPoint()</code></li>
     * <li><code>delay = -1</code></li>
     * </ul>
     */
    public static void mouseRelease(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button) {
        mouseRelease(window, button, new io.qt.core.Qt.KeyboardModifiers(0), new io.qt.core.QPoint(), (int)-1);
    }
    
    public static void mouseRelease(io.qt.gui.QWindow window, io.qt.core.Qt.MouseButton button, io.qt.core.Qt.KeyboardModifiers stateKey, io.qt.core.QPoint pos, int delay){
        mouseRelease_native_QWindow_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(QtJambi_LibraryUtilities.internal.checkedNativeId(window), button.value(), stateKey.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(pos), delay);
    }
    
    private native static void mouseRelease_native_QWindow_ptr_Qt_MouseButton_QFlags_Qt_KeyboardModifier__QPoint_int(long window, int button, int stateKey, long pos, int delay);
    
    public native static void qCleanup();
    
    public native static boolean qCompare(java.lang.String t1, java.lang.String t2, java.lang.String actual, java.lang.String expected, java.lang.String file, int line);
    
    public static boolean qCompare(io.qt.gui.QIcon t1, io.qt.gui.QIcon t2, java.lang.String actual, java.lang.String expected, java.lang.String file, int line){
        return qCompare_native_cref_QIcon_cref_QIcon_const_char_ptr_const_char_ptr_const_char_ptr_int(QtJambi_LibraryUtilities.internal.checkedNativeId(t1), QtJambi_LibraryUtilities.internal.checkedNativeId(t2), actual, expected, file, line);
    }
    
    private native static boolean qCompare_native_cref_QIcon_cref_QIcon_const_char_ptr_const_char_ptr_const_char_ptr_int(long t1, long t2, java.lang.String actual, java.lang.String expected, java.lang.String file, int line);
    
    public static boolean qCompare(io.qt.gui.QImage t1, io.qt.gui.QImage t2, java.lang.String actual, java.lang.String expected, java.lang.String file, int line){
        return qCompare_native_cref_QImage_cref_QImage_const_char_ptr_const_char_ptr_const_char_ptr_int(QtJambi_LibraryUtilities.internal.checkedNativeId(t1), QtJambi_LibraryUtilities.internal.checkedNativeId(t2), actual, expected, file, line);
    }
    
    private native static boolean qCompare_native_cref_QImage_cref_QImage_const_char_ptr_const_char_ptr_const_char_ptr_int(long t1, long t2, java.lang.String actual, java.lang.String expected, java.lang.String file, int line);
    
    public static boolean qCompare(io.qt.gui.QPixmap t1, io.qt.gui.QPixmap t2, java.lang.String actual, java.lang.String expected, java.lang.String file, int line){
        return qCompare_native_cref_QPixmap_cref_QPixmap_const_char_ptr_const_char_ptr_const_char_ptr_int(QtJambi_LibraryUtilities.internal.checkedNativeId(t1), QtJambi_LibraryUtilities.internal.checkedNativeId(t2), actual, expected, file, line);
    }
    
    private native static boolean qCompare_native_cref_QPixmap_cref_QPixmap_const_char_ptr_const_char_ptr_const_char_ptr_int(long t1, long t2, java.lang.String actual, java.lang.String expected, java.lang.String file, int line);
    
    public native static boolean qCompare(double t1, double t2, java.lang.String actual, java.lang.String expected, java.lang.String file, int line);
    
    public native static boolean qCompare(double t1, float t2, java.lang.String actual, java.lang.String expected, java.lang.String file, int line);
    
    public native static boolean qCompare(float t1, double t2, java.lang.String actual, java.lang.String expected, java.lang.String file, int line);
    
    public native static boolean qCompare(float t1, float t2, java.lang.String actual, java.lang.String expected, java.lang.String file, int line);
    
    public native static boolean qCompare(int t1, int t2, java.lang.String actual, java.lang.String expected, java.lang.String file, int line);
    
    public native static java.lang.Object qData(java.lang.String tagName, int typeId);
    
    public native static java.lang.Object qElementData(java.lang.String elementName, int metaTypeId);
    
    public static int qExec(io.qt.core.QObject testObject, java.util.Collection<java.lang.String> arguments){
        return qExec_native_QObject_ptr_cref_QStringList(QtJambi_LibraryUtilities.internal.checkedNativeId(testObject), arguments);
    }
    
    private native static int qExec_native_QObject_ptr_cref_QStringList(long testObject, java.util.Collection<java.lang.String> arguments);
    
    public static int qExec(io.qt.core.QObject testObject){
        return qExec_native_QObject_ptr_int_char_ptr_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(testObject));
    }
    
    private native static int qExec_native_QObject_ptr_int_char_ptr_ptr(long testObject);
    
    public static boolean qExpectFail(java.lang.String dataIndex, java.lang.String comment, io.qt.test.QTest.TestFailMode mode, java.lang.String file, int line){
        return qExpectFail_native_const_char_ptr_const_char_ptr_QTest_TestFailMode_const_char_ptr_int(dataIndex, comment, mode.value(), file, line);
    }
    
    private native static boolean qExpectFail_native_const_char_ptr_const_char_ptr_QTest_TestFailMode_const_char_ptr_int(java.lang.String dataIndex, java.lang.String comment, int mode, java.lang.String file, int line);
    
    public native static io.qt.core.QTemporaryDir qExtractTestData(java.lang.String dirName);
    
    public native static void qFail(java.lang.String statementStr, java.lang.String file, int line);
    
    /**
     * <p>Overloaded function for {@link #qFindTestData(java.lang.String, java.lang.String, int, java.lang.String)}
     *  with <code>builddir = null</code>.</p>
     */
    public static java.lang.String qFindTestData(java.lang.String basepath, java.lang.String file, int line) {
        return qFindTestData(basepath, file, line, (java.lang.String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #qFindTestData(java.lang.String, java.lang.String, int, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>line = 0</code></li>
     * <li><code>builddir = null</code></li>
     * </ul>
     */
    public static java.lang.String qFindTestData(java.lang.String basepath, java.lang.String file) {
        return qFindTestData(basepath, file, (int)0, (java.lang.String)null);
    }
    
    /**
     * <p>Overloaded function for {@link #qFindTestData(java.lang.String, java.lang.String, int, java.lang.String)}</p>
     * <p>with: </p><ul>
     * <li><code>file = null</code></li>
     * <li><code>line = 0</code></li>
     * <li><code>builddir = null</code></li>
     * </ul>
     */
    public static java.lang.String qFindTestData(java.lang.String basepath) {
        return qFindTestData(basepath, (java.lang.String)null, (int)0, (java.lang.String)null);
    }
    
    public native static java.lang.String qFindTestData(java.lang.String basepath, java.lang.String file, int line, java.lang.String builddir);
    
    public native static java.lang.Object qGlobalData(java.lang.String tagName, int typeId);
    
    public static void qInit(io.qt.core.QObject testObject){
        qInit_native_QObject_ptr_int_char_ptr_ptr(QtJambi_LibraryUtilities.internal.checkedNativeId(testObject));
    }
    
    private native static void qInit_native_QObject_ptr_int_char_ptr_ptr(long testObject);
    
    public native static int qRun();
    
    public native static void qSkip(java.lang.String message, java.lang.String file, int line);
    
    public native static void qSleep(int ms);
    
    public native static boolean qVerify(boolean statement, java.lang.String statementStr, java.lang.String description, java.lang.String file, int line);
    
    public native static void qWait(int ms);
    
    /**
     * <p>Overloaded function for {@link #qWaitForWindowActive(io.qt.widgets.QWidget, int)}
     *  with <code>timeout = 5000</code>.</p>
     */
    public static boolean qWaitForWindowActive(io.qt.widgets.QWidget widget) {
        return qWaitForWindowActive(widget, (int)5000);
    }
    
    public static boolean qWaitForWindowActive(io.qt.widgets.QWidget widget, int timeout){
        return qWaitForWindowActive_native_QWidget_ptr_int(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), timeout);
    }
    
    private native static boolean qWaitForWindowActive_native_QWidget_ptr_int(long widget, int timeout);
    
    /**
     * <p>Overloaded function for {@link #qWaitForWindowActive(io.qt.gui.QWindow, int)}
     *  with <code>timeout = 5000</code>.</p>
     */
    public static boolean qWaitForWindowActive(io.qt.gui.QWindow window) {
        return qWaitForWindowActive(window, (int)5000);
    }
    
    public static boolean qWaitForWindowActive(io.qt.gui.QWindow window, int timeout){
        return qWaitForWindowActive_native_QWindow_ptr_int(QtJambi_LibraryUtilities.internal.checkedNativeId(window), timeout);
    }
    
    private native static boolean qWaitForWindowActive_native_QWindow_ptr_int(long window, int timeout);
    
    /**
     * <p>Overloaded function for {@link #qWaitForWindowExposed(io.qt.widgets.QWidget, int)}
     *  with <code>timeout = 5000</code>.</p>
     */
    public static boolean qWaitForWindowExposed(io.qt.widgets.QWidget widget) {
        return qWaitForWindowExposed(widget, (int)5000);
    }
    
    public static boolean qWaitForWindowExposed(io.qt.widgets.QWidget widget, int timeout){
        return qWaitForWindowExposed_native_QWidget_ptr_int(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), timeout);
    }
    
    private native static boolean qWaitForWindowExposed_native_QWidget_ptr_int(long widget, int timeout);
    
    /**
     * <p>Overloaded function for {@link #qWaitForWindowExposed(io.qt.gui.QWindow, int)}
     *  with <code>timeout = 5000</code>.</p>
     */
    public static boolean qWaitForWindowExposed(io.qt.gui.QWindow window) {
        return qWaitForWindowExposed(window, (int)5000);
    }
    
    public static boolean qWaitForWindowExposed(io.qt.gui.QWindow window, int timeout){
        return qWaitForWindowExposed_native_QWindow_ptr_int(QtJambi_LibraryUtilities.internal.checkedNativeId(window), timeout);
    }
    
    private native static boolean qWaitForWindowExposed_native_QWindow_ptr_int(long window, int timeout);
    
    /**
     * <p>Overloaded function for {@link #qWarn(java.lang.String, java.lang.String, int)}
     *  with <code>line = 0</code>.</p>
     */
    public static void qWarn(java.lang.String message, java.lang.String file) {
        qWarn(message, file, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #qWarn(java.lang.String, java.lang.String, int)}</p>
     * <p>with: </p><ul>
     * <li><code>file = null</code></li>
     * <li><code>line = 0</code></li>
     * </ul>
     */
    public static void qWarn(java.lang.String message) {
        qWarn(message, (java.lang.String)null, (int)0);
    }
    
    public native static void qWarn(java.lang.String message, java.lang.String file, int line);
    
    /**
     * <p>Overloaded function for {@link #sendKeyEvent(io.qt.test.QTest.KeyAction, io.qt.widgets.QWidget, io.qt.core.Qt.Key, java.lang.String, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void sendKeyEvent(io.qt.test.QTest.KeyAction action, io.qt.widgets.QWidget widget, io.qt.core.Qt.Key code, java.lang.String text, io.qt.core.Qt.KeyboardModifiers modifier) {
        sendKeyEvent(action, widget, code, text, modifier, (int)-1);
    }
    
    public static void sendKeyEvent(io.qt.test.QTest.KeyAction action, io.qt.widgets.QWidget widget, io.qt.core.Qt.Key code, java.lang.String text, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        sendKeyEvent_native_QTest_KeyAction_QWidget_ptr_Qt_Key_QString_QFlags_Qt_KeyboardModifier__int(action.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(widget), code.value(), text, modifier.value(), delay);
    }
    
    private native static void sendKeyEvent_native_QTest_KeyAction_QWidget_ptr_Qt_Key_QString_QFlags_Qt_KeyboardModifier__int(int action, long widget, int code, java.lang.String text, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #sendKeyEvent(io.qt.test.QTest.KeyAction, io.qt.widgets.QWidget, io.qt.core.Qt.Key, char, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void sendKeyEvent(io.qt.test.QTest.KeyAction action, io.qt.widgets.QWidget widget, io.qt.core.Qt.Key code, char ascii, io.qt.core.Qt.KeyboardModifiers modifier) {
        sendKeyEvent(action, widget, code, ascii, modifier, (int)-1);
    }
    
    public static void sendKeyEvent(io.qt.test.QTest.KeyAction action, io.qt.widgets.QWidget widget, io.qt.core.Qt.Key code, char ascii, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        sendKeyEvent_native_QTest_KeyAction_QWidget_ptr_Qt_Key_char_QFlags_Qt_KeyboardModifier__int(action.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(widget), code.value(), ascii, modifier.value(), delay);
    }
    
    private native static void sendKeyEvent_native_QTest_KeyAction_QWidget_ptr_Qt_Key_char_QFlags_Qt_KeyboardModifier__int(int action, long widget, int code, char ascii, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #sendKeyEvent(io.qt.test.QTest.KeyAction, io.qt.gui.QWindow, io.qt.core.Qt.Key, java.lang.String, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void sendKeyEvent(io.qt.test.QTest.KeyAction action, io.qt.gui.QWindow window, io.qt.core.Qt.Key code, java.lang.String text, io.qt.core.Qt.KeyboardModifiers modifier) {
        sendKeyEvent(action, window, code, text, modifier, (int)-1);
    }
    
    public static void sendKeyEvent(io.qt.test.QTest.KeyAction action, io.qt.gui.QWindow window, io.qt.core.Qt.Key code, java.lang.String text, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        sendKeyEvent_native_QTest_KeyAction_QWindow_ptr_Qt_Key_QString_QFlags_Qt_KeyboardModifier__int(action.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(window), code.value(), text, modifier.value(), delay);
    }
    
    private native static void sendKeyEvent_native_QTest_KeyAction_QWindow_ptr_Qt_Key_QString_QFlags_Qt_KeyboardModifier__int(int action, long window, int code, java.lang.String text, int modifier, int delay);
    
    /**
     * <p>Overloaded function for {@link #sendKeyEvent(io.qt.test.QTest.KeyAction, io.qt.gui.QWindow, io.qt.core.Qt.Key, char, io.qt.core.Qt.KeyboardModifiers, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void sendKeyEvent(io.qt.test.QTest.KeyAction action, io.qt.gui.QWindow window, io.qt.core.Qt.Key code, char ascii, io.qt.core.Qt.KeyboardModifiers modifier) {
        sendKeyEvent(action, window, code, ascii, modifier, (int)-1);
    }
    
    public static void sendKeyEvent(io.qt.test.QTest.KeyAction action, io.qt.gui.QWindow window, io.qt.core.Qt.Key code, char ascii, io.qt.core.Qt.KeyboardModifiers modifier, int delay){
        sendKeyEvent_native_QTest_KeyAction_QWindow_ptr_Qt_Key_char_QFlags_Qt_KeyboardModifier__int(action.value(), QtJambi_LibraryUtilities.internal.checkedNativeId(window), code.value(), ascii, modifier.value(), delay);
    }
    
    private native static void sendKeyEvent_native_QTest_KeyAction_QWindow_ptr_Qt_Key_char_QFlags_Qt_KeyboardModifier__int(int action, long window, int code, char ascii, int modifier, int delay);
    
    public static void setBenchmarkResult(double result, io.qt.test.QTest.QBenchmarkMetric metric){
        setBenchmarkResult_native_qtjambireal_QTest_QBenchmarkMetric(result, metric.value());
    }
    
    private native static void setBenchmarkResult_native_qtjambireal_QTest_QBenchmarkMetric(double result, int metric);
    
    /**
     * <p>Overloaded function for {@link #setMainSourcePath(java.lang.String, java.lang.String)}
     *  with <code>builddir = null</code>.</p>
     */
    public static void setMainSourcePath(java.lang.String file) {
        setMainSourcePath(file, (java.lang.String)null);
    }
    
    public native static void setMainSourcePath(java.lang.String file, java.lang.String builddir);
    
    /**
     * <p>Overloaded function for {@link #simulateEvent(io.qt.widgets.QWidget, boolean, int, io.qt.core.Qt.KeyboardModifiers, java.lang.String, boolean, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void simulateEvent(io.qt.widgets.QWidget widget, boolean press, int code, io.qt.core.Qt.KeyboardModifiers modifier, java.lang.String text, boolean repeat) {
        simulateEvent(widget, press, code, modifier, text, repeat, (int)-1);
    }
    
    public static void simulateEvent(io.qt.widgets.QWidget widget, boolean press, int code, io.qt.core.Qt.KeyboardModifiers modifier, java.lang.String text, boolean repeat, int delay){
        simulateEvent_native_QWidget_ptr_bool_int_QFlags_Qt_KeyboardModifier__QString_bool_int(QtJambi_LibraryUtilities.internal.checkedNativeId(widget), press, code, modifier.value(), text, repeat, delay);
    }
    
    private native static void simulateEvent_native_QWidget_ptr_bool_int_QFlags_Qt_KeyboardModifier__QString_bool_int(long widget, boolean press, int code, int modifier, java.lang.String text, boolean repeat, int delay);
    
    /**
     * <p>Overloaded function for {@link #simulateEvent(io.qt.gui.QWindow, boolean, int, io.qt.core.Qt.KeyboardModifiers, java.lang.String, boolean, int)}
     *  with <code>delay = -1</code>.</p>
     */
    public static void simulateEvent(io.qt.gui.QWindow window, boolean press, int code, io.qt.core.Qt.KeyboardModifiers modifier, java.lang.String text, boolean repeat) {
        simulateEvent(window, press, code, modifier, text, repeat, (int)-1);
    }
    
    public static void simulateEvent(io.qt.gui.QWindow window, boolean press, int code, io.qt.core.Qt.KeyboardModifiers modifier, java.lang.String text, boolean repeat, int delay){
        simulateEvent_native_QWindow_ptr_bool_int_QFlags_Qt_KeyboardModifier__QString_bool_int(QtJambi_LibraryUtilities.internal.checkedNativeId(window), press, code, modifier.value(), text, repeat, delay);
    }
    
    private native static void simulateEvent_native_QWindow_ptr_bool_int_QFlags_Qt_KeyboardModifier__QString_bool_int(long window, boolean press, int code, int modifier, java.lang.String text, boolean repeat, int delay);
    
    public native static io.qt.core.QObject testObject();
    
    @io.qt.QtUninvokable
    public static void QBENCHMARK(Runnable runnable) {
        for (QBenchmarkIterationController __iteration_controller = new QBenchmarkIterationController();
                        __iteration_controller.isDone() == false; __iteration_controller.next())
            runnable.run();
    }
    
    @io.qt.QtUninvokable
    public static void QBENCHMARK_ONCE(Runnable runnable) {
        for (QBenchmarkIterationController __iteration_controller = new QBenchmarkIterationController(QBenchmarkIterationController.RunMode.RunOnce);
                        __iteration_controller.isDone() == false; __iteration_controller.next())
            runnable.run();
    }
    
    @io.qt.QtUninvokable
    public static <T extends Comparable<T>> boolean qCompare(T t1, T t2, java.lang.String actual, java.lang.String expected, java.lang.String file, int line){
        return QTest.compare_helper(t1==null ? t1!=null : t1.compareTo(t2)==0, "Compared values are not the same", 
                "value1", 
                "value2", 
                java.util.Objects.toString(t2), 
                java.util.Objects.toString(t1), 
                file, line);
    }
    
    @io.qt.QtUninvokable
    public static <T> boolean qCompare(T t1, T t2, java.lang.String actual, java.lang.String expected, java.lang.String file, int line){
        return QTest.compare_helper(java.util.Objects.equals(t1, t2), "Compared values are not the same", 
                "value1", 
                "value2", 
                java.util.Objects.toString(t2), 
                java.util.Objects.toString(t1), 
                file, line);
    }
    
    @io.qt.QtUninvokable
    public static <T extends Comparable<T>> void QCOMPARE(T t1, T t2) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        if(!QTest.qCompare(t1, t2,
                java.util.Objects.toString(t2), 
                java.util.Objects.toString(t1), 
                info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
            throw new AssertionError("Compared values are not the same");
    }
    
    @io.qt.QtUninvokable
    public static <T> void QCOMPARE(T t1, T t2) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        if(!QTest.qCompare(t1, t2,
                java.util.Objects.toString(t2), 
                java.util.Objects.toString(t1), 
                info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
            throw new AssertionError("Compared values are not the same");
    }
    
    @io.qt.QtUninvokable
    public static void QCOMPARE(int t1, int t2) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        if(!QTest.qCompare(t1, t2, 
                java.lang.Integer.toString(t2), 
                java.lang.Integer.toString(t1), 
                info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
                throw new AssertionError("Compared values are not the same");
    }
    
    @io.qt.QtUninvokable
    public static void QCOMPARE(double t1, double t2) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        if(!QTest.qCompare(t1, t2, 
                java.lang.Double.toString(t2), 
                java.lang.Double.toString(t1), 
                info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
                throw new AssertionError("Compared values are not the same");
    }
    
    @io.qt.QtUninvokable
    public static void QCOMPARE(float t1, double t2) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        if(!QTest.qCompare(t1, t2, 
                java.lang.Double.toString(t2), 
                java.lang.Float.toString(t1), 
                info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
                throw new AssertionError("Compared values are not the same");
    }
    
    @io.qt.QtUninvokable
    public static void QCOMPARE(double t1, float t2) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        if(!QTest.qCompare(t1, t2, 
                java.lang.Float.toString(t2), 
                java.lang.Double.toString(t1), 
                info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
                throw new AssertionError("Compared values are not the same");
    }
    
    @io.qt.QtUninvokable
    public static void QCOMPARE(float t1, float t2) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        if(!QTest.qCompare(t1, t2, 
                java.lang.Float.toString(t2), 
                java.lang.Float.toString(t1), 
                info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
                throw new AssertionError("Compared values are not the same");
    }
    
    @io.qt.QtUninvokable
    public static void QCOMPARE(String t1, String t2) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        if(!QTest.qCompare(t1, t2, 
                t2, 
                t1, 
                info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
                throw new AssertionError("Compared values are not the same");
    }
    
    @io.qt.QtUninvokable
    public static void QCOMPARE(io.qt.gui.QIcon t1, io.qt.gui.QIcon t2) throws AssertionError {
        if(t1==null)
            t1 = new io.qt.gui.QIcon();
        if(t2==null)
            t2 = new io.qt.gui.QIcon();
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        if(!QTest.qCompare(t1, t2, 
                java.util.Objects.toString(t2), 
                java.util.Objects.toString(t1), 
                info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
                throw new AssertionError("Compared values are not the same");
    }
    
    @io.qt.QtUninvokable
    public static void QCOMPARE(io.qt.gui.QPixmap t1, io.qt.gui.QPixmap t2) throws AssertionError {
        if(t1==null)
            t1 = new io.qt.gui.QPixmap();
        if(t2==null)
            t2 = new io.qt.gui.QPixmap();
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        if(!QTest.qCompare(t1, t2, 
                java.util.Objects.toString(t2), 
                java.util.Objects.toString(t1), 
                info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
                throw new AssertionError("Compared values are not the same");
    }
    
    @io.qt.QtUninvokable
    public static void QCOMPARE(io.qt.gui.QImage t1, io.qt.gui.QImage t2) throws AssertionError {
        if(t1==null)
            t1 = new io.qt.gui.QImage();
        if(t2==null)
            t2 = new io.qt.gui.QImage();
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        if(!QTest.qCompare(t1, t2, 
                java.util.Objects.toString(t2), 
                java.util.Objects.toString(t1), 
                info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
            throw new AssertionError("Compared values are not the same");
    }
    
    @io.qt.QtUninvokable
    public static void QEXPECT_FAIL(String dataIndex, String comment, QTest.TestFailMode mode) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        if(!QTest.qExpectFail(dataIndex, comment, mode, info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
            throw new AssertionError(comment);
    }
    
    @io.qt.QtUninvokable
    public static void QFAIL(String message) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        QTest.qFail(message, info.declaringClass.getName()+"."+info.methodName, info.lineNumber);
        throw new AssertionError(message);
    }
    
    @io.qt.QtUninvokable
    public static <T> T QFETCH(Class<T> type, String name) {
        return io.qt.core.QVariant.convert(qData(name, io.qt.core.QMetaType.fromType(type).id()), type);
    }
    
    @io.qt.QtUninvokable
    public static <T> T QFETCH_GLOBAL(Class<T> type, String name) {
        return io.qt.core.QVariant.convert(qGlobalData(name, io.qt.core.QMetaType.fromType(type).id()), type);
    }
    
    @io.qt.QtUninvokable
    public static String QFINDTESTDATA(String basepath){
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        return QTest.qFindTestData(basepath, info.declaringClass.getName()+"."+info.methodName, info.lineNumber);
    }
    
    @io.qt.QtUninvokable
    public static String QFINDTESTDATA(String basepath, java.lang.String builddir){
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        return QTest.qFindTestData(basepath, info.declaringClass.getName()+"."+info.methodName, info.lineNumber, builddir);
    }
    
    @io.qt.QtUninvokable
    public static void QSKIP(String statement){
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        QTest.qSkip(statement, info.declaringClass.getName()+"."+info.methodName, info.lineNumber);
    }
    
    @io.qt.QtUninvokable
    public static <T> boolean qTest(T actual, String elementName, String actualStr, String expected, String file, int line) {
        @SuppressWarnings("unchecked")
        Class<T> cls = (Class<T>)actual.getClass();
        return qCompare(actual, io.qt.core.QVariant.convert(QTest.qElementData(elementName, io.qt.core.QMetaType.fromType(cls).id()), cls), actualStr, expected, file, line);
    }
    
    @io.qt.QtUninvokable
    public static <T> void QTEST(T actual, String testElement) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        if(!QTest.qTest(actual, testElement, java.util.Objects.toString(actual), java.util.Objects.toString(actual), info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
            throw new AssertionError();
    }
    
    @io.qt.QtUninvokable
    public static int qExec(io.qt.core.QObject testObject, String...args){
        return qExec(testObject, java.util.Arrays.asList(args));
    }
    
    @io.qt.QtUninvokable
    private static int QTRY_LOOP_IMPL(java.util.function.BooleanSupplier expr, int timeoutValue, int step) {
        if (!(expr.getAsBoolean())) {
            qWait(0);
        }
        int qt_test_i = 0;
        for (; qt_test_i < timeoutValue && !(expr.getAsBoolean()); qt_test_i += step) {
            qWait(step);
        }
        return qt_test_i;
    }
    
    @io.qt.QtUninvokable
    private static void QTRY_TIMEOUT_DEBUG_IMPL(io.qt.InternalAccess.CallerContext info, java.util.function.BooleanSupplier expr, int timeoutValue, int step) throws AssertionError {
        if (!(expr.getAsBoolean())) {
            int qt_test_i = QTRY_LOOP_IMPL(expr, (2 * timeoutValue), step);
            if (expr.getAsBoolean()) {
                String message = String.format("QTestLib: This test case check failed because the requested timeout (%1$s ms) was too short, %2$s ms would have been sufficient this time.", timeoutValue, timeoutValue + qt_test_i);
                QTest.qFail(message, info.declaringClass.getName()+"."+info.methodName, info.lineNumber);
                throw new AssertionError(message);
            }
        }
    }
    
    @io.qt.QtUninvokable
    private static void QTRY_IMPL(io.qt.InternalAccess.CallerContext info, java.util.function.BooleanSupplier expr, int timeout) throws AssertionError {
        int qt_test_step = timeout < 350 ? timeout / 7 + 1 : 50;
        int qt_test_timeoutValue = timeout;
        { QTRY_LOOP_IMPL(()->currentTestFailed() || (expr.getAsBoolean()), qt_test_timeoutValue, qt_test_step); }
        QTRY_TIMEOUT_DEBUG_IMPL(info, ()->currentTestFailed() || (expr.getAsBoolean()), qt_test_timeoutValue, qt_test_step);
    }
    
    @io.qt.QtUninvokable
    private static void QTRY_COMPARE_WITH_TIMEOUT_IMPL(io.qt.InternalAccess.CallerContext info, java.util.function.BooleanSupplier expr, java.util.function.BooleanSupplier equals, int timeout) throws AssertionError {
        int qt_test_step = timeout < 350 ? timeout / 7 + 1 : 50;
        int qt_test_timeoutValue = timeout;
        { 
            QTRY_LOOP_IMPL(()->currentTestFailed() || (expr.getAsBoolean()), qt_test_timeoutValue, qt_test_step); 
        }
        QTRY_TIMEOUT_DEBUG_IMPL(info, ()->currentTestFailed() || (expr.getAsBoolean()), qt_test_timeoutValue, qt_test_step);
        QTRY_IMPL(info, equals, timeout);
        if(!QTest.compare_helper(equals.getAsBoolean(), "Compared values are not the same", 
                "value1", 
                "value2", 
                "value1", 
                "value2", 
                info.declaringClass.getName()+"."+info.methodName, info.lineNumber)) {
            throw new AssertionError("Compared values are not the same");
        }
    }
    
    @io.qt.QtUninvokable
    public static <T extends Comparable<T>> void QTRY_COMPARE_WITH_TIMEOUT(T t1, T t2, int timeout) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        QTRY_COMPARE_WITH_TIMEOUT_IMPL(info, ()->t1!=null, ()->t1.compareTo(t2)==0, timeout);
    }
    
    @io.qt.QtUninvokable
    public static <T extends Comparable<T>> void QTRY_COMPARE(T t1, T t2) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        QTRY_COMPARE_WITH_TIMEOUT_IMPL(info, ()->t1!=null, ()->t1.compareTo(t2)==0, 5000);
    }
    
    @io.qt.QtUninvokable
    public static <T> void QTRY_COMPARE_WITH_TIMEOUT(T t1, T t2, int timeout) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        QTRY_COMPARE_WITH_TIMEOUT_IMPL(info, ()->t1!=null, ()->java.util.Objects.equals(t1, t2), timeout);
    }
    
    @io.qt.QtUninvokable
    public static <T> void QTRY_COMPARE(T t1, T t2) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        QTRY_COMPARE_WITH_TIMEOUT_IMPL(info, ()->t1!=null, ()->java.util.Objects.equals(t1, t2), 5000);
    }
    
    @io.qt.QtUninvokable
    public static void QTRY_VERIFY_WITH_TIMEOUT(java.util.function.BooleanSupplier expr, int timeout) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        QTRY_IMPL(info, expr, timeout);
        QVERIFY(info, expr);
    }
    
    @io.qt.QtUninvokable
    public static void QTRY_VERIFY_WITH_TIMEOUT(java.util.function.BooleanSupplier expr, String messageExpression, int timeout) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        QTRY_IMPL(info, expr, timeout);
        QVERIFY(info, expr, messageExpression);
    }
    
    @io.qt.QtUninvokable
    public static void QVERIFY(java.util.function.BooleanSupplier statement) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        QVERIFY(info, statement);
    }
    
    @io.qt.QtUninvokable
    private static void QVERIFY(io.qt.InternalAccess.CallerContext info, java.util.function.BooleanSupplier statement) throws AssertionError {
        if (!qVerify(statement.getAsBoolean(), "", "", info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
            throw new AssertionError();
    }
    
    @io.qt.QtUninvokable
    public static void QVERIFY(java.util.function.BooleanSupplier statement, String description) throws AssertionError {
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        QVERIFY(info, statement, description);
    }
    
    @io.qt.QtUninvokable
    private static void QVERIFY(io.qt.InternalAccess.CallerContext info, java.util.function.BooleanSupplier statement, String description) throws AssertionError {
        if(statement.getAsBoolean()) {
            if (!qVerify(true, "", description, info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
                throw new AssertionError(description);
        }else {
            if (!qVerify(false, "", description, info.declaringClass.getName()+"."+info.methodName, info.lineNumber))
                throw new AssertionError(description);
        }
    }
    
    @io.qt.QtUninvokable
    public static void QWARN(String message){
        io.qt.InternalAccess.CallerContext info = QtJambi_LibraryUtilities.internal.callerContextProvider().get();
        QTest.qWarn(message, info.declaringClass.getName()+"."+info.methodName, info.lineNumber);
    }
    
    @io.qt.QtUninvokable
    public static io.qt.core.QTemporaryDir QEXTRACTTESTDATA(String resourcePath){
        return QTest.qExtractTestData(resourcePath);
    }
    
    @io.qt.QtUninvokable
    public static void addColumn(Class<?> type, String name){
        addColumnInternal(io.qt.core.QMetaType.fromType(type).id(), name);
    }
    
    @io.qt.QtUninvokable
    public static io.qt.test.QTest.QTouchEventSequence touchEvent(io.qt.gui.QWindow window, io.qt.gui.QTouchDevice device) {
        return touchEvent(window, device, true);
    }
    
    @io.qt.QtUninvokable
    public static native io.qt.test.QTest.QTouchEventSequence touchEvent(io.qt.gui.QWindow window, io.qt.gui.QTouchDevice device, boolean autoCommit);
    
    @io.qt.QtUninvokable
    public static io.qt.test.QTest.QTouchEventSequence touchEvent(io.qt.widgets.QWidget window, io.qt.gui.QTouchDevice device) {
        return touchEvent(window, device, true);
    }
    
    @io.qt.QtUninvokable
    public static native io.qt.test.QTest.QTouchEventSequence touchEvent(io.qt.widgets.QWidget window, io.qt.gui.QTouchDevice device, boolean autoCommit);
}
