package io.qt.test;

import java.util.*;
import java.util.function.*;
import java.util.stream.Stream;
import io.qt.core.*;

/**
 * <p>Enables introspection of signal emission</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsignalspy.html">QSignalSpy</a></p>
 */
public class QSignalSpy extends io.qt.core.QObject
    implements List<java.util.List<java.lang.Object>>
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    public QSignalSpy(io.qt.core.QObject obj, io.qt.core.QMetaMethod signal){
        super((QPrivateConstructor)null);
        initialize_native(this, obj, signal);
    }
    
    private native static void initialize_native(QSignalSpy instance, io.qt.core.QObject obj, io.qt.core.QMetaMethod signal);
    
    public QSignalSpy(io.qt.core.QObject obj, java.lang.String aSignal){
        super((QPrivateConstructor)null);
        initialize_native(this, obj, aSignal);
    }
    
    private native static void initialize_native(QSignalSpy instance, io.qt.core.QObject obj, java.lang.String aSignal);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsignalspy.html#isValid">QSignalSpy::isValid()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    private final io.qt.core.QList<java.util.List<java.lang.Object>> list(){
        return list_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<java.util.List<java.lang.Object>> list_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsignalspy.html#signal">QSignalSpy::signal()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QByteArray signal(){
        return signal_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QByteArray signal_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #waitForTimeout(int)}
     *  with <code>timeout = 5000</code>.</p>
     */
    @io.qt.QtUninvokable
    public final boolean waitForTimeout() {
        return waitForTimeout((int)5000);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsignalspy.html#wait">QSignalSpy::wait(int)</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean waitForTimeout(int timeout){
        return waitForTimeout_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), timeout);
    }
    
    @io.qt.QtUninvokable
    private native boolean waitForTimeout_native_int(long __this__nativeId, int timeout);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSignalSpy(QPrivateConstructor p) { super(p); } 
    
    public QSignalSpy(QMetaObject.AbstractSignal signal) {
        super((QPrivateConstructor)null);
        if(!(signal.containingObject() instanceof QObject)) {
            throw new IllegalArgumentException("Signal spy can only operate on QObject signals.");
        }
        QObject obj = (QObject)signal.containingObject();
        QMetaMethod signalMethod = QMetaMethod.fromSignal(signal);
        initialize_native(this, obj, signalMethod);
    }
    
    @io.qt.QtUninvokable
    public final void forEach(Consumer<? super java.util.List<java.lang.Object>> action) {
        list().forEach(action);
    }
    
    @io.qt.QtUninvokable
    public boolean addAll(Collection<? extends java.util.List<java.lang.Object>> c) {
        return list().addAll(c);
    }
    
    @io.qt.QtUninvokable
    public boolean addAll(int index, Collection<? extends java.util.List<java.lang.Object>> c) {
        return list().addAll(index, c);
    }
    
    @io.qt.QtUninvokable
    public java.util.List<java.lang.Object> remove(int index) {
        return list().remove(index);
    }
    
    @io.qt.QtUninvokable
    public ListIterator<java.util.List<java.lang.Object>> listIterator() {
        return list().listIterator();
    }
    
    @io.qt.QtUninvokable
    public ListIterator<java.util.List<java.lang.Object>> listIterator(int index) {
        return list().listIterator(index);
    }
    
    @io.qt.QtUninvokable
    public List<java.util.List<java.lang.Object>> subList(int fromIndex, int toIndex) {
        return list().subList(fromIndex, toIndex);
    }
    
    @io.qt.QtUninvokable
    public Object[] toArray() {
        return list().toArray();
    }
    
    @io.qt.QtUninvokable
    public <T> T[] toArray(T[] a) {
        return list().toArray(a);
    }
    
    @io.qt.QtUninvokable
    public boolean containsAll(Collection<?> c) {
        return list().containsAll(c);
    }
    
    @io.qt.QtUninvokable
    public QList<java.util.List<java.lang.Object>> clone() {
        return list().clone();
    }
    
    @io.qt.QtUninvokable
    public final void append(Collection<java.util.List<java.lang.Object>> t) {
        list().append(t);
    }
    
    @io.qt.QtUninvokable
    public boolean removeAll(Collection<?> c) {
        return list().removeAll(c);
    }
    
    @io.qt.QtUninvokable
    public boolean retainAll(Collection<?> c) {
        return list().retainAll(c);
    }
    
    @io.qt.QtUninvokable
    public final void append(java.util.List<java.lang.Object> t) {
        list().append(t);
    }
    
    @io.qt.QtUninvokable
    public Iterator<java.util.List<java.lang.Object>> iterator() {
        return list().iterator();
    }
    
    @io.qt.QtUninvokable
    public String toString() {
        return list().toString();
    }
    
    @io.qt.QtUninvokable
    public final java.util.List<java.lang.Object> at(int i) {
        return list().at(i);
    }
    
    @io.qt.QtUninvokable
    public final void clear() {
        list().clear();
    }
    
    @io.qt.QtUninvokable
    public final boolean contains(Object t) {
        return list().contains(t);
    }
    
    @io.qt.QtUninvokable
    public final int count() {
        return list().count();
    }
    
    @io.qt.QtUninvokable
    public final int count(java.util.List<java.lang.Object> t) {
        return list().count(t);
    }
    
    @io.qt.QtUninvokable
    public final boolean endsWith(java.util.List<java.lang.Object> t) {
        return list().endsWith(t);
    }
    
    @io.qt.QtUninvokable
    public final java.util.List<java.lang.Object> first() {
        return list().first();
    }
    
    @io.qt.QtUninvokable
    public final int indexOf(java.util.List<java.lang.Object> t, int from) {
        return list().indexOf(t, from);
    }
    
    @io.qt.QtUninvokable
    public final void insert(int i, java.util.List<java.lang.Object> t) {
        list().insert(i, t);
    }
    
    @io.qt.QtUninvokable
    public final boolean isEmpty() {
        return list().isEmpty();
    }
    
    @io.qt.QtUninvokable
    public final java.util.List<java.lang.Object> last() {
        return list().last();
    }
    
    @io.qt.QtUninvokable
    public final int lastIndexOf(Object t) {
        return list().lastIndexOf(t);
    }
    
    @io.qt.QtUninvokable
    public final int lastIndexOf(java.util.List<java.lang.Object> t, int from) {
        return list().lastIndexOf(t, from);
    }
    
    @io.qt.QtUninvokable
    public final int length() {
        return list().length();
    }
    
    @io.qt.QtUninvokable
    public final QList<java.util.List<java.lang.Object>> mid(int pos) {
        return list().mid(pos);
    }
    
    @io.qt.QtUninvokable
    public final QList<java.util.List<java.lang.Object>> mid(int pos, int length) {
        return list().mid(pos, length);
    }
    
    @io.qt.QtUninvokable
    public final void move(int from, int to) {
        list().move(from, to);
    }
    
    @io.qt.QtUninvokable
    public final void prepend(java.util.List<java.lang.Object> t) {
        list().prepend(t);
    }
    
    @io.qt.QtUninvokable
    public final int removeAll(java.util.List<java.lang.Object> t) {
        return list().removeAll(t);
    }
    
    @io.qt.QtUninvokable
    public final void removeAt(int i) {
        list().removeAt(i);
    }
    
    @io.qt.QtUninvokable
    public final boolean removeOne(java.util.List<java.lang.Object> t) {
        return list().removeOne(t);
    }
    
    @io.qt.QtUninvokable
    public final void replace(int i, java.util.List<java.lang.Object> t) {
        list().replace(i, t);
    }
    
    @io.qt.QtUninvokable
    public final void reserve(int size) {
        list().reserve(size);
    }
    
    @io.qt.QtUninvokable
    public final int size() {
        return list().size();
    }
    
    @io.qt.QtUninvokable
    public final boolean startsWith(java.util.List<java.lang.Object> t) {
        return list().startsWith(t);
    }
    
    @io.qt.QtUninvokable
    public final java.util.List<java.lang.Object> takeAt(int i) {
        return list().takeAt(i);
    }
    
    @io.qt.QtUninvokable
    public final java.util.List<java.lang.Object> takeFirst() {
        return list().takeFirst();
    }
    
    @io.qt.QtUninvokable
    public final java.util.List<java.lang.Object> takeLast() {
        return list().takeLast();
    }
    
    @io.qt.QtUninvokable
    public final java.util.List<java.lang.Object> value(int i) {
        return list().value(i);
    }
    
    @io.qt.QtUninvokable
    public final java.util.List<java.lang.Object> value(int i, java.util.List<java.lang.Object> defaultValue) {
        return list().value(i, defaultValue);
    }
    
    @io.qt.QtUninvokable
    public boolean equals(Object other) {
        return list().equals(other);
    }
    
    @io.qt.QtUninvokable
    public int hashCode() {
        return list().hashCode();
    }
    
    @io.qt.QtUninvokable
    public boolean add(java.util.List<java.lang.Object> e) {
        return list().add(e);
    }
    
    @io.qt.QtUninvokable
    public void add(int index, java.util.List<java.lang.Object> e) {
        list().add(index, e);
    }
    
    @io.qt.QtUninvokable
    public java.util.List<java.lang.Object> set(int index, java.util.List<java.lang.Object> e) {
        return list().set(index, e);
    }
    
    @io.qt.QtUninvokable
    public boolean remove(Object e) {
        return list().remove(e);
    }
    
    @io.qt.QtUninvokable
    public int indexOf(Object e) {
        return list().indexOf(e);
    }
    
    @io.qt.QtUninvokable
    public java.util.List<java.lang.Object> get(int index) {
        return list().get(index);
    }
    
    @io.qt.QtUninvokable
    public final void swapItemsAt(int i, int j) {
        list().swapItemsAt(i, j);
    }
    
    @io.qt.QtUninvokable
    public final void replaceAll(UnaryOperator<java.util.List<java.lang.Object>> operator) {
        list().replaceAll(operator);
    }
    
    @io.qt.QtUninvokable
    public void writeTo(QDataStream stream) {
        list().writeTo(stream);
    }
    
    @io.qt.QtUninvokable
    public void readFrom(QDataStream stream) {
        list().readFrom(stream);
    }
    
    @io.qt.QtUninvokable
    public final void sort(Comparator<? super java.util.List<java.lang.Object>> c) {
        list().sort(c);
    }
    
    @io.qt.QtUninvokable
    public final boolean removeIf(Predicate<? super java.util.List<java.lang.Object>> filter) {
        return list().removeIf(filter);
    }
    
    @io.qt.QtUninvokable
    public final Spliterator<java.util.List<java.lang.Object>> spliterator() {
        return list().spliterator();
    }
    
    @io.qt.QtUninvokable
    public final Stream<java.util.List<java.lang.Object>> stream() {
        return list().stream();
    }
    
    @io.qt.QtUninvokable
    public final Stream<java.util.List<java.lang.Object>> parallelStream() {
        return list().parallelStream();
    }
    
    @io.qt.QtUninvokable
    public final void removeFirst() {
        list().removeFirst();
    }
    
    @io.qt.QtUninvokable
    public final void removeLast() {
        list().removeLast();
    }
    @io.qt.QtUninvokable
    public final QSet<java.util.List<java.lang.Object>> toSet()    {
        return list().toSet();
    }
}
